/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataType;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfErrorCode;
import com.sun.netstorage.mgmt.esm.util.format.PrintfFormat;
import java.util.ArrayList;
import java.util.List;

public class PerfData
implements Cloneable {
    public static final int ONE_KILOBYTE = 1024;
    public static final long ONE_MEGABYTE = 0x100000L;
    protected long pollTime;
    protected double averageReadSize = 0.0;
    protected double averageWriteSize = 0.0;
    private double totalIOPs = 0.0;
    protected float readPercentage = 0.0f;
    protected float writePercentage = 0.0f;
    protected float cacheReadHitPercentage = 0.0f;
    protected double totalDataTransferredPerSecond = 0.0;
    private double bytesReadPerSecond = 0.0;
    private double bytesWrittenPerSecond = 0.0;
    private ArrayList errorCodes = new ArrayList();
    public static final int NOT_AVAILABLE = -1;
    protected String name = null;
    protected String wwn = null;
    protected PerfDataType type = null;

    public PerfData(String string, String string2, PerfDataType perfDataType) {
        this.name = string;
        this.wwn = string2;
        this.type = perfDataType;
    }

    public String getName() {
        return this.name;
    }

    public String getWWN() {
        return this.wwn;
    }

    public PerfDataType getType() {
        return this.type;
    }

    public long getPollTime() {
        return this.pollTime;
    }

    public void setPollTime(long l) {
        this.pollTime = l;
    }

    public double getAverageReadSize() {
        return this.averageReadSize;
    }

    public void setAverageReadSize(double d) {
        this.averageReadSize = d;
    }

    public double getAverageWriteSize() {
        return this.averageReadSize;
    }

    public void setAverageWriteSize(double d) {
        this.averageWriteSize = d;
    }

    public float getCacheReadHitPercentage() {
        return this.cacheReadHitPercentage;
    }

    public void setCacheReadHitPercentage(float f) {
        this.cacheReadHitPercentage = f;
    }

    public float getReadPercentage() {
        return this.readPercentage;
    }

    public void setReadPercentage(float f) {
        this.readPercentage = f;
    }

    public double getReadsPerSec() {
        return this.bytesReadPerSecond;
    }

    protected void setReadsPerSec(double d) {
        this.bytesReadPerSecond = d;
    }

    public double getTotalDataTransPerSec() {
        if (this.bytesReadPerSecond == -1.0 || this.bytesWrittenPerSecond == -1.0) {
            return -1.0;
        }
        return this.bytesReadPerSecond + this.bytesWrittenPerSecond;
    }

    public double getTotalIOPs() {
        return this.totalIOPs;
    }

    protected void setTotalIOPs(double d) {
        this.totalIOPs = d;
    }

    public float getWritePercentage() {
        return this.writePercentage;
    }

    public void setWritePercentage(float f) {
        this.writePercentage = f;
    }

    public double getWritesPerSec() {
        return this.bytesWrittenPerSecond;
    }

    protected void setWritesPerSec(double d) {
        this.bytesWrittenPerSecond = d;
    }

    protected void markDataAsNotAvailable() {
        this.averageReadSize = -1.0;
        this.averageWriteSize = -1.0;
        this.totalIOPs = -1.0;
        this.readPercentage = -1.0f;
        this.writePercentage = -1.0f;
        this.cacheReadHitPercentage = -1.0f;
        this.totalDataTransferredPerSecond = -1.0;
        this.bytesReadPerSecond = -1.0;
        this.bytesWrittenPerSecond = -1.0;
    }

    public void clear() {
        this.averageReadSize = 0.0;
        this.averageWriteSize = 0.0;
        this.totalIOPs = 0.0;
        this.readPercentage = 0.0f;
        this.writePercentage = 0.0f;
        this.cacheReadHitPercentage = 0.0f;
        this.totalDataTransferredPerSecond = 0.0;
        this.bytesReadPerSecond = 0.0;
        this.bytesWrittenPerSecond = 0.0;
    }

    protected void addErrorCode(PerfErrorCode perfErrorCode) {
        if (this.errorCodes == null) {
            this.errorCodes = new ArrayList();
        } else if (this.errorCodes.contains(perfErrorCode)) {
            return;
        }
        this.errorCodes.add(perfErrorCode);
    }

    protected void addErrorCodes(PerfErrorCode[] perfErrorCodeArray) {
        for (int i = 0; i < perfErrorCodeArray.length; ++i) {
            this.addErrorCode(perfErrorCodeArray[i]);
        }
    }

    protected void addErrorCodes(List list) {
        if (list != null) {
            this.addErrorCodes(list.toArray(new PerfErrorCode[list.size()]));
        }
    }

    protected void clearAllErrors() {
        this.errorCodes = null;
    }

    public List getErrorCodes() {
        if (this.errorCodes == null) {
            return new ArrayList();
        }
        return this.errorCodes;
    }

    protected String getErrorCodeStr() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.errorCodes == null) {
            return "";
        }
        PerfErrorCode[] perfErrorCodeArray = this.errorCodes.toArray(new PerfErrorCode[this.errorCodes.size()]);
        for (int i = 0; i < perfErrorCodeArray.length; ++i) {
            stringBuffer.append(perfErrorCodeArray[i].toString());
            stringBuffer.append("\n");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private String printHelper(double d, PrintfFormat printfFormat) {
        if (d == -1.0) {
            return "N/A";
        }
        return printfFormat.sprintf(d);
    }

    private double getInKBytes(double d) {
        if (d == 0.0 || d == -1.0) {
            return d;
        }
        return d / 1024.0;
    }

    public String getStatsStr(String string, boolean bl) {
        PrintfFormat printfFormat = new PrintfFormat("%8.2f");
        PrintfFormat printfFormat2 = new PrintfFormat("%5.2f%%");
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(string);
            stringBuffer.append("IOPs                   = ");
            stringBuffer.append(this.printHelper(this.getTotalIOPs(), printfFormat));
            stringBuffer.append(string);
            stringBuffer.append("Read                   = ");
            stringBuffer.append(this.printHelper(this.getReadPercentage(), printfFormat2));
            stringBuffer.append(string);
            stringBuffer.append("Write                  = ");
            stringBuffer.append(this.printHelper(this.getWritePercentage(), printfFormat2));
            stringBuffer.append(string);
            stringBuffer.append("Cache Read Hit         = ");
            stringBuffer.append(this.printHelper(this.getCacheReadHitPercentage(), printfFormat2));
            stringBuffer.append(string);
            stringBuffer.append("Data Trans (KB/sec)    = ");
            stringBuffer.append(this.printHelper(this.getInKBytes(this.getTotalDataTransPerSec()), printfFormat));
            stringBuffer.append(string);
            stringBuffer.append("KB/sec Read            = ");
            stringBuffer.append(this.printHelper(this.getInKBytes(this.getReadsPerSec()), printfFormat));
            stringBuffer.append(string);
            stringBuffer.append("KB/sec Written         = ");
            stringBuffer.append(this.printHelper(this.getInKBytes(this.getWritesPerSec()), printfFormat));
        } else {
            stringBuffer.append(new PrintfFormat("%4s").sprintf(this.getType().toString()));
            stringBuffer.append("  ");
            stringBuffer.append(new PrintfFormat("%-14s").sprintf(this.getName()));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getTotalIOPs(), printfFormat));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getReadPercentage(), printfFormat2));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getWritePercentage(), printfFormat2));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getCacheReadHitPercentage(), printfFormat2));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getInKBytes(this.getTotalDataTransPerSec()), printfFormat));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getInKBytes(this.getReadsPerSec()), printfFormat));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getInKBytes(this.getWritesPerSec()), printfFormat));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getAverageReadSize(), printfFormat));
            stringBuffer.append("  ");
            stringBuffer.append(this.printHelper(this.getAverageWriteSize(), printfFormat));
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        stringBuffer.append(this.getStatsStr(", ", true));
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Assertion failure");
        }
    }
}

