/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.cacao.ObjectNameFactory;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.OperationalStatus;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.Perf6130CollectorFactoryMBean;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.core.ArrayReg;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.core.Broadcaster;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.ArrayUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.CollectorTask;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.CollectorTaskThread;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.Perf6130Constants;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataCollector;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataCollectorKeyFactory;
import com.sun.netstorage.mgmt.esm.logic.data.api.performance.array6130.KeyLookup;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.thread.ThreadPool;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableIllegalArgumentException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableNotFoundException;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.VendorException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class Perf6130CollectorFactory
implements Perf6130CollectorFactoryMBean {
    public static final String DOMAIN = "com.sun.netstorage.portal";
    private String logfile = null;
    private Handler logfileHandler = null;
    private Logger logger = Perf6130Constants.LOGGER;
    private static final String CLASSNAME = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$impl$Perf6130CollectorFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$impl$Perf6130CollectorFactory = Perf6130CollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.Perf6130CollectorFactory")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$impl$Perf6130CollectorFactory).getName();
    private static final String COLLECTOR_OBJECT_NAME_PREFIX = "com.sun.netstorage.portal:type=6130PerfCollector,instance=";
    private static final String[] SUPPORTED_MODELS = new String[]{"StorEdge 6130"};
    private static final String[] SUPPORTED_TYPES = new String[]{"storage"};
    Hashtable map = new Hashtable();
    Object statusChangeLock = new Object();
    OperationalStatus status = OperationalStatus.STOPPED;
    ObjectName factoryObjectName = null;
    private MBeanServer mBeanServer = null;
    private static Perf6130CollectorFactory INSTANCE = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$impl$Perf6130CollectorFactory;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean;

    private Perf6130CollectorFactory() {
        INSTANCE = this;
        ObjectNameFactory objectNameFactory = new ObjectNameFactory(this.getClass());
        this.factoryObjectName = objectNameFactory.getObjectName(class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean = Perf6130CollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.Perf6130CollectorFactoryMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean, (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean = Perf6130CollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.Perf6130CollectorFactoryMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean).getName());
    }

    public static Perf6130CollectorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Perf6130CollectorFactory();
        }
        return INSTANCE;
    }

    public String[] getTypes() {
        return SUPPORTED_TYPES;
    }

    public String[] getModels() {
        return SUPPORTED_MODELS;
    }

    public String addCollector(String string) throws LocalizableException {
        ArrayReg arrayReg = ArrayUtil.getArrayReg(string);
        return this.addCollector(arrayReg);
    }

    private synchronized String addCollector(ArrayReg arrayReg) throws LocalizableException {
        try {
            Object object;
            if (arrayReg == null) {
                throw new LocalizableException("perfDataCollector.6130.noIPAddressSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/array6130/api/Localization");
            }
            PerfDataCollectorKeyFactory perfDataCollectorKeyFactory = PerfDataCollectorKeyFactory.getInstance();
            String string = null;
            string = perfDataCollectorKeyFactory.getKey(arrayReg);
            if (string == null && (string = KeyLookup.getKeyForWWN((String)arrayReg.getWWN())) != null) {
                object = new StringBuffer("Factory key lookup failed, but key exists in database for collector key=");
                ((StringBuffer)object).append(string).append(" factory=").append(perfDataCollectorKeyFactory.toString());
                this.logger.logp(Level.SEVERE, CLASSNAME, "addCollector(ArrayReg, Object)", ((StringBuffer)object).toString());
            }
            if (string != null) {
                object = arrayReg.getIps();
                Object object2 = "";
                if (((String[])object).length > 1) {
                    object2 = object[1];
                }
                throw new LocalizableException("perfDataCollector.6130.collectorAlreadyExists", new Serializable[]{arrayReg.getNodeName(), object[0], object2, perfDataCollectorKeyFactory.toString()}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/array6130/api/Localization");
            }
            string = perfDataCollectorKeyFactory.add(arrayReg);
            object = new PerfDataCollector(string, arrayReg);
            ((PerfDataCollector)object).start();
            this.map.put(string, object);
            this.registerCollectorWithMBeanServer((PerfDataCollector)object);
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.logp(Level.INFO, CLASSNAME, "addCollector(ArrayReg, Object)", "Successfully created performance data collector, key=" + string);
            }
            return string;
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.INFO, CLASSNAME, "addCollector(ArrayReg, Object)", localizableException.getLocalizedMessage(Locale.ENGLISH));
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logger.logp(Level.SEVERE, CLASSNAME, "addCollector(ArrayReg, Object)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public void removeCollector(String string) throws LocalizableException {
        try {
            PerfDataCollector perfDataCollector = this.getCollector(string);
            perfDataCollector.stop();
            perfDataCollector.unload();
            this.map.remove(string);
            PerfDataCollectorKeyFactory.getInstance().remove(perfDataCollector.getWWN());
            this.unRegisterCollectorWithMBeanServer(perfDataCollector);
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.INFO, CLASSNAME, "removeCollector(String)", localizableException.getLocalizedMessage(Locale.ENGLISH));
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logger.logp(Level.SEVERE, CLASSNAME, "removeCollector(String)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public boolean containsCollector(String string) {
        if (string == null) {
            return false;
        }
        return this.map.containsKey(string);
    }

    public synchronized int discoveryAutoAdd(int n) throws LocalizableException {
        String[] stringArray;
        Broadcaster broadcaster = new Broadcaster();
        try {
            broadcaster.discover(n);
        }
        catch (Exception exception) {
            this.logger.logp(Level.FINE, CLASSNAME, "discoveryAutoAdd(int)", exception.getMessage());
            throw new LocalizableException((Throwable)exception);
        }
        List list = broadcaster.getDiscoveredControllers();
        if (list.size() == 0) {
            return 0;
        }
        InetAddress inetAddress = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            inetAddress = (InetAddress)list.get(i);
            stringArray = inetAddress.getHostAddress();
            String string = KeyLookup.getKeyForIpAddress((String)stringArray);
            if (string != null) continue;
            try {
                this.addCollector((String)stringArray);
                ++n2;
                continue;
            }
            catch (Exception exception) {
                arrayList.add(stringArray);
            }
        }
        if (arrayList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringArray = arrayList.toArray(new String[arrayList.size()]);
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]).append(" ");
            }
            throw new LocalizableException("perfDataCollectorFactory.6130.failedToAdd", new Serializable[]{Integer.toString(n2), stringBuffer.toString()}, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/array6130/api/Localization");
        }
        return n2;
    }

    public String[] getCollectorKeys() {
        return this.map.keySet().toArray(new String[this.map.size()]);
    }

    public void startCollector(String string) throws LocalizableException {
        try {
            PerfDataCollector perfDataCollector = this.getCollector(string);
            perfDataCollector.start();
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.INFO, CLASSNAME, "startCollector(String)", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logger.logp(Level.SEVERE, CLASSNAME, "startCollector(String)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public PerfDataCollector getCollector(String string) throws LocalizableException {
        if (string == null) {
            throw new LocalizableIllegalArgumentException("illegalArgument.keyIsNull", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
        }
        PerfDataCollector perfDataCollector = (PerfDataCollector)this.map.get(string);
        if (perfDataCollector == null) {
            throw new LocalizableNotFoundException("perfDataCollectorFactory.canNotFindSpecifiedCollector", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
        }
        return perfDataCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.logger.logp(Level.INFO, CLASSNAME, "start()", "Attempting to start service");
        Object object = this.statusChangeLock;
        synchronized (object) {
            this.status = OperationalStatus.STARTING;
            List list = null;
            try {
                list = KeyLookup.getAllKeys();
            }
            catch (Exception exception) {
                this.logger.logp(Level.SEVERE, CLASSNAME, "start()", "Failed to retrieve list of available collectors from database.  " + exception.getLocalizedMessage());
                this.status = OperationalStatus.NON_RECOVERABLE_ERROR;
            }
            if (list != null) {
                String[] stringArray = list.toArray(new String[list.size()]);
                int n = this.instantiateCollectors(stringArray);
            }
            if (this.status.equals((Object)OperationalStatus.STARTING)) {
                this.status = OperationalStatus.OK;
                this.logger.logp(Level.INFO, CLASSNAME, "start()", "Service successfully started");
            }
        }
        if (this.mBeanServer != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.logp(Level.FINE, CLASSNAME, "start()", this.factoryObjectName.toString());
            }
            try {
                this.mBeanServer.registerMBean(new StandardMBean(this, class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean = Perf6130CollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.Perf6130CollectorFactoryMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$Perf6130CollectorFactoryMBean){}, this.factoryObjectName);
            }
            catch (Exception exception) {
                this.logger.logp(Level.SEVERE, CLASSNAME, "start()", exception.getMessage(), exception);
            }
        }
    }

    public synchronized void startAllCollectors() throws LocalizableException {
        String[] stringArray = this.map.keySet().toArray(new String[this.map.size()]);
        int n = 0;
        ThreadPool threadPool = ThreadPool.getInstance();
        for (int i = 0; i < stringArray.length; ++i) {
            CollectorTaskThread collectorTaskThread = new CollectorTaskThread(stringArray[i], CollectorTask.START_COLLECTOR);
            try {
                threadPool.execute(collectorTaskThread);
                continue;
            }
            catch (Exception exception) {
                ++n;
                VendorException vendorException = new VendorException(exception);
                this.logger.logp(Level.SEVERE, CLASSNAME, "startAllCollectors()", vendorException.getLocalizedMessage(Locale.ENGLISH));
                throw vendorException;
            }
        }
        if (n > 0) {
            throw new LocalizableException("perfDataCollectorFactory.failedToStopOneOrMoreCollectors", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
        }
    }

    public void stopCollector(String string) throws LocalizableException {
        try {
            PerfDataCollector perfDataCollector = this.getCollector(string);
            perfDataCollector.stop();
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.INFO, CLASSNAME, "stopCollector(String)", localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logger.logp(Level.SEVERE, CLASSNAME, "stopCollector(String)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public synchronized void stopAllCollectors() throws LocalizableException {
        String[] stringArray = this.map.keySet().toArray(new String[this.map.size()]);
        int n = 0;
        ThreadPool threadPool = ThreadPool.getInstance();
        for (int i = 0; i < stringArray.length; ++i) {
            CollectorTaskThread collectorTaskThread = new CollectorTaskThread(stringArray[i], CollectorTask.STOP_COLLECTOR);
            try {
                threadPool.execute(collectorTaskThread);
                continue;
            }
            catch (Exception exception) {
                ++n;
                VendorException vendorException = new VendorException(exception);
                this.logger.logp(Level.SEVERE, CLASSNAME, "stopAllCollectors()", vendorException.getLocalizedMessage(Locale.ENGLISH));
            }
        }
        if (n > 0) {
            throw new LocalizableException("perfDataCollectorFactory.failedToStopOneOrMoreCollectors", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/performance/api/Localization");
        }
    }

    public LocalizableException[] reloadCollectors() throws LocalizableException {
        List list;
        try {
            list = KeyLookup.getAllKeys();
        }
        catch (LocalizableException localizableException) {
            throw localizableException;
        }
        catch (Exception exception) {
            throw new VendorException(exception);
        }
        if (list != null) {
            String[] stringArray = list.toArray(new String[list.size()]);
            ArrayList<LocalizableException> arrayList = new ArrayList<LocalizableException>();
            for (int i = 0; i <= stringArray.length; ++i) {
                PerfDataCollector perfDataCollector = (PerfDataCollector)this.map.get(stringArray[i]);
                try {
                    if (perfDataCollector != null) continue;
                    this.instantiateCollector(stringArray[i]);
                    perfDataCollector = (PerfDataCollector)this.map.get(stringArray[i]);
                    this.registerCollectorWithMBeanServer(perfDataCollector);
                    continue;
                }
                catch (LocalizableException localizableException) {
                    arrayList.add(localizableException);
                    continue;
                }
                catch (Exception exception) {
                    arrayList.add((LocalizableException)new VendorException(exception));
                }
            }
            return arrayList.toArray(new LocalizableException[list.size()]);
        }
        return new LocalizableException[0];
    }

    int instantiateCollectors(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.instantiateCollector(stringArray[i]);
                continue;
            }
            catch (LocalizableException localizableException) {
                ++n;
                this.logger.logp(Level.WARNING, CLASSNAME, "instantiateColectors(String[])", "Unable to reconsititute performance data collector, key=" + stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                ++n;
                VendorException vendorException = new VendorException(exception);
                this.logger.logp(Level.SEVERE, CLASSNAME, "instantiateColectors(String[])", vendorException.getLocalizedMessage(Locale.ENGLISH));
            }
        }
        if (n > 0) {
            this.logger.logp(Level.WARNING, CLASSNAME, "instantiateColectors(String[])", "Failed to start " + n + " collectors.");
        }
        return n;
    }

    public void instantiateCollector(String string) throws LocalizableException {
        PerfDataCollector perfDataCollector = null;
        try {
            perfDataCollector = new PerfDataCollector(string);
            this.map.put(string, perfDataCollector);
            PerfDataCollectorKeyFactory perfDataCollectorKeyFactory = PerfDataCollectorKeyFactory.getInstance();
            perfDataCollectorKeyFactory.add(perfDataCollector.getWWN(), string);
            this.logger.logp(Level.INFO, CLASSNAME, "instantiateCollector(String)", "Successully reconstituted collector key=" + string);
            this.registerCollectorWithMBeanServer(perfDataCollector);
        }
        catch (LocalizableException localizableException) {
            this.logger.logp(Level.INFO, CLASSNAME, "instantiateCollector(String)", localizableException.getLocalizedMessage(Locale.ENGLISH));
            throw localizableException;
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logger.logp(Level.SEVERE, CLASSNAME, "instantiateCollector(String)", "Failed to instantiate collector for device with the key of " + string + ". Cause: " + vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.statusChangeLock;
        synchronized (object) {
            this.status = OperationalStatus.STOPPING;
            if (this.mBeanServer != null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.logp(Level.FINE, CLASSNAME, "stop()", "Unregistering " + this.factoryObjectName.toString());
                }
                try {
                    this.mBeanServer.unregisterMBean(this.factoryObjectName);
                }
                catch (Exception exception) {
                    this.logger.logp(Level.SEVERE, CLASSNAME, "stop()", exception.getMessage(), exception);
                }
            }
            PerfDataCollector[] perfDataCollectorArray = this.map.values().toArray(new PerfDataCollector[this.map.size()]);
            int n = 0;
            for (int i = 0; i < perfDataCollectorArray.length; ++i) {
                try {
                    perfDataCollectorArray[i].shutdown();
                    this.unRegisterCollectorWithMBeanServer(perfDataCollectorArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    ++n;
                    this.logger.logp(Level.SEVERE, CLASSNAME, "stop()", "VENDER ERROR: Caught an unexpected exception: " + exception.getMessage(), exception);
                }
            }
            if (n > 0) {
                this.logger.logp(Level.WARNING, CLASSNAME, "stop()", "Failed to stop one or more collectors");
            }
            try {
                PersistenceManager.release();
            }
            catch (PersistenceException persistenceException) {
                // empty catch block
            }
            this.status = OperationalStatus.STOPPED;
        }
        this.logger.logp(Level.INFO, CLASSNAME, "stop()", "stop service completed.");
    }

    public int scrubDatabase() {
        String[] stringArray = this.getCollectorKeys();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                PerfDataCollector perfDataCollector = this.getCollector(stringArray[i]);
                if (perfDataCollector == null) continue;
                perfDataCollector.scrub();
                continue;
            }
            catch (LocalizableException localizableException) {
                ++n;
                this.logger.logp(Level.WARNING, CLASSNAME, "scrubDatabase()", "Colllector key=" + stringArray[i] + " failed to scrub it's database entries. Cause: " + localizableException.getLocalizedMessage(Locale.ENGLISH), localizableException);
                continue;
            }
            catch (Exception exception) {
                ++n;
                VendorException vendorException = new VendorException(exception);
                this.logger.logp(Level.WARNING, CLASSNAME, "scrubDatabase()", "Colllector key=" + stringArray[i] + " failed to scrub it's database entries. Cause: " + vendorException.getLocalizedMessage(Locale.ENGLISH));
            }
        }
        return n;
    }

    public String getLogFile() {
        return this.logfile;
    }

    public void setLogFile(String string) throws LocalizableException {
        if (string.equals(this.logfile)) {
            return;
        }
        if (this.logfileHandler != null) {
            try {
                this.logfileHandler.close();
                this.logger.removeHandler(this.logfileHandler);
            }
            catch (Exception exception) {
                this.logger.logp(Level.WARNING, CLASSNAME, "setLogFile(String)", "Failed to remove previous logfile handler for" + this.logfile);
            }
        }
        try {
            if ("null".equals(string)) {
                string = null;
            }
            this.logfile = string;
            if (this.logfile != null) {
                this.logfileHandler = new FileHandler(string);
                SimpleFormatter simpleFormatter = new SimpleFormatter();
                this.logfileHandler.setFormatter(simpleFormatter);
                this.logger.addHandler(this.logfileHandler);
            }
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logger.logp(Level.SEVERE, CLASSNAME, "setLogFile(String)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public String getEffectiveLogLevel() {
        Logger logger;
        for (logger = this.logger; logger != null && logger.getLevel() == null; logger = logger.getParent()) {
        }
        if (logger == null) {
            return "null";
        }
        Level level = logger.getLevel();
        if (level == null) {
            return "null";
        }
        String string = level.getName();
        if (string == null) {
            string = Integer.toString(level.intValue());
        }
        return string;
    }

    public String getLogLevel() {
        Level level = this.logger.getLevel();
        if (level == null) {
            return "null";
        }
        String string = this.logger.getLevel().getName();
        if (string == null) {
            string = Integer.toString(this.logger.getLevel().intValue());
        }
        return string;
    }

    public void setLogLevel(String string) throws LocalizableException {
        try {
            if (string != null && string.length() != 0) {
                if (string.toLowerCase().equals("null")) {
                    this.logger.setLevel(null);
                    ThreadPool.logger.setLevel(null);
                } else {
                    Level level = Level.parse(string.toUpperCase());
                    ThreadPool.logger.setLevel(level);
                    this.logger.setLevel(level);
                }
            }
            if (this.logger.isLoggable(Level.CONFIG)) {
                this.logger.logp(Level.CONFIG, CLASSNAME, "setLogLevel(String)", "Log level set to " + string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LocalizableException((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            VendorException vendorException = new VendorException(exception);
            this.logger.logp(Level.SEVERE, CLASSNAME, "setLogLevel(String)", vendorException.getLocalizedMessage(Locale.ENGLISH));
            throw vendorException;
        }
    }

    public String getOperationalStatus() {
        return this.status.toString();
    }

    public void setDataRetentionIntervalOnCollectorsTo(int n) throws LocalizableException {
        PerfDataCollector[] perfDataCollectorArray = this.map.values().toArray(new PerfDataCollector[this.map.size()]);
        int n2 = 0;
        for (int i = 0; i < perfDataCollectorArray.length; ++i) {
            try {
                perfDataCollectorArray[i].setDataRetentionInterval(n);
                continue;
            }
            catch (Exception exception) {
                ++n2;
                VendorException vendorException = new VendorException(exception);
                this.logger.logp(Level.SEVERE, CLASSNAME, "setPollIntervalOnCollectorsTo()", vendorException.getLocalizedMessage(Locale.ENGLISH));
            }
        }
        if (n2 > 0) {
            this.logger.logp(Level.WARNING, CLASSNAME, "setPollIntervalOnCollectorsTo()", "Failed to successfully set data retention interval of " + n + "days on " + n2 + " collectors.");
        }
    }

    public void setPollIntervalOnCollectorsTo(int n) throws LocalizableException {
        PerfDataCollector[] perfDataCollectorArray = this.map.values().toArray(new PerfDataCollector[this.map.size()]);
        int n2 = 0;
        for (int i = 0; i < perfDataCollectorArray.length; ++i) {
            try {
                perfDataCollectorArray[i].setPollingInterval(n);
                continue;
            }
            catch (Exception exception) {
                ++n2;
                VendorException vendorException = new VendorException(exception);
                this.logger.logp(Level.SEVERE, CLASSNAME, "setPollIntervalOnCollectorsTo()", vendorException.getLocalizedMessage(Locale.ENGLISH));
            }
        }
        if (n2 > 0) {
            this.logger.logp(Level.WARNING, CLASSNAME, "setPollIntervalOnCollectorsTo()", "Failed to successfully set polling interval on " + n2 + " collectors.");
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    private void registerCollectorWithMBeanServer(PerfDataCollector perfDataCollector) {
        if (this.mBeanServer != null) {
            try {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("key", perfDataCollector.getKey());
                hashtable.put("instance", (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean = Perf6130CollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.PerfDataCollectorMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean).getName());
                hashtable.put("type", "6130PerfCollector");
                ObjectName objectName = new ObjectName(DOMAIN, hashtable);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.logp(Level.FINE, CLASSNAME, "registerCollectorWithMBeanServer(PerfDataCollector)", "Registering MBean " + objectName.toString());
                }
                this.mBeanServer.registerMBean(perfDataCollector, objectName);
            }
            catch (Exception exception) {
                this.logger.logp(Level.SEVERE, CLASSNAME, "registerCollectorWithMBeanServer(PerfDataCollector)", exception.getMessage(), exception);
            }
        }
    }

    private void unRegisterCollectorWithMBeanServer(PerfDataCollector perfDataCollector) {
        if (this.mBeanServer != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("key", perfDataCollector.getKey());
            hashtable.put("instance", (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean = Perf6130CollectorFactory.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.api.PerfDataCollectorMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$api$PerfDataCollectorMBean).getName());
            hashtable.put("type", "6130PerfCollector");
            try {
                ObjectName objectName = new ObjectName(DOMAIN, hashtable);
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.logp(Level.FINE, CLASSNAME, "unRegisterCollectorWithMBeanServer(PerfDataCollector)", "Unregistering " + objectName.toString());
                }
                this.mBeanServer.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                this.logger.logp(Level.SEVERE, CLASSNAME, "unRegisterCollectorWithMBeanServer(PerfDataCollector)", exception.getMessage(), exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

