/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.ControllerPerfCounterData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataType;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfErrorCode;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.VolPerfCounterData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.VolPerfData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.util.Trace;

class ControllerPerfData
extends PerfData {
    private boolean blockSizeStatsValid = true;
    protected static final double LAZILY_PROCESS = -2.0;
    protected ControllerPerfCounterData currentPerfData = null;
    protected boolean volumeDeletedAfterStart = false;
    private boolean volumeDeletedDuringLastPoll = false;
    protected boolean volumeCreatedAfterStart = false;
    protected boolean controllerResetAfterStart = false;
    protected long bootTime = 0L;

    public ControllerPerfData(String string, String string2, PerfDataType perfDataType) {
        super(string, string2, perfDataType);
    }

    public ControllerPerfData(String string, String string2) {
        super(string, string2, PerfDataType.CONTROLLER);
    }

    public void setVolumeDeletedAfterStart() {
        this.volumeDeletedAfterStart = true;
        this.volumeDeletedDuringLastPoll = true;
    }

    public boolean volumeDeletedAfterStart() {
        return this.volumeDeletedAfterStart;
    }

    public void setVolumeCreatedAfterStart() {
        this.volumeCreatedAfterStart = true;
    }

    public boolean volumeCreatedAfterStart() {
        return this.volumeCreatedAfterStart;
    }

    public boolean controllerResetAfterStart() {
        return this.controllerResetAfterStart;
    }

    public void setControllerResetAfterStart() {
        this.controllerResetAfterStart = true;
        this.currentPerfData = new ControllerPerfCounterData();
        this.currentPerfData.setDataValid(false);
        this.currentPerfData.addErrorCode(PerfErrorCode.CONTROLLER_RESET);
        this.markDataAsNotAvailable();
        this.addErrorCode(PerfErrorCode.CONTROLLER_RESET);
    }

    public long getBootTime() {
        return this.bootTime;
    }

    public void setBootTime(long l) {
        this.bootTime = l;
    }

    protected void markInvalidDueToBlockSize() {
        this.blockSizeStatsValid = false;
        this.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        this.setAverageReadSize(-1.0);
        this.setAverageWriteSize(-1.0);
        this.setReadsPerSec(-1.0);
        this.setWritesPerSec(-1.0);
    }

    ControllerPerfCounterData getPerfData() {
        return this.currentPerfData;
    }

    void setPerfData(Object[] objectArray) {
        VolPerfData[] volPerfDataArray = (VolPerfData[])objectArray;
        ControllerPerfCounterData controllerPerfCounterData = new ControllerPerfCounterData();
        VolPerfCounterData volPerfCounterData = null;
        int n = 0;
        if (this.volumeDeletedDuringLastPoll) {
            this.volumeDeletedDuringLastPoll = false;
            this.addErrorCode(PerfErrorCode.VOLUME_DELETED);
            controllerPerfCounterData.setDataValid(false);
        }
        for (int i = 0; i < volPerfDataArray.length && controllerPerfCounterData.isDataValid(); ++i) {
            volPerfCounterData = volPerfDataArray[i].getDiffData();
            if (volPerfCounterData != null) {
                ++n;
                if (!volPerfCounterData.isDataValid()) {
                    controllerPerfCounterData.setDataValid(false);
                    controllerPerfCounterData.addErrorCodes(volPerfCounterData.getErrorCodes());
                    continue;
                }
                if (controllerPerfCounterData.time == 0L) {
                    controllerPerfCounterData.time = volPerfCounterData.time;
                }
                controllerPerfCounterData.totalIOs += (double)volPerfCounterData.totalRequestsServiced;
                controllerPerfCounterData.totalReadRequests += (double)volPerfCounterData.totalReadRequests;
                controllerPerfCounterData.totalWriteRequests += (double)volPerfCounterData.totalWriteRequests;
                controllerPerfCounterData.totalCacheReadChecks += volPerfCounterData.totalCacheReadChecks;
                controllerPerfCounterData.totalCacheReadCheckHits += volPerfCounterData.totalCacheReadCheckHits;
                controllerPerfCounterData.totalIOPs += volPerfDataArray[i].getTotalIOPs();
                if (controllerPerfCounterData.isBlockSizeValid() && volPerfCounterData.isBlockSizeValid()) {
                    controllerPerfCounterData.totalBytesReadPerSec += volPerfDataArray[i].getReadsPerSec();
                    controllerPerfCounterData.totalBytesWrittenPerSec += volPerfDataArray[i].getWritesPerSec();
                    controllerPerfCounterData.totalAverageReadSize += volPerfDataArray[i].getAverageReadSize();
                    controllerPerfCounterData.totalAverageWriteSize += volPerfDataArray[i].getAverageWriteSize();
                    continue;
                }
                controllerPerfCounterData.setBlockSizeValid(false);
                continue;
            }
            VolPerfCounterData volPerfCounterData2 = volPerfDataArray[i].getPerfData();
            if (volPerfCounterData2 == null) {
                Trace.verbose((Object)this, "setPerfData", "Didn't get any data for volume " + volPerfDataArray[i].getName());
            } else {
                if (!volPerfCounterData2.isDataValid()) {
                    controllerPerfCounterData.setDataValid(false);
                    controllerPerfCounterData.addErrorCodes(volPerfCounterData2.getErrorCodes());
                }
                ++n;
            }
            if (!volPerfDataArray[i].volumeCreatedAfterStart()) continue;
            this.setVolumeCreatedAfterStart();
        }
        if (n > 0 && n != volPerfDataArray.length && controllerPerfCounterData.isDataValid()) {
            controllerPerfCounterData.setDataValid(false);
            Trace.error((Object)this, "setPerfData", "Didn't process all the volume stats for " + this.getName() + " processed=" + n + " volData.length=" + volPerfDataArray.length);
            controllerPerfCounterData.addErrorCode(PerfErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION);
        }
        if (controllerPerfCounterData.isDataValid()) {
            if (controllerPerfCounterData.totalCacheReadChecks == 0L || controllerPerfCounterData.totalCacheReadCheckHits == 0L) {
                this.setCacheReadHitPercentage(0.0f);
            } else {
                this.setCacheReadHitPercentage(controllerPerfCounterData.totalCacheReadCheckHits / controllerPerfCounterData.totalCacheReadChecks * 100L);
            }
            if (controllerPerfCounterData.totalReadRequests == 0.0) {
                this.setReadPercentage(0.0f);
            } else {
                this.setReadPercentage((float)(controllerPerfCounterData.totalReadRequests / controllerPerfCounterData.totalIOs) * 100.0f);
            }
            if (controllerPerfCounterData.totalWriteRequests == 0.0) {
                this.setWritePercentage(0.0f);
            } else {
                this.setWritePercentage((float)(controllerPerfCounterData.totalWriteRequests / controllerPerfCounterData.totalIOs) * 100.0f);
            }
            this.setTotalIOPs(controllerPerfCounterData.totalIOPs);
            if (controllerPerfCounterData.isBlockSizeValid()) {
                this.setAverageReadSize(controllerPerfCounterData.totalAverageReadSize);
                this.setAverageWriteSize(controllerPerfCounterData.totalAverageWriteSize);
                this.setReadsPerSec(controllerPerfCounterData.totalBytesReadPerSec);
                this.setWritesPerSec(controllerPerfCounterData.totalBytesWrittenPerSec);
            } else {
                this.markInvalidDueToBlockSize();
            }
        } else {
            this.markDataAsNotAvailable();
        }
        this.addErrorCodes(controllerPerfCounterData.getErrorCodes());
        this.currentPerfData = controllerPerfCounterData;
    }
}

