/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfCounterData;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfErrorCode;

public class ControllerPerfCounterData
extends PerfCounterData {
    long time = 0L;
    double totalIOs = 0.0;
    double totalIOPs = 0.0;
    double totalReadRequests = 0.0;
    double totalWriteRequests = 0.0;
    long totalCacheReadCheckHits = 0L;
    long totalCacheReadChecks = 0L;
    double totalBytesReadPerSec = 0.0;
    double totalBytesWrittenPerSec = 0.0;
    double totalAverageReadSize = 0.0;
    double totalAverageWriteSize = 0.0;
    boolean dataValidity = true;
    boolean blockSizeValidity = true;

    public boolean isDataValid() {
        return this.dataValidity;
    }

    public void setDataValid(boolean bl) {
        this.dataValidity = bl;
    }

    public boolean isBlockSizeValid() {
        return this.blockSizeValidity;
    }

    public void setBlockSizeValid(boolean bl) {
        this.blockSizeValidity = bl;
    }

    public void add(ControllerPerfCounterData controllerPerfCounterData) {
        if (controllerPerfCounterData == null) {
            this.setDataValid(false);
            this.addErrorCode(PerfErrorCode.NO_PATH_TO_CONTROLLER);
            return;
        }
        if (!this.isDataValid()) {
            return;
        }
        this.totalIOs += controllerPerfCounterData.totalIOs;
        this.totalIOPs += controllerPerfCounterData.totalIOPs;
        this.totalReadRequests += controllerPerfCounterData.totalReadRequests;
        this.totalWriteRequests += controllerPerfCounterData.totalWriteRequests;
        this.totalCacheReadCheckHits += controllerPerfCounterData.totalCacheReadCheckHits;
        this.totalCacheReadChecks += controllerPerfCounterData.totalCacheReadChecks;
        if (this.isBlockSizeValid() && controllerPerfCounterData.isBlockSizeValid()) {
            this.totalBytesReadPerSec += controllerPerfCounterData.totalBytesReadPerSec;
            this.totalBytesWrittenPerSec += controllerPerfCounterData.totalBytesWrittenPerSec;
            this.totalAverageReadSize += controllerPerfCounterData.totalAverageReadSize;
            this.totalAverageWriteSize += controllerPerfCounterData.totalAverageWriteSize;
        } else if (!this.isBlockSizeValid()) {
            this.setBlockSizeValid(false);
            this.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        }
    }
}

