/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.CollectorTask;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.Perf6130CollectorFactory;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.Perf6130Constants;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.PerfDataCollector;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.util.logging.Level;

public class CollectorTaskThread
extends Thread {
    String key;
    int taskId;
    Object param;

    public CollectorTaskThread(String string, CollectorTask collectorTask, Object object) {
        this.key = string;
        this.taskId = collectorTask.getTaskId();
        this.param = object;
    }

    public CollectorTaskThread(String string, CollectorTask collectorTask) {
        this(string, collectorTask, null);
    }

    public void run() {
        Perf6130CollectorFactory perf6130CollectorFactory = Perf6130CollectorFactory.getInstance();
        try {
            PerfDataCollector perfDataCollector = null;
            if (perf6130CollectorFactory.containsCollector(this.key)) {
                try {
                    perfDataCollector = perf6130CollectorFactory.getCollector(this.key);
                }
                catch (LocalizableException localizableException) {
                    // empty catch block
                }
            }
            if (perfDataCollector != null) {
                switch (this.taskId) {
                    case 0: {
                        perfDataCollector.start();
                        break;
                    }
                    case 1: {
                        perfDataCollector.stop();
                        break;
                    }
                    case 2: {
                        perf6130CollectorFactory.instantiateCollector(this.key);
                        break;
                    }
                    case 3: {
                        int n = (Integer)this.param;
                        perfDataCollector.setPollingInterval(n);
                        break;
                    }
                    case 4: {
                        int n = (Integer)this.param;
                        perfDataCollector.setDataRetentionInterval(n);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized task id " + this.taskId);
                    }
                }
            }
        }
        catch (Exception exception) {
            Perf6130Constants.LOGGER.logp(Level.WARNING, this.getClass().getName(), "run()", "VENDOR ERROR: Unexpected exception: " + exception.getMessage(), exception);
        }
    }
}

