/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.core;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.core.ArrayReg;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.impl.Perf6130Constants;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.util.Convert;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.util.Trace;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.symbol.AccessibleController;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DiscoveryResponse;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectBundleManager {
    public static final String CLASSNAME = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$core$ObjectBundleManager == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$core$ObjectBundleManager = ObjectBundleManager.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.performance.array6130.core.ObjectBundleManager")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$core$ObjectBundleManager).getName();
    private static final Logger logger = Perf6130Constants.LOGGER;
    private static final String PING_CMD = "/usr/sbin/ping -A inet ";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$performance$array6130$core$ObjectBundleManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectBundle getObjectBundle(ArrayReg arrayReg) {
        SYMbolAPIClientV1 sYMbolAPIClientV1 = null;
        ObjectBundle objectBundle = null;
        if (arrayReg == null) {
            throw new IllegalArgumentException("ArrayReg is null.");
        }
        String[] stringArray = arrayReg.getIps();
        try {
            for (int i = 0; i < stringArray.length && objectBundle == null; ++i) {
                InetAddress inetAddress;
                try {
                    if (stringArray[i] != null) {
                        inetAddress = InetAddress.getByName(stringArray[i]);
                        sYMbolAPIClientV1 = ObjectBundleManager.ping(stringArray[i]) ? new SYMbolAPIClientV1(inetAddress, 2463, true) : null;
                    }
                }
                catch (Exception exception) {
                    Trace.error((Object)this, "Exception while attempting to load:" + stringArray[i], exception);
                    sYMbolAPIClientV1 = null;
                }
                if (sYMbolAPIClientV1 == null) continue;
                try {
                    inetAddress = sYMbolAPIClientV1.discoverControllers();
                    AccessibleController[] accessibleControllerArray = inetAddress.getControllers();
                    int n = accessibleControllerArray == null ? 0 : accessibleControllerArray.length;
                    for (int j = 0; j < n && objectBundle == null; ++j) {
                        ControllerRef controllerRef = accessibleControllerArray[j].getThisController();
                        SAIdentifier sAIdentifier = accessibleControllerArray[j].getSaId();
                        ControllerDescriptor controllerDescriptor = new ControllerDescriptor();
                        controllerDescriptor.setControllerRef(controllerRef);
                        controllerDescriptor.setSaId(sAIdentifier);
                        ReturnCode returnCode = sYMbolAPIClientV1.bindToController(controllerDescriptor);
                        if (returnCode.getValue() == 1) {
                            objectBundle = sYMbolAPIClientV1.getObjectGraph();
                            continue;
                        }
                        Trace.verbose((Object)this, "run", "failed binding with controller:" + accessibleControllerArray[j].getSlot());
                    }
                    continue;
                }
                catch (RPCError rPCError) {
                    Trace.error(this, (Exception)((Object)rPCError));
                    continue;
                }
                catch (IOException iOException) {
                    Trace.error(this, (Exception)iOException);
                }
            }
            Object var15_17 = null;
            if (sYMbolAPIClientV1 == null) return objectBundle;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (sYMbolAPIClientV1 == null) throw throwable;
            try {
                sYMbolAPIClientV1.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            sYMbolAPIClientV1.close();
            return objectBundle;
        }
        catch (Exception exception) {}
        return objectBundle;
    }

    public SYMbolAPIClientV1 getClient(ArrayReg arrayReg) throws RPCError, IOException {
        SYMbolAPIClientV1 sYMbolAPIClientV1 = null;
        String[] stringArray = arrayReg.getIps();
        for (int i = 0; i < stringArray.length; ++i) {
            InetAddress inetAddress = InetAddress.getByName(stringArray[i]);
            if (!ObjectBundleManager.ping(stringArray[i]) || (sYMbolAPIClientV1 = new SYMbolAPIClientV1(inetAddress, 2463, true)) == null) continue;
            return sYMbolAPIClientV1;
        }
        return null;
    }

    public SYMbolAPIClientV1 getClient(ArrayReg arrayReg, String string) throws RPCError, IOException {
        boolean bl = false;
        SYMbolAPIClientV1 sYMbolAPIClientV1 = null;
        String[] stringArray = arrayReg.getIps();
        for (int i = 0; i < stringArray.length && !bl; ++i) {
            ControllerDescriptor controllerDescriptor;
            Object object;
            Object object2;
            int n;
            AccessibleController[] accessibleControllerArray;
            InetAddress inetAddress = InetAddress.getByName(stringArray[i]);
            if (!ObjectBundleManager.ping(stringArray[i])) {
                throw new IOException("Ping to " + inetAddress.getHostAddress() + " timed out.");
            }
            sYMbolAPIClientV1 = new SYMbolAPIClientV1(inetAddress, 2463, true);
            DiscoveryResponse discoveryResponse = sYMbolAPIClientV1.discoverControllers();
            if (!discoveryResponse.getResponseFromAgent()) {
                accessibleControllerArray = sYMbolAPIClientV1.getObjectGraph().getController();
                for (n = 0; n < accessibleControllerArray.length && !bl; ++n) {
                    String string2 = Convert.bytesToString(accessibleControllerArray[n].getControllerRef().getRefToken());
                    if (!string2.equals(string)) continue;
                    object2 = this.getIPFromController((Controller)accessibleControllerArray[n]);
                    if (object2 != null && ((String)object2).equals(inetAddress.getHostAddress())) {
                        bl = true;
                    } else {
                        try {
                            sYMbolAPIClientV1.close();
                        }
                        catch (Exception exception) {
                            Trace.error((Object)this, "getClient", "Error closing connection:" + exception.getMessage());
                        }
                        object = InetAddress.getByName((String)object2);
                        if (!ObjectBundleManager.ping(((InetAddress)object).getHostAddress())) {
                            throw new IOException("Ping to " + ((InetAddress)object).getHostAddress() + " timed out.");
                        }
                        sYMbolAPIClientV1 = new SYMbolAPIClientV1((InetAddress)object, 2463, true);
                        bl = true;
                    }
                    object = new ControllerDescriptor();
                    object.setControllerRef(accessibleControllerArray[n].getControllerRef());
                    controllerDescriptor = sYMbolAPIClientV1.getSAData().getSaId();
                    object.setSaId((SAIdentifier)controllerDescriptor);
                    sYMbolAPIClientV1.bindToController((ControllerDescriptor)object);
                }
                continue;
            }
            accessibleControllerArray = discoveryResponse.getControllers();
            n = accessibleControllerArray == null ? 0 : accessibleControllerArray.length;
            for (int j = 0; j < n && !bl; ++j) {
                object2 = accessibleControllerArray[j].getThisController();
                if (!Convert.bytesToString(object2.getRefToken()).equals(string) || (object = accessibleControllerArray[j].getSaId()).getWorldWideName() == null || !Convert.bytesToString(object.getWorldWideName()).equalsIgnoreCase(arrayReg.getWWN())) continue;
                controllerDescriptor = new ControllerDescriptor();
                controllerDescriptor.setControllerRef((ControllerRef)object2);
                controllerDescriptor.setSaId((SAIdentifier)object);
                sYMbolAPIClientV1.bindToController(controllerDescriptor);
                bl = true;
            }
        }
        if (!bl) {
            throw new IOException("Connection to " + arrayReg.getNodeName() + " could not be established.");
        }
        return sYMbolAPIClientV1;
    }

    private String getIPFromController(Controller controller) {
        String string = null;
        NetInterfaceTypeData[] netInterfaceTypeDataArray = controller.getNetInterfaces();
        for (int i = 0; i < netInterfaceTypeDataArray.length && string == null; ++i) {
            if (netInterfaceTypeDataArray[i].getInterfaceType().getValue() != 1) continue;
            string = Convert.getIpStrFromInt(netInterfaceTypeDataArray[i].getEthernet().getIp());
        }
        return string;
    }

    public ArrayReg getArrayReg(InetAddress inetAddress) throws UnknownHostException, RPCError, IOException {
        Controller[] controllerArray;
        ArrayReg arrayReg = new ArrayReg();
        if (!ObjectBundleManager.ping(inetAddress.getHostAddress())) {
            throw new IOException("Ping to device " + inetAddress.getHostAddress() + " failed.");
        }
        SYMbolAPIClientV1 sYMbolAPIClientV1 = new SYMbolAPIClientV1(inetAddress, 2463, true);
        DiscoveryResponse discoveryResponse = sYMbolAPIClientV1.discoverControllers();
        byte[] byArray = sYMbolAPIClientV1.getSAData().getSaId().getWorldWideName();
        if (byArray != null) {
            controllerArray = Convert.bytesToString(byArray).toUpperCase();
            arrayReg.setWWN((String)controllerArray);
        }
        if (!discoveryResponse.getResponseFromAgent()) {
            controllerArray = sYMbolAPIClientV1.getObjectGraph().getController();
            for (int i = 0; i < controllerArray.length; ++i) {
                String string = this.getIPFromController(controllerArray[i]);
                if (string == null) continue;
                arrayReg.addIp(string);
            }
        } else {
            arrayReg.addIp(inetAddress.getHostAddress());
        }
        arrayReg.setNodeName(sYMbolAPIClientV1.getSAData());
        return arrayReg;
    }

    public static boolean ping(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(PING_CMD);
            stringBuffer.append(string);
            Process process = Runtime.getRuntime().exec(stringBuffer.toString());
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLASSNAME, "ping(String)", "VENDER ERROR: Caught an unexpected exception: " + exception.getLocalizedMessage(), exception);
            return true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

