/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl;

import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.IpRange;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.AgentLocationUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.DeviceUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.IpRangeUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryCollectorUtil;
import com.sun.netstorage.mgmt.esm.logic.data.api.Element;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class StoradeDiscoveryDeleteJob
implements Job {
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob = StoradeDiscoveryDeleteJob.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryDeleteJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob).getPackage().getName());
    private static String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob = StoradeDiscoveryDeleteJob.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryDeleteJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob).getName();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$Element;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "execute", ": job name < " + jobExecutionContext.getJobDetail().getFullName() + " > at time < " + new Date() + " >");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<CollectedKeys> arrayList2 = new ArrayList<CollectedKeys>();
        try {
            Object[] objectArray;
            StoradeDiscoveryCollectorUtil storadeDiscoveryCollectorUtil;
            String[] stringArray;
            JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            IpRange[] ipRangeArray = (IpRange[])jobDataMap.get((Object)"ranges");
            if (null == ipRangeArray) {
                logger.logp(Level.SEVERE, CLAZZ, "execute", "deletion job data map returned null ranges array");
            } else {
                for (int i = 0; i < ipRangeArray.length; ++i) {
                    try {
                        stringArray = AgentLocationUtil.getAgentLocationBean(ipRangeArray[i].getAgentLocation());
                        if (stringArray == null) {
                            logger.logp(Level.INFO, CLAZZ, "execute", "AgentLocationBean is null for range: " + ipRangeArray[i].getStart() + "-" + ipRangeArray[i].getEnd());
                            continue;
                        }
                        storadeDiscoveryCollectorUtil = new StoradeDiscoveryCollectorUtil(ipRangeArray[i].getAgentLocation(), stringArray.getUid(), stringArray.getPasswd());
                        String[] stringArray2 = null;
                        if (storadeDiscoveryCollectorUtil == null) continue;
                        stringArray2 = IpRangeUtil.iterateIps(new IpRange[]{ipRangeArray[i]});
                        for (int j = 0; j < stringArray2.length; ++j) {
                            arrayList.add(stringArray2[j]);
                        }
                        String[] stringArray3 = StoradeDiscoveryDeleteJob.getDeviceKeys(stringArray2);
                        CollectedKeys collectedKeys = new CollectedKeys(storadeDiscoveryCollectorUtil, stringArray3);
                        arrayList2.add(collectedKeys);
                        continue;
                    }
                    catch (Exception exception) {
                        logger.logp(Level.INFO, CLAZZ, "execute", "Exception caught getting devices to be deleted", exception);
                    }
                }
            }
            try {
                objectArray = arrayList.toArray(new String[arrayList.size()]);
                DeviceUtil.deleteDevice((String[])objectArray);
            }
            catch (Exception exception) {
                logger.logp(Level.INFO, CLAZZ, "execute", "Exception caught deleting elements from the dbase", exception);
            }
            objectArray = arrayList2.toArray(new CollectedKeys[arrayList2.size()]);
            stringArray = null;
            storadeDiscoveryCollectorUtil = null;
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray = ((CollectedKeys)objectArray[i]).getDeviceKeys();
                storadeDiscoveryCollectorUtil = ((CollectedKeys)objectArray[i]).getCollectorUtil();
                try {
                    storadeDiscoveryCollectorUtil.deleteDevice(stringArray);
                    storadeDiscoveryCollectorUtil = null;
                    continue;
                }
                catch (Exception exception) {
                    logger.logp(Level.INFO, CLAZZ, "execute", "Exception caught deleting devices from storade", exception);
                }
            }
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, CLAZZ, "execute", "Exception thrown executing job < " + jobExecutionContext.getJobDetail().getFullName() + " > at time < " + new Date() + " >", exception);
            throw new JobExecutionException(exception);
        }
    }

    private static String[] getDeviceKeys(String[] stringArray) {
        Element[] elementArray = StoradeDiscoveryDeleteJob.getElements(stringArray);
        String[] stringArray2 = new String[elementArray.length];
        for (int i = 0; i < elementArray.length; ++i) {
            stringArray2[i] = new String(elementArray[i].getDeviceKey());
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Element[] getElements(String[] stringArray) {
        ArrayList<Element> arrayList;
        block13: {
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            Transaction transaction = null;
            PersistentObject[] persistentObjectArray = null;
            PersistenceManager persistenceManager = null;
            arrayList = new ArrayList<Element>();
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$Element == null ? StoradeDiscoveryDeleteJob.class$("com.sun.netstorage.mgmt.esm.logic.data.api.Element") : class$com$sun$netstorage$mgmt$esm$logic$data$api$Element, (Filter)new EqualsFilter("ip_address", stringArray[i].trim()));
                    if (persistentObjectArray == null || persistentObjectArray.length <= 0) continue;
                    arrayList.add((Element)persistentObjectArray[0]);
                    continue;
                }
                catch (Exception exception) {
                    logger.logp(Level.INFO, CLAZZ, "getElements", "Exception caught attempting to get element " + stringArray[i] + " from database: ", exception);
                }
            }
            Object var9_8 = null;
            try {
                persistenceManager.releaseTransaction(transaction);
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "getElements", "Exception caught releasing transaction from database", exception);
            }
            break block13;
            {
                catch (Exception exception) {
                    logger.logp(Level.INFO, CLAZZ, "getElements", "Exception caught attempting to get elements from dbase", exception);
                    Object var9_9 = null;
                    try {
                        persistenceManager.releaseTransaction(transaction);
                    }
                    catch (Exception exception2) {
                        logger.logp(Level.WARNING, CLAZZ, "getElements", "Exception caught releasing transaction from database", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    persistenceManager.releaseTransaction(transaction);
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "getElements", "Exception caught releasing transaction from database", exception);
                }
                throw throwable;
            }
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new Element[arrayList.size()]);
        }
        return new Element[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CollectedKeys {
        private StoradeDiscoveryCollectorUtil collectorUtil = null;
        private String[] deviceKeys = null;

        public CollectedKeys(StoradeDiscoveryCollectorUtil storadeDiscoveryCollectorUtil, String[] stringArray) {
            this.collectorUtil = storadeDiscoveryCollectorUtil;
            this.deviceKeys = stringArray;
        }

        public StoradeDiscoveryCollectorUtil getCollectorUtil() {
            return this.collectorUtil;
        }

        public String[] getDeviceKeys() {
            return this.deviceKeys;
        }
    }
}

