/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl;

import com.sun.netstorage.fm.storade.client.SAClient;
import com.sun.netstorage.fm.storade.service.StoradeException;
import com.sun.netstorage.fm.storade.service.device.DeviceMaintenanceService;
import com.sun.netstorage.fm.storade.service.device.DeviceProperties;
import com.sun.netstorage.fm.storade.service.device.DeviceReportService;
import com.sun.netstorage.fm.storade.service.device.DeviceSummary;
import com.sun.netstorage.fm.storade.service.device.DiscoveryResult;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.common.impl.StoradeClientException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.SAClientFactory;
import com.sun.netstorage.mgmt.esm.logic.data.api.Element;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StoradeDiscoveryCollectorUtil {
    private static SAClient client = null;
    private static DeviceMaintenanceService dms = null;
    private static DeviceReportService drs = null;
    private static final int WAIT_TIME = 5000;
    private static final String SUN = "Sun";
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorUtil == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorUtil = StoradeDiscoveryCollectorUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryCollectorUtil")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorUtil).getPackage().getName());
    private static final String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorUtil == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorUtil = StoradeDiscoveryCollectorUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryCollectorUtil")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorUtil).getName();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorUtil;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$Element;

    public StoradeDiscoveryCollectorUtil(String string, String string2, String string3) throws StoradeClientException {
        client = SAClientFactory.getInstance().getSAClient(string, string2, string3);
        if (client == null) {
            logger.logp(Level.WARNING, CLAZZ, "StoradeDiscoveryCollectorUtil", "could not instantiate SAClient");
            throw new StoradeClientException();
        }
        dms = client.getDeviceMaintenanceService();
        drs = client.getDeviceReportService();
    }

    protected void discoverDevice(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("ips == null || ips.length == 0");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "discoverDevice", "ips.length = " + stringArray.length);
        }
        Vector<DeviceSummary> vector = new Vector<DeviceSummary>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                DeviceProperties[] devicePropertiesArray;
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLAZZ, "discoverDevice", "Asking StorADE to discover: " + stringArray[i]);
                }
                if ((devicePropertiesArray = dms.discoverDevice(stringArray[i])) != null) {
                    for (int j = 0; j < devicePropertiesArray.length; ++j) {
                        if (null == devicePropertiesArray[j] || null == devicePropertiesArray[j].getKey()) continue;
                        DeviceSummary deviceSummary = drs.getDeviceSummary(devicePropertiesArray[j].getKey());
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLAZZ, "discoverDevice", "\nFor IP: " + stringArray[i] + " storade returned DeviceProperties key: " + devicePropertiesArray[j].getKey() + ", IP: " + devicePropertiesArray[j].getIPNumber() + ", name: " + devicePropertiesArray[j].getName());
                        }
                        if (null == deviceSummary) continue;
                        vector.add(deviceSummary);
                        if (!logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.FINER, CLAZZ, "discoverDevice", "\nFor DeviceProperties key: " + devicePropertiesArray[j].getKey() + " storade returned DeviceSummary key: " + deviceSummary.getKey() + ", IP: " + deviceSummary.getIpNumber() + ", name: " + deviceSummary.getName());
                    }
                }
            }
            catch (StoradeException storadeException) {
                logger.logp(Level.WARNING, CLAZZ, "discoverDevice", "Exception caught attempting to discover device " + stringArray[i], storadeException);
            }
            try {
                StoradeDiscoveryCollectorUtil.persistElements(vector.toArray(new DeviceSummary[0]));
                continue;
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, CLAZZ, "discoverDevice", "Exception caught persisting elements", exception);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "discoverDevice");
        }
    }

    protected DeviceSummary[] discoverDeviceAsynch(String string) {
        DeviceProperties[] devicePropertiesArray;
        if (string == null) {
            throw new IllegalArgumentException("ipList == null");
        }
        String string2 = client.getURL().getHost();
        try {
            if (InetAddress.getLocalHost().equals(InetAddress.getByName(string2))) {
                string2 = null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            logger.logp(Level.WARNING, CLAZZ, "discoverDeviceAsynch", "Exception caught getting InetAddress for agent host " + string2, unknownHostException);
            return new DeviceSummary[0];
        }
        Vector<DeviceSummary> vector = new Vector<DeviceSummary>();
        DiscoveryResult discoveryResult = null;
        String string3 = null;
        try {
            string3 = dms.discoverDevice(string, true, true, null, string2);
            if (string3 == null) {
                logger.logp(Level.WARNING, CLAZZ, "discoverDeviceAsynch", "execution id returned from discoverDevice for " + string + " is null");
            }
            if ((discoveryResult = dms.getDiscoveryResult(string3)) == null) {
                logger.logp(Level.WARNING, CLAZZ, "discoverDeviceAsynch", "discovery result returned from discoverDevice for " + string + " is null");
            }
        }
        catch (StoradeException storadeException) {
            logger.logp(Level.WARNING, CLAZZ, "discoverDeviceAsynch", "exeption caught while trying to discover device(s) " + string, storadeException);
        }
        int n = 0;
        int n2 = discoveryResult.getState();
        while (n2 == 1 && (long)n < 604800000L) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                logger.logp(Level.WARNING, CLAZZ, "discoverDeviceAsynch", "Exception caught while discovery thread sleeps", interruptedException);
            }
            n += 5000;
            try {
                discoveryResult = dms.getDiscoveryResult(string3);
            }
            catch (StoradeException storadeException) {
                logger.logp(Level.WARNING, CLAZZ, "discoverDeviceAsynch", "exeption caught trying to get discovery result for " + string, storadeException);
                break;
            }
            if (discoveryResult != null) {
                n2 = discoveryResult.getState();
                continue;
            }
            logger.logp(Level.WARNING, CLAZZ, "discoverDeviceAsynch", "discovery result returned from discoverDevice for " + string + " is null");
            break;
        }
        if ((devicePropertiesArray = discoveryResult.getDiscoveredDevices()) != null) {
            for (int i = 0; i < devicePropertiesArray.length; ++i) {
                if (null == devicePropertiesArray[i]) continue;
                try {
                    vector.add(drs.getDeviceSummary(devicePropertiesArray[i].getKey()));
                    continue;
                }
                catch (StoradeException storadeException) {
                    logger.logp(Level.WARNING, CLAZZ, "discoverDeviceAsynch", "Exception caught getting device summary for " + string, storadeException);
                }
            }
        }
        DeviceSummary[] deviceSummaryArray = null;
        deviceSummaryArray = vector != null && vector.size() > 0 ? vector.toArray(new DeviceSummary[0]) : new DeviceSummary[]{};
        return deviceSummaryArray;
    }

    protected void deleteDevice(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLAZZ, "deleteDevice", "removing " + stringArray[i] + " from storade");
                }
                dms.removeDevice(stringArray[i]);
                continue;
            }
            catch (StoradeException storadeException) {
                logger.logp(Level.WARNING, CLAZZ, "deleteDevice", "Exception caught attempting to delete element " + stringArray[i] + " from storade: ", storadeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static void persistElements(DeviceSummary[] deviceSummaryArray) {
        block30: {
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            if (deviceSummaryArray == null || deviceSummaryArray.length == 0) {
                return;
            }
            try {
                persistenceManager = PersistenceManager.getInstance();
                transaction = persistenceManager.getTransaction();
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "persistElements", "Exception caught getting transaction to persist elements", exception);
                try {
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception2) {
                    logger.logp(Level.WARNING, CLAZZ, "persistElements", "Exception caught releasing transaction", exception2);
                }
                return;
            }
            for (int i = 0; i < deviceSummaryArray.length; ++i) {
                String string;
                Object object;
                Object object2;
                if (deviceSummaryArray[i] == null) continue;
                String string2 = deviceSummaryArray[i].getWwn();
                if (string2 == null || string2.length() == 0 || string2.trim().toLowerCase().equals("null")) {
                    logger.logp(Level.WARNING, CLAZZ, "persistElements", "Storade returned a null WWN for device with IP: " + deviceSummaryArray[i].getIpNumber() + ", name: " + deviceSummaryArray[i].getDisplayName() + ", type: " + deviceSummaryArray[i].getCategory() + ", model: " + deviceSummaryArray[i].getModel() + ", vendor: " + deviceSummaryArray[i].getVendor() + ", device key: " + deviceSummaryArray[i].getKey());
                    continue;
                }
                Element element = null;
                PersistentObject[] persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$Element == null ? StoradeDiscoveryCollectorUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.Element") : class$com$sun$netstorage$mgmt$esm$logic$data$api$Element, (Filter)new EqualsFilter("wwn", string2));
                if (persistentObjectArray == null || persistentObjectArray.length == 0) {
                    element = new Element(string2);
                    element.setDiscovered(true);
                    element.setType(deviceSummaryArray[i].getCategory());
                    object2 = deviceSummaryArray[i].getModel();
                    if (object2 == null) {
                        element.setModel("");
                    } else {
                        element.setModel((String)object2);
                    }
                    element.setName(deviceSummaryArray[i].getDisplayName());
                    element.setIpAddress(deviceSummaryArray[i].getIpNumber());
                    object = deviceSummaryArray[i].getVendor();
                    if (null != object && ((String)object).trim().equalsIgnoreCase(SUN)) {
                        element.setVendor(SUN);
                    } else {
                        element.setVendor((String)object);
                    }
                    element.setDeviceKey(deviceSummaryArray[i].getKey());
                    try {
                        transaction.begin();
                        transaction.put((PersistentObject)element);
                        transaction.commit();
                    }
                    catch (Exception exception) {
                        logger.logp(Level.WARNING, CLAZZ, "persistElements", "Exception caught persisting element " + element.getName() + " in database.", exception);
                        transaction.rollback();
                    }
                    continue;
                }
                object2 = new EqualsFilter("wwn", string2);
                object = new String[]{"name", "type", "ip_address", "model", "vendor", "device_key", "discovered"};
                String string3 = deviceSummaryArray[i].getVendor();
                if (null != string3 && string3.trim().equalsIgnoreCase(SUN)) {
                    string3 = new String(SUN);
                }
                if ((string = deviceSummaryArray[i].getModel()) == null) {
                    string = new String("");
                }
                String[] stringArray = new String[]{deviceSummaryArray[i].getDisplayName(), deviceSummaryArray[i].getCategory(), deviceSummaryArray[i].getIpNumber(), string, string3, deviceSummaryArray[i].getKey(), Boolean.toString(true)};
                try {
                    transaction.begin();
                    Element.update((Transaction)transaction, (String[])object, (String[])stringArray, (Filter)object2);
                    transaction.commit();
                    continue;
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "persistElements", "Exception caught persisting element " + element.getName() + " in database.", exception);
                    transaction.rollback();
                }
            }
            Object var15_17 = null;
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                break block30;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "persistElements", "Exception caught releasing transaction", exception);
            }
            break block30;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "persistElements", "Exception caught attempting to persist elements in database", exception);
                    Object var15_18 = null;
                    try {
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block30;
                    }
                    catch (Exception exception3) {
                        logger.logp(Level.WARNING, CLAZZ, "persistElements", "Exception caught releasing transaction", exception3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                try {
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "persistElements", "Exception caught releasing transaction", exception);
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

