/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl;

import EDU.oswego.cs.dl.util.concurrent.CountDown;
import com.sun.cacao.ObjectNameFactory;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.CollectorException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.CollectorType;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.OperationalStatus;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.common.impl.event.publisher.PublisherMBean;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.common.impl.StoradeClientException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.AgentLocation;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.HostBasedElement;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.HostBasedElementKey;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.IpRange;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.StoradeDiscoveryCollectorConstants;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.StoradeDiscoveryCollectorMBean;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.AgentLocationUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.DeviceUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.ElementManagerTemplateUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.IpRangeUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryCollectorThread;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryCollectorUtil;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryThreadPool;
import com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.Element;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.api.StoradeDiscoveryCollectorBean;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.logic.scheduler.impl.SchedulerUtilImpl;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableIllegalArgumentException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.helpers.TriggerUtils;

public class StoradeDiscoveryCollectorImpl
extends StandardMBean
implements StoradeDiscoveryCollectorMBean {
    private StoradeDiscoveryCollectorUtil clientUtil;
    private static String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorImpl = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryCollectorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorImpl).getName();
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorImpl == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorImpl = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryCollectorImpl")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorImpl).getPackage().getName());
    private String key;
    private int pollingInterval;
    private boolean pollingEnabled;
    private static int MAX_REFRESH = 5;
    private boolean verboseEnabled;
    private String revision;
    private OperationalStatus operationalStatus;
    private Object statusChangeLock;
    private Level level;
    private static ObjectName pubObjectName = null;
    private static PublisherMBean publisherMBean = null;
    private static final int IP_BUNDLE_SIZE = 10;
    private int refreshRequest;
    private Object refreshLock;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryCollectorImpl;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$api$StoradeDiscoveryCollectorMBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryPollJob;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$Element;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeDiscoveryCollectorBean;

    public StoradeDiscoveryCollectorImpl(String string, Properties properties, MBeanServer mBeanServer) throws Exception {
        block13: {
            Object[] objectArray;
            super(class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$api$StoradeDiscoveryCollectorMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$api$StoradeDiscoveryCollectorMBean = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.StoradeDiscoveryCollectorMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$api$StoradeDiscoveryCollectorMBean);
            this.clientUtil = null;
            this.key = null;
            this.pollingInterval = 60;
            this.pollingEnabled = true;
            this.verboseEnabled = false;
            this.revision = "1.0";
            this.operationalStatus = OperationalStatus.STOPPED;
            this.statusChangeLock = new Object();
            this.refreshRequest = 0;
            this.refreshLock = new Object();
            if (logger.isLoggable(Level.FINER)) {
                objectArray = new Object[]{string, properties, mBeanServer};
                logger.entering(CLAZZ, "StoradeDiscoveryCollectorImpl", objectArray);
            }
            if (string == null) {
                throw new IllegalArgumentException("key == null");
            }
            this.key = string;
            if (this.getOperationalStatus().equals((Object)OperationalStatus.STARTING) || this.getOperationalStatus().equals((Object)OperationalStatus.OK)) {
                logger.logp(Level.WARNING, CLAZZ, "StoradeDiscoveryCollectorImpl", "an attempt was made to restart the discovery collector");
                return;
            }
            this.setOperationalStatus(OperationalStatus.STARTING);
            this.createJob("Refresh", class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryPollJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryPollJob = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryPollJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryPollJob);
            this.createJob("Delete", class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryDeleteJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryDeleteJob);
            if (!this.loadPropertiesFromPersistence()) {
                if (properties != null) {
                    this.setProperties(properties);
                }
                this.persistProperties();
            }
            if (mBeanServer != null) {
                try {
                    objectArray = new ObjectNameFactory("com.sun.netstorage.portal");
                    if (objectArray == null) {
                        logger.logp(Level.WARNING, CLAZZ, "StoradeDiscoveryCollectorImpl", "Publisher object name is null, unable to send events");
                        break block13;
                    }
                    pubObjectName = objectArray.getObjectName(class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.common.impl.event.publisher.PublisherMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean, (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.common.impl.event.publisher.PublisherMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean).getName());
                    if (pubObjectName != null) {
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLAZZ, "StoradeDiscoveryCollectorImpl", "pubObjectName: " + pubObjectName);
                        }
                        publisherMBean = (PublisherMBean)MBeanServerInvocationHandler.newProxyInstance(mBeanServer, pubObjectName, class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.common.impl.event.publisher.PublisherMBean")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$common$impl$event$publisher$PublisherMBean, false);
                        break block13;
                    }
                    logger.logp(Level.WARNING, CLAZZ, "StoradeDiscoveryCollectorImpl", "Publisher object name is null, unable to send events");
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "StoradeDiscoveryCollectorImpl", "failed to establish an MBeanServerConnection used to notify other mbeans of events", exception);
                }
            } else {
                logger.logp(Level.WARNING, CLAZZ, "StoradeDiscoveryCollectorImpl", "MBeanServer is null, unable to send events");
            }
        }
        this.start();
        this.setOperationalStatus(OperationalStatus.OK);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "StoradeDiscoveryCollectorImpl");
        }
    }

    public OperationalStatus getOperationalStatus() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLAZZ, "getOperationalStatus", "operational status is: " + this.operationalStatus);
        }
        return this.operationalStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOperationalStatus(OperationalStatus operationalStatus) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "setOperationalStatus", operationalStatus);
        }
        Object object = this.statusChangeLock;
        synchronized (object) {
            this.operationalStatus = operationalStatus;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "setOperationalStatus");
        }
    }

    public CollectorType getType() {
        return StoradeDiscoveryCollectorConstants.STORADE_COLLECTOR_TYPE;
    }

    public void start() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "start");
        }
        try {
            if (this.pollingEnabled) {
                this.startSchedule();
            }
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLAZZ, "start", "caught exception starting mbean", exception);
            throw new SchedulerException(exception);
        }
        this.setOperationalStatus(OperationalStatus.OK);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "start");
        }
    }

    public void stop() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "stop");
        }
        if (this.operationalStatus.equals((Object)OperationalStatus.STOPPING) || this.operationalStatus.equals((Object)OperationalStatus.STOPPED)) {
            return;
        }
        this.setOperationalStatus(OperationalStatus.STOPPING);
        this.unschedulePollJob();
        this.unscheduleJob("Refresh");
        this.unscheduleJob("Delete");
        this.setOperationalStatus(OperationalStatus.STOPPED);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "stop");
        }
    }

    public void enablePolling() throws CollectorException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "enablePolling");
        }
        if (this.pollingEnabled) {
            return;
        }
        try {
            this.schedulePollJob(this.pollingInterval);
        }
        catch (Exception exception) {
            throw new CollectorException("storADE.enablePollingFailed", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        this.setPollingEnabled(true);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "enablePolling");
        }
    }

    public void disablePolling() throws CollectorException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "disablePolling");
        }
        if (!this.pollingEnabled) {
            return;
        }
        try {
            this.unschedulePollJob();
        }
        catch (Exception exception) {
            throw new CollectorException("storADE.disablePollingFailed", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        this.setPollingEnabled(false);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "disablePolling");
        }
    }

    public boolean isPollingEnabled() throws IOException {
        return this.pollingEnabled;
    }

    private void setPollingEnabled(boolean bl) throws IOException {
        this.pollingEnabled = bl;
        try {
            this.persistProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void enableVerbose() throws IOException {
        this.verboseEnabled = true;
        try {
            this.level = logger.getLevel();
            logger.setLevel(Level.FINEST);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void disableVerbose() throws IOException {
        this.verboseEnabled = false;
        try {
            logger.setLevel(this.level);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isVerboseEnabled() throws IOException {
        return this.verboseEnabled;
    }

    public String getRevision() throws IOException {
        return "1.0";
    }

    public int getMinPollInterval() throws IOException {
        return 10;
    }

    public int getPollInterval() throws IOException {
        return this.pollingInterval;
    }

    public void setPollInterval(int n) throws Exception, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "setPollInterval", new Integer(n));
        }
        if (n == this.pollingInterval) {
            return;
        }
        if (!this.isPollingIntervalValid(n)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLAZZ, "setPollInterval", "throwing CollectorException");
            }
            throw new CollectorException("storADE.invalidPollingIntervalSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        this.pollingInterval = n;
        if (this.isMbeanRunning() && this.pollingEnabled) {
            try {
                this.changeSchedule();
            }
            catch (Exception exception) {
                throw new CollectorException((Throwable)exception);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLAZZ, "setPollInterval", "set polling interval to: " + n);
            }
            try {
                this.persistProperties();
            }
            catch (Exception exception) {
                throw new CollectorException("storADE.persistenceError", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "setPollInterval");
        }
    }

    public void refresh() throws CollectorException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "refresh");
        }
        try {
            this.manualRefresh();
        }
        catch (Exception exception) {
            throw new CollectorException("storADE.refreshFailed", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "refresh");
        }
    }

    public IpRange[] getIpRanges(String string) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getIpRanges", string);
        }
        if (string == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getIpRanges");
        }
        return IpRangeUtil.getIpRanges(string);
    }

    public IpRange getIpRange(String string) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getIpRange", string);
        }
        if (string == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidOidSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getIpRange");
        }
        return IpRangeUtil.getIpRange(string);
    }

    public void addIpRange(IpRange ipRange) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer(ipRange.getStart()).append("-").append(ipRange.getEnd());
            logger.entering(CLAZZ, "addIpRange", stringBuffer);
        }
        if (ipRange == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidIpRangeSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        IpRangeUtil.addIpRange(new IpRange[]{ipRange});
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "addIpRange");
        }
    }

    public void addIpRange(IpRange[] ipRangeArray) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "addIpRange");
        }
        if (ipRangeArray == null || ipRangeArray.length == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidIpRangeSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        IpRangeUtil.addIpRange(ipRangeArray);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "addIpRange");
        }
    }

    public void modifyIpRange(IpRange ipRange) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "modifyIpRange", ipRange.getOid());
        }
        if (ipRange == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidIpRangeSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        IpRangeUtil.modifyIpRange(ipRange);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "modifyIpRange");
        }
    }

    public void deleteIpRange(String[] stringArray) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        Serializable serializable;
        if (logger.isLoggable(Level.FINER)) {
            serializable = new StringBuffer("id array length: ").append(stringArray.length);
            logger.entering(CLAZZ, "deleteIpRange", serializable);
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidOidSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        serializable = new ArrayList();
        IpRange ipRange = null;
        for (int i = 0; i < stringArray.length; ++i) {
            ipRange = IpRangeUtil.getIpRange(stringArray[i]);
            if (null == ipRange) continue;
            ((ArrayList)serializable).add(ipRange);
        }
        IpRange[] ipRangeArray = null;
        if (((ArrayList)serializable).size() > 0) {
            ipRangeArray = ((ArrayList)serializable).toArray(new IpRange[((ArrayList)serializable).size()]);
        }
        String[] stringArray2 = IpRangeUtil.getIpAddresses(stringArray);
        IpRangeUtil.deleteIpRange(stringArray);
        try {
            String string = this.getJobTriggerName("Delete");
            String string2 = this.getJobGroupName("Delete");
            Scheduler scheduler = this.getJobScheduler();
            scheduler.getJobDetail(string, string2).getJobDataMap().put((Object)"ranges", (Object)ipRangeArray);
            scheduler.triggerJob(string, string2);
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLAZZ, "deleteIpRange", "Unable to perform deleteIpRange operation", exception);
            throw new CollectorException((Throwable)exception);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "deleteIpRange");
        }
    }

    public void addAgent(AgentLocation agentLocation) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "addAgent", agentLocation.getAgentLocation());
        }
        if (agentLocation == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        AgentLocationUtil.addAgent(agentLocation);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "addAgent");
        }
    }

    public void modifyAgent(AgentLocation agentLocation, AgentLocation agentLocation2) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "modifyAgent", agentLocation.getAgentLocation());
        }
        if (agentLocation == null || agentLocation2 == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        AgentLocationUtil.modifyAgent(agentLocation, agentLocation2);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "modifyAgent");
        }
    }

    public void deleteAgent(String[] stringArray) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer("agentLocation array length: ").append(stringArray.length);
            logger.entering(CLAZZ, "deleteAgent", stringBuffer);
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        AgentLocationUtil.deleteAgent(stringArray);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "deleteAgent");
        }
    }

    public AgentLocation[] getAllStoradeAgents() throws CollectorException, IOException {
        return AgentLocationUtil.getAllAgents("storade");
    }

    public AgentLocation[] getAllAgents() throws CollectorException, IOException {
        return AgentLocationUtil.getAllAgents();
    }

    public AgentLocation getStoradeAgent(String string) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "getStoradeAgent", string);
        }
        if (string == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "getStoradeAgent");
        }
        return AgentLocationUtil.getStoradeAgent(string);
    }

    public void addDevice(String[] stringArray) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer("wwn array length: " + stringArray.length);
            logger.entering(CLAZZ, "addDevice", stringBuffer);
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidKeySpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        DeviceUtil.setRemoved(stringArray, false);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "addDevice");
        }
    }

    public void removeDevice(String[] stringArray) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer stringBuffer = new StringBuffer("wwn array length: " + stringArray.length);
            logger.entering(CLAZZ, "removeDevice", stringBuffer);
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidWwnSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        DeviceUtil.setRemoved(stringArray, true);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "removeDevice");
        }
    }

    public void setHostBasedElement(HostBasedElement hostBasedElement) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (hostBasedElement == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidHostBasedElementSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        HostBasedElementKey hostBasedElementKey = null;
        hostBasedElementKey = hostBasedElement.getKey();
        if (hostBasedElementKey == null) {
            throw new CollectorException("storADE.invalidKeySpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        String string = hostBasedElementKey.getModel();
        String string2 = hostBasedElementKey.getVendor();
        if (string == null || string2 == null) {
            throw new CollectorException("storADE.invalidKeySpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        ElementManagerTemplateUtil.setHost(string, string2, hostBasedElement.getHost());
    }

    public HostBasedElement getHostBasedElement(HostBasedElementKey hostBasedElementKey) throws CollectorException, LocalizableIllegalArgumentException, IOException {
        if (hostBasedElementKey == null) {
            throw new LocalizableIllegalArgumentException("storADE.invalidKeySpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        String string = hostBasedElementKey.getModel();
        String string2 = hostBasedElementKey.getVendor();
        if (string == null || string2 == null) {
            throw new CollectorException("storADE.invalidKeySpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        return ElementManagerTemplateUtil.getHostBasedElement(string, string2);
    }

    public HostBasedElement[] getAllHostBasedElements() throws CollectorException, IOException {
        return ElementManagerTemplateUtil.getAllHostBasedElements();
    }

    private void manualRefresh() throws CollectorException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "manualRefresh");
        }
        try {
            Scheduler scheduler = this.getJobScheduler();
            String string = this.getJobTriggerName("Refresh");
            String string2 = this.getJobGroupName("Refresh");
            scheduler.triggerJob(string, string2);
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLAZZ, "manualRefresh", "Unable to perform refresh operation", exception);
            throw new CollectorException((Throwable)exception);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "manualRefresh");
        }
    }

    private void setProperties(Properties properties) throws Exception {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "setProperties", properties);
        }
        if (properties == null) {
            return;
        }
        String string = properties.getProperty("pollingInterval");
        if (string != null && string.length() > 0) {
            this.setPollInterval(Integer.valueOf(string));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "setProperties");
        }
    }

    protected static ObjectName getPublisherObjectName() {
        return pubObjectName;
    }

    protected static PublisherMBean getPublisherMBean() {
        return publisherMBean;
    }

    protected String getKey() {
        return this.key;
    }

    private Scheduler getJobScheduler() throws SchedulerException {
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        return scheduler;
    }

    private void createJob(String string, Class clazz) throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "createJob");
        }
        Scheduler scheduler = this.getJobScheduler();
        String string2 = this.getJobTriggerName(string);
        String string3 = this.getJobGroupName(string);
        JobDetail jobDetail = new JobDetail(string2, string3, clazz);
        jobDetail.getJobDataMap().put((Object)"object", (Object)this);
        jobDetail.setDurability(true);
        scheduler.addJob(jobDetail, true);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "createJob");
        }
    }

    private void startSchedule() throws SchedulerException {
        this.schedulePollJob(this.pollingInterval);
    }

    private void changeSchedule() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "changeSchedule");
        }
        String string = this.getJobTriggerName("Poll");
        String string2 = this.getJobTriggerGroupName("Poll");
        String string3 = string;
        String string4 = string2;
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        scheduler.unscheduleJob(string, string2);
        scheduler.deleteJob(string3, string4);
        this.startSchedule();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "changeSchedule");
        }
    }

    private void schedulePollJob(int n) throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "schedulePollJob", new Integer(n));
        }
        Scheduler scheduler = this.getJobScheduler();
        try {
            long l = TriggerUtils.getNextGivenSecondDate(null, (int)15).getTime();
            String string = this.getJobTriggerName("Poll");
            String string2 = this.getJobTriggerGroupName("Poll");
            String string3 = string;
            String string4 = string2;
            JobDetail jobDetail = new JobDetail(string3, string4, class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryPollJob == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryPollJob = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.StoradeDiscoveryPollJob")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$StoradeDiscoveryPollJob);
            jobDetail.getJobDataMap().put((Object)"object", (Object)this);
            SimpleTrigger simpleTrigger = new SimpleTrigger(string, string2, string3, string4, new Date(l), null, SimpleTrigger.REPEAT_INDEFINITELY, 60000L * (long)n);
            scheduler.scheduleJob(jobDetail, (Trigger)simpleTrigger);
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLAZZ, "schedulePollJob", "Exception caught scheduling poll job", exception);
            throw new SchedulerException(exception);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "schedulePollJob");
        }
    }

    private void stopSchedule() throws SchedulerException {
        this.unschedulePollJob();
    }

    private void unschedulePollJob() throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "unschedulePollJob");
        }
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string = this.getJobTriggerName("Poll");
        String string2 = this.getJobTriggerGroupName("Poll");
        String string3 = string;
        String string4 = string2;
        scheduler.unscheduleJob(string, string2);
        scheduler.deleteJob(string3, string4);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "unschedulePollJob");
        }
    }

    private void unscheduleJob(String string) throws SchedulerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "unscheduleJob");
        }
        Scheduler scheduler = null;
        try {
            scheduler = SchedulerUtilImpl.getInstance().getScheduler();
        }
        catch (Exception exception) {
            throw new SchedulerException(exception);
        }
        String string2 = this.getJobTriggerName(string);
        String string3 = this.getJobGroupName(string);
        scheduler.deleteJob(string2, string3);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "unscheduleJob");
        }
    }

    private String getJobTriggerName(String string) {
        String string2 = "JobTrig_" + string + "_" + this.getKey() + "_Discovery";
        return string2;
    }

    private String getJobTriggerGroupName(String string) {
        String string2 = "GrpTrig_" + string + "_" + this.getKey() + "_Discovery";
        return string2;
    }

    private String getJobName(String string) {
        String string2 = "Job_" + string + "_" + this.getKey() + "_Discovery";
        return string2;
    }

    private String getJobGroupName(String string) {
        String string2 = "Grp_" + string + "_" + this.getKey() + "_Discovery";
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void collectAll() throws CollectorException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "collectAll");
        }
        PersistentObject[] persistentObjectArray = this.refreshLock;
        synchronized (this.refreshLock) {
            try {
                if (this.refreshRequest >= MAX_REFRESH) {
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return;
                }
                if (this.isRefreshPending()) {
                    this.addRefreshRequest();
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLAZZ, "collectAll", "Discovery refresh already in progress, refreshRequest: " + this.refreshRequest);
                    }
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return;
                }
                this.setOperationalStatus(OperationalStatus.REFRESH_IN_PROGRESS);
            }
            catch (Exception exception) {
                logger.logp(Level.INFO, CLAZZ, "collectAll", "Failed to increment refresh request count", exception);
                throw new CollectorException((Throwable)exception);
            }
            this.addRefreshRequest();
            while (this.isRefreshPending()) {
                Object object2222;
                AgentLocationBean agentLocationBean;
                block30: {
                    persistentObjectArray = null;
                    PersistenceManager persistenceManager = null;
                    Transaction transaction = null;
                    persistenceManager = PersistenceManager.getInstance();
                    transaction = persistenceManager.getTransaction();
                    EqualsFilter equalsFilter = new EqualsFilter("type", "storade");
                    persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean == null ? StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean") : class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean, (Filter)equalsFilter);
                    agentLocationBean = null;
                    try {
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block30;
                    }
                    catch (Exception object2222) {
                        logger.logp(Level.WARNING, CLAZZ, "collectAll", "exception caught releasing transaction", (Throwable)object2222);
                        this.setOperationalStatus(OperationalStatus.OK);
                    }
                    break block30;
                    {
                        catch (Exception exception) {
                            logger.logp(Level.WARNING, CLAZZ, "collectAll", "Exception caught getting agent location beans", exception);
                            throw new CollectorException((Throwable)exception);
                        }
                    }
                    catch (Throwable throwable) {
                        agentLocationBean = null;
                        try {
                            if (persistenceManager != null) {
                                persistenceManager.releaseTransaction(transaction);
                                persistenceManager = null;
                            }
                        }
                        catch (Exception object2222) {
                            logger.logp(Level.WARNING, CLAZZ, "collectAll", "exception caught releasing transaction", (Throwable)object2222);
                            this.setOperationalStatus(OperationalStatus.OK);
                        }
                        throw throwable;
                    }
                }
                if (persistentObjectArray == null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLAZZ, "collectAll", "No agent locations found in database");
                    }
                    return;
                }
                try {
                    StoradeDiscoveryCollectorImpl.markUndiscoveredElements();
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "collectAll", "Exception caught marking undiscovered dbase elements", exception);
                }
                boolean bl = true;
                for (int i = 0; i < persistentObjectArray.length; ++i) {
                    agentLocationBean = (AgentLocationBean)persistentObjectArray[i];
                    if (agentLocationBean == null) continue;
                    object2222 = agentLocationBean.getAgentLocation();
                    try {
                        bl = StoradeDiscoveryCollectorImpl.collect((String)object2222, agentLocationBean.getUid(), agentLocationBean.getPasswd());
                        continue;
                    }
                    catch (Exception exception) {
                        logger.logp(Level.WARNING, CLAZZ, "collectAll", "Exception caught attempting to collect data from " + (String)object2222, exception);
                    }
                }
                if (bl) {
                    try {
                        StoradeDiscoveryCollectorImpl.deleteUndiscoveredElements();
                    }
                    catch (Exception exception) {
                        logger.logp(Level.WARNING, CLAZZ, "collectAll", "Exception caught marking undiscovered dbase elements", exception);
                    }
                }
                this.removeRefreshRequest();
                this.setOperationalStatus(OperationalStatus.OK);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(CLAZZ, "collectAll");
            }
            return;
        }
    }

    private static boolean collect(String string, String string2, String string3) throws CollectorException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "collect");
        }
        StoradeDiscoveryCollectorUtil storadeDiscoveryCollectorUtil = null;
        try {
            storadeDiscoveryCollectorUtil = new StoradeDiscoveryCollectorUtil(string, string2, string3);
        }
        catch (StoradeClientException storadeClientException) {
            throw new CollectorException((Throwable)storadeClientException);
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLAZZ, "collect", "Exception caught trying to collect elements", exception);
            throw new CollectorException((Throwable)exception);
        }
        IpRange[] ipRangeArray = null;
        try {
            ipRangeArray = IpRangeUtil.getIpRanges(string);
        }
        catch (Exception exception) {
            throw new CollectorException((Throwable)exception);
        }
        int n = 1;
        StoradeDiscoveryCollectorThread[] storadeDiscoveryCollectorThreadArray = null;
        CountDown countDown = null;
        if (ipRangeArray != null && ipRangeArray.length > 0) {
            String[] stringArray = IpRangeUtil.iterateIps(ipRangeArray);
            if (stringArray.length > 10) {
                n = stringArray.length / 10 + (stringArray.length % 10 > 0 ? 1 : 0);
            }
            StoradeDiscoveryThreadPool storadeDiscoveryThreadPool = StoradeDiscoveryThreadPool.getInstance();
            storadeDiscoveryCollectorThreadArray = new StoradeDiscoveryCollectorThread[n];
            countDown = new CountDown(n);
            for (int i = 0; i < n; ++i) {
                int n2 = (stringArray.length - i * 10) / 10 > 0 ? 10 : stringArray.length % 10;
                String[] stringArray2 = new String[n2];
                System.arraycopy(stringArray, i * 10, stringArray2, 0, n2);
                try {
                    storadeDiscoveryCollectorThreadArray[i] = new StoradeDiscoveryCollectorThread(countDown, storadeDiscoveryCollectorUtil, stringArray2);
                    storadeDiscoveryThreadPool.execute(storadeDiscoveryCollectorThreadArray[i]);
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.FINER, CLAZZ, "collect", "Started StorADE discovery thread: " + storadeDiscoveryCollectorThreadArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    logger.logp(Level.SEVERE, CLAZZ, "collect", "Unable to start StorADE discovery thread", exception);
                }
            }
        }
        boolean bl = true;
        if (null != countDown) {
            block16: {
                try {
                    bl = countDown.attempt(604800000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!logger.isLoggable(Level.FINER)) break block16;
                    logger.logp(Level.FINER, CLAZZ, "collect", "Exception caught waiting for discovery threads to complete", interruptedException);
                }
            }
            if (!bl) {
                logger.logp(Level.WARNING, CLAZZ, "collect", "The discovery collection cycle timed out before all collector threads completed");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "collect");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void markUndiscoveredElements() throws Exception {
        block11: {
            Object var1 = null;
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            Element.update((Transaction)transaction, (String[])new String[]{"discovered"}, (String[])new String[]{"false"}, null);
            transaction.commit();
            Object var6_3 = null;
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                break block11;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "markUndiscoveredElements", "exception caught releasing transaction", exception);
            }
            break block11;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "markUndiscoveredElements", "Exception caught marking elements as undiscovered");
                    Object var6_4 = null;
                    try {
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block11;
                    }
                    catch (Exception exception2) {
                        logger.logp(Level.WARNING, CLAZZ, "markUndiscoveredElements", "exception caught releasing transaction", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                try {
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "markUndiscoveredElements", "exception caught releasing transaction", exception);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void deleteUndiscoveredElements() throws Exception {
        block13: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "deleteUndiscoveredElements");
            }
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$Element == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$Element = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.Element")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$Element, (Filter)new EqualsFilter("discovered", false));
            transaction.commit();
            Object var5_2 = null;
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                break block13;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "deleteUndiscoveredElements", "Exception caught releasing transaction", exception);
            }
            break block13;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "deleteUndiscoveredElements", "Exception caught deleting undiscovered elements", exception);
                    Object var5_3 = null;
                    try {
                        if (persistenceManager != null) {
                            persistenceManager.releaseTransaction(transaction);
                            persistenceManager = null;
                        }
                        break block13;
                    }
                    catch (Exception exception2) {
                        logger.logp(Level.WARNING, CLAZZ, "deleteUndiscoveredElements", "Exception caught releasing transaction", exception2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "deleteUndiscoveredElements", "Exception caught releasing transaction", exception);
                }
                throw throwable;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "deleteUndiscoveredElements");
        }
    }

    protected static void _markUndiscoveredElements() throws Exception {
        StoradeDiscoveryCollectorImpl.markUndiscoveredElements();
    }

    protected static void _deleteUndiscoveredElements() throws Exception {
        StoradeDiscoveryCollectorImpl.deleteUndiscoveredElements();
    }

    /*
     * Loose catch block
     */
    private boolean loadPropertiesFromPersistence() throws Exception {
        PersistentObject[] persistentObjectArray;
        block16: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "loadPropertiesFromPersistence");
            }
            persistentObjectArray = null;
            PersistenceManager persistenceManager = null;
            try {
                persistenceManager = PersistenceManager.getInstance();
            }
            catch (PersistenceException persistenceException) {
                throw new CollectorException((Throwable)persistenceException);
            }
            Transaction transaction = null;
            transaction = persistenceManager.getTransaction();
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeDiscoveryCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeDiscoveryCollectorBean = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoradeDiscoveryCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeDiscoveryCollectorBean, (Filter)new EqualsFilter("collector_key", this.key));
            Object var7_5 = null;
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                break block16;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "loadPropertiesFromPersistence", "exception caught releasing transaction", exception);
            }
            break block16;
            {
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "loadPropertiesFromPersistence", "exception getting collector properties from persistence", exception);
                    throw new CollectorException((Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "loadPropertiesFromPersistence", "exception caught releasing transaction", exception);
                }
                throw throwable;
            }
        }
        boolean bl = false;
        if (persistentObjectArray != null && persistentObjectArray.length > 0) {
            StoradeDiscoveryCollectorBean storadeDiscoveryCollectorBean = (StoradeDiscoveryCollectorBean)persistentObjectArray[0];
            this.setPollInterval(storadeDiscoveryCollectorBean.getPollingInterval());
            if (storadeDiscoveryCollectorBean.isPollingEnabled()) {
                this.setPollingEnabled(true);
            } else {
                this.setPollingEnabled(false);
            }
            bl = true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "loadPropertiesFromPersistence");
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    private void persistProperties() throws CollectorException {
        block14: {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(CLAZZ, "persistProperties");
            }
            PersistenceManager persistenceManager = null;
            try {
                persistenceManager = PersistenceManager.getInstance();
            }
            catch (PersistenceException persistenceException) {
                throw new CollectorException((Throwable)persistenceException);
            }
            StoradeDiscoveryCollectorBean storadeDiscoveryCollectorBean = new StoradeDiscoveryCollectorBean();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLAZZ, "persistProperties", "persisting key: " + this.getKey() + " isPollingEnabled: " + this.pollingEnabled + " pollInterval: " + this.pollingInterval);
            }
            storadeDiscoveryCollectorBean.setCollectorKey(this.getKey());
            storadeDiscoveryCollectorBean.setPollingEnabled(this.pollingEnabled);
            storadeDiscoveryCollectorBean.setPollingInterval(this.pollingInterval);
            Transaction transaction = null;
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeDiscoveryCollectorBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeDiscoveryCollectorBean = StoradeDiscoveryCollectorImpl.class$("com.sun.netstorage.mgmt.esm.logic.data.api.StoradeDiscoveryCollectorBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$StoradeDiscoveryCollectorBean, (Filter)new EqualsFilter("collector_key", this.key));
            transaction.put((PersistentObject)storadeDiscoveryCollectorBean);
            transaction.commit();
            Object var7_5 = null;
            try {
                if (persistenceManager != null) {
                    persistenceManager.releaseTransaction(transaction);
                    persistenceManager = null;
                }
                break block14;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "persistProperties", "exception caught attempting to release transaction", exception);
            }
            break block14;
            {
                catch (Exception exception) {
                    throw new CollectorException((Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (persistenceManager != null) {
                        persistenceManager.releaseTransaction(transaction);
                        persistenceManager = null;
                    }
                }
                catch (Exception exception) {
                    logger.logp(Level.WARNING, CLAZZ, "persistProperties", "exception caught attempting to release transaction", exception);
                }
                throw throwable;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLAZZ, "persistProperties");
        }
    }

    private boolean isPollingIntervalValid(int n) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLAZZ, "isPollingIntervalValid");
        }
        if (n < 10) {
            if (logger.isLoggable(Level.FINER)) {
                String string = "returning false";
                logger.exiting(CLAZZ, "isPollingIntervalValid", string);
            }
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            String string = "returning true";
            logger.exiting(CLAZZ, "isPollingIntervalValid", string);
        }
        return true;
    }

    private boolean isMbeanRunning() {
        OperationalStatus operationalStatus = this.operationalStatus;
        return !operationalStatus.equals((Object)OperationalStatus.STARTING) && !operationalStatus.equals((Object)OperationalStatus.STOPPED) && !operationalStatus.equals((Object)OperationalStatus.STOPPING);
    }

    protected void addRefreshRequest() {
        ++this.refreshRequest;
    }

    protected void removeRefreshRequest() {
        --this.refreshRequest;
    }

    protected boolean isRefreshPending() {
        return this.refreshRequest > 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

