/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl;

import com.sun.netstorage.fm.util.InetIterator;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.CollectorException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.IpRange;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.AgentLocationUtil;
import com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.IpRangeBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Sort;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableIllegalArgumentException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IpRangeUtil {
    private static final String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$IpRangeUtil == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$IpRangeUtil = IpRangeUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.IpRangeUtil")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$IpRangeUtil).getName();
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$IpRangeUtil == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$IpRangeUtil = IpRangeUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.IpRangeUtil")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$IpRangeUtil).getPackage().getName());
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$IpRangeUtil;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpRange[] getIpRanges(String string) throws LocalizableIllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        PersistentObject[] persistentObjectArray = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        IpRange[] ipRangeArray = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            Sort[] sortArray = new Sort[]{new Sort("start_ip", true)};
            EqualsFilter equalsFilter = new EqualsFilter("agent_location", string);
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean = IpRangeUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.IpRangeBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean, (Filter)equalsFilter, sortArray);
            if (persistentObjectArray != null && persistentObjectArray.length > 0) {
                IpRangeBean ipRangeBean = null;
                ipRangeArray = new IpRange[persistentObjectArray.length];
                for (int i = 0; i < persistentObjectArray.length; ++i) {
                    ipRangeBean = (IpRangeBean)persistentObjectArray[i];
                    ipRangeArray[i] = new IpRange(ipRangeBean.getAgentLocation(), ipRangeBean.getStart(), ipRangeBean.getEnd(), Integer.toString(ipRangeBean.getId()));
                }
            }
        }
        catch (PersistenceException persistenceException) {
            logger.logp(Level.WARNING, CLAZZ, "getIpRanges", "Exception caught getting persistence manager instance for getting ip addresses", persistenceException);
        }
        catch (TransactionException transactionException) {
            logger.logp(Level.WARNING, CLAZZ, "getIpRanges", "Exception caught getting agent location beans for ip addresses", transactionException);
        }
        finally {
            IpRangeUtil.cleanupTransaction(persistenceManager, transaction);
        }
        if (persistentObjectArray == null || persistentObjectArray.length == 0) {
            return new IpRange[0];
        }
        return ipRangeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IpRange getIpRange(String string) throws LocalizableIllegalArgumentException {
        EqualsFilter equalsFilter;
        if (string == null || string.length() == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidOidSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        PersistentObject[] persistentObjectArray = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        Object var5_4 = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            equalsFilter = new EqualsFilter("id", string);
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean = IpRangeUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.IpRangeBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean, (Filter)equalsFilter);
        }
        catch (PersistenceException persistenceException) {
            logger.logp(Level.WARNING, CLAZZ, "getIpRange", "Exception caught getting persistence manager instance for getting ip addresses", persistenceException);
        }
        catch (TransactionException transactionException) {
            logger.logp(Level.WARNING, CLAZZ, "getIpRange", " Exception caught getting agent location beans for ip addresses", transactionException);
        }
        finally {
            IpRangeUtil.cleanupTransaction(persistenceManager, transaction);
        }
        if (persistentObjectArray != null && persistentObjectArray.length > 0) {
            equalsFilter = (IpRangeBean)persistentObjectArray[0];
            return new IpRange(equalsFilter.getAgentLocation(), equalsFilter.getStart(), equalsFilter.getEnd(), Integer.toString(equalsFilter.getId()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIpRange(IpRange[] ipRangeArray) throws LocalizableIllegalArgumentException, CollectorException {
        if (ipRangeArray == null || ipRangeArray.length == 0) {
            throw new LocalizableIllegalArgumentException("storADE.noIpRangesSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < ipRangeArray.length; ++i) {
            AgentLocationBean agentLocationBean;
            if (ipRangeArray[i] == null) continue;
            String string = ipRangeArray[i].getStart() + "-" + ipRangeArray[i].getEnd();
            String string2 = ipRangeArray[i].getAgentLocation();
            if (string2 == null || string2.length() == 0) {
                vector.add(string);
            } else {
                agentLocationBean = AgentLocationUtil.getAgentLocationBean(string2);
                if (agentLocationBean == null) {
                    vector.add(string);
                }
            }
            agentLocationBean = IpRangeUtil.createIpRangeBean(ipRangeArray[i]);
            PersistenceManager persistenceManager = null;
            Transaction transaction = null;
            try {
                persistenceManager = PersistenceManager.getInstance();
                transaction = persistenceManager.getTransaction();
                transaction.begin();
                transaction.put((PersistentObject)agentLocationBean);
                transaction.commit();
                continue;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "addIpRange", "Exception caught persistng agent location bean", exception);
                vector.add(string);
                continue;
            }
            finally {
                IpRangeUtil.cleanupTransaction(persistenceManager, transaction);
            }
        }
        if (vector.size() > 0) {
            Serializable[] serializableArray = new Serializable[vector.size()];
            serializableArray = vector.toArray(new Serializable[0]);
            throw new CollectorException("storADE.addIpRangeFailed", serializableArray, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
    }

    public static void modifyIpRange(IpRange ipRange) throws LocalizableIllegalArgumentException, CollectorException {
        if (ipRange == null) {
            throw new LocalizableIllegalArgumentException("storADE.noIpRangesSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        IpRangeBean ipRangeBean = IpRangeUtil.createIpRangeBean(ipRange);
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            if (transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean = IpRangeUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.IpRangeBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean, (Filter)new EqualsFilter("id", ipRange.getOid())) == 0) {
                throw new Exception("Unable to modify nonexistent iprange with id: " + ipRange.getOid());
            }
            transaction.put((PersistentObject)ipRangeBean);
            transaction.commit();
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLAZZ, "modifyIpRange", "Exception caught persisting agent location bean" + exception);
            throw new CollectorException("storADE.modifyIpRangeFailed", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        finally {
            IpRangeUtil.cleanupTransaction(persistenceManager, transaction);
        }
    }

    public static void deleteIpRange(String[] stringArray) throws LocalizableIllegalArgumentException, CollectorException {
        if (stringArray == null || stringArray.length == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidOidSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        Object var2_1 = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        Vector<String> vector = new Vector<String>();
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLAZZ, "deleteIpRange", "Exception caught getting transaction to delete ranges", exception);
            IpRangeUtil.cleanupTransaction(persistenceManager, transaction);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                transaction.begin();
                if (transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean == null ? IpRangeUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.IpRangeBean") : class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean, (Filter)new EqualsFilter("id", stringArray[i])) == 0) {
                    vector.add(stringArray[i]);
                }
                transaction.commit();
                continue;
            }
            catch (Exception exception) {
                vector.add(stringArray[i]);
                logger.logp(Level.WARNING, CLAZZ, "deleteIpRange", "Exception caught deleting agent location bean", exception);
            }
        }
        IpRangeUtil.cleanupTransaction(persistenceManager, transaction);
        if (vector.size() > 0) {
            Serializable[] serializableArray = new Serializable[vector.size()];
            serializableArray = vector.toArray(new Serializable[0]);
            throw new CollectorException("storADE.deleteIpRangeFailed", serializableArray, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
    }

    private static IpRangeBean createIpRangeBean(IpRange ipRange) {
        if (ipRange == null) {
            throw new IllegalArgumentException("ipRange == null");
        }
        IpRangeBean ipRangeBean = new IpRangeBean();
        ipRangeBean.setAgentLocation(ipRange.getAgentLocation());
        ipRangeBean.setStart(ipRange.getStart());
        ipRangeBean.setEnd(ipRange.getEnd());
        return ipRangeBean;
    }

    protected static String[] getIpAddresses(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("oids == null");
        }
        Vector<String> vector = new Vector<String>();
        Object var2_2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String[] stringArray2 = IpRangeUtil.iterateIps(new IpRange[]{IpRangeUtil.getIpRange(stringArray[i])});
                for (int j = 0; j < stringArray2.length; ++j) {
                    vector.add(stringArray2[j]);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (vector.size() > 0) {
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    protected static String[] iterateIps(IpRange[] ipRangeArray) {
        if (ipRangeArray == null || ipRangeArray.length == 0) {
            throw new IllegalArgumentException("ipRanges == null || ipRanges.length == 0");
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < ipRangeArray.length; ++i) {
            String string;
            Object object;
            InetIterator inetIterator = null;
            try {
                object = ipRangeArray[i].getStart();
                string = ipRangeArray[i].getEnd();
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLAZZ, "iterateIps", "iterating over " + (String)object + "-" + string);
                }
                inetIterator = new InetIterator((String)object, string);
            }
            catch (UnknownHostException unknownHostException) {
                continue;
            }
            while (inetIterator.hasNext()) {
                object = (InetAddress)inetIterator.next();
                string = ((InetAddress)object).getHostAddress();
                vector.add(string);
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.logp(Level.FINER, CLAZZ, "iterateIps", "adding " + string + " to list of IPs");
            }
        }
        if (vector.size() == 0) {
            return new String[0];
        }
        return vector.toArray(new String[0]);
    }

    protected static String convertToSAFormat(IpRange[] ipRangeArray) {
        if (ipRangeArray == null) {
            throw new IllegalArgumentException("ipRange == null");
        }
        if (ipRangeArray.length == 0) {
            return null;
        }
        String[] stringArray = null;
        StringBuffer stringBuffer = null;
        stringArray = IpRangeUtil.iterateIps(ipRangeArray);
        if (stringArray != null && stringArray.length > 0) {
            stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(",").append(stringArray[i]);
            }
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String[] getAgentLocations(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("oids == null || oids.length ==0");
        }
        PersistentObject[] persistentObjectArray = null;
        Vector<String> vector = new Vector<String>();
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        Object var6_5 = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            for (int i = 0; i < stringArray.length; ++i) {
                EqualsFilter equalsFilter;
                persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean == null ? IpRangeUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.IpRangeBean") : class$com$sun$netstorage$mgmt$esm$logic$data$api$IpRangeBean, (Filter)(equalsFilter = new EqualsFilter("id", stringArray[i])));
                if (persistentObjectArray == null) continue;
                for (int j = 0; j < persistentObjectArray.length; ++j) {
                    vector.add(((IpRangeBean)persistentObjectArray[j]).getAgentLocation());
                }
            }
        }
        catch (PersistenceException persistenceException) {
            logger.logp(Level.WARNING, CLAZZ, "getAgentLocations", "Exception caught getting persistence manager instance for getting ip addresses", persistenceException);
        }
        catch (TransactionException transactionException) {
            logger.logp(Level.WARNING, CLAZZ, "getAgentLocations", "Exception caught getting agent location beans for ip addresses", transactionException);
        }
        finally {
            IpRangeUtil.cleanupTransaction(persistenceManager, transaction);
        }
        if (vector.size() > 0) {
            return vector.toArray(new String[0]);
        }
        return new String[0];
    }

    private static void cleanupTransaction(PersistenceManager persistenceManager, Transaction transaction) {
        if (persistenceManager != null) {
            try {
                persistenceManager.releaseTransaction(transaction);
                persistenceManager = null;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "cleanupTransaction", "Exception caught attempting to release database transaction", exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

