/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl;

import com.sun.netstorage.fm.storade.client.SAClient;
import com.sun.netstorage.fm.storade.service.agent.AgentConfigService;
import com.sun.netstorage.fm.storade.service.agent.AgentSummary;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.api.CollectorException;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.api.AgentLocation;
import com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.SAClientFactory;
import com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean;
import com.sun.netstorage.mgmt.esm.logic.data.api.PersistentObject;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.PersistenceManager;
import com.sun.netstorage.mgmt.esm.logic.data.engine.Transaction;
import com.sun.netstorage.mgmt.esm.logic.data.engine.TransactionException;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.AndFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.EqualsFilter;
import com.sun.netstorage.mgmt.esm.logic.data.engine.query.Filter;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableIllegalArgumentException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AgentLocationUtil {
    private static Logger logger = Logger.getLogger((class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$AgentLocationUtil == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$AgentLocationUtil = AgentLocationUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.AgentLocationUtil")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$AgentLocationUtil).getPackage().getName());
    private static final String CLAZZ = (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$AgentLocationUtil == null ? (class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$AgentLocationUtil = AgentLocationUtil.class$("com.sun.netstorage.mgmt.esm.logic.collector.adapter.storade.discovery.impl.AgentLocationUtil")) : class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$AgentLocationUtil).getName();
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$collector$adapter$storade$discovery$impl$AgentLocationUtil;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean;

    protected static void addAgent(AgentLocation agentLocation) throws CollectorException, LocalizableIllegalArgumentException {
        if (agentLocation == null || !AgentLocationUtil.isAgentLocationValid(agentLocation)) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        SAClient sAClient = AgentLocationUtil.getSAClientConnection(agentLocation);
        if (sAClient == null) {
            throw new CollectorException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        if (!AgentLocationUtil.isVersionValid(sAClient, agentLocation)) {
            throw new CollectorException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        Object var3_2 = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            AgentLocationBean agentLocationBean = AgentLocationUtil.createAgentLocationBean(agentLocation);
            transaction.begin();
            transaction.put((PersistentObject)agentLocationBean);
            transaction.commit();
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, CLAZZ, "addAgent", "Exception caught persisting agent location bean", exception);
            throw new CollectorException("storADE.addAgentFailed", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        finally {
            AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
        }
    }

    protected static void deleteAgent(String[] stringArray) throws CollectorException, LocalizableIllegalArgumentException {
        if (stringArray == null || stringArray.length == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        Object var2_1 = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        Vector<String> vector = new Vector<String>();
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
        }
        catch (Exception exception) {
            AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
            logger.logp(Level.WARNING, CLAZZ, "deleteAgent", "Exception caught getting transaction to delete agents", exception);
            throw new CollectorException("storADE.deleteAgentFailed", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        SAClientFactory sAClientFactory = SAClientFactory.getInstance();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                transaction.begin();
                if (transaction.delete(class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean == null ? AgentLocationUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean") : class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean, (Filter)new EqualsFilter("agent_location", stringArray[i])) == 0) {
                    vector.add(stringArray[i]);
                } else {
                    sAClientFactory.removeSAClient(stringArray[i]);
                }
                transaction.commit();
                continue;
            }
            catch (Exception exception) {
                vector.add(stringArray[i]);
                logger.logp(Level.WARNING, CLAZZ, "deleteAgent", "Exception caught deleting agent location bean", exception);
            }
        }
        AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
        if (vector.size() > 0) {
            Serializable[] serializableArray = new Serializable[vector.size()];
            serializableArray = vector.toArray(new Serializable[0]);
            throw new CollectorException("storADE.deleteAgentFailed", serializableArray, "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
    }

    protected static synchronized void modifyAgent(AgentLocation agentLocation, AgentLocation agentLocation2) throws CollectorException, LocalizableIllegalArgumentException {
        if (agentLocation == null || !AgentLocationUtil.isAgentLocationValid(agentLocation)) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        Object var3_2 = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        Vector vector = new Vector();
        try {
            persistenceManager = PersistenceManager.getInstance();
            AgentLocationBean agentLocationBean = AgentLocationUtil.getAgentLocationBean(agentLocation.getAgentLocation());
            if (agentLocationBean == null) {
                throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
            }
            agentLocationBean.setDescription(agentLocation2.getDescription());
            agentLocationBean.setHost(agentLocation2.getHost());
            agentLocationBean.setPort(agentLocation2.getPort());
            agentLocationBean.setType(agentLocation2.getType());
            agentLocationBean.setProtocol(agentLocation2.getProtocol());
            agentLocationBean.setUid(agentLocation2.getUid());
            agentLocationBean.setPasswd(agentLocation2.getPasswd());
            transaction = persistenceManager.getTransaction();
            transaction.begin();
            if (!agentLocationBean.update(transaction)) {
                throw new Exception("Unable to modify agentLocation: " + agentLocation.getAgentLocation());
            }
            SAClientFactory sAClientFactory = SAClientFactory.getInstance();
            sAClientFactory.removeSAClient(agentLocation.getAgentLocation());
            sAClientFactory.getSAClient(agentLocationBean.getAgentLocation(), agentLocationBean.getUid(), agentLocationBean.getPasswd());
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                throw new CollectorException("storADE.modifyAgentFailed", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
            }
            catch (Throwable throwable) {
                AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
                throw throwable;
            }
        }
        AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AgentLocation[] getAllAgents() throws CollectorException {
        PersistentObject[] persistentObjectArray = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            persistentObjectArray = transaction.getAll(class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean = AgentLocationUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean);
        }
        catch (PersistenceException persistenceException) {
            logger.logp(Level.WARNING, CLAZZ, "getAllAgents", "Exception caught getting persistence manager instance for getting agent location beans: ", persistenceException);
        }
        catch (TransactionException transactionException) {
            logger.logp(Level.WARNING, CLAZZ, "getAllAgents", "Exception caught getting agent location beans", transactionException);
        }
        finally {
            AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
        }
        if (persistentObjectArray == null || persistentObjectArray.length == 0) {
            return new AgentLocation[0];
        }
        Vector<AgentLocation> vector = new Vector<AgentLocation>();
        AgentLocation agentLocation = null;
        AgentLocationBean agentLocationBean = null;
        for (int i = 0; i < persistentObjectArray.length; ++i) {
            agentLocationBean = (AgentLocationBean)persistentObjectArray[i];
            agentLocation = new AgentLocation(agentLocationBean.getHost(), agentLocationBean.getPort(), agentLocationBean.getType(), agentLocationBean.getProtocol(), agentLocationBean.getUid(), agentLocationBean.getPasswd(), agentLocationBean.getDescription());
            vector.add(agentLocation);
        }
        return vector.toArray(new AgentLocation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AgentLocation[] getAllAgents(String string) throws CollectorException {
        Object object;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("type == null");
        }
        PersistentObject[] persistentObjectArray = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            object = new EqualsFilter("type", string);
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean = AgentLocationUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean, (Filter)object);
        }
        catch (PersistenceException persistenceException) {
            logger.logp(Level.WARNING, CLAZZ, "getAllAgents", "Exception caught getting persistence manager instance for getting agent location beans", persistenceException);
        }
        catch (TransactionException transactionException) {
            logger.logp(Level.WARNING, CLAZZ, "getAllAgents", "Exception caught getting agent location beans", transactionException);
        }
        finally {
            AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
        }
        if (persistentObjectArray == null || persistentObjectArray.length == 0) {
            return new AgentLocation[0];
        }
        object = new Vector();
        AgentLocation agentLocation = null;
        AgentLocationBean agentLocationBean = null;
        for (int i = 0; i < persistentObjectArray.length; ++i) {
            agentLocationBean = (AgentLocationBean)persistentObjectArray[i];
            agentLocation = new AgentLocation(agentLocationBean.getHost(), agentLocationBean.getPort(), agentLocationBean.getType(), agentLocationBean.getProtocol(), agentLocationBean.getUid(), agentLocationBean.getPasswd(), agentLocationBean.getDescription());
            ((Vector)object).add(agentLocation);
        }
        return ((Vector)object).toArray(new AgentLocation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AgentLocation getStoradeAgent(String string) throws CollectorException, LocalizableIllegalArgumentException {
        EqualsFilter equalsFilter;
        if (string == null || string.length() == 0) {
            throw new LocalizableIllegalArgumentException("storADE.invalidAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        PersistentObject[] persistentObjectArray = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            equalsFilter = new EqualsFilter("agent_location", string);
            EqualsFilter equalsFilter2 = new EqualsFilter("type", "storade");
            AndFilter andFilter = new AndFilter((Filter)equalsFilter, (Filter)equalsFilter2);
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean = AgentLocationUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean, (Filter)andFilter);
        }
        catch (PersistenceException persistenceException) {
            logger.logp(Level.WARNING, CLAZZ, "getStoradeAgent", "Exception caught getting persistence manager instance for getting agent location bean", persistenceException);
        }
        catch (TransactionException transactionException) {
            logger.logp(Level.WARNING, CLAZZ, "getStoradeAgent", "Exception caught getting agent location beans", transactionException);
        }
        finally {
            AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
        }
        if (persistentObjectArray == null || persistentObjectArray.length == 0) {
            return null;
        }
        equalsFilter = (AgentLocationBean)persistentObjectArray[0];
        return new AgentLocation(equalsFilter.getHost(), equalsFilter.getPort(), equalsFilter.getType(), equalsFilter.getProtocol(), equalsFilter.getUid(), equalsFilter.getPasswd(), equalsFilter.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AgentLocationBean getAgentLocationBean(String string) throws CollectorException, LocalizableIllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new LocalizableIllegalArgumentException("storADE.noAgentLocationSpecified", "com/sun/netstorage/mgmt/esm/logic/collector/adapter/storade/discovery/api");
        }
        PersistentObject[] persistentObjectArray = null;
        PersistenceManager persistenceManager = null;
        Transaction transaction = null;
        try {
            persistenceManager = PersistenceManager.getInstance();
            transaction = persistenceManager.getTransaction();
            EqualsFilter equalsFilter = new EqualsFilter("agent_location", string);
            persistentObjectArray = transaction.get(class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean == null ? (class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean = AgentLocationUtil.class$("com.sun.netstorage.mgmt.esm.logic.data.api.AgentLocationBean")) : class$com$sun$netstorage$mgmt$esm$logic$data$api$AgentLocationBean, (Filter)equalsFilter);
        }
        catch (PersistenceException persistenceException) {
            logger.logp(Level.WARNING, CLAZZ, "getAgentLocationBean", "Exception caught getting persistence manager instance for getting agent location beans", persistenceException);
        }
        catch (TransactionException transactionException) {
            logger.logp(Level.WARNING, CLAZZ, "getAgentLocationBean", "Exception caught getting agent location beans", transactionException);
        }
        finally {
            AgentLocationUtil.cleanupTransaction(persistenceManager, transaction);
        }
        if (persistentObjectArray == null || persistentObjectArray.length == 0) {
            return null;
        }
        return (AgentLocationBean)persistentObjectArray[0];
    }

    private static AgentLocationBean createAgentLocationBean(AgentLocation agentLocation) {
        if (agentLocation == null) {
            return null;
        }
        AgentLocationBean agentLocationBean = new AgentLocationBean();
        agentLocationBean.setDescription(agentLocation.getDescription());
        agentLocationBean.setHost(agentLocation.getHost());
        agentLocationBean.setPort(agentLocation.getPort());
        agentLocationBean.setProtocol(agentLocation.getProtocol());
        agentLocationBean.setType(agentLocation.getType());
        agentLocationBean.setUid(agentLocation.getUid());
        agentLocationBean.setPasswd(agentLocation.getPasswd());
        return agentLocationBean;
    }

    protected static boolean isAgentLocationValid(AgentLocation agentLocation) {
        if (agentLocation == null) {
            return false;
        }
        String string = agentLocation.getHost();
        if (string == null || string.length() == 0) {
            return false;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return true;
    }

    private static SAClient getSAClientConnection(AgentLocation agentLocation) {
        return SAClientFactory.getInstance().getSAClient(agentLocation.getAgentLocation(), agentLocation.getUid(), agentLocation.getPasswd());
    }

    private static boolean isVersionValid(SAClient sAClient, AgentLocation agentLocation) {
        AgentConfigService agentConfigService = sAClient.getAgentConfigService();
        if (agentConfigService == null) {
            return false;
        }
        AgentSummary[] agentSummaryArray = null;
        try {
            agentSummaryArray = agentConfigService.getAgentList();
        }
        catch (Exception exception) {
            return false;
        }
        if (agentSummaryArray == null) {
            return false;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(agentLocation.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        boolean bl = false;
        String string = null;
        for (int i = 0; i < agentSummaryArray.length; ++i) {
            if (!agentSummaryArray[i].getInetAddress().equals(inetAddress)) continue;
            string = agentSummaryArray[i].getAgentVersion();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLAZZ, "isVersionValid", "Agent " + agentLocation.getAgentLocation() + " version: " + string);
            }
            if (string == null || string.length() == 0) {
                return false;
            }
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer("2.4.39.007", ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, ".");
        while (stringTokenizer2.hasMoreTokens()) {
            if (!stringTokenizer.hasMoreTokens() || Integer.parseInt(stringTokenizer2.nextToken()) >= Integer.parseInt(stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static void cleanupTransaction(PersistenceManager persistenceManager, Transaction transaction) {
        if (persistenceManager != null) {
            try {
                persistenceManager.releaseTransaction(transaction);
                persistenceManager = null;
            }
            catch (Exception exception) {
                logger.logp(Level.WARNING, CLAZZ, "cleanupTransaction", "Exception caught releasing database transaction", exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

