/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.server;

import com.sun.admin.pm.server.Debug;
import com.sun.admin.pm.server.DoPrinterAdd;
import com.sun.admin.pm.server.DoPrinterDelete;
import com.sun.admin.pm.server.DoPrinterMod;
import com.sun.admin.pm.server.DoPrinterUtil;
import com.sun.admin.pm.server.DoPrinterView;
import com.sun.admin.pm.server.Host;
import com.sun.admin.pm.server.NameService;
import com.sun.admin.pm.server.PrinterDebug;
import com.sun.admin.pm.server.pmInternalErrorException;
import com.sun.admin.pm.server.pmMisc;

public class Printer {
    private String printername = null;
    private String printertype = null;
    private String printserver = null;
    private String comment = null;
    private String device = null;
    private String make = null;
    private String model = null;
    private String ppd = null;
    private String ppdfile = null;
    private String notify = null;
    private String protocol = null;
    private String destination = null;
    private String extensions = null;
    private String[] file_contents = null;
    private String[] user_allow_list = null;
    private String[] user_deny_list = null;
    private boolean use_ppd_file = true;
    private boolean default_printer = false;
    private String banner = null;
    private boolean enable = true;
    private boolean accept = true;
    private String locale = null;
    private NameService nscontext;
    private String warnlog = null;
    private String errlog = null;
    private String cmdlog = null;
    protected String modhints = "";

    public Printer() {
        Debug.message("SVR: Printer constructor called empty.");
        this.nscontext = new NameService();
        PrinterDebug.printObj(this.nscontext);
    }

    public Printer(NameService nameService) {
        Debug.message("SVR: Printer constructor called with NS.");
        this.nscontext = nameService;
        PrinterDebug.printObj(nameService);
    }

    public synchronized boolean isPrinterLocal(String string) throws Exception {
        Debug.message("SVR: Printer.isPrinterLocal()");
        return DoPrinterUtil.isLocal(string);
    }

    public synchronized void getPrinterDetails() throws Exception {
        Debug.message("SVR: Printer.getPrinterDetails()");
        if (this.printername == null) {
            throw new pmInternalErrorException("Printer.getPrinterDetails(): printername must be set");
        }
        DoPrinterView.view(this, this.nscontext);
    }

    public synchronized void addLocalPrinter() throws Exception {
        Debug.message("SVR: Printer.addLocalPrinter()");
        if (this.printername == null) {
            throw new pmInternalErrorException("Printer.addLocalPrinter(): printername must be set");
        }
        if (this.printserver == null) {
            Host host = new Host();
            this.printserver = host.getLocalHostName();
            host = null;
        }
        if (this.device == null) {
            throw new pmInternalErrorException("Printer.addLocalPrinter(): device must be set");
        }
        if (pmMisc.isppdCachefile() && this.use_ppd_file) {
            if (this.make == null) {
                throw new pmInternalErrorException("Printer.addLocalPrinter(): make must be set");
            }
            if (this.model == null) {
                throw new pmInternalErrorException("Printer.addLocalPrinter(): model must be set");
            }
            if (this.ppd == null) {
                throw new pmInternalErrorException("Printer.addLocalPrinter(): ppd file must be selected");
            }
        }
        PrinterDebug.printObj(this);
        this.clearLogs();
        DoPrinterAdd.add(this, this.nscontext);
    }

    public synchronized void addRemotePrinter() throws Exception {
        Debug.message("SVR: Printer.addRemotePrinter()");
        if (this.printername == null) {
            throw new pmInternalErrorException("Printer.addRemotePrinter(): printername must be set");
        }
        if (this.printserver == null) {
            throw new pmInternalErrorException("Printer.addRemotePrinter(): printserver must be set");
        }
        PrinterDebug.printObj(this);
        this.clearLogs();
        DoPrinterAdd.add(this, this.nscontext);
    }

    public synchronized void deletePrinter() throws Exception {
        Debug.message("SVR: Printer.deletePrinter()");
        if (this.printername == null) {
            throw new pmInternalErrorException("Printer.deletePrinter(): printername must be set");
        }
        PrinterDebug.printObj(this);
        this.clearLogs();
        DoPrinterDelete.delete(this, this.nscontext);
    }

    public synchronized void modifyPrinter() throws Exception {
        Debug.message("SVR: Printer.modifyPrinter()");
        if (this.printername == null) {
            throw new pmInternalErrorException("Printer.modifyPrinter(): printername must be set");
        }
        PrinterDebug.printObj(this);
        this.clearLogs();
        DoPrinterMod.modify(this, this.nscontext);
    }

    public synchronized void setCmdLog(String string) {
        if (string == null) {
            return;
        }
        if (!string.endsWith("\n")) {
            string = string.concat("\n");
        }
        if (this.cmdlog == null) {
            this.cmdlog = new String(string);
            return;
        }
        this.cmdlog = this.cmdlog.concat(string);
    }

    public synchronized void setErrorLog(String string) {
        if (string == null) {
            return;
        }
        if (!string.endsWith("\n")) {
            string = string.concat("\n");
        }
        if (this.errlog == null) {
            this.errlog = new String(string);
            return;
        }
        this.errlog = this.errlog.concat(string);
    }

    public synchronized void setWarnLog(String string) {
        if (string == null) {
            return;
        }
        if (!string.endsWith("\n")) {
            string = string.concat("\n");
        }
        if (this.warnlog == null) {
            this.warnlog = new String(string);
            return;
        }
        this.warnlog = this.warnlog.concat(string);
    }

    public String getCmdLog() {
        if (this.cmdlog == null) {
            return null;
        }
        return new String(this.cmdlog.trim());
    }

    public String getErrorLog() {
        if (this.errlog == null) {
            return null;
        }
        return new String(this.errlog.trim());
    }

    public String getWarnLog() {
        if (this.warnlog == null) {
            return null;
        }
        return new String(this.warnlog.trim());
    }

    public synchronized void setPrinterName(String string) {
        this.printername = string;
    }

    public synchronized void setPrinterType(String string) {
        this.printertype = string;
    }

    public synchronized void setPrintServer(String string) {
        this.printserver = string;
    }

    public synchronized void setComment(String string) {
        this.comment = string;
    }

    public synchronized void setMake(String string) {
        this.make = string;
    }

    public synchronized void setModel(String string) {
        this.model = string;
    }

    public synchronized void setPPD(String string) {
        this.ppd = string;
    }

    public synchronized void setPPDFile(String string) {
        this.ppdfile = string;
    }

    public synchronized void setDevice(String string) {
        this.device = string;
    }

    public synchronized void setUsePPD(boolean bl) {
        this.use_ppd_file = bl;
    }

    public synchronized void setNotify(String string) {
        this.notify = string;
    }

    public synchronized void setProtocol(String string) {
        this.protocol = string;
    }

    public synchronized void setDestination(String string) {
        this.destination = string;
    }

    public synchronized void setExtensions(String string) {
        this.extensions = string;
    }

    public synchronized void setFileContents(String[] stringArray) {
        this.file_contents = stringArray;
    }

    public synchronized void setUserAllowList(String[] stringArray) {
        this.user_allow_list = stringArray;
    }

    public synchronized void setUserDenyList(String[] stringArray) {
        this.user_deny_list = stringArray;
    }

    public synchronized void setIsDefaultPrinter(boolean bl) {
        this.default_printer = bl;
    }

    public synchronized void setBanner(String string) {
        this.banner = string;
    }

    public synchronized void setEnable(boolean bl) {
        this.enable = bl;
    }

    public synchronized void setAccept(boolean bl) {
        this.accept = bl;
    }

    public synchronized void setLocale(String string) {
        this.locale = string;
    }

    public String getPrinterName() {
        return this.printername;
    }

    public String getPrinterType() {
        return this.printertype;
    }

    public String getPrintServer() {
        return this.printserver;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDevice() {
        return this.device;
    }

    public boolean getUsePPD() {
        return this.use_ppd_file;
    }

    public String getMake() {
        return this.make;
    }

    public String getModel() {
        return this.model;
    }

    public String getPPD() {
        return this.ppd;
    }

    public String getPPDFile() {
        return this.ppdfile;
    }

    public String getNotify() {
        return this.notify;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public String[] getFileContents() {
        return this.file_contents;
    }

    public String[] getUserAllowList() {
        return this.user_allow_list;
    }

    public String[] getUserDenyList() {
        return this.user_deny_list;
    }

    public boolean getIsDefaultPrinter() {
        return this.default_printer;
    }

    public String getBanner() {
        return this.banner;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public boolean getAccept() {
        return this.accept;
    }

    public String getLocale() {
        return this.locale;
    }

    protected void clearLogs() {
        this.warnlog = null;
        this.errlog = null;
        this.cmdlog = null;
    }
}

