/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.pm.server;

import com.sun.admin.pm.server.Debug;
import com.sun.admin.pm.server.DoPrinterNS;
import com.sun.admin.pm.server.DoPrinterView;
import com.sun.admin.pm.server.SysCommand;
import com.sun.admin.pm.server.pmCmdFailedException;
import com.sun.admin.pm.server.pmHostNotPingableException;
import com.sun.admin.pm.server.pmInternalErrorException;
import com.sun.admin.pm.server.pmNSNotConfiguredException;
import java.io.File;

public class Host {
    public static void main(String[] stringArray) {
        try {
            System.out.println(Host.getLocalHostName());
            System.out.println(Host.getDomainName());
            System.out.println(Host.getNisHost("master"));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        System.exit(0);
    }

    public static synchronized String getLocalHostName() throws Exception {
        Debug.message("SVR: Host.getLocalHostName()");
        String string = "/usr/bin/hostname";
        SysCommand sysCommand = new SysCommand();
        sysCommand.exec(string);
        if (sysCommand.getExitValue() != 0) {
            String string2 = sysCommand.getError();
            sysCommand = null;
            throw new pmCmdFailedException(string2);
        }
        String string3 = sysCommand.getOutput();
        sysCommand = null;
        if (string3 == null) {
            return new String("");
        }
        return new String(string3);
    }

    public static synchronized String getDomainName() throws Exception {
        Debug.message("SVR: Host.getDomainName()");
        String string = "/usr/bin/domainname";
        SysCommand sysCommand = new SysCommand();
        sysCommand.exec(string);
        if (sysCommand.getExitValue() != 0) {
            String string2 = sysCommand.getError();
            sysCommand = null;
            throw new pmCmdFailedException(string2);
        }
        String string3 = sysCommand.getOutput();
        sysCommand = null;
        if (string3 == null) {
            return new String("");
        }
        return new String(string3);
    }

    public static synchronized void pingHost(String string) throws Exception {
        Debug.message("SVR: Host.pingHost()");
        SysCommand sysCommand = new SysCommand();
        sysCommand.exec("/usr/sbin/ping " + string);
        int n = sysCommand.getExitValue();
        sysCommand = null;
        if (n != 0) {
            String string2 = sysCommand.getError();
            throw new pmHostNotPingableException(string2);
        }
    }

    public static synchronized String getNisMaster() throws Exception {
        return Host.getNisHost("master");
    }

    public static synchronized String getNisHost(String string) throws Exception {
        Debug.message("SVR: Host.getNisHost() " + string);
        SysCommand sysCommand = null;
        String string2 = null;
        int n = 0;
        string2 = string.equals("master") ? "/usr/bin/ypwhich -m printers.conf.byname" : "/usr/bin/ypwhich";
        sysCommand = new SysCommand();
        sysCommand.exec(string2);
        n = sysCommand.getExitValue();
        if (n != 0 && string.equals("master")) {
            Debug.message("SVR: printers.conf NIS host not found.");
            Debug.message("SVR: Looking for NIS passwd host.");
            string2 = "/usr/bin/ypwhich -m passwd";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            n = sysCommand.getExitValue();
        }
        if (n != 0) {
            Debug.error("SVR: NIS server could not be found");
            String string3 = sysCommand.getError();
            sysCommand = null;
            throw new pmNSNotConfiguredException(string3);
        }
        String string4 = sysCommand.getOutput();
        sysCommand = null;
        if (string4 == null) {
            throw new pmCmdFailedException(sysCommand.getError());
        }
        string4 = string4.trim();
        return new String(string4);
    }

    public static synchronized String getLDAPMaster() throws Exception {
        SysCommand sysCommand = null;
        String string = null;
        int n = 0;
        if (!DoPrinterNS.isRoot()) {
            Debug.error("SVR: Not root. Can't determine LDAP master.");
            return null;
        }
        string = "/usr/sbin/ldapclient list";
        sysCommand = new SysCommand();
        sysCommand.exec(string);
        n = sysCommand.getExitValue();
        if (n != 0) {
            Debug.error("SVR: ldapclient failed.");
            Debug.error("SVR: " + sysCommand.getError());
            sysCommand = null;
            return null;
        }
        String string2 = sysCommand.getOutput();
        sysCommand = null;
        String string3 = DoPrinterView.getToken(string2 + "\n", "NS_LDAP_SERVERS=");
        if (string3 == null) {
            Debug.error("SVR: ldapclient did not return NS_LDAP_SERVERS.");
            sysCommand = null;
            return null;
        }
        for (int i = 0; i < string3.length(); ++i) {
            if (string3.charAt(i) != ',' && string3.charAt(i) != ' ' && string3.charAt(i) != '\t') continue;
            string3 = string3.substring(0, i);
            break;
        }
        string3 = string3.trim();
        return new String(string3);
    }

    public static synchronized String getDefaultAdminDN() throws Exception {
        String string;
        String string2;
        SysCommand sysCommand = null;
        String string3 = null;
        int n = 0;
        try {
            string2 = Host.getLDAPMaster();
            string3 = "/usr/bin/ldapsearch -h " + string2 + " -b o=NetScapeRoot o=NetscapeRoot";
            sysCommand = new SysCommand();
            sysCommand.exec(string3);
            n = sysCommand.getExitValue();
            if (n == 0) {
                string = sysCommand.getOutput();
                sysCommand = null;
                if (string != null && string.indexOf("NetscapeRoot") != -1) {
                    return "cn=Directory Manager";
                }
            }
            sysCommand = null;
        }
        catch (Exception exception) {
            Debug.message("SVR: ldapsearch for NSDS failed. Continuing");
        }
        string3 = "/usr/bin/ldaplist -d printers";
        sysCommand = new SysCommand();
        sysCommand.exec(string3);
        n = sysCommand.getExitValue();
        if (n != 0) {
            Debug.error("SVR: ldaplist printers failed.");
            Debug.error("SVR: " + sysCommand.getError());
            sysCommand = null;
            return null;
        }
        string2 = sysCommand.getOutput();
        sysCommand = null;
        if (string2 == null) {
            return null;
        }
        string = DoPrinterView.getToken(string2 + "\n", "ou=printers,");
        if (string == null) {
            return null;
        }
        string = "cn=admin," + string;
        string = string.trim();
        return new String(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void isNSConfigured(String string) throws Exception {
        Debug.message("SVR: Host.isNSConfigured() " + string);
        String string2 = null;
        String string3 = null;
        SysCommand sysCommand = null;
        if (string.equals("system")) {
            return;
        }
        if (string.equals("nis")) {
            string2 = "/usr/bin/ypwhich";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            int n = sysCommand.getExitValue();
            string3 = sysCommand.getError();
            sysCommand = null;
            if (n != 0) {
                throw new pmNSNotConfiguredException(string3);
            }
            string2 = "/usr/bin/ypcat cred";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            n = sysCommand.getExitValue();
            sysCommand = null;
            if (n != 0) return;
            Debug.warning("SVR: Discovered NIS+ server in yp compat mode.");
            Debug.warning("SVR: Unable to update this configuration.");
            throw new pmNSNotConfiguredException();
        }
        if (string.equals("nisplus")) {
            string2 = "/usr/bin/grep printers: /etc/nsswitch.conf";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            if (sysCommand.getExitValue() != 0) {
                sysCommand = null;
                Debug.message("SVR: nisplus is not supported for this system");
                throw new pmNSNotConfiguredException();
            }
            string2 = "/usr/bin/nisls";
            sysCommand = new SysCommand();
            sysCommand.exec(string2);
            if (sysCommand.getExitValue() == 0) return;
            string3 = sysCommand.getError();
            sysCommand = null;
            throw new pmNSNotConfiguredException(string3);
        }
        if (!string.equals("ldap")) throw new pmInternalErrorException("Unkown name service " + string);
        File file = new File("/var/ldap/ldap_client_file");
        if (!file.isFile()) throw new pmNSNotConfiguredException();
        string2 = "/usr/bin/ldaplist -d printers";
        sysCommand = new SysCommand();
        sysCommand.exec(string2);
        int n = sysCommand.getExitValue();
        sysCommand = null;
        if (n == 0) return;
        throw new pmNSNotConfiguredException();
    }
}

