#!/bin/sh
# 
#  @(#)hd-server.sh	1.56 03/04/21
#
# Copyright 2003 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#  @version 1.56 03/04/21 16:26:09
#
#

# source es-common for getting ENV variables
if test -z "$ESROOT"; then
    /usr/bin/gettext "ESROOT environment variable must be set"
    exit 1
fi
. ${ESROOT}/sbin/es-common.sh

#Below lines are added for l10n/I18N changes

basedir=`/usr/bin/pkgparam SUNWescom BASEDIR`
. ${basedir:=/opt}/SUNWsymon/sbin/es-common.sh

#
# Set the locale for I18N/L10N
# ----------------------------
check_for_l10n
TEXTDOMAIN="SUNW_HWDIAG"
export TEXTDOMAIN
setup_textdomain $TEXTDOMAIN


##jdk/jre
# All the L10N variables will be exported from start-diag
set -k
unset TEST
TEST=thisTest

# Let's see if an other HWDS server is running. If yes exit
PWD=`/bin/pwd`

thisIsme=`/usr/bin/id | grep "uid=0"`
if [ -z $thisIsme ] ; then
	# sunmc reason
	/bin/gettext "Hardware Diagnostic Suite can be started only by root"
	echo ""
	exit 1
fi

#-A- Let's see if /var/opt/SUNWhwdiag/logs/hwdserver.pid exists 
#    and if the pid is the pid of a runing process

if [ !  -d "/var/opt/SUNWhwdiag/logs" ]; then
	/usr/bin/mkdir -m 664 -p /var/opt/SUNWhwdiag/logs
fi

if [ -f "/var/opt/SUNWhwdiag/logs/hwdserver.pid" ]; then
	EDS_PID=`cat /var/opt/SUNWhwdiag/logs/hwdserver.pid`
	if [ ! ${TEST} = ${TEST}${EDS_PID} ] ; then
		EDS_PID_A=`/bin/ps -efo pid | /bin/grep ${EDS_PID}`
		if [ ! ${TEST} = ${TEST}${EDS_PID_A} ] ; then
			## server already runs. exit.
			/bin/gettext "Hardware Diagnostic Suite Server is already running."
			echo ""
			exit 0;
		else
			# the pid in /var/opt/SUNWhwdiag/logs/hwdserver.pid is useless
			/bin/rm -f /var/opt/SUNWhwdiag/logs/hwdserver.pid
		fi
 	fi
fi

#-B-HWDS Server is not running or /var/opt/SUNWhwdiag/logs/hwdserver.pid 
#	  is not present. Need to double check.
#     Figure out if HWDS Server is running and 
#     /var/opt/SUNWhwdiag/logs/hwdserver is not present
EDS_PID=`/bin/ps -ef | /bin/fgrep "DHWDS" | /bin/fgrep -v fgrep | /bin/awk '{ print $2 }'`

if [ -x /usr/ucb/ps ] ; then
        EDS_PID=`/usr/ucb/ps -aw | /bin/fgrep "DHWDS" | /bin/fgrep -v fgrep | /bin/awk '{ print $1 }'`
fi

if [ ! ${TEST} = ${TEST}${EDS_PID} ] ; then
	## server already runs. 
	## Update the /var/opt/SUNWhwdiag/logs/hwdserver.pid & exit.
	/bin/echo ${EDS_PID} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
	/bin/gettext "Hardware Diagnostic Suite Server is already running."
	echo ""
	exit 0;
fi

PATH=""
unset LD_LIBRARY_PATH
unset CLASSPATH
unset JAVA_COMPILER
unset THREADS_FLAG
LANGHWD2=$LANG

#### 
#	Check if JAVA_HOME is set ?
####
if [ -z "$JAVA_HOME" ]; then
	/bin/gettext "Hardware Diagnostic Suite Server ERROR: can not find JAVA_HOME"
	echo "HWDS Server ERROR  can not find JAVA_HOME" > /var/opt/SUNWhwdiag/logs/.java_home
	/usr/bin/chmod 644 /var/opt/SUNWhwdiag/logs/.java_home
	 exit 1
fi

###
# User first message 
###

/bin/gettext  "Hardware Diagnostic Suite Server Start Procedure"
echo ""

SCRIPT_DIR=`/bin/dirname $0`
DEV_CLASSES=${SCRIPT_DIR}/../../classes
PRO_CLASSES=${SCRIPT_DIR}/../../../../apps/classes
CHECK_DIR=${SCRIPT_DIR}/../../../AdvancedMonitoring

###
# Check if it is a development/production env and set the paths
# accordingly. This check will use a API when SunMC publishes 
# the same in the near future.
###
if [ -d ${CHECK_DIR} ]; then
    # Working in production environment
    CLASSES_DIR=${PRO_CLASSES}
else
    # Working in developement environment
    CLASSES_DIR=${DEV_CLASSES}
    cd ${CLASSES_DIR}
fi

OS_V=`/usr/bin/uname -r | /usr/bin/sed -e 1,1s/5/2/`

whereIsSunMC=`/usr/bin/pkginfo -r SUNWessmn`
if [ ${TEST}${whereIsSunMC} = ${TEST} ]; then
	/bin/gettext  "Hardware Diagnostic Suite Server can not find where SunMC Advanced Server Monitoring SUNWessmn is installed. Exit"
	echo ""
	exit 1	# ERROR

elif [ -d ${whereIsSunMC} ]; then
	SunMC_CLASSES=${whereIsSunMC}/SUNWsymon/classes
else
	/bin/gettext  "Hardware Diagnostic Suite Server can not find where SunMC Advanced Server Monitoring SUNWessmn is installed. Exit"
	echo ""
	exit 2	# ERROR
fi

PATH=${JAVA_HOME}/bin:/bin:/etc:$PATH
export PATH

which_java=${JAVA_HOME}/bin/java

##
# Some debug useful info
##
if [ -f /var/opt/SUNWhwdiag/logs/.java_home ] ; then
	rm -f /var/opt/SUNWhwdiag/logs/.java_home
fi
echo "HWDS Server JAVA_HOME=${JAVA_HOME}" > /var/opt/SUNWhwdiag/logs/.java_home
ZZZ=`${which_java} -version   2>&1 | /usr/bin/xargs echo `
echo "HWDS Server JavaVersion=${ZZZ}" >> /var/opt/SUNWhwdiag/logs/.java_home


## For SunMC 3.1. Will not work on SunMC 3.0
LD_LIBRARY_PATH=${SunMC_CLASSES}/../base/lib:${SunMC_CLASSES}/../base/lib/sparc-sun-solaris${OS_V}:${JAVA_HOME}/lib

INTERFACE_PATH=/var/opt/SUNWsymon/cfg:/var/opt/SUNWsymon/classes:${SunMC_CLASSES}/base/server/cfg:${SunMC_CLASSES}
export INTERFACE_PATH

CLASSPATH1=${JAVA_HOME}/lib/classes.zip:${CLASSES_DIR}:${CLASSES_DIR}/hdsrv.jar:${CLASSES_DIR}/hdsrvrmi.jar:${CLASSES_DIR}/../../classes/jdbc/classes12.zip 
CLASSPATH2=${SunMC_CLASSES}/essrv.jar:${SunMC_CLASSES}/esjrm.jar
CLASSPATH3=${SunMC_CLASSES}/essfx.jar:${SunMC_CLASSES}/escom.jar:${SunMC_CLASSES}/esclt.jar:${SunMC_CLASSES}/escom.jar
CLASSPATH4=${SunMC_CLASSES}/escon.jar:${SunMC_CLASSES}/esmigrate.jar:${SunMC_CLASSES}/esmsg.jar
CLASSPATH=${CLASSPATH1}:${CLASSPATH2}:${CLASSPATH3}:${CLASSPATH4}

JAVA_COMPILER=NONE
export JAVA_COMPILER 
export CLASSPATH
export LD_LIBRARY_PATH

THREADS_FLAG=native
export THREADS_FLAG
/bin/rm -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log

if [ ! -f $BASE_PATH/lib/server/hdserversec.policy ]; then
	echo "grant { permission java.security.AllPermission;};" > $BASE_PATH/lib/server/hdserversec.policy
fi

unset LANG

# For NAT between console and server, pass in a host alias that
# is resolvable by the console/client

checkJavaOK
set_basedir
set_xput
HOSTALIAS=-Dsunmc.host=`$XGET ${ESDIR}/cfg/domain-config.x topology.topologyServer`

reply=`${which_java} ${HOSTALIAS} -DHWDS -Djava.compiler=NONE -Djava.security.policy=$BASE_PATH/lib/server/hdserversec.policy -DINTERFACE_PATH=${INTERFACE_PATH} -classpath ${CLASSPATH}  com.sun.entdiag.server.EDServerRMIServer > /tmp/edserver1099   & `

sleep 5
/usr/bin/chmod 644 /tmp/edserver1099

## fix bugid 4350403
LANG=$LANGHWD2
export LANG

if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
	sleep 10
	if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
		sleep 15
	fi
	if [ ! -f /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log ]; then
		echo "*********************************"
		/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
		echo ""
		echo "*********************************"
		exit 1
	fi
fi

sleep 5
/bin/chmod -f 644 /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log
set muErr=
muErr=`/bin/grep ERROR /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log | /bin/awk '{ print $1 }'`
set muErr2=
muErr2=`/bin/grep Exception /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log | /bin/awk '{ print $1 }'`
if [ ! ${TEST} = ${TEST}$muErr -o ! ${TEST} = ${TEST}$muErr2 ] ; then
	echo "*********************************"
	/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
	echo ""
	echo "*********************************"
	/bin/cat /var/opt/SUNWhwdiag/logs/HWDServerRMIServer.log 
	/bin/gettext  "EXIT"
	echo ""
	$BASE_PATH/sbin/stop-diag > /dev/null
	exit 1
else
	## Store the ED Server pid in /var/opt/SUNWhwdiag/logs/hwdserver.pid
	/bin/rm -f /var/opt/SUNWhwdiag/logs/hwdserver.pid
	EDS_PID2=`/usr/ucb/ps -gww | /bin/fgrep EDServ | /bin/fgrep -v fgrep | /bin/awk '{ print $1 }'`
	# Work around for the case when EDS_PID2 is null at boot time.
	EDS_PID3=`/usr/bin/ps -ef | /bin/fgrep "AdvancedMonitoring/classes/./jre2/bin" | /bin/fgrep -v fgrep | /bin/awk '{ print $2 }'`
	if [ ${EDS_PID2} ]; then
		/bin/echo ${EDS_PID2} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/chmod 644 /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/gettext  "Hardware Diagnostic Suite Server started OK"
	elif [ ${EDS_PID3} ]; then
		/bin/echo ${EDS_PID3} > /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/chmod 644 /var/opt/SUNWhwdiag/logs/hwdserver.pid
		/bin/gettext  "Hardware Diagnostic Suite Server started OK"
	else
		/bin/gettext  "ERROR in Hardware Diagnostic Suite Server start procedure"
	fi
	echo ""
	exit 0
fi

