/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.report;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.report.SMReportCategory;
import com.sun.symon.base.client.report.SMReportProperty;
import com.sun.symon.base.client.report.SMReportPropertyGroup;
import com.sun.symon.base.client.scm.common.SCMAPIException;
import com.sun.symon.base.client.scm.manager.SCMContainer;
import com.sun.symon.base.client.scm.manager.SCMHostTree;
import com.sun.symon.base.client.scm.manager.SCMTreeNode;
import com.sun.symon.base.client.scm.report.SCMReportResult;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.report.MrReportServiceImpl;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceImpl;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportConstants;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportData;
import com.sun.symon.base.mgmtservice.scm.report.SCMSimpleRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class SCMReportController
implements SCMReportConstants {
    private static SMReportCategory category = null;
    private static MrReportServiceImpl rptService = null;
    private static SCMServiceImpl scmService = null;
    private MSLogPrintWriter logWriter;
    private static Vector allProps = new Vector();
    private static Vector translatedCSVProps;
    private static boolean translationDone;

    public SCMReportController(MrReportServiceImpl mrReportServiceImpl, SCMServiceImpl sCMServiceImpl) throws SMAPIException, RemoteException {
        SMDBObjectID sMDBObjectID;
        rptService = mrReportServiceImpl;
        scmService = sCMServiceImpl;
        SCMServiceController sCMServiceController = SCMServiceController.getInstance();
        this.logWriter = sCMServiceController.getLogWriter();
        this.logWriter.println("SCMReportController init");
        boolean bl = false;
        SMReportCategory[] sMReportCategoryArray = mrReportServiceImpl.getAllCategory();
        int n = 0;
        while (n < sMReportCategoryArray.length) {
            if (sMReportCategoryArray[n].getName().equals("##Containers")) {
                sMDBObjectID = sMReportCategoryArray[n].getObjectID();
                category = mrReportServiceImpl.getReportCategory(sMDBObjectID);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            category = new SMReportCategory("##Containers", "");
            sMDBObjectID = mrReportServiceImpl.save(category);
            category = mrReportServiceImpl.getReportCategory(sMDBObjectID);
        }
    }

    public void finalize() throws Throwable {
    }

    public static Vector getCSVProps() {
        return translatedCSVProps;
    }

    private void translateCSVProperties() {
        if (translationDone) {
            return;
        }
        Vector<String> vector = new Vector<String>(allProps);
        vector.add(new String("Containers.ContTable.ContEntry.projectID"));
        vector.add(new String("Containers.ContTable.ContEntry.projectName"));
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Host");
        vector2.add("Time");
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = this.getI18nKey(string);
            String string3 = this.getUnit(string);
            if (string2 != null) {
                string = UcInternationalizer.translateKey((Locale)Locale.getDefault(), (String)string2, (String)string);
            }
            if (string3 != null && string.indexOf(string3) == -1) {
                string = string + " (" + string3 + ")";
            }
            vector2.add(string);
            ++n;
        }
        translatedCSVProps = new Vector(vector2);
        translationDone = true;
    }

    public SCMReportResult[] runPerformanceReportByHost(SCMHostTree[] sCMHostTreeArray, String[] stringArray, SCMTreeNode sCMTreeNode, String string, Vector vector, String string2, int n, Date date, Date date2) throws SMAPIException, RemoteException, SCMAPIException {
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        Object object2;
        String string3;
        SCMContainer[] sCMContainerArray;
        boolean bl = false;
        SCMReportResult[] sCMReportResultArray = null;
        Vector<SMReportProperty> vector2 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<SMReportPropertyGroup> vector3 = null;
        Vector<String> vector4 = new Vector<String>();
        this.translateCSVProperties();
        int n6 = 0;
        int n7 = 0;
        if (vector != null && vector.size() == 1 && (sCMContainerArray = (SCMContainer[])vector.elementAt(0)).equals("_ALL_SCM_")) {
            bl = true;
            this.logWriter.println("runPerformanceReportByHost : For CSV");
            vector = allProps;
        }
        if (sCMHostTreeArray != null) {
            this.logWriter.println("runPerformanceReportByHost : no filter");
            int n8 = vector.size();
            vector3 = new Vector<SMReportPropertyGroup>();
            vector2 = new Vector<SMReportProperty>();
            n6 = 0;
            while (n6 < n8) {
                String string4 = this.getI18nKey((String)vector.elementAt(n6));
                string3 = this.getUnit((String)vector.elementAt(n6));
                if (!bl) {
                    vector2 = new Vector();
                }
                object2 = this.constructProperty((String)vector.elementAt(n6), "_ALL_", string4, string3);
                vector2.addElement((SMReportProperty)object2);
                if (!bl) {
                    vector3.addElement(new SMReportPropertyGroup(vector2));
                }
                ++n6;
            }
            if (bl) {
                vector3.addElement(new SMReportPropertyGroup(vector2));
            }
            n5 = 0;
            while (n5 < sCMHostTreeArray.length) {
                string3 = sCMHostTreeArray[n5].getName() + ":" + sCMHostTreeArray[n5].getPort();
                if (!vector4.contains(string3)) {
                    this.logWriter.println("runPerformanceReportByHost : adding" + string3);
                    vector4.add(string3);
                }
                ++n5;
            }
        } else {
            this.logWriter.println("runPerformanceReportByHost : need to filter");
            sCMContainerArray = null;
            try {
                sCMContainerArray = scmService.getContainers(sCMTreeNode.getID(), true);
            }
            catch (Exception exception) {
                String string5 = "Exception on getContainers";
                this.logWriter.println(string5);
                throw new SCMAPIException(1, string5);
            }
            if (sCMContainerArray == null || sCMContainerArray.length == 0) {
                String string6 = "The result is empty.";
                this.logWriter.println(string6);
                throw new SCMAPIException(3, string6);
            }
            n5 = vector.size();
            vector3 = new Vector();
            vector2 = new Vector();
            n6 = 0;
            while (n6 < n5) {
                string3 = this.getI18nKey((String)vector.elementAt(n6));
                object2 = this.getUnit((String)vector.elementAt(n6));
                if (!bl) {
                    vector2 = new Vector();
                    hashtable = new Hashtable();
                }
                n4 = 0;
                while (n4 < sCMContainerArray.length) {
                    object = sCMContainerArray[n4].getContainerHostName();
                    int n9 = 0;
                    while (n9 < stringArray.length) {
                        if (((String)object).compareToIgnoreCase(stringArray[n9]) == 0) {
                            String string7 = (String)object + ":" + sCMContainerArray[n4].getContainerPort();
                            if (!vector4.contains(string7)) {
                                this.logWriter.println("runPerformanceReportByHost : adding" + string7);
                                vector4.add(string7);
                            }
                            String string8 = Long.toString(sCMContainerArray[n9].getProjectID());
                            String string9 = string;
                            if (string == null) {
                                string9 = sCMContainerArray[n9].getZoneName();
                            }
                            String string10 = string9 + "," + string8;
                            SMReportProperty sMReportProperty = this.constructProperty((String)vector.elementAt(n6), string10, string3, (String)object2);
                            if (!this.isDuplicateProperty(hashtable, sMReportProperty)) {
                                vector2.addElement(sMReportProperty);
                                hashtable.put(string10, sMReportProperty.getPropertyName());
                                this.logWriter.println("runPerformanceReportByHost : Adding Property and index:" + vector.elementAt(n6) + "(" + string10 + ")");
                            } else {
                                this.logWriter.println("runPerformanceReportByHost : Duplicate Property and index:" + sMReportProperty.getPropertyName() + "(" + string10 + ")");
                            }
                        }
                        ++n9;
                    }
                    ++n4;
                }
                if (!bl) {
                    vector3.addElement(new SMReportPropertyGroup(vector2));
                }
                ++n6;
            }
            if (bl) {
                vector3.addElement(new SMReportPropertyGroup(vector2));
            }
        }
        int n10 = vector4.size();
        String[] stringArray2 = new String[n10];
        stringArray2 = vector4.toArray(stringArray2);
        this.logWriter.println("nb of hosts:" + stringArray2.length);
        this.logWriter.println("pgroups size:" + vector3.size());
        if (stringArray2.length == 1) {
            n3 = 1;
            n2 = 1;
            n4 = 2;
        } else {
            n3 = 2;
            n2 = 1;
            n4 = 1;
        }
        object = null;
        object = bl ? new SCMSimpleRequest(rptService, stringArray2, vector3, string2, n, date, date2, "Performance Request For tabular results", category) : new SCMSimpleRequest(rptService, stringArray2, vector3, string2, n, date, date2, "Performance Request", category);
        try {
            SCMReportData[] sCMReportDataArray = null;
            sCMReportDataArray = bl ? ((SCMSimpleRequest)object).run() : ((SCMSimpleRequest)object).run(n3, n2, n4);
            sCMReportResultArray = new SCMReportResult[sCMReportDataArray.length];
            n7 = 0;
            while (n7 < sCMReportDataArray.length) {
                sCMReportResultArray[n7] = sCMReportDataArray[n7].getReportResult();
                ++n7;
            }
            ((SCMSimpleRequest)object).deleteRequest();
        }
        catch (SCMAPIException sCMAPIException) {
            ((SCMSimpleRequest)object).deleteRequest();
            throw sCMAPIException;
        }
        catch (SMAPIException sMAPIException) {
            ((SCMSimpleRequest)object).deleteRequest();
            throw sMAPIException;
        }
        catch (RemoteException remoteException) {
            ((SCMSimpleRequest)object).deleteRequest();
            throw remoteException;
        }
        return sCMReportResultArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SCMReportResult[] runPerformanceReportByServiceElement(SCMTreeNode[] sCMTreeNodeArray, String[] stringArray, SCMTreeNode sCMTreeNode, String string, Vector vector, String string2, int n, Date date, Date date2) throws SMAPIException, RemoteException, SCMAPIException {
        int n2;
        int n3;
        String[] stringArray2;
        SCMContainer[] sCMContainerArray;
        boolean bl = false;
        SCMReportResult[] sCMReportResultArray = new SCMReportResult[vector.size()];
        Vector vector2 = new Vector();
        SCMSimpleRequest sCMSimpleRequest = null;
        Vector<SMReportProperty> vector3 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector<SMReportPropertyGroup> vector4 = null;
        int n4 = 0;
        int n5 = 0;
        this.translateCSVProperties();
        this.logWriter.println("Final Result array initialized to: " + sCMReportResultArray.length);
        n4 = 0;
        while (n4 < sCMReportResultArray.length) {
            sCMReportResultArray[n4] = new SCMReportResult();
            ++n4;
        }
        if (vector != null && vector.size() == 1 && (sCMContainerArray = (String)vector.elementAt(0)).equals("_ALL_SCM_")) {
            bl = true;
            this.logWriter.println("runPerformanceReportByServiceElement : For CSV");
            vector = allProps;
        }
        if (sCMTreeNodeArray != null) {
            int n6;
            int n7;
            int n8;
            String[] stringArray3;
            this.logWriter.println("runPerformanceReportByServiceElement: no filter");
            sCMContainerArray = new Vector();
            int n9 = vector.size();
            vector4 = new Vector<SMReportPropertyGroup>();
            vector3 = new Vector<SMReportProperty>();
            n5 = 0;
            while (n5 < n9) {
                String string3 = this.getI18nKey((String)vector.elementAt(n5));
                stringArray3 = this.getUnit((String)vector.elementAt(n5));
                if (!bl) {
                    vector3 = new Vector();
                    hashtable = new Hashtable();
                }
                n8 = 0;
                while (n8 < sCMTreeNodeArray.length) {
                    this.logWriter.println("Handling : " + sCMTreeNodeArray[n8].getName());
                    SCMContainer[] sCMContainerArray2 = null;
                    try {
                        sCMContainerArray2 = scmService.getContainers(sCMTreeNodeArray[n8].getID(), true);
                    }
                    catch (Exception exception) {
                        String string4 = "Exception on getContainers";
                        this.logWriter.println(string4);
                        throw new SCMAPIException(1, string4);
                    }
                    if (sCMContainerArray2 == null || sCMContainerArray2.length == 0) {
                        this.logWriter.println("No container... skip it");
                    } else {
                        n7 = 0;
                        while (n7 < sCMContainerArray2.length) {
                            String string5 = sCMContainerArray2[n7].getContainerHostName() + ":" + sCMContainerArray2[n7].getContainerPort();
                            if (!sCMContainerArray.contains(string5)) {
                                sCMContainerArray.add(string5);
                            }
                            String string6 = Long.toString(sCMContainerArray2[n7].getProjectID());
                            String string7 = string;
                            if (string == null) {
                                string7 = sCMContainerArray2[n7].getZoneName();
                            }
                            String string8 = string7 + "," + string6;
                            SMReportProperty sMReportProperty = this.constructProperty((String)vector.elementAt(n5), string8, string3, (String)stringArray3);
                            if (!this.isDuplicateProperty(hashtable, sMReportProperty)) {
                                vector3.addElement(sMReportProperty);
                                hashtable.put(string8, sMReportProperty.getPropertyName());
                                this.logWriter.println("runPerformanceReportByHost : Adding Property and index:" + vector.elementAt(n5) + "(" + string8 + ")");
                            } else {
                                this.logWriter.println("runPerformanceReportByHost : Duplicate property" + sMReportProperty.getPropertyName());
                            }
                            ++n7;
                        }
                    }
                    ++n8;
                }
                if (!bl) {
                    vector4.addElement(new SMReportPropertyGroup(vector3));
                }
                ++n5;
            }
            if (bl) {
                vector4.addElement(new SMReportPropertyGroup(vector3));
            }
            int n10 = sCMContainerArray.size();
            stringArray3 = new String[n10];
            stringArray3 = sCMContainerArray.toArray(stringArray3);
            this.logWriter.println("nb of hosts:" + stringArray3.length);
            if (stringArray3.length == 1) {
                n8 = 1;
                n6 = 1;
                n7 = 2;
            } else {
                n8 = 2;
                n6 = 1;
                n7 = 1;
            }
            sCMSimpleRequest = bl ? new SCMSimpleRequest(rptService, stringArray3, vector4, string2, n, date, date2, "Performance Request For tabular results", category) : new SCMSimpleRequest(rptService, stringArray3, vector4, string2, n, date, date2, "Performance Request", category);
            try {
                Object var26_41 = null;
                if (bl) {
                    SCMReportData[] sCMReportDataArray = sCMSimpleRequest.run();
                } else {
                    SCMReportData[] sCMReportDataArray = sCMSimpleRequest.run(n8, n6, n7);
                }
                n4 = 0;
                while (n4 < sCMReportResultArray.length) {
                    void var26_44;
                    sCMReportResultArray[n4] = var26_44[n4].getReportResult();
                    ++n4;
                }
                sCMSimpleRequest.deleteRequest();
                return sCMReportResultArray;
            }
            catch (SCMAPIException sCMAPIException) {
                sCMSimpleRequest.deleteRequest();
                if (sCMAPIException.getReasonCode() == 3) return sCMReportResultArray;
                throw sCMAPIException;
            }
            catch (RemoteException remoteException) {
                sCMSimpleRequest.deleteRequest();
                throw remoteException;
            }
            catch (SMAPIException sMAPIException) {
                sCMSimpleRequest.deleteRequest();
                throw sMAPIException;
            }
        }
        this.logWriter.println("runPerformanceReportByServiceElement: filter");
        sCMContainerArray = null;
        try {
            sCMContainerArray = scmService.getContainers(sCMTreeNode.getID(), true);
        }
        catch (Exception exception) {
            String string9 = "Exception on getContainers";
            this.logWriter.println(string9);
            throw new SCMAPIException(1, string9);
        }
        if (sCMContainerArray == null || sCMContainerArray.length == 0) {
            String string10 = "The result is empty.";
            this.logWriter.println(string10);
            throw new SCMAPIException(3, string10);
        }
        Vector<String> vector5 = new Vector<String>();
        int n11 = vector.size();
        vector4 = new Vector();
        vector3 = new Vector();
        n5 = 0;
        while (n5 < n11) {
            String string11 = this.getI18nKey((String)vector.elementAt(n5));
            stringArray2 = this.getUnit((String)vector.elementAt(n5));
            if (!bl) {
                vector3 = new Vector();
                hashtable = new Hashtable();
            }
            n3 = 0;
            while (n3 < stringArray.length) {
                n2 = 0;
                while (n2 < sCMContainerArray.length) {
                    String string12 = sCMContainerArray[n2].getContainerName();
                    if (string12.compareToIgnoreCase(stringArray[n3]) == 0) {
                        String string13 = sCMContainerArray[n2].getContainerHostName() + ":" + sCMContainerArray[n2].getContainerPort();
                        if (!vector5.contains(string13)) {
                            vector5.add(string13);
                        }
                        String string14 = Long.toString(sCMContainerArray[n2].getProjectID());
                        String string15 = string;
                        if (string == null) {
                            string15 = sCMContainerArray[n2].getZoneName();
                        }
                        String string16 = string15 + "," + string14;
                        SMReportProperty sMReportProperty = this.constructProperty((String)vector.elementAt(n5), string16, string11, (String)stringArray2);
                        if (!this.isDuplicateProperty(hashtable, sMReportProperty)) {
                            vector3.addElement(sMReportProperty);
                            hashtable.put(string16, sMReportProperty.getPropertyName());
                            this.logWriter.println("runPerformanceReportByHost : Adding Property and index:" + vector.elementAt(n5) + "(" + string16 + ")");
                        } else {
                            this.logWriter.println("runPerformanceReportByHost : Duplicate property" + sMReportProperty.getPropertyName());
                        }
                    }
                    ++n2;
                }
                ++n3;
            }
            if (!bl) {
                vector4.addElement(new SMReportPropertyGroup(vector3));
            }
            ++n5;
        }
        if (bl) {
            vector4.addElement(new SMReportPropertyGroup(vector3));
        }
        int n12 = vector5.size();
        stringArray2 = new String[n12];
        stringArray2 = vector5.toArray(stringArray2);
        this.logWriter.println("nb of hosts:" + stringArray2.length);
        if (stringArray2.length == 1) {
            n3 = 1;
            n2 = 1;
            int n13 = 2;
        } else {
            n3 = 2;
            n2 = 1;
            boolean bl2 = true;
        }
        sCMSimpleRequest = bl ? new SCMSimpleRequest(rptService, stringArray2, vector4, string2, n, date, date2, "Performance Request For tabular results", category) : new SCMSimpleRequest(rptService, stringArray2, vector4, string2, n, date, date2, "Performance Request", category);
        try {
            Object var27_53 = null;
            if (bl) {
                SCMReportData[] sCMReportDataArray = sCMSimpleRequest.run();
            } else {
                void var26_49;
                SCMReportData[] sCMReportDataArray = sCMSimpleRequest.run(n3, n2, (int)var26_49);
            }
            n4 = 0;
            while (n4 < sCMReportResultArray.length) {
                void var27_56;
                sCMReportResultArray[n4] = var27_56[n4].getReportResult();
                ++n4;
            }
            sCMSimpleRequest.deleteRequest();
            return sCMReportResultArray;
        }
        catch (SCMAPIException sCMAPIException) {
            sCMSimpleRequest.deleteRequest();
            if (sCMAPIException.getReasonCode() == 3) return sCMReportResultArray;
            throw sCMAPIException;
        }
        catch (RemoteException remoteException) {
            sCMSimpleRequest.deleteRequest();
            throw remoteException;
        }
        catch (SMAPIException sMAPIException) {
            sCMSimpleRequest.deleteRequest();
            throw sMAPIException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector getContainers(SCMTreeNode sCMTreeNode) throws SCMAPIException {
        Vector<SCMContainer> vector = new Vector<SCMContainer>();
        Vector vector2 = sCMTreeNode.getChildren();
        if (vector2 != null) {
            int n = 0;
            while (n < vector2.size()) {
                SCMTreeNode sCMTreeNode2 = (SCMTreeNode)vector2.elementAt(n);
                Vector vector3 = this.getContainers(sCMTreeNode2);
                vector.addAll(vector3);
                ++n;
            }
            return vector;
        } else {
            SCMContainer[] sCMContainerArray = null;
            try {
                sCMContainerArray = scmService.getContainers(sCMTreeNode.getID(), true);
                if (sCMContainerArray == null) return vector;
                int n = 0;
                while (n < sCMContainerArray.length) {
                    vector.add(sCMContainerArray[n]);
                    ++n;
                }
                return vector;
            }
            catch (Exception exception) {
                String string = "Exception on getContainers";
                this.logWriter.println(string);
                throw new SCMAPIException(1, string);
            }
        }
    }

    private String url2MDRurl(SMRawDataRequest sMRawDataRequest, String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("snmp")) {
            string = "snmp://host:161/" + string;
        }
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        boolean bl = ucAgentURL.getPropertyType();
        String string2 = sMRawDataRequest.getMDRBaseURL() + "mod/" + ucAgentURL.getModuleId() + "+" + ucAgentURL.getMdrModuleId();
        String string3 = string2 + "/" + ucAgentURL.getManagedObject() + "/" + ucAgentURL.getProperty();
        if (bl && (string3.indexOf("table") <= 0 || string3.indexOf("entry") <= 0)) {
            string3 = string3 + "#0";
        }
        return string3;
    }

    private String getI18nKey(String string) {
        SMRawDataRequest sMRawDataRequest;
        String string2 = null;
        String string3 = "mediumDesc";
        String[] stringArray = new String[1];
        StObject[][] stObjectArray = new StObject[1][1];
        try {
            sMRawDataRequest = scmService.getRawDataRequest();
            String string4 = this.url2MDRurl(sMRawDataRequest, "/mod/scm-container/" + string);
            stringArray[0] = SMRawDataRequest.buildShadowURL((String)string4, (String)"consoleHintKey", null);
            stObjectArray[0][0] = new StString(string3);
            StObject[][] stObjectArray2 = null;
            stObjectArray2 = sMRawDataRequest.setURLValue(stringArray, stObjectArray);
            if (stObjectArray2 != null && stObjectArray2.length != 0) {
                string2 = stObjectArray2[0][0].toString();
            }
        }
        catch (Exception exception) {
            this.logWriter.println("Could not set the i18n key for property:" + string);
        }
        sMRawDataRequest = string2;
        return sMRawDataRequest;
    }

    private String getUnit(String string) {
        SMRawDataRequest sMRawDataRequest;
        String string2 = null;
        String[] stringArray = new String[1];
        try {
            sMRawDataRequest = scmService.getRawDataRequest();
            String string3 = this.url2MDRurl(sMRawDataRequest, "/mod/scm-container/" + string);
            stringArray[0] = SMRawDataRequest.buildShadowURL((String)string3, (String)"units", null);
            StObject[][] stObjectArray = sMRawDataRequest.getURLValue(stringArray);
            if (stObjectArray != null && stObjectArray.length == 1) {
                string2 = stObjectArray[0][0].toString();
            }
        }
        catch (Exception exception) {
            this.logWriter.println("Could not set the unit for property:" + string);
        }
        sMRawDataRequest = string2;
        return sMRawDataRequest;
    }

    private SMReportProperty constructProperty(String string, String string2, String string3, String string4) {
        this.logWriter.println("Property:" + string);
        this.logWriter.println("Index:" + string2);
        this.logWriter.println("I18n Key:" + string3);
        this.logWriter.println("Unit:" + string4);
        SMReportProperty sMReportProperty = new SMReportProperty(string, string2, "scm-container", null, string4);
        if (string3 != null) {
            sMReportProperty.setI18nKey(string3);
        }
        return sMReportProperty;
    }

    private boolean isDuplicateProperty(Hashtable hashtable, SMReportProperty sMReportProperty) {
        String string = sMReportProperty.getPropertyInstance();
        String string2 = sMReportProperty.getPropertyName();
        String string3 = (String)hashtable.get(string);
        if (string3 != null) {
            return string3.equals(string2);
        }
        return false;
    }

    private SCMSimpleRequest constructReportRequest(Vector vector, SCMContainer[] sCMContainerArray, String string, int n, Date date, Date date2, boolean bl, boolean bl2) throws SCMAPIException, RemoteException, SMAPIException {
        Object object;
        String string2;
        String string3;
        String string4;
        Object object2;
        Object object3;
        Object object4;
        Object var9_9 = null;
        Hashtable hashtable = new Hashtable();
        Vector vector2 = new Vector();
        this.translateCSVProperties();
        if (vector != null && vector.size() == 1 && ((String)(object4 = (String)vector.elementAt(0))).equals("_ALL_SCM_")) {
            bl2 = true;
            this.logWriter.println("runPerformanceReportByHost : For CSV");
            vector = allProps;
        }
        if (sCMContainerArray == null || sCMContainerArray.length == 0) {
            object4 = "The result is empty.";
            this.logWriter.println((String)object4);
            throw new SCMAPIException(3, (String)object4);
        }
        object4 = new Vector();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        if (bl) {
            object3 = sCMContainerArray[0];
            object2 = object3.getHostName() + ":" + object3.getPort();
            ((Vector)object4).add(object2);
            vector3.add("_ALL_");
        } else {
            int n2 = 0;
            while (n2 < sCMContainerArray.length) {
                object2 = sCMContainerArray[n2];
                String string5 = object2.getHostName();
                int n3 = object2.getPort();
                string4 = string5 + ":" + n3;
                if (!((Vector)object4).contains(string4)) {
                    ((Vector)object4).add(string4);
                }
                string3 = object2.getZoneName();
                long l = object2.getProjectID();
                string2 = string3 + "," + l;
                if (!vector3.contains(string2)) {
                    vector3.add(string2);
                }
                if (!vector4.contains(string3)) {
                    vector4.add(string3);
                }
                ++n2;
            }
        }
        object3 = new Vector();
        object2 = new Vector();
        int n4 = 0;
        while (n4 < vector.size()) {
            int n5;
            if (!bl2) {
                object3 = new Vector();
            }
            String string6 = (String)vector.elementAt(n4);
            string4 = this.getI18nKey(string6);
            string3 = this.getUnit(string6);
            if (string6.indexOf("ZoneTable.ZoneEntry") > 0) {
                n5 = 0;
                while (n5 < vector4.size()) {
                    object = this.constructProperty(string6, (String)vector4.get(n5), string4, string3);
                    ((Vector)object3).addElement(object);
                    ++n5;
                }
            } else {
                n5 = 0;
                while (n5 < vector3.size()) {
                    object = (String)vector3.get(n5);
                    string2 = this.constructProperty(string6, (String)vector3.get(n5), string4, string3);
                    ((Vector)object3).addElement(string2);
                    ++n5;
                }
            }
            if (!bl2) {
                ((Vector)object2).addElement(new SMReportPropertyGroup((Vector)object3));
            }
            ++n4;
        }
        if (bl2) {
            ((Vector)object2).add(new SMReportPropertyGroup((Vector)object3));
        }
        String[] stringArray = new String[((Vector)object4).size()];
        stringArray = ((Vector)object4).toArray(stringArray);
        this.logWriter.println("nb of hosts:" + stringArray.length);
        if (stringArray.length == 1) {
            boolean bl3 = true;
            boolean bl4 = true;
            int n6 = 2;
        } else {
            int n7 = 2;
            boolean bl5 = true;
            boolean bl6 = true;
        }
        object = null;
        object = bl2 ? new SCMSimpleRequest(rptService, stringArray, (Vector)object2, string, n, date, date2, "Performance Request For tabular results", category) : new SCMSimpleRequest(rptService, stringArray, (Vector)object2, string, n, date, date2, "Performance Request", category);
        return object;
    }

    public SCMReportResult[] runPerformanceReport(SCMContainer[] sCMContainerArray, Vector vector, String string, int n, Date date, Date date2, boolean bl) throws SMAPIException, RemoteException, SCMAPIException {
        return this.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, bl, -1, 0);
    }

    public SCMReportResult[] runPerformanceReport(SCMContainer[] sCMContainerArray, Vector vector, String string, int n, Date date, Date date2, boolean bl, int n2, int n3) throws SMAPIException, RemoteException, SCMAPIException {
        int n4;
        int n5;
        int n6;
        String[] stringArray;
        Object object;
        boolean bl2 = false;
        if (vector != null && vector.size() == 1 && ((String)(object = (String)vector.elementAt(0))).equals("_ALL_SCM_")) {
            bl2 = true;
            this.logWriter.println("runPerformanceReportByHost : For CSV");
            vector = allProps;
        }
        if ((stringArray = ((SCMSimpleRequest)(object = this.constructReportRequest(vector, sCMContainerArray, string, n, date, date2, bl, bl2))).getTargetHosts()).length == 1) {
            n6 = 1;
            n5 = 1;
            n4 = 2;
        } else {
            n6 = 2;
            n5 = 1;
            n4 = 1;
        }
        SCMReportResult[] sCMReportResultArray = null;
        try {
            SCMReportData[] sCMReportDataArray = null;
            sCMReportDataArray = bl2 ? ((SCMSimpleRequest)object).run() : (n2 > 0 ? ((SCMSimpleRequest)object).run(n2, n3) : ((SCMSimpleRequest)object).run(n6, n5, n4));
            sCMReportResultArray = new SCMReportResult[sCMReportDataArray.length];
            int n7 = 0;
            while (n7 < sCMReportResultArray.length) {
                sCMReportResultArray[n7] = sCMReportDataArray[n7].getReportResult();
                ++n7;
            }
            ((SCMSimpleRequest)object).deleteRequest();
        }
        catch (SCMAPIException sCMAPIException) {
            ((SCMSimpleRequest)object).deleteRequest();
            if (sCMAPIException.getReasonCode() != 3) {
                throw sCMAPIException;
            }
        }
        catch (RemoteException remoteException) {
            ((SCMSimpleRequest)object).deleteRequest();
            throw remoteException;
        }
        catch (SMAPIException sMAPIException) {
            ((SCMSimpleRequest)object).deleteRequest();
            throw sMAPIException;
        }
        return sCMReportResultArray;
    }

    static {
        allProps.add(new String("Containers.ContTable.ContEntry.cpuRes"));
        allProps.add(new String("Containers.ContTable.ContEntry.cpuUsage"));
        allProps.add(new String("Containers.ContTable.ContEntry.cpuROI"));
        allProps.add(new String("Containers.ContTable.ContEntry.cpuExacct"));
        allProps.add(new String("Containers.ContTable.ContEntry.memCap"));
        allProps.add(new String("Containers.ContTable.ContEntry.memRSS"));
        allProps.add(new String("Containers.ContTable.ContEntry.memPctUsed"));
        allProps.add(new String("Containers.ContTable.ContEntry.memROI"));
        translatedCSVProps = null;
        translationDone = false;
    }
}

