/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager.traps;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.scm.common.SCMAPIException;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.mgmtservice.common.MSTrapData;
import com.sun.symon.base.mgmtservice.scm.manager.SCMBaseHandler;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceConstants;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceImpl;
import com.sun.symon.base.server.types.StInteger;
import com.sun.symon.base.server.types.StObject;
import java.net.InetAddress;

public class SCMModuleHandler
extends SCMBaseHandler
implements SCMServiceConstants {
    private static final String CONFIRM_URL = "/mod/scm-container/Admin/trapAck#0";
    private static final String CONFIRM_VALUE = "8";
    private SCMServiceImpl service = null;
    private SMRawDataRequest request = null;

    public void emitOperation(SCMServiceImpl sCMServiceImpl, MSTrapData mSTrapData) {
        String string = null;
        try {
            string = InetAddress.getByName(mSTrapData.getSourceIp()).getHostName();
        }
        catch (Exception exception) {
            string = mSTrapData.getSourceIp();
        }
        int n = mSTrapData.getPort();
        try {
            this.updateDatabase(sCMServiceImpl, string, n);
        }
        catch (Exception exception) {
            SCMBaseHandler.logWriter.println("Error in handling scm module loaded trap.-- " + exception.getMessage());
            return;
        }
        this.confirmAgent(sCMServiceImpl, string, n);
    }

    private void updateDatabase(SCMServiceImpl sCMServiceImpl, String string, int n) throws SCMAPIException, SMAPIException {
        try {
            Thread.sleep(30000L);
        }
        catch (Exception exception) {
            SCMBaseHandler.logWriter.println((Throwable)exception);
        }
        boolean bl = this.updateSystem(sCMServiceImpl, string, n);
        if (bl) {
            this.createSunMCEntity(sCMServiceImpl, string, n);
        }
        this.updateResourcePools(sCMServiceImpl, string, n);
        this.updateZones(sCMServiceImpl, string, n);
        this.updateContainers(sCMServiceImpl, string, n);
    }

    private void confirmAgent(SCMServiceImpl sCMServiceImpl, String string, int n) {
        String[] stringArray = new String[]{"snmp://" + string + ":" + n + CONFIRM_URL};
        SCMBaseHandler.logWriter.println("confirm host (" + string + "): " + stringArray[0]);
        StObject[][] stObjectArray = new StObject[1][1];
        stObjectArray[0][0] = new StInteger(CONFIRM_VALUE);
        try {
            StObject[][] stObjectArray2 = sCMServiceImpl.getRawDataRequest().getURLValue(stringArray);
            SCMBaseHandler.logWriter.println("before confirm : " + stObjectArray2[0][0].toString());
            sCMServiceImpl.getRawDataRequest().setURLValue(stringArray, stObjectArray);
            stObjectArray2 = sCMServiceImpl.getRawDataRequest().getURLValue(stringArray);
            SCMBaseHandler.logWriter.println("after confirm host (" + string + "): done: " + stObjectArray2[0][0].toString());
        }
        catch (SMAPIException sMAPIException) {
            SCMBaseHandler.logWriter.println("confirm host (" + string + ") failed.");
        }
    }

    private void createSunMCEntity(SCMServiceImpl sCMServiceImpl, String string, int n) throws SCMAPIException {
        SMUserDomainData sMUserDomainData = null;
        try {
            sMUserDomainData = sCMServiceImpl.createSCMDomain();
        }
        catch (Exception exception) {
            this.handleErrors("Create SCM domain failed: " + exception.getMessage());
        }
        if (sMUserDomainData == null) {
            SCMBaseHandler.logWriter.println("DEBUG: create domain failed: ");
            this.handleErrors("Create SCM domain failed: ");
        }
        try {
            if (sCMServiceImpl.isHostInDomain(string, n)) {
                SCMBaseHandler.logWriter.println(string + " is already in hidden domain");
                return;
            }
            SCMBaseHandler.logWriter.println("Create host in SCM domain: " + string);
            InetAddress inetAddress = InetAddress.getByName(string);
            String string2 = inetAddress.getHostAddress();
            String string3 = sMUserDomainData.getDomainRootUrl();
            SMRawDataRequest sMRawDataRequest = sCMServiceImpl.getRawDataRequest();
            SMTopologyRequest sMTopologyRequest = new SMTopologyRequest(sMRawDataRequest);
            SMManagedEntityRequest sMManagedEntityRequest = new SMManagedEntityRequest(sMRawDataRequest);
            String string4 = sMManagedEntityRequest.getAgentRootUrl(string, n);
            String string5 = string;
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "ahost";
            boolean bl = true;
            String string12 = "";
            String string13 = "";
            SCMBaseHandler.logWriter.println("Create host in under parent: " + string3);
            sMTopologyRequest.createEntity(string3, string, "", string, string2, "", "", null, string13, "", bl, string11, string9, string10, string7, string8, string4);
        }
        catch (Exception exception) {
            this.handleErrors("Error in create entity: " + exception.getMessage());
        }
    }
}

