/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager;

import com.sun.symon.base.client.scm.manager.SCMIPQSInfo;
import com.sun.symon.base.client.scm.manager.SCMZone;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.scm.manager.SCMDB;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;

public class SCMZoneManager
extends SCMDB {
    public static final String SP_GET_ZONES_BY_HOST = "{call sp_get_zones_by_hostid(?, ?)}";
    public static final int SP_GET_ZONES_BY_HOST_HID = 1;
    public static final int SP_GET_ZONES_BY_HOST_CSR = 2;
    public static final String SP_GET_ZONES_BY_POOL = "{call sp_get_zones_by_poolid(?, ?)}";
    public static final int SP_GET_ZONES_BY_POOL_PID = 1;
    public static final int SP_GET_ZONES_BY_POOL_CSR = 2;
    static final int SP_SAVE_SCM_ZONE_ID = 1;
    static final int SP_SAVE_SCM_ZONE_NAME = 2;
    static final int SP_SAVE_SCM_ZONE_STATE = 3;
    static final int SP_SAVE_SCM_IS_GLOBAL = 4;
    static final int SP_SAVE_SCM_ZONE_PATH = 5;
    static final int SP_SAVE_SCM_NETWORK_IP = 6;
    static final int SP_SAVE_SCM_NETWORK_NAME = 7;
    static final int SP_SAVE_SCM_POOL_ID = 8;
    static final int SP_SAVE_SCM_CPU_SHARES = 9;
    static final int SP_SAVE_SCM_MEMORY_CAP = 10;
    static final int SP_SAVE_SCM_IPQS_ENABLE = 11;
    static final int SP_SAVE_SCM_ZONE_INPUT__BANDWIDTH = 12;
    static final int SP_SAVE_SCM_ZONE_OUTPUT_BANDWIDTH = 13;
    static final int SP_SAVE_SCM_AUTOBOOT = 14;
    static final int SP_SAVE_SCM_ZONE_HOSTNAME = 15;
    static final int SP_SAVE_SCM_MAX_CPU_SHARES = 16;
    static final String SP_SAVE_SCM_ZONE = "{call sp_save_scm_zone(" + SCMDB.createParamString(16) + ")}";
    public static final String SP_DELETE_ZONE = "{call sp_delete_scm_zone(?)}";
    public static final int SP_DELETE_ZONE_ZID = 1;
    public static final String SP_GET_ZONE_BY_ZID_DEF = "{call sp_get_zone_by_id(?,?)}";
    public static final int SP_GET_ZONE_BY_ZID = 1;
    public static final int SP_GET_ZONE_BY_ZID_CSR = 2;
    public static final String AGENT_ZONE_MIB_URI = "scm-container/Zones/ZoneTable/ZoneEntry/";
    public static final String AGENT_ZONE_MIB_URL = "/mod/scm-container/Zones/ZoneTable/ZoneEntry/";
    public static final String[] SYNC_AGENT_ZONE_MIB_COLUMNS = new String[]{"zoneName", "zonePath", "zonePhysicalAddr", "zoneIPAddr", "zoneHostName", "cpuRes", "maxZoneCPUShares", "zoneState", "poolName", "ipqosEnabled", "ipBandWidth", "opBandWidth", "zoneAutoBoot", "extraZoneAttr"};
    public static final String ZONETABLE = "scm-container/Zones/ZoneTable/ZoneEntry";

    public static long persistZone(SCMZone sCMZone) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        if (connection == null) {
            return -1L;
        }
        long l = -1L;
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall(SP_SAVE_SCM_ZONE);
                callableStatement.registerOutParameter(1, 2);
                SCMDB.setNullable(callableStatement, 1, sCMZone.getID());
                callableStatement.setString(2, sCMZone.getZoneName());
                String string = SCMZoneManager.zoneState2DBState(sCMZone.getState());
                callableStatement.setString(3, string);
                String string2 = sCMZone.isGlobal() ? "T" : "F";
                callableStatement.setString(4, string2);
                callableStatement.setString(5, sCMZone.getZonePath());
                callableStatement.setString(6, sCMZone.getZoneIP());
                callableStatement.setString(7, sCMZone.getNetworkInterface());
                callableStatement.setLong(8, sCMZone.getPoolID());
                callableStatement.setLong(9, sCMZone.getCPUShare());
                callableStatement.setLong(16, sCMZone.getMaxCPUShares());
                callableStatement.setFloat(10, (float)sCMZone.getMemoryCAP());
                String string3 = sCMZone.getIPQSInfo().isIPQSEnabled() ? "T" : "F";
                callableStatement.setString(11, string3);
                callableStatement.setFloat(12, sCMZone.getIPQSInfo().getMaxInputBandWidth());
                callableStatement.setFloat(13, sCMZone.getIPQSInfo().getMaxOutputBandWidth());
                callableStatement.setFloat(12, sCMZone.getIPQSInfo().getMaxInputBandWidth());
                String string4 = sCMZone.isAutoboot() ? "T" : "F";
                callableStatement.setString(14, string4);
                callableStatement.setString(15, sCMZone.getZoneHostName());
                callableStatement.execute();
                l = callableStatement.getLong(1);
                SCMDB.closeCall(callableStatement);
                connection.commit();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(SCMDB.logWriter);
                MSDB.rollback((Connection)connection);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static SCMZone[] getZonesByHost(long l) throws SMDatabaseException {
        Object[] objectArray;
        Connection connection = MSDB.getConnection();
        try {
            Object[] objectArray2;
            CallableStatement callableStatement = connection.prepareCall(SP_GET_ZONES_BY_HOST);
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
            Vector<Object[]> vector = new Vector<Object[]>();
            while (oracleResultSet.next()) {
                objectArray2 = SCMZoneManager.createZoneFromDBData((ResultSet)oracleResultSet);
                vector.addElement(objectArray2);
            }
            SCMDB.closeCall(callableStatement);
            objectArray2 = new SCMZone[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var9_8 = null;
        }
        catch (SQLException sQLException) {
            try {
                SCMDB.logWriter.println("getZonesByHost: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public static SCMZone[] getZonesByPool(long l) throws SMDatabaseException {
        Object[] objectArray;
        Connection connection = MSDB.getConnection();
        try {
            Object[] objectArray2;
            CallableStatement callableStatement = connection.prepareCall(SP_GET_ZONES_BY_POOL);
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
            Vector<Object[]> vector = new Vector<Object[]>();
            while (oracleResultSet.next()) {
                objectArray2 = SCMZoneManager.createZoneFromDBData((ResultSet)oracleResultSet);
                vector.addElement(objectArray2);
            }
            SCMDB.closeCall(callableStatement);
            objectArray2 = new SCMZone[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var9_8 = null;
        }
        catch (SQLException sQLException) {
            try {
                SCMDB.logWriter.println("getZonesByPool: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public static final SCMZone getZoneByID(long l) throws SMDatabaseException {
        CallableStatement callableStatement;
        Connection connection;
        block6: {
            connection = MSDB.getConnection();
            callableStatement = null;
            callableStatement = connection.prepareCall(SP_GET_ZONE_BY_ZID_DEF);
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            ResultSet resultSet = (ResultSet)callableStatement.getObject(2);
            if (!resultSet.next()) break block6;
            SCMZone sCMZone = SCMZoneManager.createZoneFromDBData(resultSet);
            if (resultSet.next()) {
                throw new SMDatabaseException("Can't have more than one Zone with the same zone ID:" + l);
            }
            SCMZone sCMZone2 = sCMZone;
            Object var8_7 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            return sCMZone2;
        }
        try {
            try {
                throw new SMDatabaseException("No Zone Found with ID:" + l);
            }
            catch (SQLException sQLException) {
                SCMDB.logWriter.println("getZonesByID: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    private static SCMZone createZoneFromDBData(ResultSet resultSet) throws SQLException {
        return new SCMZone(resultSet.getLong("zone_id"), resultSet.getString("zone_name"), resultSet.getString("zone_path"), resultSet.getString("autoboot").equals("T"), resultSet.getString("network_name"), resultSet.getString("network_ip"), resultSet.getString("zone_hostname"), resultSet.getLong("cpu_shares"), resultSet.getLong("max_cpushares"), resultSet.getLong("avl_cpushares"), resultSet.getLong("memory_cap"), new SCMIPQSInfo(resultSet.getFloat("ip_bandwidth"), resultSet.getFloat("op_bandwidth"), "T".equals(resultSet.getString("ipqos_enabled"))), resultSet.getString("zone_state"), resultSet.getString("is_global").equals("true"), resultSet.getLong("pool_id"), resultSet.getString("resource_pool_name"), resultSet.getLong("host_id"), resultSet.getString("host_name"), null);
    }

    public static void deleteZone(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall(SP_DELETE_ZONE);
                callableStatement.setLong(1, l);
                callableStatement.execute();
                connection.commit();
            }
            catch (SQLException sQLException) {
                SCMDB.logWriter.println("getZonesByID: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    private static String zoneState2DBState(String string) {
        if (string == null) {
            return "0";
        }
        if (string.equals(SCMZone.INSTALLED)) {
            return "0";
        }
        if (string.equals(SCMZone.RUNNING)) {
            return "1";
        }
        if (string.equals(SCMZone.READY)) {
            return "2";
        }
        if (string.equals(SCMZone.HALT)) {
            return "3";
        }
        if (string.equals(SCMZone.INCOMPLETE)) {
            return "4";
        }
        if (string.equals(SCMZone.UNINSTALL)) {
            return "5";
        }
        if (string.equals(SCMZone.REBOOT)) {
            return "6";
        }
        if (string.equals(SCMZone.CONFIGURED)) {
            return "7";
        }
        if (string.equals(SCMZone.BOOT)) {
            return "8";
        }
        if (string.equals(SCMZone.DELETING)) {
            return "9";
        }
        return "0";
    }
}

