/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.scm.common.SCMAPIException;
import com.sun.symon.base.client.scm.manager.SCMContainer;
import com.sun.symon.base.client.scm.manager.SCMContainerMaster;
import com.sun.symon.base.client.scm.manager.SCMHost;
import com.sun.symon.base.client.scm.manager.SCMIPQSInfo;
import com.sun.symon.base.client.scm.manager.SCMProject;
import com.sun.symon.base.client.scm.manager.SCMResourcePool;
import com.sun.symon.base.client.scm.manager.SCMZone;
import com.sun.symon.base.mgmtservice.scm.manager.SCMResourcePoolManager;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceImpl;
import com.sun.symon.base.mgmtservice.scm.manager.SCMZoneManager;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcListUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class SCMSynchronizer {
    private static PrintWriter logWriter = SCMServiceController.getInstance().getLogWriter();
    private static SCMSynchronizer instance = new SCMSynchronizer();
    protected static final String SYSTEM_NODE = "/mod/scm-container/System/Configuration/";
    protected static final String[] systemTable = new String[]{"hostName", "operatingSystem", "platform", "memory", "cpus", "cpuClockFrequency"};
    protected static final String CONTAINER_URL_PREFIX = "/mod/scm-container/Containers/ContTable/ContEntry/";
    protected static final String[] containerFields = new String[]{"contID", "contName", "projectID", "projectName", "primaryUsers", "poolName", "cpuRes", "cpuUsage", "memCap", "memVirtual", "memRSS", "users", "groups", "maxSHMMemory", "defaultContainer"};
    private final String SOLARIS_10 = "5.10";
    private static final SCMResourcePool[] emptySCMResourcePool = new SCMResourcePool[0];
    private static final SCMZone[] emptyZoneArray = new SCMZone[0];

    public static SCMSynchronizer getInstance() {
        return instance;
    }

    private SCMSynchronizer() {
    }

    public synchronized boolean updateSystem(SCMServiceImpl sCMServiceImpl, String string, int n) throws SCMAPIException {
        boolean bl;
        block13: {
            String string2 = "snmp://" + string + ":" + n + SYSTEM_NODE;
            int n2 = systemTable.length;
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = string2 + systemTable[n3] + "#0";
                ++n3;
            }
            SMRawDataRequest sMRawDataRequest = sCMServiceImpl.getRawDataRequest();
            StObject[][] stObjectArray = null;
            try {
                stObjectArray = sMRawDataRequest.getURLValue(stringArray);
            }
            catch (SMAPIException sMAPIException) {
                SCMSynchronizer.handleErrors("Error in getting system information on host " + string + " -- ", (Exception)((Object)sMAPIException));
            }
            if (stObjectArray == null || stObjectArray.length < n2) {
                SCMSynchronizer.handleErrors("Error in getting system information on host " + string);
            }
            String string3 = stObjectArray[0][0].toString();
            String string4 = stObjectArray[1][0].toString();
            String string5 = stObjectArray[2][0].toString();
            int n4 = this.toInt(stObjectArray[3][0].toString(), 0);
            int n5 = this.toInt(stObjectArray[4][0].toString(), 0);
            int n6 = this.toInt(stObjectArray[5][0].toString(), 0);
            bl = false;
            SCMHost sCMHost = null;
            try {
                long l = sCMServiceImpl.getHostID(string);
                if (l > 0L) {
                    sCMHost = sCMServiceImpl.getHost(l);
                }
            }
            catch (Exception exception) {
                SCMSynchronizer.handleErrors("Get host in db failed: " + exception.getMessage(), exception, false);
            }
            if (sCMHost != null) {
                if (!string4.equals(sCMHost.getVersion()) || !string5.equals(sCMHost.getPlatform()) || n4 != sCMHost.getMemory() || n5 != sCMHost.getProcessors() || n6 != sCMHost.getFrequency()) {
                    sCMHost.setVersion(string4);
                    sCMHost.setPlatform(string5);
                    sCMHost.setMemory(n4);
                    sCMHost.setProcessors(n5);
                    sCMHost.setFrequency(n6);
                } else {
                    sCMHost = null;
                }
            } else {
                sCMHost = new SCMHost(0L, string, n, string4, string5, n5, n4, n6);
                bl = true;
            }
            if (sCMHost == null) break block13;
            try {
                sCMServiceImpl.saveHost(sCMHost);
            }
            catch (Exception exception) {
                SCMSynchronizer.handleErrors("Error in adding system information on host " + string + " into database.--", exception);
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public synchronized SCMContainer[] updateContainers(SCMServiceImpl var1_1, String var2_2, int var3_3) throws SCMAPIException, SMAPIException {
        block60: {
            block59: {
                var4_4 = this.is10Module(var2_2, var3_3);
                var5_5 = this.retrieveContainersFromAgent(var1_1, var2_2, var3_3, var4_4);
                var6_6 = var5_5[0];
                var7_7 = var5_5[1];
                var8_8 = var5_5[2];
                var9_9 = var5_5[3];
                var10_10 = var5_5[4];
                var11_11 = var5_5[5];
                var12_12 = var5_5[6];
                var13_13 = var5_5[7];
                var14_14 = var5_5[8];
                var15_15 = var5_5[9];
                var16_16 = var5_5[10];
                var17_17 = var5_5[11];
                var18_18 = var5_5[12];
                var19_19 = var5_5[13];
                var20_20 = var5_5[14];
                var21_21 = this.retriveZoneNames(var5_5, var17_17);
                var22_22 = 0L;
                try {
                    var22_22 = var1_1.getHostID(var2_2);
                }
                catch (Exception var24_23) {
                    SCMSynchronizer.handleErrors("Update Containers failed, host not in DB: " + var2_2, var24_23);
                }
                var24_24 = this.retrieveContainersInDB(var1_1, var22_22);
                var25_25 = this.retrieveResourcePoolsFromDB(var1_1, var22_22);
                var26_26 = this.retrieveZonesFromDB(var1_1, var22_22);
                var27_27 = new Vector<Integer>();
                var28_28 = new Vector<Object>();
                var29_29 = new Vector<String>();
                var30_30 = new Vector<String>();
                var31_31 = new Vector<Object>();
                if (!var24_24.isEmpty()) break block59;
                var32_32 = 0;
                while (var32_32 < var6_6.size()) {
                    var27_27.addElement(new Integer(var32_32));
                    ++var32_32;
                }
                break block60;
            }
            var32_32 = 0;
            while (var32_32 < var8_8.size()) {
                block62: {
                    block61: {
                        var33_36 = (SCMContainerMaster[])var8_8.elementAt(var32_32);
                        var34_38 = (String)var21_21.elementAt(var32_32);
                        var35_44 = var34_38 + "," + (String)var33_36;
                        var36_46 = (SCMContainer)var24_24.remove(var35_44);
                        if (var36_46 != null) break block61;
                        var27_27.addElement(new Integer(var32_32));
                        break block62;
                    }
                    var37_48 = (String)var6_6.elementAt(var32_32);
                    var38_51 = (String)var9_9.elementAt(var32_32);
                    var39_53 = var36_46.getContainerID();
                    if (var37_48 != null && var37_48.trim().length() != 0 && this.toLong(var37_48, 0L) == var39_53) ** GOTO lbl69
                    var41_55 = null;
                    try {
                        var41_55 = var1_1.getProject(this.toLong((String)var33_36, 0L));
                    }
                    catch (Exception var42_56) {
                        SCMSynchronizer.handleErrors("Error in getting project : " + (String)var33_36, var42_56, false);
                        var41_55 = null;
                    }
                    if (var41_55 != null && !var38_51.equals(var41_55.getProjectName())) {
                        SCMSynchronizer.handleErrors("project name conflict: " + var38_51, null, false);
                    } else {
                        var42_57 /* !! */  = var4_4 != false ? var33_36 : var34_38 + "," + (String)var33_36;
                        var28_28.addElement(var42_57 /* !! */ );
                        var29_29.addElement(new String("" + var39_53));
                        var30_30.addElement(var36_46.getContainerName());
lbl69:
                        // 2 sources

                        if ((var41_55 = (String)var11_11.elementAt(var32_32)) == null || var41_55.trim().length() == 0) {
                            var41_55 = "pool_default";
                        }
                        var42_58 = this.toInt((String)var14_14.elementAt(var32_32), 0);
                        var43_60 = this.toLong((String)var19_19.elementAt(var32_32), 0L);
                        var45_61 = this.toLong((String)var12_12.elementAt(var32_32), 0L);
                        var47_64 = (SCMResourcePool)var25_25.get(var41_55);
                        if (var47_64 == null) {
                            SCMSynchronizer.handleErrors("Resource is missed: " + var36_46.getResourceID(), null, false);
                        } else {
                            var48_67 = false;
                            if (!var41_55.equals(var36_46.getResourceName())) {
                                var36_46.setResourceName((String)var41_55);
                                var36_46.setResourceID(var47_64.getResourcePoolID());
                                var48_67 = true;
                            }
                            if (var42_58 != var36_46.getMemory()) {
                                var36_46.setMemory(var42_58);
                                var48_67 = true;
                            }
                            if (var43_60 != var36_46.getMaxSHMemory()) {
                                var36_46.setMaxSHMemory(var43_60);
                                var48_67 = true;
                            }
                            if (var45_61 != var36_46.getCPUShares()) {
                                var36_46.setCPUShares(var45_61);
                                var48_67 = true;
                            }
                            if (!var36_46.getStatus()) {
                                var36_46.setStatus(true);
                                var48_67 = true;
                            }
                            if (var48_67) {
                                try {
                                    SCMSynchronizer.logWriter.println("Update container in DB: " + var36_46.toString());
                                    var1_1.saveContainerInDB((SCMContainer)var36_46);
                                }
                                catch (Exception var49_70) {
                                    SCMSynchronizer.handleErrors("Error in finding container", var49_70, false);
                                }
                            }
                            var36_46.setCPUUsage((String)var13_13.elementAt(var32_32));
                            var36_46.setMemVirtual((String)var15_15.elementAt(var32_32));
                            var36_46.setMemRSS((String)var16_16.elementAt(var32_32));
                            var31_31.addElement(var36_46);
                        }
                    }
                }
                ++var32_32;
            }
        }
        if (!var24_24.isEmpty()) {
            var32_33 = var24_24.elements();
            while (var32_33.hasMoreElements()) {
                var33_36 = (SCMContainer)var32_33.nextElement();
                SCMSynchronizer.logWriter.println("Container <" + var33_36.getContainerName() + "> has been deactivated");
                if (!var33_36.getStatus()) continue;
                var33_36.setStatus(false);
                try {
                    var1_1.saveContainerInDB((SCMContainer)var33_36);
                }
                catch (Exception var34_39) {
                    SCMSynchronizer.handleErrors("Error in deactivating container", var34_39, false);
                }
            }
        }
        if (var27_27.size() > 0) {
            var32_34 = new Hashtable<String, SCMContainerMaster>();
            try {
                var33_36 = var1_1.getContainerMasters();
                var34_40 = 0;
                while (var34_40 < ((SCMContainerMaster[])var33_36).length) {
                    var32_34.put(var33_36[var34_40].getMasterName(), var33_36[var34_40]);
                    ++var34_40;
                }
            }
            catch (Exception var33_37) {
                SCMSynchronizer.handleErrors("Error in getting container masters: " + var33_37.getMessage());
            }
            var33_36 = null;
            var35_45 = 0;
            while (var35_45 < var27_27.size()) {
                block58: {
                    var36_46 = (Integer)var27_27.elementAt(var35_45);
                    var37_49 = var36_46.intValue();
                    var38_51 = (String)var8_8.elementAt(var37_49);
                    var39_54 = (String)var20_20.elementAt(var37_49);
                    var34_41 = var39_54.equals("1");
                    var40_73 = (String)var9_9.elementAt(var37_49);
                    var41_55 = (String)var21_21.elementAt(var37_49);
                    var42_59 = this.toLong(var38_51, 0L);
                    try {
                        var33_36 = var1_1.getProject(var42_59);
                    }
                    catch (Exception var44_75) {
                        var33_36 = null;
                    }
                    if (var33_36 == null) {
                        var44_74 = "A";
                        if (var40_73.startsWith("user.")) {
                            var44_74 = "U";
                        } else if (var40_73.startsWith("group.")) {
                            var44_74 = "G";
                        }
                        var33_36 = new SCMProject(var42_59, var40_73, var44_74, "", (String)var10_10.elementAt(var37_49), "", (String)var17_17.elementAt(var37_49), (String)var18_18.elementAt(var37_49));
                        SCMSynchronizer.logWriter.println("save project: " + var33_36.toString());
                        try {
                            var1_1.addSystemProject(var33_36);
                            break block57;
                        }
                        catch (Exception var45_62) {
                            SCMSynchronizer.logWriter.println("save project failed: " + var40_73);
                            break block58;
                        }
                    }
                    if (!var40_73.equals(var33_36.getProjectName())) {
                        SCMSynchronizer.handleErrors("project name conflict: " + var40_73, null, false);
                    } else {
                        block57: {
                            SCMSynchronizer.logWriter.println("project <" + var40_73 + "> exists");
                        }
                        var44_74 = (String)var7_7.elementAt(var37_49);
                        if (var44_74 == null || var44_74.trim().length() == 0) {
                            var44_74 = var40_73;
                        }
                        var45_63 = new String(var44_74 + " [" + var2_2 + "." + (String)var41_55 + "]");
                        var46_76 = (SCMContainerMaster)var32_34.get(var44_74);
                        if (var46_76 != null && var46_76.getProjectID() != var33_36.getProjectID()) {
                            SCMSynchronizer.logWriter.println("Container master: " + var44_74 + " is used, use name: " + var45_63 + " as container's name");
                            var44_74 = var45_63;
                            var46_76 = null;
                        }
                        if (var46_76 == null && (var46_76 = (SCMContainerMaster)var32_34.get(var45_63)) != null && var46_76.getProjectID() != var33_36.getProjectID()) {
                            SCMSynchronizer.logWriter.println("Error: container master: " + var44_74 + " is defined in " + var2_2);
                        } else {
                            if (var46_76 == null) {
                                var46_76 = new SCMContainerMaster(0L, var44_74, var33_36.getProjectID(), var45_63);
                                SCMSynchronizer.logWriter.println("create a new cont master : " + var44_74);
                                try {
                                    var47_65 = var1_1.addContainerMaster(var46_76, 0L);
                                    var46_76.setMasterID(var47_65);
                                    var32_34.put(var44_74, var46_76);
                                }
                                catch (Exception var47_66) {
                                    SCMSynchronizer.handleErrors("Error in saving container master: " + var47_66.getMessage(), var47_66, false);
                                    break block58;
                                }
                            }
                            if ((var47_64 = (String)var11_11.elementAt(var37_49)) == null || var47_64.length() == 0) {
                                var47_64 = "pool_default";
                            }
                            if ((var48_69 = (SCMResourcePool)var25_25.get(var47_64)) == null) {
                                var49_71 = "Error in creating container, resource pool dose not exist";
                                SCMSynchronizer.handleErrors(var49_71, null, false);
                            } else {
                                var49_72 = this.toLong((String)var12_12.elementAt(var37_49), 0L);
                                var51_77 = this.toInt((String)var14_14.elementAt(var37_49), 0);
                                var52_78 = this.toLong((String)var19_19.elementAt(var37_49), 0L);
                                var54_79 = -1L;
                                try {
                                    var54_79 = ((SCMZone)var26_26.get(var41_55)).getID();
                                }
                                catch (Exception var56_81) {
                                    var56_81.printStackTrace(SCMSynchronizer.logWriter);
                                }
                                var56_80 = SCMSynchronizer.createContainer(var46_76, var48_69, var49_72, var51_77, var52_78, var34_41, var54_79);
                                var56_80.setStatus(true);
                                var57_82 = 0L;
                                try {
                                    SCMSynchronizer.logWriter.println("Save a new Container: " + var56_80.toString());
                                    var57_82 = var1_1.saveContainerInDB(var56_80);
                                }
                                catch (Exception var59_84) {
                                    SCMSynchronizer.handleErrors("Error in saving container: " + var59_84.getMessage(), var59_84, false);
                                    break block58;
                                }
                                if (var57_82 > 0L) {
                                    var59_83 = var4_4 != false ? var38_51 : (String)var41_55 + "," + var38_51;
                                    var28_28.addElement(new String(var59_83));
                                    var29_29.addElement(new String("" + var57_82));
                                    var30_30.addElement(var46_76.getMasterName());
                                }
                                var56_80.setCPUUsage((String)var13_13.elementAt(var37_49));
                                var56_80.setMemVirtual((String)var15_15.elementAt(var37_49));
                                var56_80.setMemRSS((String)var16_16.elementAt(var37_49));
                                var31_31.addElement(var56_80);
                            }
                        }
                    }
                }
                ++var35_45;
            }
        }
        var32_35 = "snmp://" + var2_2 + ":" + var3_3 + "/mod/scm-container/Containers/ContTable/ContEntry/" + "contID";
        var33_36 = "snmp://" + var2_2 + ":" + var3_3 + "/mod/scm-container/Containers/ContTable/ContEntry/" + "contName";
        if (var28_28.size() > 0) {
            var34_42 = new String[var28_28.size() * 2];
            var35_44 = new StObject[var28_28.size() * 2][1];
            var36_47 = 0;
            var37_50 = 0;
            while (var37_50 < var28_28.size()) {
                var34_42[var36_47] = SMRawDataRequest.buildShadowURL((String)var32_35, null, (String)((String)var28_28.elementAt(var37_50)));
                var35_44[var36_47][0] = new StString((String)var29_29.elementAt(var37_50));
                var34_42[++var36_47] = SMRawDataRequest.buildShadowURL((String)var33_36, null, (String)((String)var28_28.elementAt(var37_50)));
                var35_44[var36_47][0] = new StString((String)var30_30.elementAt(var37_50));
                ++var36_47;
                ++var37_50;
            }
            try {
                var1_1.getRawDataRequest().setURLValue(var34_42, var35_44);
            }
            catch (SMAPIException var38_52) {
                SCMSynchronizer.handleErrors("Error in setting container id: " + var38_52.getMessage());
            }
        }
        var34_43 = new SCMContainer[var31_31.size()];
        var31_31.toArray(var34_43);
        return var34_43;
    }

    private Vector retriveZoneNames(Vector[] vectorArray, Vector vector) {
        Vector vector2 = new Vector();
        if (vectorArray.length == 16) {
            vector2 = vectorArray[15];
        } else {
            int n = 0;
            while (n < vector.size()) {
                vector2.add("global");
                ++n;
            }
        }
        return vector2;
    }

    private void printContainerInfo(Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, Vector vector7, Vector vector8, Vector vector9, Vector vector10, Vector vector11, Vector vector12) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector2.elementAt(n);
            String string2 = (String)vector3.elementAt(n);
            boolean bl = string2.equals("1");
            logWriter.println("cont: " + (String)vector.elementAt(n) + ", " + (String)vector4.elementAt(n) + ", " + (String)vector5.elementAt(n) + ", " + (String)vector6.elementAt(n) + ", " + (String)vector2.elementAt(n) + ", " + (String)vector7.elementAt(n) + ", " + (String)vector8.elementAt(n) + ", " + (String)vector9.elementAt(n) + ", " + (String)vector10.elementAt(n) + ", " + (String)vector11.elementAt(n) + ", " + (String)vector12.elementAt(n) + ", " + bl);
            ++n;
        }
    }

    private static SCMContainer createContainer(SCMContainerMaster sCMContainerMaster, SCMResourcePool sCMResourcePool, long l, int n, long l2, boolean bl, long l3) {
        SCMContainer sCMContainer = new SCMContainer(0L, sCMContainerMaster, sCMResourcePool.getResourcePoolID(), l, n, l2, bl);
        sCMContainer.setZoneID(l3);
        return sCMContainer;
    }

    public synchronized void updateResourcePools(SCMServiceImpl sCMServiceImpl, String string, int n) throws SCMAPIException {
        try {
            SCMResourcePool sCMResourcePool;
            long l = sCMServiceImpl.getHostID(string);
            SCMHost sCMHost = sCMServiceImpl.getHost(l);
            SCMResourcePool[] sCMResourcePoolArray = this.retrieveResourcePoolsFromAgent(sCMServiceImpl, sCMHost, n);
            Hashtable hashtable = this.retrieveResourcePoolsFromDB(sCMServiceImpl, l);
            int n2 = 0;
            while (n2 < sCMResourcePoolArray.length) {
                sCMResourcePool = (SCMResourcePool)hashtable.remove(sCMResourcePoolArray[n2].getResourcePoolName());
                try {
                    if (sCMResourcePool == null) {
                        logWriter.println("New ResourcePool found: " + sCMResourcePoolArray[n2].getResourcePoolName());
                        sCMServiceImpl.saveResourcePool(sCMResourcePoolArray[n2], true);
                    } else if (SCMResourcePool.copyAgentPool2DBPool((SCMResourcePool)sCMResourcePoolArray[n2], (SCMResourcePool)sCMResourcePool)) {
                        logWriter.println("ResourcePool is being updated in DB: " + sCMResourcePoolArray[n2].getResourcePoolName());
                        sCMServiceImpl.saveResourcePool(sCMResourcePool, true);
                    }
                }
                catch (Exception exception) {
                    SCMSynchronizer.handleErrors("Error in saving resource pool: " + exception.getMessage(), exception, false);
                }
                ++n2;
            }
            sCMResourcePool = hashtable.elements();
            while (sCMResourcePool.hasMoreElements()) {
                logWriter.println("Some changes in resource pool: need to delete these from DB");
                try {
                    SCMResourcePool sCMResourcePool2 = (SCMResourcePool)sCMResourcePool.nextElement();
                    logWriter.println("Delete resource pool from DB: " + sCMResourcePool2.getResourcePoolName());
                    sCMServiceImpl.deleteResourcePool(sCMResourcePool2, true);
                }
                catch (Exception exception) {
                    SCMSynchronizer.handleErrors("Error in saving resource pool", exception);
                }
            }
        }
        catch (Exception exception) {
            SCMSynchronizer.handleErrors("Error in syncing of resource pool for host: " + string, exception);
        }
    }

    private SCMResourcePool[] retrieveResourcePoolsFromAgent(SCMServiceImpl sCMServiceImpl, SCMHost sCMHost, int n) throws SCMAPIException {
        String string = sCMHost.getHostName();
        String string2 = "snmp://" + string + ":" + n + "/mod/scm-container/Pools/PoolTable/PoolEntry/";
        int n2 = SCMResourcePoolManager.SYNC_AGENT_RESOURCE_POOL_MIB_COLUMNS.length;
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = string2 + SCMResourcePoolManager.SYNC_AGENT_RESOURCE_POOL_MIB_COLUMNS[n3];
            ++n3;
        }
        SMRawDataRequest sMRawDataRequest = sCMServiceImpl.getRawDataRequest();
        try {
            StObject[][] stObjectArray = sMRawDataRequest.getURLValue(stringArray);
            if (stObjectArray == null || stObjectArray.length < n2) {
                SCMSynchronizer.handleErrors("Error in getting resource pool information on host " + string);
            }
            Vector[] vectorArray = SCMSynchronizer.decryptData(stObjectArray, SCMResourcePoolManager.SYNC_AGENT_RESOURCE_POOL_MIB_COLUMNS, string);
            long l = sCMHost.getHostID();
            ArrayList<SCMResourcePool> arrayList = new ArrayList<SCMResourcePool>();
            int n4 = 0;
            while (n4 < vectorArray[0].size()) {
                try {
                    arrayList.add(SCMResourcePool.createResourcePoolWithAgentData((String)vectorArray[0].get(n4).toString(), (String)vectorArray[1].get(n4).toString(), (long)Long.parseLong(vectorArray[2].get(n4).toString()), (long)Long.parseLong(vectorArray[3].get(n4).toString()), (long)Long.parseLong(vectorArray[4].get(n4).toString()), (String)vectorArray[5].get(n4).toString(), (long)-3000L, (vectorArray[6].get(n4).toString().equals("1") ? 1 : 0) != 0, (long)l, (String)string));
                }
                catch (Throwable throwable) {
                    logWriter.println("Skipping the sync up of the resource pool " + vectorArray[0].get(n4) + " due to exception:");
                    throwable.printStackTrace(logWriter);
                }
                ++n4;
            }
            return arrayList.toArray(emptySCMResourcePool);
        }
        catch (SMAPIException sMAPIException) {
            SCMSynchronizer.handleErrors("Error in getting resource pool information on host " + string + ", ", (Exception)((Object)sMAPIException));
            return emptySCMResourcePool;
        }
    }

    private Hashtable retrieveResourcePoolsFromDB(SCMServiceImpl sCMServiceImpl, long l) throws SCMAPIException {
        Hashtable<String, SCMResourcePool> hashtable = new Hashtable<String, SCMResourcePool>();
        try {
            SCMResourcePool[] sCMResourcePoolArray = SCMResourcePoolManager.getResourcePools(l);
            int n = 0;
            while (n < sCMResourcePoolArray.length) {
                hashtable.put(sCMResourcePoolArray[n].getResourcePoolName(), sCMResourcePoolArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            String string = "Error in getting resource pools for host:  ";
            SCMSynchronizer.handleErrors(string, exception);
        }
        return hashtable;
    }

    public synchronized void updateZones(SCMServiceImpl sCMServiceImpl, String string, int n) throws SCMAPIException {
        try {
            SCMZone sCMZone;
            long l = sCMServiceImpl.getHostID(string);
            SCMHost sCMHost = sCMServiceImpl.getHost(l);
            if (!sCMHost.getVersion().equals("5.10")) {
                return;
            }
            SCMZone[] sCMZoneArray = this.retrieveZonesFromAgent(sCMServiceImpl, sCMHost);
            logWriter.println("get " + sCMZoneArray.length + " zones from agent" + "get zones from db for host: " + string);
            Hashtable hashtable = this.retrieveZonesFromDB(sCMServiceImpl, l);
            int n2 = 0;
            while (n2 < sCMZoneArray.length) {
                sCMZone = (SCMZone)hashtable.remove(sCMZoneArray[n2].getZoneName());
                try {
                    if (sCMZone == null) {
                        logWriter.println("Create a new zone in DB:" + sCMZoneArray[n2].getZoneName());
                        sCMServiceImpl.saveZone(sCMZoneArray[n2], true);
                    } else if (SCMZone.copyAgentZone2DBZone((SCMZone)sCMZoneArray[n2], (SCMZone)sCMZone)) {
                        logWriter.println("Update Zone in DB: " + sCMZoneArray[n2].getZoneName());
                        sCMServiceImpl.saveZone(sCMZone, true);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(logWriter);
                    SCMSynchronizer.handleErrors("Error in saving zone: " + exception.getMessage(), exception, false);
                }
                ++n2;
            }
            sCMZone = hashtable.elements();
            while (sCMZone.hasMoreElements()) {
                try {
                    SCMZone sCMZone2 = (SCMZone)sCMZone.nextElement();
                    logWriter.println("Delete zone from DB: " + sCMZone2.getZoneName());
                    sCMServiceImpl.deleteZone(sCMZone2.getID(), true);
                }
                catch (Exception exception) {
                    SCMSynchronizer.handleErrors("Error in saving zone: " + exception.getMessage(), exception, false);
                }
            }
        }
        catch (Exception exception) {
            SCMSynchronizer.handleErrors("Error in saving zones on Host: " + string, exception);
        }
    }

    private SCMZone[] retrieveZonesFromAgent(SCMServiceImpl sCMServiceImpl, SCMHost sCMHost) throws SCMAPIException {
        String string = sCMHost.getHostName();
        int n = sCMHost.getPort();
        int n2 = SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS.length;
        String string2 = "0";
        String string3 = "0";
        String string4 = "snmp://" + string + ":" + n + "/mod/scm-container/Zones/ZoneTable/ZoneEntry/";
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = string4 + SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS[n3];
            ++n3;
        }
        SMRawDataRequest sMRawDataRequest = sCMServiceImpl.getRawDataRequest();
        try {
            StObject[][] stObjectArray = sMRawDataRequest.getURLValue(stringArray);
            if (stObjectArray == null || stObjectArray.length < n2) {
                SCMSynchronizer.handleErrors("Error in getting zone information on host " + string);
            }
            Vector[] vectorArray = SCMSynchronizer.decryptData(stObjectArray, SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS, string);
            long l = sCMHost.getHostID();
            Hashtable<String, SCMResourcePool> hashtable = new Hashtable<String, SCMResourcePool>();
            SCMResourcePool[] sCMResourcePoolArray = sCMServiceImpl.getResourcePools(l);
            int n4 = 0;
            while (n4 < sCMResourcePoolArray.length) {
                hashtable.put(sCMResourcePoolArray[n4].getResourcePoolName(), sCMResourcePoolArray[n4]);
                ++n4;
            }
            ArrayList<SCMZone> arrayList = new ArrayList<SCMZone>();
            int n5 = 0;
            while (n5 < vectorArray[0].size()) {
                try {
                    long l2 = 0L;
                    String string5 = vectorArray[8].get(n5).toString();
                    SCMResourcePool sCMResourcePool = (SCMResourcePool)hashtable.get(string5);
                    if (sCMResourcePool != null) {
                        l2 = sCMResourcePool.getResourcePoolID();
                    }
                    string2 = vectorArray[10].get(n5).toString();
                    string3 = vectorArray[11].get(n5).toString();
                    if (string2.equals("100000000")) {
                        string2 = "0";
                    }
                    if (string3.equals("100000000")) {
                        string3 = "0";
                    }
                    arrayList.add(SCMZone.createZoneFromAgentData((String)vectorArray[0].get(n5).toString(), (String)vectorArray[1].get(n5).toString(), (String)vectorArray[2].get(n5).toString(), (String)vectorArray[3].get(n5).toString(), (String)vectorArray[4].get(n5).toString(), (long)Long.parseLong(vectorArray[5].get(n5).toString()), (long)Long.parseLong(vectorArray[6].get(n5).toString()), (SCMIPQSInfo)new SCMIPQSInfo(Float.parseFloat(string2), Float.parseFloat(string3), "T".equals(vectorArray[8].get(n5).toString())), (String)vectorArray[7].get(n5).toString(), (long)l2, (String)string5, ("true".equals(vectorArray[12].get(n5)) ? 1 : 0) != 0, (String)vectorArray[13].get(n5).toString()));
                }
                catch (Throwable throwable) {
                    logWriter.println("Skipping sync up of zone  " + vectorArray[0].get(n5) + " due to exception:");
                    throwable.printStackTrace(logWriter);
                }
                ++n5;
            }
            return arrayList.toArray(emptyZoneArray);
        }
        catch (Exception exception) {
            SCMSynchronizer.handleErrors("Error in getting zone information on host " + string + ", ", exception);
            return emptyZoneArray;
        }
    }

    private Hashtable retrieveZonesFromDB(SCMServiceImpl sCMServiceImpl, long l) throws SCMAPIException {
        Hashtable<String, SCMZone> hashtable = new Hashtable<String, SCMZone>();
        try {
            SCMZone[] sCMZoneArray = sCMServiceImpl.getZonesByHost(l, false);
            int n = 0;
            while (n < sCMZoneArray.length) {
                hashtable.put(sCMZoneArray[n].getZoneName(), sCMZoneArray[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            String string = "Error in getting zones from DB: ";
            SCMSynchronizer.handleErrors(string, exception);
        }
        return hashtable;
    }

    private Vector[] retrieveContainersFromAgent(SCMServiceImpl sCMServiceImpl, String string, int n, boolean bl) throws SCMAPIException, SMAPIException {
        String string2 = "snmp://" + string + ":" + n + CONTAINER_URL_PREFIX;
        int n2 = containerFields.length;
        if (!bl) {
            n2 = containerFields.length + 1;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < containerFields.length) {
            stringArray[n3] = containerFields[n3];
            ++n3;
        }
        if (!bl) {
            stringArray[n2 - 1] = "zoneName";
        }
        String[] stringArray2 = new String[n2];
        int n4 = 0;
        while (n4 < n2) {
            stringArray2[n4] = string2 + stringArray[n4];
            ++n4;
        }
        SMRawDataRequest sMRawDataRequest = sCMServiceImpl.getRawDataRequest();
        StObject[][] stObjectArray = null;
        stObjectArray = sMRawDataRequest.getURLValue(stringArray2);
        if (stObjectArray == null || stObjectArray.length < n2) {
            SCMSynchronizer.handleErrors("Error in getting container information on host " + string);
        }
        Vector[] vectorArray = new Vector[n2];
        vectorArray[0] = new Vector();
        if (!UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), (Vector)vectorArray[0])) {
            SCMSynchronizer.handleErrors("Error in getting container information on host " + string);
        }
        int n5 = vectorArray[0].size();
        int n6 = 1;
        while (n6 < n2) {
            vectorArray[n6] = new Vector();
            if (!UcListUtil.decomposeList((String)stObjectArray[n6][0].toString(), (Vector)vectorArray[n6]) || vectorArray[n6].size() != n5) {
                SCMSynchronizer.handleErrors("Error in getting container information on host " + string);
            }
            ++n6;
        }
        return vectorArray;
    }

    private Hashtable retrieveContainersInDB(SCMServiceImpl sCMServiceImpl, long l) throws SCMAPIException {
        SCMContainer[] sCMContainerArray = null;
        try {
            sCMContainerArray = sCMServiceImpl.getContainersInDB(l, false);
        }
        catch (Exception exception) {
            SCMSynchronizer.handleErrors("Error in getting container information on host ", exception);
        }
        Hashtable<String, SCMContainer> hashtable = new Hashtable<String, SCMContainer>();
        int n = 0;
        while (n < sCMContainerArray.length) {
            String string = sCMContainerArray[n].getZoneName() + "," + sCMContainerArray[n].getProjectID();
            hashtable.put(string, sCMContainerArray[n]);
            ++n;
        }
        return hashtable;
    }

    private static void handleErrors(String string) throws SCMAPIException {
        SCMSynchronizer.handleErrors(string, null, true);
    }

    private static void handleErrors(String string, Exception exception) throws SCMAPIException {
        SCMSynchronizer.handleErrors(string, exception, true);
    }

    private static void handleErrors(String string, Exception exception, boolean bl) throws SCMAPIException {
        logWriter.println(string);
        if (exception != null) {
            exception.printStackTrace(logWriter);
            if (bl) {
                throw new SCMAPIException(string, (Throwable)exception);
            }
        }
        if (bl) {
            throw new SCMAPIException(string);
        }
    }

    private int toInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            return n;
        }
    }

    private float toFloat(String string, float f) {
        try {
            return Float.parseFloat(string);
        }
        catch (Throwable throwable) {
            return f;
        }
    }

    private long toLong(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (Throwable throwable) {
            return l;
        }
    }

    private boolean is10Module(String string, int n) {
        return false;
    }

    static Vector[] decryptData(StObject[][] stObjectArray, String[] stringArray, String string) throws SCMAPIException {
        Vector[] vectorArray = new Vector[stObjectArray.length];
        int n = 0;
        while (n < stObjectArray.length) {
            vectorArray[n] = new Vector();
            if (!UcListUtil.decomposeList((String)stObjectArray[n][0].toString(), (Vector)vectorArray[n]) || vectorArray[n].size() != vectorArray[0].size()) {
                SCMSynchronizer.handleErrors("Error in getting" + stringArray[n] + " on host " + string);
            }
            ++n;
        }
        return vectorArray;
    }
}

