/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.scm.manager.SCMContainer;
import com.sun.symon.base.client.scm.manager.SCMContainerMaster;
import com.sun.symon.base.client.scm.manager.SCMContainerTree;
import com.sun.symon.base.client.scm.manager.SCMHost;
import com.sun.symon.base.client.scm.manager.SCMHostTree;
import com.sun.symon.base.client.scm.manager.SCMProject;
import com.sun.symon.base.client.scm.manager.SCMTreeNode;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.scm.manager.SCMDBProcedures;
import com.sun.symon.base.mgmtservice.scm.manager.SCMResourcePoolManager;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.jdbc.driver.OracleResultSet;

public class SCMDB
implements SCMDBProcedures {
    static final PrintWriter logWriter;
    static final String HOST_TOPOLOGY = "H";
    static final String CONTAINER_TOPOLOGY = "S";
    static final String FOLDER = "F";
    static final String ROOT_HOST_NAME = "Hosts";
    static final String ROOT_CONTAINER_NAME = "Containers";
    static final String DEFAULT_CONTAINER_FOLDER = "System";
    static final int DB_ERROR = -1;
    static final long ID_GAP = 20000L;
    static final int ACTIVE = 1;
    static final int INACTIVE = 0;
    static final int BOTH = 2;
    static final String GE_SIGN = ">=";
    static final String COMMA_SIGN = ",";
    static final String UNIQUE_CONSTRAINT = "unique constraint";

    public static long addHost(SCMHost sCMHost) throws SMDatabaseException, SMAPIException {
        Connection connection = MSDB.getConnection();
        long l = -1L;
        try {
            try {
                boolean bl = false;
                if (sCMHost.getHostID() == 0L) {
                    bl = true;
                }
                l = SCMDB.saveHost(sCMHost, connection);
                if (bl) {
                    long l2 = 0L;
                    long l3 = 0L;
                    long l4 = 0L;
                    String string = sCMHost.getHostName();
                    l2 = SCMDB.saveNode(l2, string, HOST_TOPOLOGY, l, l3, l4, HOST_TOPOLOGY, connection);
                }
                connection.commit();
                sCMHost.setHostID(l);
            }
            catch (SQLException sQLException) {
                logWriter.println("addHost: Exception: " + sQLException);
                MSDB.rollback((Connection)connection);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_10 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static void deleteHost(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        try {
            try {
                long l2 = SCMDB.getHostNodeID(l, connection);
                SCMDB.deleteTreeNode(l2, connection);
                SCMDB.deleteHost(l, connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                logWriter.println("deleteHost: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
    }

    public static long addContainerMaster(SCMContainerMaster sCMContainerMaster, long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        long l2 = -1L;
        try {
            try {
                l2 = SCMDB.saveContainerMaster(sCMContainerMaster, connection);
                sCMContainerMaster.setMasterID(l2);
                long l3 = 0L;
                long l4 = 0L;
                long l5 = l;
                String string = sCMContainerMaster.getMasterName();
                l3 = SCMDB.saveNode(l3, string, CONTAINER_TOPOLOGY, l4, l2, l5, CONTAINER_TOPOLOGY, connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                logWriter.println("addContainerMaster: Exception " + sQLException);
                MSDB.rollback((Connection)connection);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var14_9 = null;
        }
        catch (Throwable throwable) {
            Object var14_10 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return l2;
    }

    public static SCMHost getHost(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        SCMHost sCMHost = null;
        try {
            try {
                sCMHost = SCMDB.getHost(l, connection);
            }
            catch (SQLException sQLException) {
                logWriter.println("getHost: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sCMHost;
    }

    public static SCMHost getHost(long l, Connection connection) throws SQLException, SMDatabaseException {
        SCMHost sCMHost = null;
        CallableStatement callableStatement = null;
        try {
            block4: {
                callableStatement = connection.prepareCall("{call sp_get_scm_host(?, ?)}");
                callableStatement.registerOutParameter(2, -10);
                callableStatement.setLong(1, l);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                if (!oracleResultSet.next()) break block4;
                String string = oracleResultSet.getString("host_name");
                int n = Integer.parseInt(oracleResultSet.getString("port"));
                String string2 = oracleResultSet.getString("solaris_version");
                String string3 = oracleResultSet.getString("platform");
                int n2 = new Float(oracleResultSet.getFloat("processors")).intValue();
                int n3 = new Float(oracleResultSet.getFloat("memory")).intValue();
                int n4 = oracleResultSet.getInt("prc_frequency");
                sCMHost = new SCMHost(l, string, n, string2, string3, n2, n3, n4);
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            SCMDB.closeCall(callableStatement);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        return sCMHost;
    }

    public static SCMHost[] searchHosts(String string, String string2, String string3, int n, int n2, int n3) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        SCMHost sCMHost = null;
        Vector<SCMHost> vector = new Vector<SCMHost>();
        Object[] objectArray = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_search_scm_hosts(?,?,?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(10, -10);
                callableStatement.registerOutParameter(9, 12);
                callableStatement.setString(1, string);
                callableStatement.setString(2, string2);
                callableStatement.setString(3, string3);
                callableStatement.setString(4, GE_SIGN + n);
                callableStatement.setString(5, GE_SIGN + n2);
                callableStatement.setString(6, null);
                callableStatement.setString(7, GE_SIGN + n3);
                callableStatement.setString(8, null);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(10);
                while (oracleResultSet.next()) {
                    long l = oracleResultSet.getLong("host_id");
                    String string4 = oracleResultSet.getString("host_name");
                    int n4 = Integer.parseInt(oracleResultSet.getString("port"));
                    String string5 = oracleResultSet.getString("solaris_version");
                    String string6 = oracleResultSet.getString("platform");
                    int n5 = new Float(oracleResultSet.getFloat("processors")).intValue();
                    int n6 = new Float(oracleResultSet.getFloat("memory")).intValue();
                    int n7 = oracleResultSet.getInt("prc_frequency");
                    sCMHost = new SCMHost(l, string4, n4, string5, string6, n5, n6, n7);
                    vector.addElement(sCMHost);
                }
                objectArray = new SCMHost[vector.size()];
                vector.copyInto(objectArray);
            }
            catch (SQLException sQLException) {
                logWriter.println("getHost: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var22_21 = null;
        }
        catch (Throwable throwable) {
            Object var22_22 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public static long getHostID(String string) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        long l = -1L;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_scm_hostid_byname(?, ?)}");
                callableStatement.setString(1, string);
                callableStatement.registerOutParameter(2, 2);
                callableStatement.execute();
                l = callableStatement.getLong(2);
            }
            catch (SQLException sQLException) {
                logWriter.println("getHostID: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static SCMHostTree getHostTree() throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        SCMHostTree sCMHostTree = new SCMHostTree(0L, null, ROOT_HOST_NAME);
        try {
            try {
                SCMDB.getAllChildNodes(connection, (SCMTreeNode)sCMHostTree);
            }
            catch (SQLException sQLException) {
                logWriter.println("getHostTree: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sCMHostTree;
    }

    public static SCMContainerTree getContainerTree() throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        SCMContainerTree sCMContainerTree = new SCMContainerTree(0L, null, ROOT_CONTAINER_NAME);
        try {
            try {
                SCMDB.getAllChildNodes(connection, (SCMTreeNode)sCMContainerTree);
            }
            catch (SQLException sQLException) {
                logWriter.println("getContainerTree: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sCMContainerTree;
    }

    public static SCMTreeNode getAllChildNodes(SCMTreeNode sCMTreeNode) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        try {
            try {
                SCMDB.getAllChildNodes(connection, sCMTreeNode);
            }
            catch (SQLException sQLException) {
                logWriter.println("getAllchildNodes: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sCMTreeNode;
    }

    public static SCMTreeNode[] getChildNodes(SCMTreeNode sCMTreeNode) throws SMDatabaseException {
        if (!sCMTreeNode.isFolder()) {
            return null;
        }
        long l = sCMTreeNode.getID();
        Vector<Object> vector = new Vector<Object>();
        Connection connection = MSDB.getConnection();
        Object[] objectArray = null;
        String string = HOST_TOPOLOGY;
        if (sCMTreeNode instanceof SCMContainerTree) {
            string = CONTAINER_TOPOLOGY;
        }
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_child_nodes(?,?,?)}");
                callableStatement.registerOutParameter(3, -10);
                if (l == 0L) {
                    callableStatement.setNull(1, 2);
                } else {
                    callableStatement.setLong(1, l);
                }
                callableStatement.setString(2, string);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
                while (oracleResultSet.next()) {
                    String string2 = oracleResultSet.getString("node_type");
                    if (string2.equals(FOLDER)) {
                        if (string.equals(HOST_TOPOLOGY)) {
                            SCMHostTree sCMHostTree = new SCMHostTree(oracleResultSet.getLong("node_id"), (SCMHostTree)sCMTreeNode, oracleResultSet.getString("node_name"));
                            vector.addElement(sCMHostTree);
                            continue;
                        }
                        SCMContainerTree sCMContainerTree = new SCMContainerTree(oracleResultSet.getLong("node_id"), (SCMContainerTree)sCMTreeNode, oracleResultSet.getString("node_name"));
                        if (DEFAULT_CONTAINER_FOLDER.equals(oracleResultSet.getString("node_name"))) {
                            sCMContainerTree.setIsDefault(true);
                        }
                        vector.addElement(sCMContainerTree);
                        continue;
                    }
                    if (string2.equals(HOST_TOPOLOGY)) {
                        int n = new Integer(oracleResultSet.getString("port"));
                        SCMHostTree sCMHostTree = new SCMHostTree(oracleResultSet.getLong("node_id"), (SCMHostTree)sCMTreeNode, oracleResultSet.getString("node_name"), n, oracleResultSet.getLong("host_id"));
                        vector.addElement(sCMHostTree);
                        continue;
                    }
                    if (!string2.equals(CONTAINER_TOPOLOGY)) continue;
                    long l2 = oracleResultSet.getLong("master_id");
                    SCMContainerTree sCMContainerTree = new SCMContainerTree(oracleResultSet.getLong("node_id"), (SCMContainerTree)sCMTreeNode, oracleResultSet.getString("node_name"), l2);
                    sCMContainerTree.setIsDefault(SCMDB.getMasterDefaultStatus(connection, l2));
                    vector.addElement(sCMContainerTree);
                }
                objectArray = new SCMTreeNode[vector.size()];
                vector.copyInto(objectArray);
            }
            catch (SQLException sQLException) {
                logWriter.println("Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public static long saveTreeNode(SCMTreeNode sCMTreeNode) throws SMDatabaseException {
        long l = -1L;
        long l2 = 0L;
        SCMTreeNode sCMTreeNode2 = sCMTreeNode.getParent();
        if (sCMTreeNode2 != null) {
            l2 = sCMTreeNode2.getID();
        }
        Connection connection = MSDB.getConnection();
        try {
            try {
                if (sCMTreeNode instanceof SCMHostTree) {
                    String string = HOST_TOPOLOGY;
                    String string2 = HOST_TOPOLOGY;
                    if (sCMTreeNode.isFolder()) {
                        string2 = FOLDER;
                    }
                    long l3 = 0L;
                    l = SCMDB.saveNode(sCMTreeNode.getID(), sCMTreeNode.getName(), string2, ((SCMHostTree)sCMTreeNode).getHostID(), l3, l2, string, connection);
                } else if (sCMTreeNode instanceof SCMContainerTree) {
                    String string = CONTAINER_TOPOLOGY;
                    String string3 = CONTAINER_TOPOLOGY;
                    if (sCMTreeNode.isFolder()) {
                        string3 = FOLDER;
                    }
                    long l4 = 0L;
                    l = SCMDB.saveNode(sCMTreeNode.getID(), sCMTreeNode.getName(), string3, l4, ((SCMContainerTree)sCMTreeNode).getMasterID(), l2, string, connection);
                }
                connection.commit();
                sCMTreeNode.setID(l);
            }
            catch (SQLException sQLException) {
                logWriter.println("saveTreeNode: Exception: " + sQLException);
                MSDB.rollback((Connection)connection);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static long saveProject(SCMProject sCMProject) throws SMDatabaseException {
        long l = sCMProject.getProjectID();
        String string = sCMProject.getProjectName();
        String string2 = sCMProject.getType();
        String string3 = sCMProject.getMatchExpression();
        String string4 = sCMProject.getPrimaryUsers();
        String string5 = sCMProject.getPrimaryGroup();
        String string6 = sCMProject.getOtherUsers();
        String string7 = sCMProject.getOtherGroups();
        Connection connection = MSDB.getConnection();
        if (connection == null) {
            return -1L;
        }
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall("{call sp_save_scm_solaris_project(?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(1, 2);
                SCMDB.setNullable(callableStatement, 1, l);
                callableStatement.setString(2, string);
                callableStatement.setString(3, string2);
                callableStatement.setString(4, string3);
                callableStatement.setString(5, string4);
                callableStatement.setString(6, string5);
                callableStatement.setString(7, string6);
                callableStatement.setString(8, string7);
                callableStatement.execute();
                l = callableStatement.getLong(1);
                SCMDB.closeCall(callableStatement);
                connection.commit();
                sCMProject.setProjectID(l);
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                logWriter.println("saveProject: Exception " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static void deleteProject(long l) throws SMDatabaseException {
        logWriter.println("deleteProject: " + l);
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_delete_solaris_project(?)}");
                callableStatement.setLong(1, l);
                callableStatement.execute();
                connection.commit();
            }
            catch (SQLException sQLException) {
                logWriter.println("deleteProject: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    public static void addSystemProject(SCMProject sCMProject) throws SMDatabaseException {
        long l = sCMProject.getProjectID();
        String string = sCMProject.getProjectName();
        String string2 = sCMProject.getType();
        String string3 = sCMProject.getMatchExpression();
        String string4 = sCMProject.getPrimaryUsers();
        String string5 = sCMProject.getPrimaryGroup();
        String string6 = sCMProject.getOtherUsers();
        String string7 = sCMProject.getOtherGroups();
        Connection connection = MSDB.getConnection();
        if (connection == null) {
            return;
        }
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall("{call sp_add_system_project(?,?,?,?,?,?,?,?)}");
                SCMDB.setNullable(callableStatement, 1, l);
                callableStatement.setString(2, string);
                callableStatement.setString(3, string2);
                callableStatement.setString(4, string3);
                callableStatement.setString(5, string4);
                callableStatement.setString(6, string5);
                callableStatement.setString(7, string6);
                callableStatement.setString(8, string7);
                callableStatement.execute();
                SCMDB.closeCall(callableStatement);
                connection.commit();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                logWriter.println("addSystemProject: Exception " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
    }

    public static SCMProject getProject(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        SCMProject sCMProject = null;
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall("{call sp_get_solaris_projects(?, ?)}");
                callableStatement.registerOutParameter(2, -10);
                callableStatement.setLong(1, l);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                if (oracleResultSet.next()) {
                    String string = oracleResultSet.getString("project_name");
                    String string2 = oracleResultSet.getString("project_type");
                    String string3 = oracleResultSet.getString("match_processes");
                    String string4 = oracleResultSet.getString("primary_user");
                    String string5 = oracleResultSet.getString("primary_group");
                    String string6 = oracleResultSet.getString("other_users");
                    String string7 = oracleResultSet.getString("other_groups");
                    sCMProject = new SCMProject(l, string, string2, string3, string4, string5, string6, string7);
                }
                SCMDB.closeCall(callableStatement);
            }
            catch (SQLException sQLException) {
                logWriter.println("getProject: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sCMProject;
    }

    public static SCMProject[] getProjects() throws SMDatabaseException {
        Object[] objectArray;
        Vector<SCMProject> vector = new Vector<SCMProject>();
        Connection connection = MSDB.getConnection();
        try {
            try {
                objectArray = connection.prepareCall("{call sp_get_solaris_projects(?, ?)}");
                objectArray.registerOutParameter(2, -10);
                objectArray.setNull(1, 2);
                objectArray.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)objectArray.getObject(2);
                while (oracleResultSet.next()) {
                    long l = oracleResultSet.getLong("project_id");
                    String string = oracleResultSet.getString("project_name");
                    String string2 = oracleResultSet.getString("project_type");
                    String string3 = oracleResultSet.getString("match_processes");
                    String string4 = oracleResultSet.getString("primary_user");
                    String string5 = oracleResultSet.getString("primary_group");
                    String string6 = oracleResultSet.getString("other_users");
                    String string7 = oracleResultSet.getString("other_groups");
                    SCMProject sCMProject = new SCMProject(l, string, string2, string3, string4, string5, string6, string7);
                    vector.addElement(sCMProject);
                }
                SCMDB.closeCall((Statement)objectArray);
            }
            catch (SQLException sQLException) {
                logWriter.println("getProject: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        objectArray = new SCMProject[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static long saveContainerMaster(SCMContainerMaster sCMContainerMaster) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        long l = -1L;
        try {
            try {
                l = SCMDB.saveContainerMaster(sCMContainerMaster, connection);
                sCMContainerMaster.setMasterID(l);
            }
            catch (SQLException sQLException) {
                logWriter.println("saveContainerMaster: Exception: " + sQLException);
                MSDB.rollback((Connection)connection);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static void deleteContainerMaster(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        try {
            try {
                long l2 = SCMDB.getMasterNodeID(l, connection);
                SCMDB.deleteTreeNode(l2, connection);
                SCMDB.deleteContainerMaster(l, connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                logWriter.println("deleteContainerMaster: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
    }

    public static void deleteTreeNode(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        try {
            try {
                SCMDB.deleteTreeNode(l, connection);
                connection.commit();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                logWriter.println("deleteTreeNode: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
    }

    public static void deleteContainer(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_delete_container(?)}");
                callableStatement.setLong(1, l);
                callableStatement.execute();
                connection.commit();
            }
            catch (SQLException sQLException) {
                logWriter.println("deleteContainer: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    public static SCMContainerMaster[] getContainerMasters() throws SMDatabaseException {
        Object[] objectArray;
        Vector<SCMContainerMaster> vector = new Vector<SCMContainerMaster>();
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{call sp_get_all_service_name(?)}");
                callableStatement.registerOutParameter(1, -10);
                callableStatement.execute();
                objectArray = (Object[])callableStatement.getObject(1);
                while (objectArray.next()) {
                    long l = objectArray.getLong("master_id");
                    String string = objectArray.getString("service_elm_name");
                    String string2 = objectArray.getString("description");
                    long l2 = objectArray.getLong("project_id");
                    SCMContainerMaster sCMContainerMaster = new SCMContainerMaster(l, string, l2, string2);
                    vector.addElement(sCMContainerMaster);
                }
            }
            catch (SQLException sQLException) {
                logWriter.println("getContainerMasters: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        objectArray = new SCMContainerMaster[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] getListValues(String string) throws SMDatabaseException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall("{?=call fn_get_list_values(?)}");
                callableStatement.registerOutParameter(1, 12);
                callableStatement.setString(2, string);
                callableStatement.execute();
                objectArray = callableStatement.getString(1);
                StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray, COMMA_SIGN);
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken());
                }
            }
            catch (SQLException sQLException) {
                logWriter.println("getVersions: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static SCMContainerMaster getContainerMaster(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        SCMContainerMaster sCMContainerMaster = null;
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall("{call sp_get_container_master(?,?)}");
                callableStatement.registerOutParameter(2, -10);
                callableStatement.setLong(1, l);
                callableStatement.execute();
                OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
                if (oracleResultSet.next()) {
                    String string = oracleResultSet.getString("service_elm_name");
                    String string2 = oracleResultSet.getString("description");
                    long l2 = oracleResultSet.getLong("project_id");
                    sCMContainerMaster = new SCMContainerMaster(l, string, l2, string2);
                }
                SCMDB.closeCall(callableStatement);
            }
            catch (SQLException sQLException) {
                logWriter.println("getContainerMaster: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return sCMContainerMaster;
    }

    public static long saveContainer(SCMContainer sCMContainer) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        if (connection == null) {
            return -1L;
        }
        long l = -1L;
        try {
            try {
                CallableStatement callableStatement = connection.prepareCall("{call sp_save_scm_container(?,?,?,?,?,?,?,?)}");
                callableStatement.registerOutParameter(1, 2);
                SCMDB.setNullable(callableStatement, 1, sCMContainer.getContainerID());
                callableStatement.setLong(2, sCMContainer.getMasterID());
                callableStatement.setLong(3, sCMContainer.getResourceID());
                callableStatement.setLong(4, sCMContainer.getCPUShares());
                callableStatement.setFloat(5, (float)sCMContainer.getMemory());
                callableStatement.setLong(8, sCMContainer.getMaxSHMemory());
                String string = "0";
                if (sCMContainer.getStatus()) {
                    string = "1";
                }
                callableStatement.setString(6, string);
                callableStatement.setLong(7, sCMContainer.getZoneID());
                callableStatement.execute();
                l = callableStatement.getLong(1);
                SCMDB.closeCall(callableStatement);
                if (sCMContainer.isDefault()) {
                    String string2 = "1";
                    callableStatement = connection.prepareCall("{call sp_set_default_container(?, ?)}");
                    callableStatement.setLong(1, l);
                    callableStatement.setString(2, string2);
                    callableStatement.execute();
                    SCMDB.closeCall(callableStatement);
                }
                connection.commit();
                sCMContainer.setContainerID(l);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace(logWriter);
                MSDB.rollback((Connection)connection);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static SCMContainer[] getContainers(long l, boolean bl) throws SMDatabaseException {
        Object[] objectArray;
        if (l > 20000L && l < 40000L) {
            if (bl) {
                return SCMDB.getContainersByPool(l - 20000L, "1");
            }
            return SCMDB.getContainersByPool(l - 20000L, "0");
        }
        String string = "0";
        if (bl) {
            string = "1";
        }
        Connection connection = MSDB.getConnection();
        try {
            Object[] objectArray2;
            CallableStatement callableStatement = connection.prepareCall("{call sp_get_container_info(?,?,?)}");
            callableStatement.registerOutParameter(3, -10);
            callableStatement.setLong(1, l);
            callableStatement.setString(2, string);
            callableStatement.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
            Vector<Object[]> vector = new Vector<Object[]>();
            while (oracleResultSet.next()) {
                objectArray2 = SCMDB.createContainer((ResultSet)oracleResultSet);
                vector.addElement(objectArray2);
            }
            SCMDB.closeCall(callableStatement);
            objectArray2 = new SCMContainer[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var11_10 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("getContainers: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public static SCMContainer[] getContainersByPool(long l) throws SMDatabaseException {
        return SCMDB.getContainersByPool(l, "2");
    }

    public static SCMContainer[] getContainersByHost(long l) throws SMDatabaseException {
        Object[] objectArray;
        Connection connection = MSDB.getConnection();
        try {
            Object[] objectArray2;
            CallableStatement callableStatement = connection.prepareCall("{call sp_get_containers_by_host(?,?)}");
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
            Vector<Object[]> vector = new Vector<Object[]>();
            while (oracleResultSet.next()) {
                objectArray2 = SCMDB.createContainer((ResultSet)oracleResultSet);
                vector.addElement(objectArray2);
            }
            SCMDB.closeCall(callableStatement);
            objectArray2 = new SCMContainer[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var9_8 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("getContainersByHost: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public static boolean isProjectOnHost(long l, long l2) throws SMDatabaseException {
        boolean bl;
        Connection connection;
        block5: {
            connection = MSDB.getConnection();
            CallableStatement callableStatement = connection.prepareCall("{call sp_get_is_project_on_host(?, ?, ?, ?)}");
            callableStatement.setLong(1, l);
            callableStatement.setLong(2, 0L);
            callableStatement.setLong(3, l2);
            callableStatement.registerOutParameter(4, 2);
            callableStatement.execute();
            int n = callableStatement.getInt(4);
            SCMDB.closeCall(callableStatement);
            if (n != 1) break block5;
            boolean bl2 = true;
            Object var9_8 = null;
            MSDB.closeConnection((Connection)connection);
            return bl2;
        }
        try {
            bl = false;
            Object var9_9 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("isProjectOnHost: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        MSDB.closeConnection((Connection)connection);
        return bl;
    }

    public static boolean isProjectOnZone(long l, long l2, long l3) throws SMDatabaseException {
        boolean bl;
        Connection connection;
        block5: {
            connection = MSDB.getConnection();
            CallableStatement callableStatement = connection.prepareCall("{call sp_get_is_project_on_host(?, ?, ?, ?)}");
            callableStatement.setLong(1, l);
            callableStatement.setLong(2, l2);
            callableStatement.setLong(3, l3);
            callableStatement.registerOutParameter(4, 2);
            callableStatement.execute();
            int n = callableStatement.getInt(4);
            SCMDB.closeCall(callableStatement);
            if (n != 1) break block5;
            boolean bl2 = true;
            Object var11_9 = null;
            MSDB.closeConnection((Connection)connection);
            return bl2;
        }
        try {
            bl = false;
            Object var11_10 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("isProjectOnZone: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        MSDB.closeConnection((Connection)connection);
        return bl;
    }

    public static SCMContainer getContainer(long l) throws SMDatabaseException {
        SCMContainer sCMContainer;
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            SCMContainer sCMContainer2 = null;
            callableStatement = connection.prepareCall("{call sp_get_container(?,?)}");
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
            if (oracleResultSet.next()) {
                sCMContainer2 = SCMDB.createContainer((ResultSet)oracleResultSet);
            }
            sCMContainer = sCMContainer2;
            Object var8_7 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("getContainer: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                SCMDB.closeCall(callableStatement);
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sCMContainer;
    }

    public static void setDefaultContainer(long l, boolean bl) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        try {
            try {
                String string = "1";
                if (!bl) {
                    string = "0";
                }
                CallableStatement callableStatement = connection.prepareCall("{call sp_set_default_container(?, ?)}");
                callableStatement.setLong(1, l);
                callableStatement.setString(2, string);
                callableStatement.execute();
                SCMDB.closeCall(callableStatement);
                connection.commit();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
    }

    private static long saveHost(SCMHost sCMHost) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        long l = -1L;
        try {
            try {
                l = SCMDB.saveHost(sCMHost, connection);
                sCMHost.setHostID(l);
            }
            catch (SQLException sQLException) {
                logWriter.println("saveHost: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static SCMContainer[] getContainersByProjectHost(long l, long l2) throws SMDatabaseException {
        Object[] objectArray;
        Connection connection = MSDB.getConnection();
        try {
            Object[] objectArray2;
            CallableStatement callableStatement = connection.prepareCall("{call sp_get_cntnrs_by_prj_host(?, ?, ?)}");
            callableStatement.registerOutParameter(3, -10);
            callableStatement.setLong(1, l2);
            callableStatement.setLong(2, l);
            callableStatement.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
            Vector<Object[]> vector = new Vector<Object[]>();
            while (oracleResultSet.next()) {
                objectArray2 = SCMDB.createContainer((ResultSet)oracleResultSet);
                vector.addElement(objectArray2);
            }
            SCMDB.closeCall(callableStatement);
            objectArray2 = new SCMContainer[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var11_9 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("getContainersByHost: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    static SMDatabaseException getSMDatabaseException(SQLException sQLException) {
        if (sQLException.getMessage().indexOf("ROW_NOT_FOUND") >= 0) {
            return new SMNoSuchObjectException((Throwable)sQLException);
        }
        if (sQLException.getMessage().indexOf("DUPLICATE_INDEX") >= 0 || sQLException.getMessage().indexOf(UNIQUE_CONSTRAINT) >= 0) {
            return new SMDuplicateException((Throwable)sQLException);
        }
        if (sQLException.getMessage().indexOf("STALE_DATA") >= 0) {
            return new SMStaleDataException((Throwable)sQLException);
        }
        return new SMDatabaseException((Throwable)sQLException);
    }

    static void closeCall(Statement statement) throws SMDatabaseException {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            throw SCMDB.getSMDatabaseException(sQLException);
        }
    }

    static void closeCallableStmt(Statement statement) throws SQLException {
        if (statement != null) {
            statement.close();
        }
    }

    static void setNullable(PreparedStatement preparedStatement, int n, long l) throws SQLException {
        if (l > 0L) {
            preparedStatement.setLong(n, l);
        } else {
            preparedStatement.setNull(n, 4);
        }
    }

    private static void getAllChildNodes(Connection connection, SCMTreeNode sCMTreeNode) throws SQLException, SMDatabaseException {
        if (connection == null || sCMTreeNode == null) {
            return;
        }
        long l = sCMTreeNode.getID();
        if (!sCMTreeNode.isFolder()) {
            return;
        }
        String string = HOST_TOPOLOGY;
        if (sCMTreeNode instanceof SCMContainerTree) {
            string = CONTAINER_TOPOLOGY;
        }
        CallableStatement callableStatement = connection.prepareCall("{call sp_get_child_nodes(?,?,?)}");
        callableStatement.registerOutParameter(3, -10);
        SCMDB.setNullable(callableStatement, 1, l);
        callableStatement.setString(2, string);
        callableStatement.execute();
        OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(3);
        while (oracleResultSet.next()) {
            String string2 = oracleResultSet.getString("node_type");
            if (string2.equals(FOLDER)) {
                if (string.equals(HOST_TOPOLOGY)) {
                    SCMHostTree sCMHostTree = new SCMHostTree(oracleResultSet.getLong("node_id"), (SCMHostTree)sCMTreeNode, oracleResultSet.getString("node_name"));
                    SCMDB.getAllChildNodes(connection, (SCMTreeNode)sCMHostTree);
                    continue;
                }
                SCMContainerTree sCMContainerTree = new SCMContainerTree(oracleResultSet.getLong("node_id"), (SCMContainerTree)sCMTreeNode, oracleResultSet.getString("node_name"));
                if (DEFAULT_CONTAINER_FOLDER.equals(oracleResultSet.getString("node_name"))) {
                    sCMContainerTree.setIsDefault(true);
                }
                SCMDB.getAllChildNodes(connection, (SCMTreeNode)sCMContainerTree);
                continue;
            }
            if (string2.equals(HOST_TOPOLOGY)) {
                int n = new Integer(oracleResultSet.getString("port"));
                String string3 = oracleResultSet.getString("solaris_version");
                long l2 = oracleResultSet.getLong("host_id");
                SCMHostTree sCMHostTree = new SCMHostTree(oracleResultSet.getLong("node_id"), (SCMHostTree)sCMTreeNode, oracleResultSet.getString("node_name"), n, l2);
                sCMHostTree.setVersion(string3);
                SCMResourcePoolManager.getAllResourcePools(connection, sCMHostTree);
                continue;
            }
            if (!string2.equals(CONTAINER_TOPOLOGY)) continue;
            long l3 = oracleResultSet.getLong("master_id");
            SCMContainerTree sCMContainerTree = new SCMContainerTree(oracleResultSet.getLong("node_id"), (SCMContainerTree)sCMTreeNode, oracleResultSet.getString("node_name"), l3);
            sCMContainerTree.setIsDefault(SCMDB.getMasterDefaultStatus(connection, l3));
        }
        oracleResultSet.close();
        SCMDB.closeCallableStmt(callableStatement);
    }

    static boolean isSolaris10(String string) {
        return string.equals("5.10");
    }

    private static long saveNode(long l, String string, String string2, long l2, long l3, long l4, String string3, Connection connection) throws SQLException {
        if (connection == null) {
            return -1L;
        }
        CallableStatement callableStatement = connection.prepareCall("{call sp_save_scm_node(?,?,?,?,?,?,?)}");
        callableStatement.registerOutParameter(1, 2);
        SCMDB.setNullable(callableStatement, 1, l);
        callableStatement.setString(2, string);
        callableStatement.setString(3, string2);
        SCMDB.setNullable(callableStatement, 4, l2);
        SCMDB.setNullable(callableStatement, 5, l3);
        SCMDB.setNullable(callableStatement, 6, l4);
        callableStatement.setString(7, string3);
        callableStatement.execute();
        long l5 = callableStatement.getLong(1);
        SCMDB.closeCallableStmt(callableStatement);
        return l5;
    }

    private static long saveContainerMaster(SCMContainerMaster sCMContainerMaster, Connection connection) throws SQLException {
        if (sCMContainerMaster == null || connection == null) {
            return -1L;
        }
        CallableStatement callableStatement = null;
        callableStatement = connection.prepareCall("{call sp_save_scm_master(?,?,?,?)}");
        callableStatement.registerOutParameter(1, 2);
        SCMDB.setNullable(callableStatement, 1, sCMContainerMaster.getMasterID());
        callableStatement.setString(2, sCMContainerMaster.getMasterName());
        SCMDB.setNullable(callableStatement, 4, sCMContainerMaster.getProjectID());
        callableStatement.setString(3, sCMContainerMaster.getDescription());
        callableStatement.execute();
        long l = callableStatement.getLong(1);
        SCMDB.closeCallableStmt(callableStatement);
        return l;
    }

    private static long getMasterNodeID(long l, Connection connection) throws SQLException {
        if (l == 0L || connection == null) {
            return -1L;
        }
        long l2 = 0L;
        CallableStatement callableStatement = null;
        callableStatement = connection.prepareCall("{call sp_get_scm_node(?,?,?,?)}");
        callableStatement.setNull(1, 2);
        callableStatement.setNull(2, 2);
        callableStatement.setLong(3, l);
        callableStatement.registerOutParameter(4, -10);
        callableStatement.execute();
        OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(4);
        if (oracleResultSet.next()) {
            l2 = oracleResultSet.getLong("node_id");
        }
        SCMDB.closeCallableStmt(callableStatement);
        return l2;
    }

    private static long getHostNodeID(long l, Connection connection) throws SQLException {
        if (l == 0L || connection == null) {
            return -1L;
        }
        long l2 = 0L;
        CallableStatement callableStatement = null;
        callableStatement = connection.prepareCall("{call sp_get_scm_node(?,?,?,?)}");
        callableStatement.setNull(1, 2);
        callableStatement.setLong(2, l);
        callableStatement.setNull(3, 2);
        callableStatement.registerOutParameter(4, -10);
        callableStatement.execute();
        OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(4);
        if (oracleResultSet.next()) {
            l2 = oracleResultSet.getLong("node_id");
        }
        SCMDB.closeCallableStmt(callableStatement);
        return l2;
    }

    private static void deleteTreeNode(long l, Connection connection) throws SQLException {
        if (l == 0L || connection == null) {
            return;
        }
        CallableStatement callableStatement = connection.prepareCall("{call sp_delete_scm_node(?)}");
        callableStatement.setLong(1, l);
        callableStatement.execute();
        SCMDB.closeCallableStmt(callableStatement);
    }

    private static long saveHost(SCMHost sCMHost, Connection connection) throws SQLException {
        if (connection == null || sCMHost == null) {
            return -1L;
        }
        CallableStatement callableStatement = connection.prepareCall("{call sp_save_scm_host(?,?,?,?,?,?,?,?)}");
        callableStatement.registerOutParameter(1, 2);
        SCMDB.setNullable(callableStatement, 1, sCMHost.getHostID());
        callableStatement.setString(2, sCMHost.getHostName());
        callableStatement.setString(3, Integer.toString(sCMHost.getPort()));
        callableStatement.setString(4, sCMHost.getVersion());
        callableStatement.setString(5, sCMHost.getPlatform());
        callableStatement.setString(6, Integer.toString(sCMHost.getProcessors()));
        callableStatement.setString(7, Integer.toString(sCMHost.getMemory()));
        callableStatement.setString(8, Integer.toString(sCMHost.getFrequency()));
        callableStatement.execute();
        long l = callableStatement.getLong(1);
        SCMDB.closeCallableStmt(callableStatement);
        return l;
    }

    private static void deleteContainerMaster(long l, Connection connection) throws SQLException {
        if (l == 0L || connection == null) {
            return;
        }
        CallableStatement callableStatement = connection.prepareCall("{call sp_delete_container_master(?)}");
        callableStatement.setLong(1, l);
        callableStatement.execute();
        SCMDB.closeCallableStmt(callableStatement);
    }

    private static void deleteHost(long l, Connection connection) throws SQLException {
        if (l == 0L || connection == null) {
            return;
        }
        CallableStatement callableStatement = connection.prepareCall("{call sp_delete_scm_host(?)}");
        callableStatement.setLong(1, l);
        callableStatement.execute();
        SCMDB.closeCallableStmt(callableStatement);
    }

    private static SCMContainer[] getContainersByPool(long l, String string) throws SMDatabaseException {
        SCMContainer sCMContainer;
        Connection connection = MSDB.getConnection();
        try {
            SCMContainer sCMContainer2;
            CallableStatement callableStatement = connection.prepareCall("{call sp_get_containers_by_pool(?,?)}");
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
            Vector<SCMContainer> vector = new Vector<SCMContainer>();
            while (oracleResultSet.next()) {
                if (!string.equals("2") && !oracleResultSet.getString("is_active").equals(string)) continue;
                sCMContainer2 = SCMDB.createContainer((ResultSet)oracleResultSet);
                vector.addElement(sCMContainer2);
            }
            SCMDB.closeCall(callableStatement);
            sCMContainer2 = new SCMContainer[vector.size()];
            vector.copyInto((Object[])sCMContainer2);
            sCMContainer = sCMContainer2;
            Object var10_9 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("getContainersByPool: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        MSDB.closeConnection((Connection)connection);
        return sCMContainer;
    }

    public static SCMContainer[] getContainersByZone(long l) throws SMDatabaseException {
        Object[] objectArray;
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            Object[] objectArray2;
            callableStatement = connection.prepareCall("{call sp_get_containers_by_zone(?,?)}");
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            OracleResultSet oracleResultSet = (OracleResultSet)callableStatement.getObject(2);
            Vector<Object[]> vector = new Vector<Object[]>();
            while (oracleResultSet.next()) {
                objectArray2 = SCMDB.createContainer((ResultSet)oracleResultSet);
                vector.addElement(objectArray2);
            }
            objectArray2 = new SCMContainer[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var9_8 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("getContainersByPool: Exception" + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                SCMDB.closeCall(callableStatement);
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public static boolean getMasterDefaultStatus(Connection connection, long l) throws SQLException {
        boolean bl;
        CallableStatement callableStatement;
        block5: {
            callableStatement = null;
            callableStatement = connection.prepareCall("{call sp_get_master_default_status(?, ?)}");
            callableStatement.setLong(1, l);
            callableStatement.registerOutParameter(2, 2);
            callableStatement.execute();
            int n = callableStatement.getInt(2);
            if (n != 1) break block5;
            boolean bl2 = true;
            Object var7_7 = null;
            SCMDB.closeCallableStmt(callableStatement);
            return bl2;
        }
        try {
            bl = false;
            Object var7_8 = null;
        }
        catch (SQLException sQLException) {
            try {
                logWriter.println("getMasterDefaultStatus: Exception" + sQLException);
                throw sQLException;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                SCMDB.closeCallableStmt(callableStatement);
                throw throwable;
            }
        }
        SCMDB.closeCallableStmt(callableStatement);
        return bl;
    }

    static final String createParamString(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n * 3);
        int n2 = 0;
        while (n2 < n - 1) {
            stringBuffer.append("?,");
            ++n2;
        }
        stringBuffer.append("?");
        return stringBuffer.toString();
    }

    private static final SCMContainer createContainer(ResultSet resultSet) throws SQLException {
        long l = resultSet.getLong("container_id");
        String string = resultSet.getString("service_elm_name");
        long l2 = resultSet.getLong("master_id");
        String string2 = resultSet.getString("description");
        long l3 = resultSet.getLong("project_id");
        long l4 = resultSet.getLong("host_id");
        String string3 = resultSet.getString("host_name");
        int n = Integer.parseInt(resultSet.getString("port"));
        long l5 = resultSet.getLong("resource_pool_id");
        String string4 = resultSet.getString("resource_pool_name");
        long l6 = resultSet.getLong("reserved_cpu");
        int n2 = new Float(resultSet.getFloat("memory_cap")).intValue();
        long l7 = new Float(resultSet.getFloat("max_shm_memory")).longValue();
        boolean bl = false;
        if (resultSet.getString("is_default").equals("1")) {
            bl = true;
        }
        boolean bl2 = false;
        if (resultSet.getString("is_active").equals("1")) {
            bl2 = true;
        }
        SCMContainerMaster sCMContainerMaster = new SCMContainerMaster(l2, string, l3, string2);
        SCMContainer sCMContainer = new SCMContainer(l, sCMContainerMaster, l5, string4, l4, string3, n, l6, n2, l7, bl2, bl, resultSet.getString("project_name"));
        sCMContainer.setZoneID(resultSet.getLong("zone_id"));
        sCMContainer.setZoneName(resultSet.getString("zone_name"));
        return sCMContainer;
    }

    static {
        SCMServiceController sCMServiceController = SCMServiceController.getInstance();
        logWriter = sCMServiceController != null ? sCMServiceController.getLogWriter() : new PrintWriter(System.out);
    }
}

