/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.scm.hosts;

import com.iplanet.jato.Log;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.scm.manager.SCMContainer;
import com.sun.symon.base.client.scm.manager.SCMHostTree;
import com.sun.symon.base.client.scm.manager.SCMResourcePoolTree;
import com.sun.symon.base.client.scm.manager.SCMService;
import com.sun.symon.base.client.scm.manager.SCMTreeNode;
import com.sun.symon.base.client.scm.manager.SCMZone;
import com.sun.symon.base.client.scm.manager.SCMZoneTree;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.web.admin.scm.common.SCMConsoleConstant;
import com.sun.web.admin.scm.common.SCMHandle;
import com.sun.web.admin.scm.common.SCMUtil;
import com.sun.web.admin.scm.hosts.SCMTableData;
import com.sun.web.admin.scm.hosts.SCMTableDataFactory;
import com.sun.web.admin.scm.hosts.SCMTableModel;
import com.sun.web.ui.common.CCI18N;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SCMTableBuilder
implements SCMConsoleConstant {
    public static final String CHILD_ACTION_BUTTON = "ActionButton";
    public static final String CHILD_COLUMN = "Col";
    public static final String CHILD_HREF = "Href";
    public static final String CHILD_STATIC_TEXT = "Text";
    private SCMTreeNode node = null;
    private SMRawDataRequest rawHandle = null;
    private SCMService scmservice = null;
    private int nodeType = -1;
    private int tabType = -1;

    public SCMTableBuilder(SCMTreeNode sCMTreeNode, RequestContext requestContext, String string, int n) {
        this.node = sCMTreeNode;
        SCMHandle sCMHandle = SCMHandle.getInstance();
        this.rawHandle = sCMHandle.getSunMCHandle(requestContext, string);
        this.scmservice = sCMHandle.getSMCServiceHandle(requestContext, string);
        this.nodeType = SCMUtil.mapTreeNodeType(this.node);
        this.tabType = n;
    }

    public SCMTableModel getTableModel() {
        return this.constructTableModel(this.nodeType);
    }

    public synchronized SCMTableModel constructTableModel(int n) {
        String[] stringArray;
        try {
            SCMTableDataFactory.checkParameter(n);
        }
        catch (Exception exception) {
            n = 0;
        }
        String string = SCMTableDataFactory.getTableXMLFile(n, this.tabType);
        if (string == null) {
            return null;
        }
        SCMTableModel sCMTableModel = new SCMTableModel(RequestManager.getRequestContext(), string, n, this.tabType);
        Hashtable hashtable = SCMTableDataFactory.getActionButtons(n, this.tabType);
        if (hashtable != null) {
            stringArray = hashtable.keys();
            while (stringArray.hasMoreElements()) {
                String string2 = (String)stringArray.nextElement();
                sCMTableModel.setActionValue(string2, (String)hashtable.get(string2));
            }
        }
        stringArray = SCMTableDataFactory.getTableHeader(n, this.tabType);
        int n2 = 0;
        int n3 = 1;
        while (n2 < stringArray.length) {
            sCMTableModel.setActionValue(CHILD_COLUMN + n3, stringArray[n2]);
            ++n2;
            ++n3;
        }
        return sCMTableModel;
    }

    public SCMTableData getTableData() throws SMAPIException {
        if (this.rawHandle == null || this.node == null || this.scmservice == null) {
            return null;
        }
        System.out.println("tabType: " + this.tabType + "  nodeType: " + this.nodeType + " nodeName: " + this.node.getName());
        switch (this.nodeType) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return this.getFolderData();
            }
            case 0: {
                if (this.tabType == 19) {
                    return this.getZonesByHost();
                }
                return this.getHostContainerData();
            }
            case 2: {
                return this.getContainerTableData();
            }
            case 7: {
                if (this.tabType == 10) {
                    return this.getZonesByPool();
                }
                return this.getContainerTableData();
            }
            case 20: {
                if (this.tabType != 10) break;
                return this.getContainersInZone();
            }
        }
        return null;
    }

    private SCMTableData getHostContainerData() throws SMAPIException {
        SCMTableData sCMTableData = this.getHostActiveContainerData(null);
        SCMTableData sCMTableData2 = this.getInactiveContainerData();
        return this.combineTableData(sCMTableData, sCMTableData2);
    }

    private SCMTableData getContainersInPool() throws SMAPIException {
        String string = ((SCMResourcePoolTree)this.node).getName();
        SCMTableData sCMTableData = this.getHostActiveContainerData(string);
        SCMTableData sCMTableData2 = this.getInactiveContainerData();
        return this.combineTableData(sCMTableData, sCMTableData2);
    }

    private SCMTableData getContainersInZone() throws SMAPIException {
        long l = ((SCMZoneTree)this.node).getZoneID();
        SCMContainer[] sCMContainerArray = null;
        Vector vector = null;
        try {
            sCMContainerArray = this.scmservice.getContainersByZone(l);
        }
        catch (Exception exception) {
            Log.log((String)("SCMTableBuilder: === error to retreive container for node " + this.node.getName()));
            Log.log((String)SCMUtil.stackTrace2String(exception));
        }
        int n = sCMContainerArray == null ? 0 : sCMContainerArray.length;
        long[] lArray = new long[n];
        long[] lArray2 = new long[n];
        int n2 = 0;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<SCMContainer> arrayList3 = new ArrayList<SCMContainer>();
        if (sCMContainerArray != null) {
            vector = new Vector();
            int n3 = 0;
            while (n3 < sCMContainerArray.length) {
                long l2;
                long l3;
                SCMContainer sCMContainer = sCMContainerArray[n3];
                arrayList3.add(sCMContainer);
                lArray[n2] = l3 = sCMContainer.getContainerID();
                lArray2[n2] = l2 = sCMContainer.getProjectID();
                ++n2;
                String string = sCMContainer.getContainerHostName();
                int n4 = sCMContainer.getContainerPort();
                Vector<String> vector2 = new Vector<String>();
                String string2 = sCMContainer.getZoneName();
                String string3 = string2 + "," + l2;
                vector2.add(string3);
                vector2.add(string + ":" + n4);
                vector.add(vector2);
                ArrayList arrayList4 = this.container2ArrayList(sCMContainer, this.nodeType);
                arrayList.add(arrayList4);
                ArrayList<SMAlarmStatusData> arrayList5 = new ArrayList<SMAlarmStatusData>();
                SMAlarmStatusData sMAlarmStatusData = new SMAlarmStatusData("" + l2, null, "-INF-0", "", 0, -1);
                arrayList5.add(sMAlarmStatusData);
                arrayList5.add(sMAlarmStatusData);
                arrayList2.add(arrayList5);
                ++n3;
            }
            this.populateContainerDataFromAgent(arrayList, arrayList2, vector);
        }
        SCMTableData sCMTableData = new SCMTableData(arrayList, arrayList2, lArray, arrayList3);
        return sCMTableData;
    }

    private SCMTableData getFolderData() {
        Object object;
        if (this.node == null) {
            return null;
        }
        Vector vector = this.node.getChildren();
        if (vector == null || vector.size() == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<SCMTreeNode> arrayList2 = new ArrayList<SCMTreeNode>();
        long[] lArray = new long[vector.size()];
        CCI18N cCI18N = new CCI18N(RequestManager.getRequestContext(), "com.sun.web.admin.scm.common.Resources");
        int n = 0;
        while (n < vector.size()) {
            object = new ArrayList();
            SCMTreeNode sCMTreeNode = (SCMTreeNode)vector.get(n);
            arrayList2.add(sCMTreeNode);
            ((ArrayList)object).add(sCMTreeNode.getName());
            String string = "";
            if (sCMTreeNode.isFolder()) {
                string = "rootPane.folder";
            } else if (sCMTreeNode instanceof SCMHostTree) {
                String string2 = ((SCMHostTree)sCMTreeNode).getVersion();
                string = string2 + " " + cCI18N.getMessage("rootPane.system");
            } else {
                string = "rootPane.containerDefinition";
            }
            ((ArrayList)object).add(string);
            ((ArrayList)object).add("");
            lArray[n] = sCMTreeNode.getID();
            arrayList.add(object);
            ++n;
        }
        object = new SCMTableData(arrayList, null, lArray, arrayList2);
        return object;
    }

    private SCMTableData getContainerTableData() {
        SCMContainer sCMContainer;
        int n;
        long l = this.node.getID();
        SCMContainer[] sCMContainerArray = null;
        SCMContainer[] sCMContainerArray2 = null;
        Vector vector = null;
        try {
            sCMContainerArray = this.scmservice.getContainers(l, true);
        }
        catch (Exception exception) {
            Log.log((String)("SCMTableBuilder: === error to retreive active container for node " + this.node.getName()));
            Log.log((String)SCMUtil.stackTrace2String(exception));
        }
        try {
            sCMContainerArray2 = this.scmservice.getContainers(l, false);
        }
        catch (Exception exception) {
            Log.log((String)("SCMTableBuilder: error to retreive inactive containers for node " + this.node.getName()));
            Log.log((String)SCMUtil.stackTrace2String(exception));
        }
        int n2 = sCMContainerArray == null ? 0 : sCMContainerArray.length;
        int n3 = sCMContainerArray2 == null ? 0 : sCMContainerArray2.length;
        long[] lArray = new long[n2 + n3];
        long[] lArray2 = new long[n2 + n3];
        int n4 = 0;
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<SCMContainer> arrayList3 = new ArrayList<SCMContainer>();
        if (sCMContainerArray != null) {
            vector = new Vector();
            n = 0;
            while (n < sCMContainerArray.length) {
                long l2;
                long l3;
                sCMContainer = sCMContainerArray[n];
                arrayList3.add(sCMContainer);
                lArray[n4] = l3 = sCMContainer.getContainerID();
                lArray2[n4] = l2 = sCMContainer.getProjectID();
                ++n4;
                String string = sCMContainer.getContainerHostName();
                int n5 = sCMContainer.getContainerPort();
                Vector<String> vector2 = new Vector<String>();
                String string2 = sCMContainer.getZoneName();
                String string3 = string2 + "," + l2;
                vector2.add(string3);
                vector2.add(string + ":" + n5);
                vector.add(vector2);
                ArrayList arrayList4 = this.container2ArrayList(sCMContainer, this.nodeType);
                arrayList.add(arrayList4);
                ArrayList<SMAlarmStatusData> arrayList5 = new ArrayList<SMAlarmStatusData>();
                SMAlarmStatusData sMAlarmStatusData = new SMAlarmStatusData("" + l2, null, "-INF-0", "", 0, -1);
                arrayList5.add(sMAlarmStatusData);
                arrayList5.add(sMAlarmStatusData);
                arrayList2.add(arrayList5);
                ++n;
            }
            this.populateContainerDataFromAgent(arrayList, arrayList2, vector);
        }
        if (sCMContainerArray2 != null) {
            n = 0;
            while (n < sCMContainerArray2.length) {
                sCMContainer = sCMContainerArray2[n];
                arrayList3.add(sCMContainer);
                lArray[n4] = sCMContainer.getContainerID();
                lArray2[n4] = sCMContainer.getProjectID();
                ArrayList arrayList6 = this.container2ArrayList(sCMContainer, this.nodeType);
                arrayList.add(arrayList6);
                ArrayList<SMAlarmStatusData> arrayList7 = new ArrayList<SMAlarmStatusData>();
                SMAlarmStatusData sMAlarmStatusData = new SMAlarmStatusData("" + lArray2[n4], null, "-INF-0", "", 0, -1);
                arrayList7.add(sMAlarmStatusData);
                arrayList7.add(sMAlarmStatusData);
                arrayList2.add(arrayList7);
                ++n4;
                ++n;
            }
        }
        SCMTableData sCMTableData = new SCMTableData(arrayList, arrayList2, lArray, arrayList3);
        return sCMTableData;
    }

    public void populateContainerDataFromAgent(ArrayList arrayList, ArrayList arrayList2, Vector vector) {
        String[] stringArray = new String[]{"cpuUsage", "memRSS"};
        String[] stringArray2 = new String[]{"cpuUsage", "memRSS"};
        int[] nArray = new int[]{6, 8};
        if (vector == null || vector.size() == 0) {
            Log.log((String)" No active containers");
            return;
        }
        String string = "/mod/scm-container/Containers/ContTable/ContEntry/";
        int n = 0;
        while (n < vector.size()) {
            Object object;
            Vector vector2 = (Vector)vector.get(n);
            String string2 = (String)vector2.get(0);
            String string3 = (String)vector2.get(1);
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray3[n2] = "snmp://" + string3 + string + stringArray[n2] + "#" + string2;
                ++n2;
            }
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < stringArray2.length) {
                object = "snmp://" + string3 + string + stringArray[n4] + "#" + string2;
                stringArray3[n3 + n4] = SMRawDataRequest.buildShadowURL((String)object, (String)"tablestatus", null);
                ++n4;
            }
            object = this.getUrlsValue(stringArray3, 2000);
            if (object != null && ((StObject[][])object).length == stringArray3.length) {
                AbstractList abstractList;
                ArrayList arrayList3 = (ArrayList)arrayList.get(n);
                int n5 = 0;
                while (n5 < stringArray.length) {
                    abstractList = new Vector();
                    UcListUtil.decomposeList((String)object[n5][0].toString(), abstractList);
                    arrayList3.set(nArray[n5], (String)((Vector)abstractList).get(0));
                    ++n5;
                }
                abstractList = (ArrayList)arrayList2.get(n);
                int n6 = n3;
                while (n6 < ((StObject[][])object).length) {
                    SMAlarmStatusData sMAlarmStatusData = null;
                    sMAlarmStatusData = SMAlarmStatusData.buildStatusData((String)string2, (String)object[n6][0].toString(), (String)"");
                    ((ArrayList)abstractList).set(n6 - n3, sMAlarmStatusData);
                    ++n6;
                }
            }
            ++n;
        }
    }

    private ArrayList container2ArrayList(SCMContainer sCMContainer, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(sCMContainer.getProjectName());
        if (this.nodeType == 0 || this.nodeType == 7 || this.nodeType == 20) {
            arrayList.add(sCMContainer.getContainerName());
        } else {
            arrayList.add(sCMContainer.getHostName());
        }
        if (sCMContainer.getContainerStatus()) {
            arrayList.add("standard.active");
        } else {
            arrayList.add("standard.inactive");
        }
        arrayList.add(sCMContainer.getResourceName());
        arrayList.add(sCMContainer.getZoneName());
        arrayList.add("" + sCMContainer.getCPU());
        arrayList.add(sCMContainer.getCPUUsage());
        if (sCMContainer.getMemory() != 0) {
            arrayList.add("" + sCMContainer.getMemory());
        } else {
            arrayList.add("");
        }
        arrayList.add(sCMContainer.getMemRSS());
        if (sCMContainer.getMaxSHMemory() != 0L) {
            arrayList.add("" + sCMContainer.getMaxSHMemory());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    private ArrayList zoneNode2ArrayList(SCMZone sCMZone) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(sCMZone.getZoneName());
        arrayList.add(sCMZone.getEnumeratedState());
        arrayList.add(sCMZone.getZoneHostName());
        arrayList.add(sCMZone.getZonePath());
        arrayList.add(sCMZone.getZoneIP());
        arrayList.add(Float.toString(sCMZone.getMaxCPUShares()));
        arrayList.add(Float.toString(sCMZone.getUnusedCPUShares()));
        arrayList.add(Float.toString(sCMZone.getCPUShare()));
        arrayList.add(sCMZone.getPoolName());
        return arrayList;
    }

    private SCMTableData combineTableData(SCMTableData sCMTableData, SCMTableData sCMTableData2) {
        if (sCMTableData == null && sCMTableData2 == null) {
            return null;
        }
        if (sCMTableData == null && sCMTableData2 != null) {
            return sCMTableData2;
        }
        if (sCMTableData != null && sCMTableData2 == null) {
            return sCMTableData;
        }
        long[] lArray = sCMTableData.getPrimaryIndexes();
        long[] lArray2 = sCMTableData2.getPrimaryIndexes();
        long[] lArray3 = new long[lArray.length + lArray2.length];
        int n = 0;
        n = 0;
        while (n < lArray.length) {
            lArray3[n] = lArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < lArray2.length) {
            lArray3[n + n2] = lArray2[n2];
            ++n2;
        }
        ArrayList arrayList = (ArrayList)sCMTableData.getTableFieldData().clone();
        arrayList.addAll(sCMTableData2.getTableFieldData());
        ArrayList arrayList2 = (ArrayList)sCMTableData.getTableAlarmData().clone();
        arrayList2.addAll(sCMTableData2.getTableAlarmData());
        ArrayList arrayList3 = (ArrayList)sCMTableData.getUserData().clone();
        arrayList3.addAll(sCMTableData2.getUserData());
        return new SCMTableData(arrayList, arrayList2, lArray3, arrayList3);
    }

    private SCMTableData getHostActiveContainerData(String string) throws SMAPIException {
        SMAlarmStatusData sMAlarmStatusData;
        Object object;
        Object object2;
        if (!(this.node instanceof SCMHostTree)) {
            return null;
        }
        long l = ((SCMHostTree)this.node).getHostID();
        SCMContainer[] sCMContainerArray = null;
        sCMContainerArray = this.scmservice.getContainersByHost(l);
        if (sCMContainerArray == null || sCMContainerArray.length == 0) {
            Log.log((String)("SCMTableBuilder:getHostActiveContainerData no active container on host " + l));
            return null;
        }
        Vector<Long> vector = new Vector<Long>();
        Vector<Long> vector2 = new Vector<Long>();
        Vector<String> vector3 = new Vector<String>();
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<long[]> arrayList3 = new ArrayList<long[]>();
        int n = 0;
        while (n < sCMContainerArray.length) {
            object2 = sCMContainerArray[n];
            if (string == null || string != null && object2.getResourceName().equals(string)) {
                arrayList3.add((long[])object2);
                arrayList.add(this.container2ArrayList((SCMContainer)object2, this.nodeType));
                vector.add(new Long(object2.getContainerID()));
                vector2.add(new Long(object2.getProjectID()));
                vector3.add(object2.getZoneName());
                object = new ArrayList();
                sMAlarmStatusData = new SMAlarmStatusData("" + object2.getProjectID(), null, "-INF-0", "", 0, -1);
                ((ArrayList)object).add(sMAlarmStatusData);
                ((ArrayList)object).add(sMAlarmStatusData);
                arrayList2.add(object);
            }
            ++n;
        }
        object2 = new long[vector2.size()];
        object = new long[vector2.size()];
        sMAlarmStatusData = new String[vector2.size()];
        int n2 = 0;
        while (n2 < vector2.size()) {
            long l2 = 0L;
            long l3 = 0L;
            try {
                l2 = (Long)vector.get(n2);
                l3 = (Long)vector2.get(n2);
                sMAlarmStatusData[n2] = (String)vector3.get(n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object2[n2] = l2;
            object[n2] = l3;
            ++n2;
        }
        if (sCMContainerArray[0].getCPUUsage().equals("--")) {
            return new SCMTableData(arrayList, arrayList2, (long[])object2, arrayList3);
        }
        arrayList2 = new ArrayList();
        String string2 = this.node.getName();
        if (this.node instanceof SCMResourcePoolTree) {
            string2 = ((SCMHostTree)this.node.getParent()).getName();
        }
        int n3 = ((SCMHostTree)this.node).getPort();
        ArrayList arrayList4 = this.getAlarmData(string2, n3);
        int n4 = 0;
        while (n4 < ((long[])object).length) {
            int n5 = 0;
            while (n5 < arrayList4.size()) {
                ArrayList arrayList5 = (ArrayList)arrayList4.get(n5);
                SMAlarmStatusData sMAlarmStatusData2 = (SMAlarmStatusData)arrayList5.get(0);
                String string3 = sMAlarmStatusData2.getObjectId();
                if (this.alarmRowMatchesContainer(string3, (String)sMAlarmStatusData[n4], String.valueOf((long)object[n4]))) {
                    arrayList2.add((ArrayList)arrayList5.clone());
                }
                ++n5;
            }
            ++n4;
        }
        return new SCMTableData(arrayList, arrayList2, (long[])object2, arrayList3);
    }

    private SCMTableData getInactiveContainerData() throws SMAPIException {
        SCMContainer[] sCMContainerArray = null;
        sCMContainerArray = this.scmservice.getContainers(this.node.getID(), false);
        if (sCMContainerArray == null) {
            return null;
        }
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<SCMContainer> arrayList3 = new ArrayList<SCMContainer>();
        long[] lArray = new long[sCMContainerArray.length];
        int n = 0;
        while (n < sCMContainerArray.length) {
            long l;
            SCMContainer sCMContainer = sCMContainerArray[n];
            arrayList3.add(sCMContainer);
            lArray[n] = l = sCMContainer.getContainerID();
            ArrayList arrayList4 = this.container2ArrayList(sCMContainer, this.nodeType);
            arrayList.add(arrayList4);
            SMAlarmStatusData sMAlarmStatusData = new SMAlarmStatusData("" + l, null, "-INF-0", "", 0, -1);
            ArrayList<SMAlarmStatusData> arrayList5 = new ArrayList<SMAlarmStatusData>();
            arrayList5.add(sMAlarmStatusData);
            arrayList5.add(sMAlarmStatusData);
            arrayList2.add(arrayList5);
            ++n;
        }
        return new SCMTableData(arrayList, arrayList2, lArray, arrayList3);
    }

    private SCMTableData getZonesByPool() throws SMAPIException {
        long l = ((SCMResourcePoolTree)this.node).getResourcePoolID();
        SCMZone[] sCMZoneArray = null;
        try {
            sCMZoneArray = this.scmservice.getZonesByPool(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (sCMZoneArray == null || sCMZoneArray.length == 0) {
            Log.log((String)("SCMTableBuilder: getZones returned empty for resource pool: " + l));
            return null;
        }
        long[] lArray = new long[sCMZoneArray.length];
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        ArrayList<SCMZone> arrayList2 = new ArrayList<SCMZone>();
        int n = 0;
        while (n < sCMZoneArray.length) {
            SCMZone sCMZone = sCMZoneArray[n];
            arrayList2.add(sCMZone);
            arrayList.add(this.zoneNode2ArrayList(sCMZone));
            lArray[n] = sCMZone.getID();
            ++n;
        }
        return new SCMTableData(arrayList, null, lArray, arrayList2);
    }

    private SCMTableData getZonesByHost() throws SMAPIException {
        long l = ((SCMHostTree)this.node).getHostID();
        SCMZone[] sCMZoneArray = null;
        try {
            sCMZoneArray = this.scmservice.getZonesByHost(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (sCMZoneArray == null || sCMZoneArray.length == 0) {
            Log.log((String)("SCMTableBuilder: getZones returned empty for host: " + l));
            return null;
        }
        long[] lArray = new long[sCMZoneArray.length];
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        ArrayList<SCMZone> arrayList2 = new ArrayList<SCMZone>();
        int n = 0;
        while (n < sCMZoneArray.length) {
            SCMZone sCMZone = sCMZoneArray[n];
            arrayList2.add(sCMZone);
            arrayList.add(this.zoneNode2ArrayList(sCMZone));
            lArray[n] = sCMZone.getID();
            ++n;
        }
        return new SCMTableData(arrayList, null, lArray, arrayList2);
    }

    public ArrayList getAlarmData(String string, int n) {
        AbstractList abstractList;
        String string2 = "snmp://" + string + ":" + n + "/mod/scm-container/Containers/ContTable/ContEntry/";
        String[] stringArray = new String[]{"cpuUsage", "memRSS"};
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = string2 + stringArray[n2] + "?indtablestatus";
            ++n2;
        }
        StObject[][] stObjectArray = null;
        try {
            stObjectArray = this.rawHandle.getURLValue(stringArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (stObjectArray == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        try {
            abstractList = new Vector();
            Vector vector = new Vector();
            int n3 = 0;
            while (n3 < stObjectArray.length) {
                String string3 = stObjectArray[n3][0].toString();
                if (!UcListUtil.decomposeList((String)string3, abstractList)) {
                    return null;
                }
                ArrayList<SMAlarmStatusData> arrayList2 = new ArrayList<SMAlarmStatusData>();
                int n4 = 0;
                while (n4 < ((Vector)abstractList).size()) {
                    String string4;
                    String string5 = (String)((Vector)abstractList).elementAt(n4);
                    UcListUtil.decomposeList((String)string5, vector);
                    if (vector.size() == 1) {
                        string4 = (String)vector.elementAt(0);
                        UcListUtil.decomposeList((String)string5, vector);
                    }
                    if (vector.size() != 2) {
                        return null;
                    }
                    string4 = (String)vector.elementAt(0);
                    String string6 = (String)vector.elementAt(1);
                    arrayList2.add(SMAlarmStatusData.buildStatusData((String)string4, (String)string6, null));
                    ++n4;
                }
                arrayList.add(arrayList2);
                ++n3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        abstractList = new ArrayList();
        int n5 = 0;
        while (n5 < ((ArrayList)arrayList.get(0)).size()) {
            ArrayList arrayList3 = new ArrayList();
            int n6 = 0;
            while (n6 < arrayList.size()) {
                arrayList3.add(((ArrayList)arrayList.get(n6)).get(n5));
                ++n6;
            }
            ((ArrayList)abstractList).add(arrayList3);
            ++n5;
        }
        return abstractList;
    }

    public boolean alarmRowMatchesContainer(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() < 2) {
            return false;
        }
        return stringTokenizer.nextToken().equals(string2) && stringTokenizer.nextToken().equals(string3);
    }

    StObject[][] getUrlsValue(String[] stringArray, int n) {
        URLRetriever uRLRetriever = new URLRetriever(this.rawHandle, stringArray, n);
        Thread thread = new Thread((Runnable)uRLRetriever, "beginGetting");
        thread.start();
        return uRLRetriever.getValue();
    }

    class URLRetriever
    implements Runnable {
        SMRawDataRequest rhandle = null;
        String[] URLs = null;
        StObject[][] retValue = null;
        int time;

        public URLRetriever(SMRawDataRequest sMRawDataRequest, String[] stringArray, int n) {
            this.rhandle = sMRawDataRequest;
            this.URLs = stringArray;
            this.time = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StObject[][] stObjectArray = null;
            try {
                stObjectArray = this.rhandle.getURLValue(this.URLs);
            }
            catch (Exception exception) {
                stObjectArray = new StObject[0][0];
                Log.log((String)("SCMTableBuilder: error to get value " + this.URLs));
            }
            URLRetriever uRLRetriever = this;
            synchronized (uRLRetriever) {
                this.retValue = stObjectArray;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StObject[][] getValue() {
            URLRetriever uRLRetriever = this;
            synchronized (uRLRetriever) {
                if (this.retValue != null && this.retValue.length == 0) {
                    this.retValue = null;
                    return this.retValue;
                }
                try {
                    this.wait(this.time);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.retValue;
        }
    }
}

