/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.scm.ContainerGraph;

import com.iplanet.jato.Log;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.web.admin.scm.ContainerGraph.SCMSwingDataSource;
import com.sun.web.admin.scm.common.SCMUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;

public class SCMMIBDataUtil {
    SMRawDataRequest rawHandle = null;
    Timer timer = null;
    SCMSwingDataSource dataModel = null;
    String resourcePool = null;
    String host = null;
    String port = null;
    String projectID = null;
    String zoneName = null;
    String cpuUnits = null;
    String cpuUsage = null;
    String poolSize = null;
    String cpuReserved = null;
    String cpuOther = null;
    String memUnits = null;
    String systemMemory = null;
    String memoryCap = null;
    String memoryUsage = null;
    double[] Xseries = null;
    String graphType = null;
    boolean firstTime = true;
    double currentSeconds = 0.0;

    public SCMMIBDataUtil(SMRawDataRequest sMRawDataRequest, SCMSwingDataSource sCMSwingDataSource, String string, String string2, String string3, String string4, String string5, String string6, int n, double[] dArray) {
        this.rawHandle = sMRawDataRequest;
        this.dataModel = sCMSwingDataSource;
        this.graphType = string;
        this.projectID = string2;
        this.zoneName = string3;
        this.resourcePool = string4;
        this.host = string5;
        this.port = string6;
        this.Xseries = dArray;
        try {
            this.addData();
        }
        catch (Exception exception) {
            Log.log((String)SCMUtil.stackTrace2String(exception));
        }
        this.timer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SCMMIBDataUtil.this.addData();
                }
                catch (Exception exception) {
                    Log.log((String)SCMUtil.stackTrace2String(exception));
                }
            }
        });
        this.timer.start();
    }

    private void addData() throws SMAPIException {
        if (this.graphType.equals("CPU")) {
            this.addCPUData();
        } else if (this.graphType.equals("CPU_OTHER")) {
            this.addCPUOtherData();
        } else if (this.graphType.equals("MEMORY")) {
            this.addMEMData();
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.dataModel.getTableModel();
        defaultTableModel.fireTableDataChanged();
    }

    public void addCPUData() throws SMAPIException {
        Vector<Double> vector = new Vector<Double>(3);
        if (this.poolSize == null) {
            this.poolSize = this.getPoolSize(this.resourcePool, this.host, this.port);
        }
        if (this.poolSize != null) {
            vector.add(new Double(this.poolSize));
        } else {
            vector.add(new Double(Double.MAX_VALUE));
        }
        this.cpuUsage = this.getCPUUsage(this.zoneName, this.projectID, this.host, this.port);
        if (this.cpuUsage != null) {
            vector.add(new Double(this.cpuUsage));
        } else {
            vector.add(new Double(Double.MAX_VALUE));
        }
        if (this.cpuReserved == null) {
            this.cpuReserved = this.getCPUReserved(this.zoneName, this.projectID, this.host, this.port);
        }
        if (this.cpuReserved != null) {
            vector.add(new Double(this.cpuReserved));
        } else {
            vector.add(new Double(Double.MAX_VALUE));
        }
        if (this.cpuUnits == null) {
            this.cpuUnits = this.getCPUUnits(this.projectID, this.host, this.port);
        }
        if (this.firstTime) {
            this.firstTime = false;
            this.cpuOther = this.getTotalCPUOtherResourcePools(this.resourcePool, this.host, this.port);
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.dataModel.getTableModel();
        defaultTableModel.addRow(vector);
        Date date = new Date();
        double d = (double)date.getTime() / 1000.0;
        this.dataModel.addXseriesPoint(d, 0);
        this.currentSeconds = d;
    }

    public String getCPUUnits(String string, String string2, String string3) throws SMAPIException {
        String string4 = "snmp://" + string2 + ":" + string3 + "/mod/scm-container/Containers/ContTable/ContEntry/cpuUsage";
        String string5 = SMRawDataRequest.buildShadowURL((String)string4, (String)"units", null);
        String[] stringArray = new String[]{string5};
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray[0][0].toString().equals("")) {
            return null;
        }
        return stObjectArray[0][0].toString();
    }

    public String getCPUUsage(String string, String string2, String string3, String string4) throws SMAPIException {
        String[] stringArray = new String[]{"snmp://" + string3 + ":" + string4 + "/mod/scm-container"};
        String string5 = string + "," + string2;
        stringArray[0] = stringArray[0] + "/Containers/ContTable/ContEntry/cpuUsage#" + string5;
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray[0][0].toString().equals("")) {
            return null;
        }
        return stObjectArray[0][0].toString();
    }

    public String getCPUUnits() {
        return this.cpuUnits;
    }

    public String getCPUUsage() {
        return this.cpuUsage;
    }

    public String getCPUReserved(String string, String string2, String string3, String string4) throws SMAPIException {
        String[] stringArray = new String[]{"snmp://" + string3 + ":" + string4 + "/mod/scm-container"};
        String string5 = string + "," + string2;
        stringArray[0] = stringArray[0] + "/Containers/ContTable/ContEntry/cpuRes#" + string5;
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray[0][0].toString().equals("")) {
            return null;
        }
        return stObjectArray[0][0].toString();
    }

    public String getCPUReserved() {
        return this.cpuReserved;
    }

    public String getPoolSize(String string, String string2, String string3) throws SMAPIException {
        String[] stringArray = new String[]{"snmp://" + string2 + ":" + string3 + "/mod/scm-container"};
        stringArray[0] = stringArray[0] + "/Pools/PoolTable/PoolEntry/cpus#" + string;
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray[0][0].toString().equals("")) {
            return null;
        }
        return stObjectArray[0][0].toString();
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public void addCPUOtherData() throws SMAPIException {
        Vector<Double> vector = new Vector<Double>(1);
        if (this.cpuOther == null) {
            this.cpuOther = this.getTotalCPUOtherResourcePools(this.resourcePool, this.host, this.port);
        }
        if (this.cpuOther != null) {
            vector.add(new Double(this.cpuOther));
        } else {
            vector.add(new Double(Double.MAX_VALUE));
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.dataModel.getTableModel();
        defaultTableModel.addRow(vector);
        Date date = new Date();
        double d = Math.round(date.getTime() / 1000L);
        if (d == this.currentSeconds) {
            d += 1.0;
        }
        this.dataModel.addXseriesPoint(d, 0);
        this.currentSeconds = d;
    }

    public String getTotalCPUOtherResourcePools(String string, String string2, String string3) throws SMAPIException {
        if (this.cpuOther != null) {
            return this.cpuOther;
        }
        double d = 0.0;
        String[] stringArray = new String[]{"snmp://" + string2 + ":" + string3 + "/mod/scm-container"};
        stringArray[0] = stringArray[0] + "/Pools/PoolTable/PoolEntry/cpus";
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null) {
            return null;
        }
        Vector vector = new Vector();
        UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector);
        if (vector == null) {
            return null;
        }
        double d2 = 0.0;
        int n = 0;
        while (n < vector.size()) {
            Double d3 = new Double((String)vector.elementAt(n));
            d2 += d3.doubleValue();
            ++n;
        }
        double d4 = 0.0;
        if (this.poolSize == null) {
            stringArray[0] = "snmp://" + string2 + ":" + string3 + "/mod/scm-container";
            stringArray[0] = stringArray[0] + "/Pools/PoolTable/PoolEntry/cpus#" + string;
            stObjectArray = this.rawHandle.getURLValue(stringArray);
            if (stObjectArray != null) {
                d4 = new Double(stObjectArray[0][0].toString());
            }
        } else {
            d4 = new Double(this.poolSize);
        }
        if ((d = d2 - d4) > 0.0) {
            this.cpuOther = Double.toString(d);
            return this.cpuOther;
        }
        return "0";
    }

    public String getTotalCPUOtherResourcePools() {
        return this.cpuOther;
    }

    public void addMEMData() throws SMAPIException {
        Vector<Double> vector = new Vector<Double>(3);
        this.systemMemory = this.getSystemMemory(this.host, this.port);
        this.memoryCap = this.getMemoryCap(this.zoneName, this.projectID, this.host, this.port);
        this.memoryUsage = this.getMemoryUsage(this.zoneName, this.projectID, this.host, this.port);
        Double d = this.systemMemory == null ? new Double(Double.MAX_VALUE) : new Double(this.systemMemory);
        Double d2 = this.memoryCap == null ? new Double(Double.MAX_VALUE) : new Double(this.memoryCap);
        Double d3 = this.memoryUsage == null ? new Double(0.0) : new Double(this.memoryUsage);
        if (d3.compareTo(d) > 0 && d3.compareTo(d2) > 0) {
            d = d3;
        } else if (d2.compareTo(d) > 0) {
            d = d2;
        }
        if (this.memUnits == null) {
            this.memUnits = this.getMemoryUnits(this.projectID, this.host, this.port);
        }
        vector.add(d);
        vector.add(d3);
        vector.add(d2);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.dataModel.getTableModel();
        defaultTableModel.addRow(vector);
        Date date = new Date();
        double d4 = (double)date.getTime() / 1000.0;
        this.dataModel.addXseriesPoint(d4, 0);
        this.currentSeconds = d4;
    }

    public String getSystemMemory(String string, String string2) throws SMAPIException {
        if (this.systemMemory != null) {
            return this.systemMemory;
        }
        String[] stringArray = new String[]{"snmp://" + string + ":" + string2 + "/mod/scm-container"};
        stringArray[0] = stringArray[0] + "/System/Configuration/memory#0";
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray[0][0].toString().equals("")) {
            return null;
        }
        this.systemMemory = stObjectArray[0][0].toString();
        return this.systemMemory;
    }

    public String getSystemMemory() {
        return this.systemMemory;
    }

    public String getMemoryUnits(String string, String string2, String string3) throws SMAPIException {
        String string4 = "snmp://" + string2 + ":" + string3 + "/mod/scm-container/Containers/ContTable/ContEntry/memRSS";
        String string5 = SMRawDataRequest.buildShadowURL((String)string4, (String)"units", null);
        String[] stringArray = new String[]{string5};
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray[0][0].toString().equals("")) {
            return null;
        }
        return stObjectArray[0][0].toString();
    }

    public String getMemoryUsage(String string, String string2, String string3, String string4) throws SMAPIException {
        String[] stringArray = new String[]{"snmp://" + string3 + ":" + string4 + "/mod/scm-container"};
        String string5 = string + "," + string2;
        stringArray[0] = stringArray[0] + "/Containers/ContTable/ContEntry/memRSS#" + string5;
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray[0][0].toString().equals("")) {
            return null;
        }
        return stObjectArray[0][0].toString();
    }

    public String getMemoryUnits() {
        return this.memUnits;
    }

    public String getMemoryUsage() {
        return this.memoryUsage;
    }

    public String getMemoryCap(String string, String string2, String string3, String string4) throws SMAPIException {
        if (this.memoryCap != null) {
            return this.memoryCap;
        }
        String[] stringArray = new String[]{"snmp://" + string3 + ":" + string4 + "/mod/scm-container"};
        String string5 = string + "," + string2;
        stringArray[0] = stringArray[0] + "/Containers/ContTable/ContEntry/memCap#" + string5;
        StObject[][] stObjectArray = this.rawHandle.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray[0][0].toString().equals("")) {
            return null;
        }
        if (stObjectArray[0][0].toString().trim().length() == 0) {
            return new Double(0.0).toString();
        }
        this.memoryCap = stObjectArray[0][0].toString();
        return this.memoryCap;
    }

    public String getMemoryCap() {
        return this.memoryCap;
    }

    public void stopCollection() {
        Log.log((String)"Stopping the timer");
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }
}

