/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.admin.scm.ContainerGraph;

import com.iplanet.jato.Log;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.util.swing.encode.JCEncodeComponent;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.scm.report.SCMReportResult;
import com.sun.web.admin.scm.ContainerGraph.SCMDummyContainer;
import com.sun.web.admin.scm.ContainerGraph.SCMGraphDataModel;
import com.sun.web.admin.scm.ContainerGraph.SCMMIBDataUtil;
import com.sun.web.admin.scm.ContainerGraph.SCMSwingDataSource;
import com.sun.web.admin.scm.ContainerGraph.SCMSwingPRMDataSource;
import com.sun.web.admin.scm.common.SCMHandle;
import com.sun.web.admin.scm.common.SCMUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

public class SCMGraphFactory {
    SCMHandle scmHandle = null;
    String graphType = null;
    String containerID = null;
    String projectID = null;
    String zoneName = null;
    String resourcePool = null;
    String host = null;
    String port = null;
    int DATA_FETCH_INTERVAL = 30000;
    Color[][] seriesColors = null;
    JComponent component = null;
    SCMMIBDataUtil dataUtil = null;
    String yAxisText = "";
    Vector columnLabels = null;

    public SCMGraphFactory(SMRawDataRequest sMRawDataRequest, SCMHandle sCMHandle, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.graphType = string;
        this.containerID = string2;
        this.projectID = string3;
        this.zoneName = string4;
        this.resourcePool = string5;
        this.host = string6;
        this.port = string7;
        this.scmHandle = sCMHandle;
        Vector vector = this.getColumnNames(string);
        DefaultTableModel defaultTableModel = new DefaultTableModel(new Vector(), vector);
        String string8 = this.getDataSourceLabel();
        try {
            SCMSwingDataSource sCMSwingDataSource = new SCMSwingDataSource(defaultTableModel, null, string8);
            this.dataUtil = new SCMMIBDataUtil(sMRawDataRequest, sCMSwingDataSource, string, string3, string4, string5, string6, string7, this.DATA_FETCH_INTERVAL, null);
            if (string.equals("CPU_OTHER") && this.dataUtil.getTotalCPUOtherResourcePools().equals("0")) {
                return;
            }
            String string9 = this.getHeader(string, this.dataUtil);
            JCChart jCChart = this.createChart(sCMSwingDataSource, string9, string, this.dataUtil);
            this.component = jCChart;
        }
        catch (Exception exception) {
            Log.log((String)SCMUtil.stackTrace2String(exception));
        }
    }

    public SCMGraphFactory(SCMReportResult sCMReportResult, SCMHandle sCMHandle, String string) {
        this.scmHandle = sCMHandle;
        Vector vector = this.convertPRMDataToChartData(sCMReportResult);
        SCMGraphDataModel sCMGraphDataModel = new SCMGraphDataModel(vector);
        String string2 = sCMReportResult.getProperty().getPropertyName(null);
        String string3 = sCMReportResult.getProperty().getUnit();
        sCMGraphDataModel.setColumnLabels(this.columnLabels);
        sCMGraphDataModel.setModelLabel(string2);
        try {
            SCMSwingPRMDataSource sCMSwingPRMDataSource = new SCMSwingPRMDataSource(sCMGraphDataModel);
            JCChart jCChart = null;
            String string4 = "Unable to display graph. Daily graphs need upto 2 hours to be generated. Weekly/Monthly graphs need 24-48 hours or Object might be newly created or Inactive.";
            String string5 = "";
            try {
                string5 = sCMReportResult.toCSV(",", ",");
                string5 = string5.trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jCChart = string5 == null || string5.equals("") ? this.createErrorChart(string4) : this.createStackingAreaChart(sCMSwingPRMDataSource, string2, string3, string);
            this.component = jCChart;
        }
        catch (Exception exception) {
            Log.log((String)SCMUtil.stackTrace2String(exception));
        }
    }

    public SCMGraphFactory(SCMReportResult[] sCMReportResultArray, SCMHandle sCMHandle, String string) {
        this.scmHandle = sCMHandle;
        SCMSwingPRMDataSource[] sCMSwingPRMDataSourceArray = new SCMSwingPRMDataSource[sCMReportResultArray.length];
        SCMGraphDataModel[] sCMGraphDataModelArray = new SCMGraphDataModel[sCMReportResultArray.length];
        String string2 = null;
        String string3 = null;
        JCChart jCChart = null;
        int n = 0;
        while (n < sCMReportResultArray.length) {
            Vector vector = this.convertPRMDataToChartData(sCMReportResultArray[n]);
            sCMGraphDataModelArray[n] = new SCMGraphDataModel(vector);
            string2 = sCMReportResultArray[n].getProperty().getPropertyName(null);
            string3 = sCMReportResultArray[n].getProperty().getUnit();
            Vector<String> vector2 = new Vector<String>();
            vector2.add(sCMReportResultArray[n].getLegend());
            sCMGraphDataModelArray[n].setColumnLabels(vector2);
            sCMGraphDataModelArray[n].setModelLabel(string2);
            try {
                sCMSwingPRMDataSourceArray[n] = new SCMSwingPRMDataSource(sCMGraphDataModelArray[n]);
            }
            catch (Exception exception) {
                System.out.println("EXCEPTION WHILE CREATING ARRAY OF CHARTS " + exception.getMessage());
                exception.printStackTrace();
            }
            ++n;
        }
        try {
            jCChart = this.createTopNGraph(sCMSwingPRMDataSourceArray, string2, string3, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.component = jCChart;
    }

    public SCMGraphFactory(SCMHandle sCMHandle, String string) {
        JCChart jCChart = null;
        String string2 = "Unable to display graph. Daily graphs need upto 2 hours to be generated. Weekly/Monthly graphs need 24-48 hours or Object might be newly created or Inactive.";
        try {
            jCChart = this.createErrorChart(string2);
            this.component = jCChart;
        }
        catch (Exception exception) {
            Log.log((String)SCMUtil.stackTrace2String(exception));
        }
    }

    private JCChart createTopNGraph(SCMSwingPRMDataSource[] sCMSwingPRMDataSourceArray, String string, String string2, String string3) {
        JCChart jCChart = new JCChart();
        int n = sCMSwingPRMDataSourceArray.length;
        ChartDataView[] chartDataViewArray = new ChartDataView[sCMSwingPRMDataSourceArray.length];
        int n2 = 0;
        while (n2 < n) {
            chartDataViewArray[n2] = jCChart.addDataView(n2);
            chartDataViewArray[n2].setDataSource((ChartDataModel)sCMSwingPRMDataSourceArray[n2]);
            chartDataViewArray[n2].setChartType(0);
            chartDataViewArray[n2].setAutoLabel(true);
            chartDataViewArray[n2].getXAxis().setInsets(new Insets(10, 10, 10, 10));
            chartDataViewArray[n2].getChartStyle(0).setLineColor(this.getUIRBColor(n2));
            chartDataViewArray[n2].getChartStyle(0).setSymbolColor(this.getUIRBColor(n2));
            ((JLabel)jCChart.getHeader()).setText(string3);
            chartDataViewArray[n2].getYAxis().setInsets(new Insets(10, 10, 10, 10));
            chartDataViewArray[n2].getYAxis().getTitle().setPlacement(2);
            chartDataViewArray[n2].getYAxis().getTitle().setRotation(3);
            chartDataViewArray[n2].setName("");
            ++n2;
        }
        ((JLabel)jCChart.getHeader()).setVisible(true);
        Font font = Font.decode("Arial-BOLD-15");
        ((JLabel)jCChart.getHeader()).setFont(font);
        jCChart.setLayoutHints((JComponent)((JLabel)jCChart.getHeader()), new Rectangle(73, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        String string4 = string;
        if (string2 != null && !string2.equals("") && string.indexOf(string2) == -1) {
            string4 = string + " (" + string2 + ")";
        }
        font = new Font("test", 0, 10);
        jCChart.getChartArea().getXAxis(0).setTimeFormat("MMM d H:mm");
        jCChart.getChartArea().getXAxis(0).setAnnotationMethod(2);
        jCChart.getChartArea().getXAxis(0).setTimeBase(new Date(0L));
        jCChart.getChartArea().getXAxis(0).setFont(font);
        jCChart.getChartArea().getXAxis(0).setGridVisible(true);
        jCChart.getChartArea().getXAxis(0).setGridSpacingIsDefault(true);
        JCLineStyle jCLineStyle = new JCLineStyle(1, new Color(228, 228, 228), 1);
        jCChart.getChartArea().getXAxis(0).getGridStyle().setLineStyle(jCLineStyle);
        jCChart.getChartArea().getYAxis(0).setFont(font);
        jCChart.getChartArea().getYAxis(0).setGridVisible(true);
        jCChart.getChartArea().getYAxis(0).setGridSpacingIsDefault(true);
        jCChart.getChartArea().getYAxis(0).getGridStyle().setLineStyle(jCLineStyle);
        JCAxisTitle jCAxisTitle = new JCAxisTitle(string4);
        jCAxisTitle.setPlacement(32);
        jCAxisTitle.setRotation(3);
        font = new Font("Label_Font", 1, 11);
        jCAxisTitle.setFont(font);
        jCAxisTitle.setForeground(new Color(102, 102, 102));
        jCChart.getChartArea().getYAxis(0).setTitle(jCAxisTitle);
        JCAxisTitle jCAxisTitle2 = new JCAxisTitle("Time");
        jCAxisTitle2.setFont(font);
        jCAxisTitle2.setForeground(new Color(102, 102, 102));
        jCChart.getChartArea().getXAxis(0).setTitle(jCAxisTitle2);
        jCChart.getChartArea().getXAxis(0).setAnnotationRotation(0);
        jCChart.setPreferredSize(new Dimension(600, 300));
        jCChart.setSize(jCChart.getPreferredSize());
        jCChart.setBackground(Color.white);
        jCChart.setOpaque(true);
        jCChart.getChartArea().getPlotArea().setBackground(Color.white);
        jCChart.getChartArea().setOpaque(true);
        font = new Font("Text_Font", 0, 11);
        jCChart.getLegend().setFont(font);
        jCChart.getLegend().setBackground(Color.white);
        jCChart.getLegend().setOpaque(true);
        jCChart.getLegend().setForeground(Color.black);
        jCChart.getLegend().setVisible(true);
        jCChart.getLegend().setAnchor(32);
        return jCChart;
    }

    public Vector convertPRMDataToChartData(SCMReportResult sCMReportResult) {
        Object object;
        Vector vector = sCMReportResult.getReportData();
        this.columnLabels = new Vector();
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            object = (String)vector2.elementAt(0);
            if (!this.columnLabels.contains(object)) {
                this.columnLabels.add(object);
            }
            ++n;
        }
        int n2 = this.columnLabels.size();
        object = new Vector();
        int n3 = 0;
        while (n3 < n2) {
            Vector vector3 = new Vector();
            vector3.add(new Vector());
            vector3.add(new Vector());
            ((Vector)object).add(vector3);
            ++n3;
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            Vector vector4 = (Vector)vector.elementAt(n4);
            String string = (String)vector4.elementAt(0);
            Long l = new Long((String)vector4.elementAt(1));
            Double d = new Double(l.doubleValue());
            int n5 = this.columnLabels.indexOf(string);
            Vector vector5 = (Vector)((Vector)object).elementAt(n5);
            ((Vector)vector5.elementAt(0)).add(d);
            ((Vector)vector5.elementAt(1)).add(vector4.elementAt(2));
            ++n4;
        }
        return object;
    }

    public void encode(OutputStream outputStream) {
        try {
            if (this.component == null) {
                return;
            }
            Dimension dimension = this.component.getPreferredSize();
            Image image = this.snapshot(this.component, dimension);
            JCEncodeComponent.encode((JCEncodeComponent.Encoding)JCEncodeComponent.JPEG, (Image)image, (OutputStream)outputStream);
        }
        catch (Exception exception) {
            Log.log((String)SCMUtil.stackTrace2String(exception));
        }
    }

    public Image snapshot(JComponent jComponent, Dimension dimension) {
        Image image = null;
        try {
            image = new BufferedImage(dimension.width, dimension.height, 2);
        }
        catch (Exception exception) {
            Log.log((String)SCMUtil.stackTrace2String(exception));
            image = new JPanel().createImage(dimension.width, dimension.height);
        }
        SCMDummyContainer sCMDummyContainer = new SCMDummyContainer((BufferedImage)image);
        sCMDummyContainer.setBackground(Color.black);
        sCMDummyContainer.setPreferredSize(dimension);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        sCMDummyContainer.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        sCMDummyContainer.add((Component)jComponent, gridBagConstraints);
        jComponent.addNotify();
        sCMDummyContainer.pack();
        if (image != null) {
            Graphics graphics = sCMDummyContainer.getGraphics();
            graphics.setClip(0, 0, sCMDummyContainer.getSize().width, sCMDummyContainer.getSize().height);
            sCMDummyContainer.paint(graphics);
        }
        return image;
    }

    public JCChart createChart(SCMSwingDataSource sCMSwingDataSource, String string, String string2, SCMMIBDataUtil sCMMIBDataUtil) {
        JCChart jCChart = new JCChart();
        ChartDataView chartDataView = jCChart.getDataView(0);
        chartDataView.setChartType(0);
        chartDataView.setDataSource((ChartDataModel)sCMSwingDataSource);
        chartDataView.setAutoLabel(true);
        chartDataView.getChartStyle(0).setLineColor(new Color(0, 0, 255));
        chartDataView.getChartStyle(0).setSymbolColor(new Color(0, 0, 255));
        chartDataView.getChartStyle(0).setSymbolShape(2);
        if (string != null) {
            ((JLabel)jCChart.getHeader()).setText(string);
            ((JLabel)jCChart.getHeader()).setVisible(true);
        }
        Font font = Font.decode("Arial-BOLD-12");
        ((JLabel)jCChart.getHeader()).setFont(font);
        jCChart.setLayoutHints((JComponent)((JLabel)jCChart.getHeader()), new Rectangle(73, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        if (string2.equals("CPU")) {
            this.yAxisText = "CPU";
            this.yAxisText = this.yAxisText + " ( " + sCMMIBDataUtil.getCPUUnits() + " )";
        } else if (string2.equals("CPU_OTHER")) {
            this.yAxisText = "CPU";
            this.yAxisText = this.yAxisText + " ( " + sCMMIBDataUtil.getCPUUnits() + " )";
        } else if (string2.equals("MEMORY")) {
            this.yAxisText = "Memory";
            this.yAxisText = this.yAxisText + " ( " + sCMMIBDataUtil.getMemoryUnits() + " )";
        }
        font = new Font("test", 0, 10);
        jCChart.getChartArea().getXAxis(0).setTimeFormat("h:mma");
        jCChart.getChartArea().getXAxis(0).setAnnotationMethod(2);
        jCChart.getChartArea().getXAxis(0).setTimeBase(new Date(0L));
        jCChart.getChartArea().getXAxis(0).setTimeUnit(1000L);
        jCChart.getChartArea().getXAxis(0).setFont(font);
        jCChart.getChartArea().getXAxis(0).setGridVisible(true);
        jCChart.getChartArea().getXAxis(0).setGridSpacingIsDefault(true);
        chartDataView.getXAxis().setAnnotationRotation(0);
        JCLineStyle jCLineStyle = new JCLineStyle(1, new Color(228, 228, 228), 1);
        jCChart.getChartArea().getXAxis(0).getGridStyle().setLineStyle(jCLineStyle);
        jCChart.getChartArea().getXAxis(0).setPlacement(1);
        jCChart.getChartArea().getYAxis(0).setFont(font);
        jCChart.getChartArea().getYAxis(0).setGridVisible(true);
        jCChart.getChartArea().getYAxis(0).setGridSpacingIsDefault(true);
        jCChart.getChartArea().getYAxis(0).getGridStyle().setLineStyle(jCLineStyle);
        JCAxisTitle jCAxisTitle = new JCAxisTitle(this.yAxisText);
        font = new Font("Label_Font", 1, 11);
        jCAxisTitle.setFont(font);
        jCAxisTitle.setForeground(new Color(102, 102, 102));
        chartDataView.getYAxis().setTitle(jCAxisTitle);
        chartDataView.getYAxis().getTitle().setPlacement(2);
        chartDataView.getYAxis().getTitle().setRotation(3);
        chartDataView.getYAxis().setInsets(new Insets(10, 10, 10, 10));
        jCChart.getChartArea().getYAxis(0).setPlacement(1);
        JCAxisTitle jCAxisTitle2 = new JCAxisTitle("Time");
        jCAxisTitle2.setFont(font);
        jCAxisTitle2.setForeground(new Color(102, 102, 102));
        chartDataView.getXAxis().setInsets(new Insets(10, 10, 10, 10));
        chartDataView.getXAxis().setTitle(jCAxisTitle2);
        jCChart.setPreferredSize(new Dimension(600, 300));
        jCChart.setSize(jCChart.getPreferredSize());
        jCChart.setBackground(Color.white);
        jCChart.setOpaque(true);
        jCChart.getChartArea().getPlotArea().setBackground(Color.white);
        jCChart.getChartArea().setOpaque(true);
        font = new Font("Text_Font", 0, 11);
        jCChart.getLegend().setFont(font);
        jCChart.getLegend().setVisible(true);
        jCChart.getLegend().setBackground(Color.white);
        jCChart.getLegend().setOpaque(true);
        jCChart.getLegend().setForeground(Color.black);
        jCChart.getLegend().setAnchor(1);
        return jCChart;
    }

    public JCChart createErrorChart(String string) {
        JCChart jCChart = new JCChart();
        jCChart.setPreferredSize(new Dimension(1000, 50));
        jCChart.setSize(jCChart.getPreferredSize());
        jCChart.setBackground(Color.white);
        jCChart.setOpaque(true);
        jCChart.setVisible(true);
        ((JLabel)jCChart.getHeader()).setVisible(true);
        Font font = Font.decode("Arial-BOLD-11");
        ((JLabel)jCChart.getHeader()).setFont(font);
        ((JLabel)jCChart.getHeader()).setBackground(Color.WHITE);
        ((JLabel)jCChart.getHeader()).setForeground(Color.BLUE.darker().darker());
        ((JLabel)jCChart.getHeader()).setText(string);
        jCChart.setLayoutHints((JComponent)((JLabel)jCChart.getHeader()), new Rectangle(73, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        jCChart.getDataView(0).setVisible(false);
        jCChart.getChartArea().setVisible(false);
        return jCChart;
    }

    public JCChart createStackingAreaChart(SCMSwingPRMDataSource sCMSwingPRMDataSource, String string, String string2, String string3) {
        JCChart jCChart = new JCChart();
        jCChart.setVisible(false);
        ChartDataView chartDataView = jCChart.getDataView(0);
        chartDataView.setChartType(0);
        chartDataView.setDataSource((ChartDataModel)sCMSwingPRMDataSource);
        chartDataView.setAutoLabel(true);
        chartDataView.getXAxis().setInsets(new Insets(10, 10, 10, 10));
        chartDataView.getChartStyle(0).setLineColor(new Color(0, 0, 255));
        chartDataView.getChartStyle(0).setSymbolColor(new Color(0, 0, 255));
        chartDataView.getChartStyle(0).setSymbolShape(2);
        ((JLabel)jCChart.getHeader()).setText(string3);
        ((JLabel)jCChart.getHeader()).setVisible(true);
        Font font = Font.decode("Arial-BOLD-15");
        ((JLabel)jCChart.getHeader()).setFont(font);
        jCChart.setLayoutHints((JComponent)((JLabel)jCChart.getHeader()), new Rectangle(73, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        String string4 = string;
        if (string2 != null && !string2.equals("") && string.indexOf(string2) == -1) {
            string4 = string + " (" + string2 + ")";
        }
        font = new Font("test", 0, 10);
        jCChart.getChartArea().getXAxis(0).setTimeFormat("MMM d H:mm");
        jCChart.getChartArea().getXAxis(0).setAnnotationMethod(2);
        jCChart.getChartArea().getXAxis(0).setTimeBase(new Date(0L));
        jCChart.getChartArea().getXAxis(0).setFont(font);
        jCChart.getChartArea().getXAxis(0).setGridVisible(true);
        jCChart.getChartArea().getXAxis(0).setGridSpacingIsDefault(true);
        JCLineStyle jCLineStyle = new JCLineStyle(1, new Color(228, 228, 228), 1);
        jCChart.getChartArea().getXAxis(0).getGridStyle().setLineStyle(jCLineStyle);
        jCChart.getChartArea().getYAxis(0).setFont(font);
        jCChart.getChartArea().getYAxis(0).setGridVisible(true);
        jCChart.getChartArea().getYAxis(0).setGridSpacingIsDefault(true);
        jCChart.getChartArea().getYAxis(0).getGridStyle().setLineStyle(jCLineStyle);
        JCAxisTitle jCAxisTitle = new JCAxisTitle(string4);
        font = new Font("Label_Font", 1, 11);
        jCAxisTitle.setFont(font);
        jCAxisTitle.setForeground(new Color(102, 102, 102));
        chartDataView.getYAxis().setTitle(jCAxisTitle);
        chartDataView.getYAxis().setInsets(new Insets(10, 10, 10, 10));
        chartDataView.getYAxis().getTitle().setPlacement(2);
        chartDataView.getYAxis().getTitle().setRotation(3);
        JCAxisTitle jCAxisTitle2 = new JCAxisTitle("Time");
        jCAxisTitle2.setFont(font);
        jCAxisTitle2.setForeground(new Color(102, 102, 102));
        chartDataView.getXAxis().setTitle(jCAxisTitle2);
        chartDataView.getXAxis().setAnnotationRotation(0);
        jCChart.setPreferredSize(new Dimension(600, 300));
        jCChart.setSize(jCChart.getPreferredSize());
        jCChart.setBackground(Color.white);
        jCChart.setOpaque(true);
        jCChart.getChartArea().getPlotArea().setBackground(Color.white);
        jCChart.getChartArea().setOpaque(true);
        font = new Font("Text_Font", 0, 11);
        jCChart.getLegend().setFont(font);
        jCChart.getLegend().setVisible(false);
        jCChart.getLegend().setBackground(Color.white);
        jCChart.getLegend().setOpaque(true);
        jCChart.getLegend().setForeground(Color.black);
        jCChart.getLegend().setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        jCChart.setLayoutHints((JComponent)jCChart.getLegend(), new Rectangle(75, 335, Integer.MAX_VALUE, Integer.MAX_VALUE));
        jCChart.setVisible(true);
        return jCChart;
    }

    public Color[] getSeriesColors(String string) {
        if (this.seriesColors == null) {
            Color[][] colorArrayArray = new Color[][]{{Color.white, Color.gray, new Color(0, 0, 132)}, {Color.lightGray}, {Color.white, new Color(0, 0, 132), Color.gray}};
            this.seriesColors = colorArrayArray;
        }
        if (string.equals("CPU")) {
            return this.seriesColors[0];
        }
        if (string.equals("CPU_OTHER")) {
            return this.seriesColors[1];
        }
        if (string.equals("MEMORY")) {
            return this.seriesColors[2];
        }
        return null;
    }

    public int[] getFillPattern(String string) {
        int[][] nArrayArray = new int[][]{{1, 1, 3}, {1}, {1, 3, 1}};
        if (string.equals("CPU")) {
            return nArrayArray[0];
        }
        if (string.equals("CPU_OTHER")) {
            return nArrayArray[1];
        }
        if (string.equals("MEMORY")) {
            return nArrayArray[2];
        }
        return null;
    }

    public Vector getColumnNames(String string) {
        Vector<String> vector = new Vector<String>();
        if (string.equals("CPU")) {
            vector.add("Pool Size");
            vector.add("CPU Usage");
            vector.add("CPU Reservation");
        } else if (string.equals("CPU_OTHER")) {
            vector.add(SCMHandle.getI18nMsg("graph.cpu.other"));
        } else if (string.equals("MEMORY")) {
            vector.add("System Memory");
            vector.add("Memory Usage");
            vector.add("Memory Cap");
        }
        return vector;
    }

    public String getContainerID() {
        return this.containerID;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public String getDataSourceLabel() {
        if (this.graphType.equals("CPU")) {
            return "Resource Pool: " + this.resourcePool;
        }
        if (this.graphType.equals("CPU_OTHER")) {
            return "Other Resource Pools";
        }
        if (this.graphType.equals("MEMORY")) {
            return "Container ID: " + this.containerID;
        }
        return this.host;
    }

    public String getHeader(String string, SCMMIBDataUtil sCMMIBDataUtil) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equals("CPU")) {
            stringBuffer.append("<html><font color=black>");
            stringBuffer.append("Pool Size");
            stringBuffer.append(": ");
            stringBuffer.append(sCMMIBDataUtil.getPoolSize());
            stringBuffer.append(" (");
            stringBuffer.append(sCMMIBDataUtil.getCPUUnits());
            stringBuffer.append(")");
            stringBuffer.append(", ");
            stringBuffer.append("CPU Usage");
            stringBuffer.append(": ");
            stringBuffer.append(sCMMIBDataUtil.getCPUUsage());
            stringBuffer.append(" (");
            stringBuffer.append(sCMMIBDataUtil.getCPUUnits());
            stringBuffer.append(")");
            stringBuffer.append(", ");
            stringBuffer.append("CPU Reservation");
            stringBuffer.append(": ");
            stringBuffer.append(sCMMIBDataUtil.getCPUReserved());
            stringBuffer.append(" (");
            stringBuffer.append(sCMMIBDataUtil.getCPUUnits());
            stringBuffer.append(")");
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        if (string.equals("CPU_OTHER")) {
            stringBuffer.append("<html><font color=black>");
            stringBuffer.append("CPU Graph for other resource pools");
            stringBuffer.append(": ");
            stringBuffer.append(sCMMIBDataUtil.getTotalCPUOtherResourcePools());
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        if (string.equals("MEMORY")) {
            stringBuffer.append("<html><font color=black>");
            stringBuffer.append("System Memory");
            stringBuffer.append(": ");
            stringBuffer.append(sCMMIBDataUtil.getSystemMemory());
            stringBuffer.append(" (");
            stringBuffer.append(sCMMIBDataUtil.getMemoryUnits());
            stringBuffer.append(")");
            stringBuffer.append(", ");
            stringBuffer.append("Memory Usage");
            stringBuffer.append(": ");
            stringBuffer.append(sCMMIBDataUtil.getMemoryUsage());
            stringBuffer.append(" (");
            stringBuffer.append(sCMMIBDataUtil.getMemoryUnits());
            stringBuffer.append(")");
            stringBuffer.append(", ");
            stringBuffer.append("Memory Cap");
            stringBuffer.append(": ");
            stringBuffer.append(sCMMIBDataUtil.getMemoryCap());
            stringBuffer.append(" (");
            stringBuffer.append(sCMMIBDataUtil.getMemoryUnits());
            stringBuffer.append(")");
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        return null;
    }

    public void resetHeader() {
        String string = this.getHeader(this.graphType, this.dataUtil);
        if (this.component != null) {
            ((JLabel)((JCChart)this.component).getHeader()).setText(string);
        }
    }

    public void cleanUp() {
        this.dataUtil.stopCollection();
    }

    private Color getUIRBColor(int n) {
        Color[] colorArray = new Color[]{new Color(204, 0, 0), new Color(0, 0, 255), new Color(204, 153, 0), new Color(102, 153, 102), new Color(0, 0, 0), new Color(102, 153, 204)};
        if (n < colorArray.length && n >= 0) {
            return colorArray[n];
        }
        return colorArray[1];
    }

    public String getHost() {
        return this.host;
    }

    public String getZone() {
        return this.zoneName;
    }
}

