/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.report;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.report.SMReportCategory;
import com.sun.symon.base.client.report.SMReportData;
import com.sun.symon.base.client.report.SMReportFilter;
import com.sun.symon.base.client.report.SMReportFormat;
import com.sun.symon.base.client.report.SMReportGraphPresentation;
import com.sun.symon.base.client.report.SMReportProperty;
import com.sun.symon.base.client.report.SMReportPropertyGroup;
import com.sun.symon.base.client.report.SMReportRequest;
import com.sun.symon.base.client.report.SMReportTemplate;
import com.sun.symon.base.client.scm.common.SCMAPIException;
import com.sun.symon.base.client.scm.manager.SCMContainer;
import com.sun.symon.base.client.scm.report.SCMReportProperty;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.util.CrReportRequestParser;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.report.MrReportServiceImpl;
import com.sun.symon.base.mgmtservice.scm.manager.SCMDB;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportConstants;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportData;
import com.sun.symon.base.utility.UcInternationalizer;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class SCMSimpleRequest
implements SCMReportConstants {
    private SMDBObjectID[] requestID = null;
    private SMReportFilter filter = null;
    private SMReportTemplate template = null;
    private SMReportRequest request = null;
    private String[] agent_list = null;
    private MrReportServiceImpl rptService = null;
    private int propertyCount = 0;
    private static SCMDB dbobj = null;
    private MSLogPrintWriter logWriter;

    public SCMSimpleRequest(MrReportServiceImpl mrReportServiceImpl, String[] stringArray, Vector vector, String string, int n, Date date, Date date2, String string2, SMReportCategory sMReportCategory) throws SMAPIException, RemoteException {
        this.propertyCount = vector.size();
        this.requestID = new SMDBObjectID[this.propertyCount];
        SCMServiceController sCMServiceController = SCMServiceController.getInstance();
        this.logWriter = sCMServiceController.getLogWriter();
        this.logWriter.println("SCMSimpleRequest init");
        this.rptService = mrReportServiceImpl;
        this.agent_list = stringArray;
        int n2 = 0;
        while (n2 < this.propertyCount) {
            SMReportPropertyGroup sMReportPropertyGroup = (SMReportPropertyGroup)vector.elementAt(n2);
            this.filter = new SMReportFilter(null, string, n, date, date2);
            SMReportGraphPresentation sMReportGraphPresentation = new SMReportGraphPresentation("", "", "");
            SMReportFormat sMReportFormat = null;
            sMReportFormat = string2.compareTo("Performance Request") == 0 ? new SMReportFormat("LINE_GRAPH", 0, sMReportGraphPresentation) : new SMReportFormat("TABULAR", 0, sMReportGraphPresentation);
            this.template = new SMReportTemplate(sMReportPropertyGroup, this.filter, sMReportFormat);
            String string3 = "##SCMRequest." + System.currentTimeMillis();
            this.request = new SMReportRequest(string3, string2, sMReportCategory, null, null, 5, this.template);
            this.request.setRequestType(1);
            this.requestID[n2] = mrReportServiceImpl.save(this.request);
            this.request = mrReportServiceImpl.getReportRequest(this.requestID[n2]);
            ++n2;
        }
    }

    public SCMReportData[] run() throws SCMAPIException, RemoteException, SMAPIException {
        Object object;
        SMReportData sMReportData = null;
        int n = 0;
        Vector<SCMReportData> vector = new Vector<SCMReportData>();
        CrReportRequestParser crReportRequestParser = null;
        Date date = null;
        Date date2 = null;
        n = 0;
        while (n < this.propertyCount) {
            this.request = this.rptService.getReportRequest(this.requestID[n]);
            crReportRequestParser = new CrReportRequestParser(this.request);
            date = crReportRequestParser.getStartDate();
            date2 = crReportRequestParser.getEndDate();
            try {
                sMReportData = this.rptService.runReportRequest(this.requestID[n], 0, this.agent_list, date, date2, null, null, 0);
            }
            catch (UnknownHostException unknownHostException) {
                String string = "The host name is not valid.";
                this.logWriter.println(string);
                throw new SCMAPIException(3, string);
            }
            if (sMReportData.isEmptyData()) {
                object = "The result is empty for one of the properties.";
                this.logWriter.println((String)object);
                throw new SCMAPIException(3, (String)object);
            }
            if (sMReportData.isMaxRecordsReached()) {
                object = "Max Record reached.";
                this.logWriter.println((String)object);
                throw new SCMAPIException(4, (String)object);
            }
            object = sMReportData.getPropertyList();
            if (object == null || ((Vector)object).size() == 0) {
                SCMReportData[] sCMReportDataArray = new SCMReportData[]{new SCMReportData()};
                return sCMReportDataArray;
            }
            boolean bl = false;
            long l = 0L;
            StringTokenizer stringTokenizer = new StringTokenizer(this.agent_list[0], ":");
            String string = null;
            try {
                string = stringTokenizer.countTokens() > 1 ? stringTokenizer.nextToken() : this.agent_list[0];
                l = SCMDB.getHostID(string);
            }
            catch (Exception exception) {
                bl = true;
                this.logWriter.println("Error while getting the host id for run report request");
                this.logWriter.println((Throwable)exception);
                this.logWriter.println("Will not be able to get container names");
            }
            int n2 = 0;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            long l2 = 0L;
            SCMContainer[] sCMContainerArray = null;
            Vector[] vectorArray = new Vector[2];
            SMReportProperty sMReportProperty = null;
            int n3 = 0;
            int n4 = 0;
            while (n4 < vectorArray.length) {
                vectorArray[n4] = new Vector();
                ++n4;
            }
            int n5 = 0;
            while (n5 < ((Vector)object).size()) {
                sMReportProperty = (SMReportProperty)((Vector)object).elementAt(n5);
                string3 = sMReportProperty.getPropertyName();
                string4 = sMReportProperty.getPropertyInstance();
                try {
                    n3 = string4.indexOf(44);
                    l2 = n3 > -1 ? new Long(string4.substring(n3 + 1)).longValue() : new Long(string4).longValue();
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    this.logWriter.println("Error while getting the projectID for run report request");
                    this.logWriter.println((Throwable)numberFormatException);
                    this.logWriter.println("Will not be able to get container names");
                }
                if (n5 == 0) {
                    string2 = string3;
                }
                if (!string3.equals(string2)) break;
                ++n2;
                if (!bl) {
                    try {
                        sCMContainerArray = SCMDB.getContainersByProjectHost(l2, l);
                        vectorArray[0].add(string4);
                        vectorArray[1].add(sCMContainerArray[0].getMasterName());
                    }
                    catch (Exception exception) {
                        this.logWriter.println("Error while getting the container names for run report request");
                        this.logWriter.println((Throwable)exception);
                        this.logWriter.println("Will not be able to add container names to the data to be exported.");
                    }
                }
                ++n5;
            }
            this.logWriter.println("SCMSimpleRequest run: Setting the data");
            this.logWriter.println("Total instances:" + n2);
            SCMReportData sCMReportData = new SCMReportData(sMReportData.getReportData(), n2, vectorArray);
            vector.add(sCMReportData);
            ++n;
        }
        object = new SCMReportData[this.propertyCount];
        object = vector.toArray((T[])object);
        return object;
    }

    public SCMReportData[] run(int n, int n2, int n3) throws SCMAPIException, RemoteException, SMAPIException {
        CrReportRequestParser crReportRequestParser;
        SMReportData sMReportData = null;
        int n4 = 0;
        Vector<SCMReportData> vector = new Vector<SCMReportData>();
        n4 = 0;
        while (n4 < this.propertyCount) {
            Object object;
            SCMReportData[] sCMReportDataArray;
            this.request = this.rptService.getReportRequest(this.requestID[n4]);
            crReportRequestParser = new CrReportRequestParser(this.request);
            Date date = crReportRequestParser.getStartDate();
            Date date2 = crReportRequestParser.getEndDate();
            try {
                sMReportData = this.rptService.runReportRequest(this.requestID[n4], this.agent_list, date, date2, null, n, n2, n3);
            }
            catch (UnknownHostException unknownHostException) {
                sCMReportDataArray = "The host name is not valid.";
                this.logWriter.println((String)sCMReportDataArray);
                throw new SCMAPIException(3, (String)sCMReportDataArray);
            }
            if (sMReportData == null || sMReportData.isEmptyData()) {
                object = "The result is empty for one of the properties.";
                this.logWriter.println((String)object);
                throw new SCMAPIException(3, (String)object);
            }
            if (sMReportData.isMaxRecordsReached()) {
                object = "Max Record reached.";
                this.logWriter.println((String)object);
                throw new SCMAPIException(4, (String)object);
            }
            object = sMReportData.getPropertyList();
            if (object == null || ((Vector)object).size() == 0) {
                sCMReportDataArray = new SCMReportData[]{new SCMReportData()};
                return sCMReportDataArray;
            }
            this.logWriter.println("SCMSimpleRequest run: Property list size: " + ((Vector)object).size());
            sCMReportDataArray = (SCMReportData[])((Vector)object).elementAt(0);
            String string = sCMReportDataArray.getPropertyName();
            String string2 = sCMReportDataArray.getI18nKey();
            if (string2 != null) {
                string = UcInternationalizer.translateKey((Locale)Locale.getDefault(), (String)string2, (String)string);
            }
            SCMReportProperty sCMReportProperty = new SCMReportProperty(string, sCMReportDataArray.getUnit());
            sCMReportProperty.setI18nKey(string2);
            SCMReportData sCMReportData = new SCMReportData(sMReportData.getReportData(), sCMReportProperty);
            vector.add(sCMReportData);
            ++n4;
        }
        crReportRequestParser = new SCMReportData[this.propertyCount];
        crReportRequestParser = vector.toArray((T[])crReportRequestParser);
        return crReportRequestParser;
    }

    public SCMReportData[] run(int n, int n2) throws SCMAPIException, RemoteException, SMAPIException {
        CrReportRequestParser crReportRequestParser;
        SMReportData sMReportData = null;
        int n3 = 0;
        Vector<SCMReportData> vector = new Vector<SCMReportData>();
        Vector vector2 = null;
        n3 = 0;
        while (n3 < this.propertyCount) {
            Object object;
            this.request = this.rptService.getReportRequest(this.requestID[n3]);
            crReportRequestParser = new CrReportRequestParser(this.request);
            Date date = crReportRequestParser.getStartDate();
            Date date2 = crReportRequestParser.getEndDate();
            SMReportFilter sMReportFilter = this.request.getTemplate().getFilter();
            sMReportFilter.setStartDate(date);
            sMReportFilter.setEndDate(date2);
            this.request.getTemplate().setFilter(sMReportFilter);
            try {
                sMReportData = this.rptService.runReportRequest(this.request, this.agent_list, n, n2);
            }
            catch (UnknownHostException unknownHostException) {
                String string = "The host name is not valid.";
                this.logWriter.println(string);
                throw new SCMAPIException(3, string);
            }
            if (sMReportData == null || sMReportData.isEmptyData()) {
                object = "The result is empty for one of the properties.";
                this.logWriter.println((String)object);
                throw new SCMAPIException(3, (String)object);
            }
            if (sMReportData.isMaxRecordsReached()) {
                object = "Max Record reached.";
                this.logWriter.println((String)object);
                throw new SCMAPIException(4, (String)object);
            }
            vector2 = sMReportData.getPropertyList();
            if (vector2 == null || vector2.size() == 0) {
                object = new SCMReportData[]{new SCMReportData()};
                return object;
            }
            this.logWriter.println("SCMSimpleRequest run: Property list size: " + vector2.size());
            object = sMReportData.getReportData();
            boolean bl = false;
            int n4 = 0;
            while (n4 <= vector2.size() - 1) {
                SMReportProperty sMReportProperty = (SMReportProperty)vector2.elementAt(n4);
                String string = sMReportProperty.getPropertyName();
                String string2 = sMReportProperty.getI18nKey();
                if (string2 != null) {
                    string = UcInternationalizer.translateKey((Locale)Locale.getDefault(), (String)string2, (String)string);
                }
                SCMReportProperty sCMReportProperty = new SCMReportProperty(string, sMReportProperty.getUnit());
                sCMReportProperty.setI18nKey(string2);
                Vector vector3 = this.getFormatedDataVector(sMReportData.getReportData(), n4);
                SCMReportData sCMReportData = new SCMReportData(vector3, sCMReportProperty, sMReportProperty.getPropertyInstance());
                vector.add(sCMReportData);
                ++n4;
            }
            ++n3;
        }
        crReportRequestParser = new SCMReportData[vector2.size()];
        crReportRequestParser = vector.toArray((T[])crReportRequestParser);
        return crReportRequestParser;
    }

    private Vector getFormatedDataVector(Vector vector, int n) {
        int n2 = ((Vector)vector.get(0)).size() - 2;
        n += 2;
        Vector vector2 = new Vector(n2);
        int n3 = 0;
        while (n3 <= vector.size() - 1) {
            Vector vector3 = new Vector();
            vector3.add(0, ((Vector)vector.get(n3)).get(0));
            vector3.add(1, ((Vector)vector.get(n3)).get(1));
            vector3.add(2, ((Vector)vector.get(n3)).get(n));
            vector2.add(vector3);
            ++n3;
        }
        return vector2;
    }

    public void deleteRequest() {
        this.logWriter.println("delete requests ...");
        try {
            int n = 0;
            while (n < this.propertyCount) {
                this.rptService.deleteReportRequest(this.requestID[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            this.logWriter.println((Throwable)exception);
        }
    }

    public String[] getTargetHosts() {
        return this.agent_list;
    }

    static {
        dbobj = new SCMDB();
    }
}

