/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.report;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.scm.common.SCMAPIException;
import com.sun.symon.base.client.scm.manager.SCMContainer;
import com.sun.symon.base.client.scm.manager.SCMContainerTree;
import com.sun.symon.base.client.scm.manager.SCMHostTree;
import com.sun.symon.base.client.scm.manager.SCMResourcePoolTree;
import com.sun.symon.base.client.scm.manager.SCMTreeNode;
import com.sun.symon.base.client.scm.manager.SCMZoneTree;
import com.sun.symon.base.client.scm.report.SCMReportResult;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceImpl;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportConstants;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportController;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.TreeMap;
import java.util.Vector;

public class SCMReportDispatcher
implements SCMReportConstants,
com.sun.symon.base.client.scm.report.SCMReportConstants {
    MSLogPrintWriter logWriter;
    SCMServiceImpl scmService;
    SCMReportController reportController;

    public SCMReportDispatcher(SCMServiceImpl sCMServiceImpl, SCMReportController sCMReportController) {
        this.reportController = sCMReportController;
        this.scmService = sCMServiceImpl;
        this.logWriter = SCMServiceController.getInstance().getLogWriter();
    }

    public SCMReportResult[] runPerformanceReport(SCMTreeNode sCMTreeNode, Vector vector, String string, int n, Date date, Date date2, int n2, int n3, int n4) throws IllegalArgumentException, SCMAPIException, RemoteException, SMAPIException {
        if (sCMTreeNode instanceof SCMZoneTree) {
            return this.runZoneNodeReport((SCMZoneTree)sCMTreeNode, vector, string, n, date, date2, n2, n3, n4);
        }
        if (sCMTreeNode instanceof SCMResourcePoolTree) {
            return this.runPoolNodeReport((SCMResourcePoolTree)sCMTreeNode, vector, string, n, date, date2, n2, n3, n4);
        }
        if (sCMTreeNode instanceof SCMHostTree && !sCMTreeNode.isFolder()) {
            return this.runHostNodeReport((SCMHostTree)sCMTreeNode, vector, string, n, date, date2, n2, n3, n4);
        }
        if (sCMTreeNode instanceof SCMContainerTree && !sCMTreeNode.isFolder()) {
            return this.runContainerMasterNodeReport((SCMContainerTree)sCMTreeNode, vector, string, n, date, date2, n2, n3, n4);
        }
        if (sCMTreeNode.isFolder()) {
            if (sCMTreeNode instanceof SCMHostTree) {
                return this.runHostFolderReport((SCMHostTree)sCMTreeNode, vector, string, n, date, date2, n2, n3, n4);
            }
            return this.runContainerFolderReport((SCMContainerTree)sCMTreeNode, vector, string, n, date, date2, n2, n3, n4);
        }
        return null;
    }

    public SCMReportResult[] runZoneNodeReport(SCMZoneTree sCMZoneTree, Vector vector, String string, int n, Date date, Date date2, int n2, int n3, int n4) throws IllegalArgumentException, SCMAPIException, RemoteException, SMAPIException {
        String string2;
        Vector<String> vector2 = new Vector<String>();
        SCMContainer[] sCMContainerArray = null;
        long l = -1L;
        try {
            l = sCMZoneTree.getZoneID();
            sCMContainerArray = this.scmService.getContainersByZone(l);
        }
        catch (Exception exception) {
            String string3 = "Database exception: getContainersByZone";
            this.logWriter.println(string3);
            throw new SMAPIException(1, string3);
        }
        if (sCMContainerArray != null) {
            int n5 = 0;
            while (n5 < sCMContainerArray.length) {
                string2 = sCMContainerArray[n5].getContainerMasterName();
                if (!vector2.contains(string2)) {
                    vector2.add(string2);
                }
                ++n5;
            }
        }
        if (vector2.size() == 0) {
            String string4 = "The result is empty.";
            this.logWriter.println(string4);
            throw new SCMAPIException(3, string4);
        }
        String[] stringArray = new String[vector2.size()];
        stringArray = vector2.toArray(stringArray);
        string2 = sCMZoneTree.getName();
        SCMReportResult[] sCMReportResultArray = this.reportController.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, false);
        if (sCMReportResultArray != null && sCMReportResultArray.length != 0) {
            sCMReportResultArray[0].setLegend("zone:" + sCMZoneTree.getName());
        }
        if (n4 == 7) {
            return sCMReportResultArray;
        }
        if (n4 == 6) {
            return this.reportController.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, false, n2, n3);
        }
        throw new IllegalArgumentException("report.invalid.subObject");
    }

    public SCMReportResult[] runPoolNodeReport(SCMResourcePoolTree sCMResourcePoolTree, Vector vector, String string, int n, Date date, Date date2, int n2, int n3, int n4) throws IllegalArgumentException, SCMAPIException, RemoteException, SMAPIException {
        this.logWriter.println(" === run pool node report ==");
        SCMContainer[] sCMContainerArray = null;
        long l = -1L;
        try {
            l = sCMResourcePoolTree.getResourcePoolID();
            sCMContainerArray = this.scmService.getContainersByPool(l);
        }
        catch (Exception exception) {
            String string2 = "Database exception: getContainersByPool";
            this.logWriter.println(string2);
            throw new SMAPIException(1, string2);
        }
        if (sCMContainerArray == null || sCMContainerArray.length == 0) {
            String string3 = "NO container for the give pool";
            this.logWriter.println(string3);
            throw new SCMAPIException(3, string3);
        }
        SCMReportResult[] sCMReportResultArray = this.reportController.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, false);
        if (sCMReportResultArray != null && sCMReportResultArray.length != 0) {
            sCMReportResultArray[0].setLegend("pool:" + sCMResourcePoolTree.getName());
        }
        if (n4 == 7) {
            return sCMReportResultArray;
        }
        if (n4 == 5) {
            Vector vector2 = sCMResourcePoolTree.getChildren();
            if (vector2 == null || vector2.size() == 0) {
                return sCMReportResultArray;
            }
            Vector<SCMReportResult> vector3 = new Vector<SCMReportResult>();
            int n5 = 0;
            while (n5 < vector2.size()) {
                block12: {
                    SCMZoneTree sCMZoneTree = (SCMZoneTree)vector2.get(n5);
                    SCMReportResult[] sCMReportResultArray2 = null;
                    try {
                        sCMReportResultArray2 = this.runZoneNodeReport(sCMZoneTree, vector, string, n, date, date2, n2, n3, 7);
                    }
                    catch (Exception exception) {
                        break block12;
                    }
                    if (sCMReportResultArray2 != null && sCMReportResultArray2.length != 0) {
                        vector3.add(sCMReportResultArray2[0]);
                    }
                }
                ++n5;
            }
            return this.constructTopNResult(vector3, sCMReportResultArray, n2, n3);
        }
        if (n4 == 6) {
            return this.reportController.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, false, n3, n2);
        }
        throw new IllegalArgumentException("report.invalid.subObject");
    }

    private SCMReportResult[] runHostNodeReport(SCMHostTree sCMHostTree, Vector vector, String string, int n, Date date, Date date2, int n2, int n3, int n4) throws IllegalArgumentException, SCMAPIException, RemoteException, SMAPIException {
        SCMReportResult[] sCMReportResultArray;
        SCMContainer[] sCMContainerArray = null;
        try {
            sCMContainerArray = this.scmService.getContainers(sCMHostTree.getID(), true);
        }
        catch (Exception exception) {
            String string2 = "Database exception: getContainers";
            this.logWriter.println(string2);
            throw new SCMAPIException(1, string2);
        }
        if (sCMContainerArray == null || sCMContainerArray.length == 0) {
            String string3 = "The result is empty.";
            this.logWriter.println(string3);
            throw new SCMAPIException(3, string3);
        }
        boolean bl = false;
        if (sCMContainerArray.length == 1) {
            bl = true;
        }
        if ((sCMReportResultArray = this.reportController.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, bl)) != null && sCMReportResultArray.length != 0) {
            sCMReportResultArray[0].setLegend("host:" + sCMHostTree.getName());
        }
        Vector vector2 = sCMHostTree.getChildren();
        if (n4 == 7) {
            return sCMReportResultArray;
        }
        if (n4 == 4) {
            this.logWriter.println("generating top n resource pools report");
            if (vector2 == null || vector2.size() == 0) {
                return sCMReportResultArray;
            }
            Vector<SCMReportResult> vector3 = new Vector<SCMReportResult>();
            int n5 = 0;
            while (n5 < vector2.size()) {
                block22: {
                    SCMResourcePoolTree sCMResourcePoolTree = (SCMResourcePoolTree)vector2.get(n5);
                    SCMReportResult[] sCMReportResultArray2 = null;
                    try {
                        sCMReportResultArray2 = this.runPoolNodeReport(sCMResourcePoolTree, vector, string, n, date, date2, n2, n3, 7);
                    }
                    catch (Exception exception) {
                        break block22;
                    }
                    if (sCMReportResultArray2 != null && sCMReportResultArray2.length != 0) {
                        vector3.add(sCMReportResultArray2[0]);
                    }
                }
                ++n5;
            }
            return this.constructTopNResult(vector3, sCMReportResultArray, n2, n3);
        }
        if (n4 == 5) {
            Object object;
            Vector vector4 = sCMHostTree.getChildren();
            if (vector4 == null || vector4.size() == 0) {
                return null;
            }
            Vector vector5 = new Vector();
            int n6 = 0;
            while (n6 < vector4.size()) {
                object = (SCMTreeNode)vector4.get(n6);
                Vector vector6 = object.getChildren();
                if (vector6 != null) {
                    vector5.addAll(vector6);
                }
                ++n6;
            }
            if (vector5.size() == 0) {
                return sCMReportResultArray;
            }
            object = new Vector();
            int n7 = 0;
            while (n7 < vector5.size()) {
                block23: {
                    SCMZoneTree sCMZoneTree = (SCMZoneTree)vector5.get(n7);
                    SCMReportResult[] sCMReportResultArray3 = null;
                    try {
                        sCMReportResultArray3 = this.runZoneNodeReport(sCMZoneTree, vector, string, n, date, date2, n2, n3, 7);
                    }
                    catch (Exception exception) {
                        break block23;
                    }
                    if (sCMReportResultArray3 != null && sCMReportResultArray3.length != 0) {
                        ((Vector)object).add(sCMReportResultArray3[0]);
                    }
                }
                ++n7;
            }
            return this.constructTopNResult((Vector)object, sCMReportResultArray, n2, n3);
        }
        if (n4 == 6) {
            return this.reportController.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, false, n3, n2);
        }
        throw new IllegalArgumentException("report.invalid.subObject");
    }

    private SCMReportResult[] runContainerMasterNodeReport(SCMContainerTree sCMContainerTree, Vector vector, String string, int n, Date date, Date date2, int n2, int n3, int n4) throws IllegalArgumentException, SCMAPIException, RemoteException, SMAPIException {
        SCMContainer[] sCMContainerArray = this.scmService.getContainers(sCMContainerTree.getID(), true);
        if (sCMContainerArray == null || sCMContainerArray.length == 0) {
            String string2 = "The result is empty.";
            this.logWriter.println(string2);
            throw new SCMAPIException(3, string2);
        }
        SCMReportResult[] sCMReportResultArray = this.reportController.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, false);
        if (sCMReportResultArray != null && sCMReportResultArray.length != 0) {
            sCMReportResultArray[0].setLegend("Container Template: " + sCMContainerTree.getName());
        }
        if (n4 == 7) {
            return sCMReportResultArray;
        }
        if (n4 == 6) {
            return this.reportController.runPerformanceReport(sCMContainerArray, vector, string, n, date, date2, false, n3, n2);
        }
        throw new IllegalArgumentException("report.invalid.subObject");
    }

    private SCMReportResult[] runHostFolderReport(SCMHostTree sCMHostTree, Vector vector, String string, int n, Date date, Date date2, int n2, int n3, int n4) throws IllegalArgumentException, SCMAPIException, RemoteException, SMAPIException {
        Vector vector2 = sCMHostTree.getChildren();
        if (vector2 == null || vector2.size() == 0) {
            String string2 = "The result is empty.";
            this.logWriter.println(string2);
            throw new SCMAPIException(3, string2);
        }
        SCMHostTree[] sCMHostTreeArray = new SCMHostTree[vector2.size()];
        int n5 = 0;
        while (n5 < vector2.size()) {
            sCMHostTreeArray[n5] = (SCMHostTree)vector2.get(n5);
            ++n5;
        }
        SCMReportResult[] sCMReportResultArray = this.reportController.runPerformanceReportByHost(sCMHostTreeArray, null, null, null, vector, string, n, date, date2);
        if (sCMReportResultArray != null && sCMReportResultArray.length != 0) {
            sCMReportResultArray[0].setLegend("Folder: " + sCMHostTree.getName());
        }
        if (n4 == 7) {
            return sCMReportResultArray;
        }
        if (n4 == 2) {
            Vector<SCMReportResult> vector3 = new Vector<SCMReportResult>();
            int n6 = 0;
            while (n6 < sCMHostTreeArray.length) {
                block9: {
                    SCMReportResult[] sCMReportResultArray2 = null;
                    try {
                        sCMReportResultArray2 = this.runHostNodeReport(sCMHostTreeArray[n6], vector, string, n, date, date2, n2, n3, 7);
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                    if (sCMReportResultArray2 != null && sCMReportResultArray2.length != 0) {
                        vector3.add(sCMReportResultArray2[0]);
                    }
                }
                ++n6;
            }
            return this.constructTopNResult(vector3, sCMReportResultArray, n2, n3);
        }
        throw new IllegalArgumentException("report.invalid.subObject");
    }

    private SCMReportResult[] runContainerFolderReport(SCMContainerTree sCMContainerTree, Vector vector, String string, int n, Date date, Date date2, int n2, int n3, int n4) throws IllegalArgumentException, SCMAPIException, RemoteException, SMAPIException {
        Vector vector2 = sCMContainerTree.getChildren();
        if (vector2 == null || vector2.size() == 0) {
            String string2 = "The result is empty.";
            this.logWriter.println(string2);
            throw new SCMAPIException(3, string2);
        }
        SCMContainerTree[] sCMContainerTreeArray = new SCMContainerTree[vector2.size()];
        int n5 = 0;
        while (n5 < vector2.size()) {
            sCMContainerTreeArray[n5] = (SCMContainerTree)vector2.get(n5);
            ++n5;
        }
        SCMReportResult[] sCMReportResultArray = this.reportController.runPerformanceReportByServiceElement((SCMTreeNode[])sCMContainerTreeArray, null, null, null, vector, string, n, date, date2);
        if (sCMReportResultArray != null && sCMReportResultArray.length != 0) {
            sCMReportResultArray[0].setLegend("Folder: " + sCMContainerTree.getName());
        }
        if (n4 == 7) {
            return sCMReportResultArray;
        }
        if (n4 == 3) {
            Vector<SCMReportResult> vector3 = new Vector<SCMReportResult>();
            int n6 = 0;
            while (n6 < sCMContainerTreeArray.length) {
                block9: {
                    SCMReportResult[] sCMReportResultArray2 = null;
                    try {
                        sCMReportResultArray2 = this.runContainerMasterNodeReport(sCMContainerTreeArray[n6], vector, string, n, date, date2, n2, n3, 7);
                    }
                    catch (Exception exception) {
                        break block9;
                    }
                    if (sCMReportResultArray2 != null && sCMReportResultArray2.length != 0) {
                        vector3.add(sCMReportResultArray2[0]);
                    }
                }
                ++n6;
            }
            return this.constructTopNResult(vector3, sCMReportResultArray, n2, n3);
        }
        throw new IllegalArgumentException("report.invalid.subObject");
    }

    private SCMReportResult[] constructTopNResult(Vector vector, SCMReportResult[] sCMReportResultArray, int n, int n2) {
        Double d;
        TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
        this.logWriter.println(" allResult length" + vector.size());
        int n3 = 0;
        while (n3 < vector.size()) {
            SCMReportResult sCMReportResult = (SCMReportResult)vector.get(n3);
            double d2 = this.getAverage(sCMReportResult);
            d = new Double(d2);
            if (treeMap.containsKey(d)) {
                d2 += 0.001 * (double)n3;
            }
            treeMap.put(new Double(d2), new Integer(n3));
            ++n3;
        }
        int n4 = Math.min(n2, treeMap.size());
        SCMReportResult[] sCMReportResultArray2 = new SCMReportResult[n4 + 1];
        int n5 = 0;
        while (n5 < n4) {
            d = n == 1 ? treeMap.lastKey() : treeMap.firstKey();
            Object v = treeMap.get(d);
            treeMap.remove(d);
            int n6 = (Integer)v;
            sCMReportResultArray2[n5] = (SCMReportResult)vector.get(n6);
            ++n5;
        }
        sCMReportResultArray2[n5] = sCMReportResultArray[0];
        return sCMReportResultArray2;
    }

    private double getAverage(SCMReportResult sCMReportResult) {
        if (sCMReportResult == null) {
            return 0.0;
        }
        Vector vector = sCMReportResult.getReportData();
        if (vector == null || vector.size() == 0) {
            return 0.0;
        }
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            Vector vector2 = (Vector)vector.get(n2);
            if (vector2 != null) {
                try {
                    d += new Double((String)vector2.get(2)).doubleValue();
                    ++n;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return n == 0 ? 0.0 : d / (double)n;
    }
}

