/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.report;

import com.sun.symon.base.client.scm.report.SCMReportProperty;
import com.sun.symon.base.client.scm.report.SCMReportResult;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportConstants;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class SCMReportData
implements SCMReportConstants {
    private Vector reportData = null;
    private SCMReportProperty reportProperty = null;
    private String strLegend = "";
    private int instanceCount = 0;
    private Vector[] containerTable = null;
    private boolean csvFlag = false;
    private MSLogPrintWriter logWriter;

    public SCMReportData() {
        SCMServiceController sCMServiceController = SCMServiceController.getInstance();
        this.logWriter = sCMServiceController.getLogWriter();
        this.reportData = null;
        this.logWriter.println("Empty report data object created");
    }

    public SCMReportData(Vector vector, SCMReportProperty sCMReportProperty) {
        this.reportData = vector;
        this.reportProperty = sCMReportProperty;
        SCMServiceController sCMServiceController = SCMServiceController.getInstance();
        this.logWriter = sCMServiceController.getLogWriter();
        this.logWriter.println("Report data created with property: " + this.reportProperty.toString());
        if (vector != null) {
            this.logWriter.println("Result vector elements: " + vector.size());
        } else {
            this.logWriter.println("Report data object created with null data");
        }
    }

    public SCMReportData(Vector vector, SCMReportProperty sCMReportProperty, String string) {
        this.reportData = vector;
        this.reportProperty = sCMReportProperty;
        this.strLegend = string;
        SCMServiceController sCMServiceController = SCMServiceController.getInstance();
        this.logWriter = sCMServiceController.getLogWriter();
        this.logWriter.println("Report data created with property: " + this.reportProperty.toString());
        if (vector != null) {
            this.logWriter.println("Result vector elements: " + vector.size());
        } else {
            this.logWriter.println("Report data object created with null data");
        }
    }

    public SCMReportData(Vector vector, int n, Vector[] vectorArray) {
        this.reportData = vector;
        this.instanceCount = n;
        this.containerTable = vectorArray;
        this.csvFlag = true;
        SCMServiceController sCMServiceController = SCMServiceController.getInstance();
        this.logWriter = sCMServiceController.getLogWriter();
        this.logWriter.println("Report data created with instances: " + n);
        if (vector != null) {
            this.logWriter.println("Result vector elements: " + vector.size());
        } else {
            this.logWriter.println("Report data object created with null data");
        }
    }

    public Vector getReportData() {
        return this.reportData;
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public SCMReportResult getReportResult() {
        if (this.csvFlag) {
            this.processReportData();
        }
        SCMReportResult sCMReportResult = null;
        this.logWriter.println("Creating result with Count: " + this.instanceCount);
        sCMReportResult = new SCMReportResult(this.reportData, this.reportProperty, this.instanceCount);
        if (this.csvFlag) {
            Vector vector = SCMReportController.getCSVProps();
            sCMReportResult.setAllProps(vector);
        }
        if (!this.strLegend.equals("") || this.strLegend != null) {
            sCMReportResult.setLegend(this.strLegend);
        }
        return sCMReportResult;
    }

    private void processReportData() {
        if (this.instanceCount == 0) {
            return;
        }
        if (this.reportData == null) {
            return;
        }
        Vector vector = this.containerTable[0];
        Vector vector2 = this.containerTable[1];
        boolean bl = false;
        if (vector != null && vector2 != null && vector.size() == this.instanceCount) {
            bl = true;
        }
        Vector vector3 = null;
        Vector<Vector> vector4 = new Vector<Vector>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            n = 0;
            while (n < this.reportData.size()) {
                vector3 = (Vector)this.reportData.elementAt(n);
                Vector[] vectorArray = new Vector[this.instanceCount];
                n2 = 0;
                while (n2 < vector3.size()) {
                    Object e = vector3.elementAt(n2);
                    String string = null;
                    String string2 = null;
                    switch (n2) {
                        case 0: {
                            string = e == null ? new String("null") : (String)e;
                            n3 = 0;
                            while (n3 < vectorArray.length) {
                                vectorArray[n3] = new Vector();
                                vectorArray[n3].add(string);
                                ++n3;
                            }
                            break;
                        }
                        case 1: {
                            if (e == null) {
                                string2 = new String("null");
                            } else {
                                try {
                                    Long l = new Long(e.toString());
                                    date = new Date(l);
                                    string2 = simpleDateFormat.format(date);
                                }
                                catch (Exception exception) {
                                    string2 = e;
                                }
                            }
                            n3 = 0;
                            while (n3 < vectorArray.length) {
                                vectorArray[n3].add(string2);
                                ++n3;
                            }
                            break;
                        }
                        default: {
                            vectorArray[(n2 - 2) % this.instanceCount].add(e);
                        }
                    }
                    ++n2;
                }
                n3 = 0;
                while (n3 < vectorArray.length) {
                    if (bl) {
                        vectorArray[n3].add(vector.elementAt(n3));
                        vectorArray[n3].add(vector2.elementAt(n3));
                    }
                    vector4.add(vectorArray[n3]);
                    ++n3;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.logWriter.println("Error while processing the reportData");
            this.logWriter.println((Throwable)exception);
        }
        this.logWriter.println("Data conversion completed");
        this.logWriter.println("New Vector elements:" + vector4.size());
        this.reportData = vector4;
    }
}

