/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.mgmtservice.common.MSBaseTrapHandler;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSObjectHandles;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.common.MSServiceException;
import com.sun.symon.base.mgmtservice.common.MSTrapData;
import com.sun.symon.base.mgmtservice.scm.manager.SCMBaseHandler;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceImpl;
import com.sun.symon.base.server.common.ScSecurityCredential;

public class SCMTrapHandler
extends MSBaseTrapHandler {
    public static MSLogPrintWriter logWriter;
    private static String SCMTRAPHANDLER;
    private SMRawDataRequest rawDataRequest;
    private static SCMServiceImpl service;
    private static SCMServiceController controller;
    private static SCMTrapHandler instance;
    private MSObjectHandles trapHandleTable;
    private final String TrapCfgFile = "com.sun.symon.base.mgmtservice.scm.manager.traps.trapOp";

    public static SCMTrapHandler getInstance() {
        if (instance == null) {
            instance = new SCMTrapHandler();
        }
        return instance;
    }

    public SCMTrapHandler() {
        logWriter.println("SCMTrapHandler init");
        ScSecurityCredential scSecurityCredential = MSSecurity.getMasterUser();
        this.rawDataRequest = new SMRawDataRequest(scSecurityCredential);
        this.rawDataRequest.setGUIMode(false);
        try {
            service = (SCMServiceImpl)controller.getService(scSecurityCredential, "");
        }
        catch (Exception exception) {
            logWriter.println("Initiate trap handler failed");
            return;
        }
        this.init();
    }

    private void init() {
        this.trapHandleTable = null;
        logWriter.println("add trap handler for SCM: com.sun.symon.base.mgmtservice.scm.manager.traps.trapOp");
        try {
            this.trapHandleTable = new MSObjectHandles("com.sun.symon.base.mgmtservice.scm.manager.traps.trapOp");
        }
        catch (MSServiceException mSServiceException) {
            logWriter.println(mSServiceException.getMessage());
        }
        this.subscribe(MSTrapData.REFRESH_TRAP);
    }

    public String getName() {
        return SCMTRAPHANDLER;
    }

    public void handleTrap(MSTrapData mSTrapData) {
        logWriter.println("Got trap: " + mSTrapData.getType() + ", " + mSTrapData.getVarValue());
        if (mSTrapData == null) {
            return;
        }
        if (mSTrapData.isRefreshTrap()) {
            this.handleRefreshTrap(mSTrapData);
        }
    }

    private void handleRefreshTrap(MSTrapData mSTrapData) {
        logWriter.println("handle refresh trap");
        if (this.trapHandleTable == null) {
            return;
        }
        String string = mSTrapData.getVarValue();
        if (string == null) {
            return;
        }
        logWriter.println("handle refresh trap: oid=" + string);
        Object object = null;
        try {
            object = this.trapHandleTable.getInstance(string);
        }
        catch (MSServiceException mSServiceException) {
            logWriter.println("No handler for refresh trap: " + mSServiceException.getMessage());
            return;
        }
        if (object == null) {
            logWriter.println("No handler for refresh trap from: " + string);
            return;
        }
        String string2 = mSTrapData.getSourceIp();
        int n = mSTrapData.getPort();
        logWriter.println("handleRefreshTrap :" + string2 + ":" + n);
        if (object instanceof SCMBaseHandler) {
            SCMBaseHandler sCMBaseHandler = (SCMBaseHandler)object;
            sCMBaseHandler.emitOperation(service, mSTrapData);
        }
    }

    static {
        SCMTRAPHANDLER = "scm_handler";
        service = null;
        controller = null;
        instance = null;
        controller = SCMServiceController.getInstance();
        logWriter = controller.getLogWriter();
    }
}

