/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRowStatusRequest;
import com.sun.symon.base.client.scm.common.SCMAPIException;
import com.sun.symon.base.client.scm.manager.SCMAlarmRecord;
import com.sun.symon.base.client.scm.manager.SCMContainer;
import com.sun.symon.base.client.scm.manager.SCMContainerMaster;
import com.sun.symon.base.client.scm.manager.SCMContainerTree;
import com.sun.symon.base.client.scm.manager.SCMHost;
import com.sun.symon.base.client.scm.manager.SCMHostInfo;
import com.sun.symon.base.client.scm.manager.SCMHostTree;
import com.sun.symon.base.client.scm.manager.SCMMoveProcessesResult;
import com.sun.symon.base.client.scm.manager.SCMProject;
import com.sun.symon.base.client.scm.manager.SCMResourcePool;
import com.sun.symon.base.client.scm.manager.SCMServiceInterface;
import com.sun.symon.base.client.scm.manager.SCMSysIDInfo;
import com.sun.symon.base.client.scm.manager.SCMTreeNode;
import com.sun.symon.base.client.scm.manager.SCMZone;
import com.sun.symon.base.client.scm.report.SCMReportResult;
import com.sun.symon.base.client.service.SMDBRemoteChangeListener;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.client.topology.SMTopologyEntityInfo;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseService;
import com.sun.symon.base.mgmtservice.report.MrReportServiceImpl;
import com.sun.symon.base.mgmtservice.scm.manager.SCMDB;
import com.sun.symon.base.mgmtservice.scm.manager.SCMEncrypt;
import com.sun.symon.base.mgmtservice.scm.manager.SCMHierarchyData;
import com.sun.symon.base.mgmtservice.scm.manager.SCMResourcePoolManager;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceConstants;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import com.sun.symon.base.mgmtservice.scm.manager.SCMSynchronizer;
import com.sun.symon.base.mgmtservice.scm.manager.SCMZoneManager;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportController;
import com.sun.symon.base.mgmtservice.scm.report.SCMReportDispatcher;
import com.sun.symon.base.server.common.ScSecurityCredential;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcURL;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;

public class SCMServiceImpl
extends MSBaseService
implements SCMServiceInterface,
SCMServiceConstants {
    private static MSSecurity scService;
    private static MSLogPrintWriter logWriter;
    private static SCMServiceController controller;
    private static SMUserDomainData scmDomain;
    private SCMDB dbobj;
    private SMRawDataRequest rawDataRequest = new SMRawDataRequest(this.getUserSecurityCredential());
    private SCMReportController reportController;
    private SCMReportDispatcher reportDispatcher;
    private SCMHierarchyData scmHierarchy = null;
    private final String inconsistentError = "SNMP request returned error status 12 (inconsistent value)";
    private final String SOLARIS_10 = "5.10";
    private static final String[] EMPTY_STRING_ARRAY;
    private static final char ESCAPE_FORWARD_SLASH_CHAR;
    private static final String CONFIG_URL_PREFIX = "/mod/scm-container/System/Configuration/";
    private static final String NETWORK_INTF_URL = "/mod/scm-container/System/Configuration/networkInterfaces#0";
    private static final String TERMINAL_TYPES_URL = "/mod/scm-container/System/Configuration/termTypes#0";
    private static final String LOCALE_URL = "/mod/scm-container/System/Configuration/locales#0";
    private static final String TIMEZONES__URL = "/mod/scm-container/System/Configuration/timezones#0";
    private static final String[] empty;

    public SCMServiceImpl(ScSecurityCredential scSecurityCredential, String string) throws RemoteException {
        super("SunContainerService", scSecurityCredential, string);
        this.rawDataRequest.setGUIMode(false);
        this.dbobj = new SCMDB();
        try {
            Class<?> clazz = Class.forName("com.sun.symon.base.mgmtservice.report.MrReportServiceImpl");
            MrReportServiceImpl mrReportServiceImpl = new MrReportServiceImpl(scSecurityCredential, string);
            this.reportController = new SCMReportController(mrReportServiceImpl, this);
            this.reportDispatcher = new SCMReportDispatcher(this, this.reportController);
        }
        catch (Exception exception) {
            this.reportController = null;
            logWriter.println("Cannot get handle on PRM report service.");
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
    }

    public void cleanup() {
        if (this.scmHierarchy != null) {
            this.scmHierarchy.cleanup();
        }
    }

    public SMRawDataRequest getRawDataRequest() {
        return this.rawDataRequest;
    }

    public void setLocale(Locale locale) throws RemoteException {
        try {
            this.checkAccess("setLocale");
            super.setLocale(locale);
        }
        catch (Exception exception) {
            throw new RemoteException(exception.getMessage());
        }
    }

    public boolean isHostInDomain(String string, int n) throws RemoteException, SMSecurityException, SMAPIException {
        this.checkAccess("isHostInDomain");
        if (this.getSCMDomain() == null) {
            throw new SCMAPIException("SCM Domain not found");
        }
        SMTopologyRequest sMTopologyRequest = new SMTopologyRequest(this.rawDataRequest);
        SMTopologyEntityInfo[] sMTopologyEntityInfoArray = sMTopologyRequest.getTopologyEntitiesInfo(scmDomain.getDomainRootUrl());
        int n2 = 0;
        while (n2 < sMTopologyEntityInfoArray.length) {
            UcURL ucURL;
            if (string.equals(sMTopologyEntityInfoArray[n2].getHostName()) && Integer.parseInt((ucURL = new UcURL(sMTopologyEntityInfoArray[n2].getTargetUrl())).getPort().trim()) == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized SMUserDomainData getSCMDomain() throws SCMAPIException {
        if (scmDomain != null) {
            return scmDomain;
        }
        SMUserDomainRequest sMUserDomainRequest = new SMUserDomainRequest(this.rawDataRequest);
        try {
            SMUserDomainData[] sMUserDomainDataArray = sMUserDomainRequest.getAllConfiguredDomains(2);
            logWriter.println("DEBUG: getSCMDomain: " + sMUserDomainDataArray.length);
            int n = 0;
            while (n < sMUserDomainDataArray.length) {
                logWriter.println("DEBUG: domain: " + sMUserDomainDataArray[n].getDomainName() + ", " + "solaris_container_manager_domain_");
                if (sMUserDomainDataArray[n].getDomainName().equals("solaris_container_manager_domain_")) {
                    scmDomain = sMUserDomainDataArray[n];
                    return scmDomain;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            logWriter.println("DEBUG: error in getting domain: " + exception.getMessage());
            throw new SCMAPIException("get scm domain failed: ", (Throwable)exception);
        }
        scmDomain = null;
        return scmDomain;
    }

    public synchronized SMUserDomainData createSCMDomain() throws SCMAPIException {
        if (scmDomain != null) {
            return scmDomain;
        }
        scmDomain = this.getSCMDomain();
        if (scmDomain != null) {
            return scmDomain;
        }
        logWriter.println("SCM domain doesn't exist, create it now");
        SMUserDomainRequest sMUserDomainRequest = new SMUserDomainRequest(this.rawDataRequest);
        try {
            scmDomain = sMUserDomainRequest.createDomain("solaris_container_manager_domain_", false);
        }
        catch (Exception exception) {
            scmDomain = null;
            logWriter.println("DEBUG: create domain: " + exception.getMessage());
            throw new SCMAPIException("create scm domain failed: ", (Throwable)exception);
        }
        return scmDomain;
    }

    public SCMHost getHost(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getHost");
        return SCMDB.getHost(l);
    }

    public SCMHost[] searchHosts(String string, String string2, String string3, int n, int n2, int n3) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("searchHosts");
        return SCMDB.searchHosts(string, string2, string3, n, n2, n3);
    }

    public long getHostID(String string) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getHostID");
        return SCMDB.getHostID(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCMHostTree getHostTree() throws RemoteException, SMAPIException, SMDatabaseException {
        this.checkAccess("getHostTree");
        SCMServiceImpl sCMServiceImpl = this;
        synchronized (sCMServiceImpl) {
            if (this.scmHierarchy == null) {
                this.scmHierarchy = new SCMHierarchyData(this, this.rawDataRequest, this.dbobj);
            }
        }
        return this.scmHierarchy.getHostTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCMContainerTree getContainerTree() throws RemoteException, SMAPIException, SMDatabaseException {
        this.checkAccess("getContainerTree");
        SCMServiceImpl sCMServiceImpl = this;
        synchronized (sCMServiceImpl) {
            if (this.scmHierarchy == null) {
                this.scmHierarchy = new SCMHierarchyData(this, this.rawDataRequest, this.dbobj);
            }
        }
        return this.scmHierarchy.getContainerTree();
    }

    public SCMTreeNode[] getChildNodes(SCMTreeNode sCMTreeNode) throws RemoteException, SMAPIException, SMDatabaseException {
        this.checkAccess("getChildNodes");
        return SCMDB.getChildNodes(sCMTreeNode);
    }

    public SCMTreeNode getAllChildNodes(SCMTreeNode sCMTreeNode) throws RemoteException, SMAPIException, SMDatabaseException {
        this.checkAccess("getAllChildNodes");
        return SCMDB.getAllChildNodes(sCMTreeNode);
    }

    public long saveTreeNode(SCMTreeNode sCMTreeNode) throws SMSecurityException, SMDatabaseException, RemoteException {
        this.checkAccess("saveTreeNode");
        return SCMDB.saveTreeNode(sCMTreeNode);
    }

    public void moveTreeNode(SCMTreeNode sCMTreeNode, SCMTreeNode sCMTreeNode2) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("moveTreeNode");
        sCMTreeNode.setParent(sCMTreeNode2);
        this.saveTreeNode(sCMTreeNode);
    }

    public void deleteTreeNode(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("deleteTreeNode");
        SCMDB.deleteTreeNode(l);
    }

    public void saveHost(SCMHost sCMHost) throws RemoteException, SMAPIException, SMDatabaseException {
        SCMDB.addHost(sCMHost);
    }

    public void addHost(String string, int n, String string2, String string3, int n2, int n3, int n4) throws RemoteException, SMAPIException, SMDatabaseException {
        SCMHost sCMHost = new SCMHost(0L, string, n, string2, string3, n2, n3, n4);
        SCMDB.addHost(sCMHost);
    }

    public void deleteHost(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("deleteHost");
        SCMDB.deleteHost(l);
    }

    public long saveProject(SCMProject sCMProject) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("saveProject");
        if (sCMProject.getProjectID() == 0L) {
            logWriter.println("Create project " + sCMProject.getProjectName());
        } else {
            logWriter.println("Save project " + sCMProject.getProjectName());
        }
        return SCMDB.saveProject(sCMProject);
    }

    public void addSystemProject(SCMProject sCMProject) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("saveProject");
        SCMDB.addSystemProject(sCMProject);
    }

    public SCMProject getProject(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        return SCMDB.getProject(l);
    }

    public void deleteProject(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("deleteProject");
        SCMDB.deleteProject(l);
    }

    public SCMContainerMaster[] getContainerMasters() throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getContainerMasters");
        return SCMDB.getContainerMasters();
    }

    public String[] getVersions() throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getVersions");
        return SCMDB.getListValues("OS");
    }

    public String[] getPlatforms() throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getPlatforms");
        return SCMDB.getListValues("PLATFORM");
    }

    public SCMContainerMaster getContainerMaster(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getContainerMaster");
        return SCMDB.getContainerMaster(l);
    }

    public long saveContainerMaster(SCMContainerMaster sCMContainerMaster) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("saveContainerMaster");
        if (sCMContainerMaster.getMasterID() == 0L) {
            logWriter.println("Create container definition " + sCMContainerMaster.getMasterName());
        } else {
            logWriter.println("Save container definition " + sCMContainerMaster.getMasterName());
        }
        return SCMDB.saveContainerMaster(sCMContainerMaster);
    }

    public long addContainerMaster(SCMContainerMaster sCMContainerMaster, long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("addContainerMaster");
        logWriter.println("Create container definition " + sCMContainerMaster.getMasterName());
        return SCMDB.addContainerMaster(sCMContainerMaster, l);
    }

    public void deleteContainerMaster(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("deleteContainerMaster");
        logWriter.println("Delete container definition " + l);
        SCMDB.deleteContainerMaster(l);
    }

    public long saveContainer(SCMContainer sCMContainer) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        this.checkAccess("saveContainer");
        if (sCMContainer.getContainerID() != 0L) {
            if (sCMContainer.getStatus()) {
                try {
                    this.updateContainerInAgent(sCMContainer);
                }
                catch (SMAPIException sMAPIException) {
                    if (sMAPIException.getReasonCode() == 1) {
                        if (!this.rawDataRequest.isInServerContext(sCMContainer.getHostName(), sCMContainer.getPort())) {
                            throw new SCMAPIException("update.container.remoteServer", (Throwable)sMAPIException);
                        }
                        throw new SCMAPIException("update.container.noaccess", (Throwable)sMAPIException);
                    }
                    if (sMAPIException.getReasonCode() == 4) {
                        throw new SCMAPIException("update.container.timeout", (Throwable)sMAPIException);
                    }
                    if (sMAPIException.getMessage().indexOf("SNMP request returned error status 12 (inconsistent value)") != -1) {
                        throw new SCMAPIException("update.container.inconsistentvalue", (Throwable)sMAPIException);
                    }
                    throw sMAPIException;
                }
            }
        } else {
            logWriter.println("Create container " + sCMContainer.getName());
        }
        return SCMDB.saveContainer(sCMContainer);
    }

    public long saveContainerInDB(SCMContainer sCMContainer) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        if (sCMContainer.getContainerID() == 0L) {
            logWriter.println("Create container in DB only: " + sCMContainer.getName());
        } else {
            logWriter.println("Save container in DB only: " + sCMContainer.getName());
        }
        return SCMDB.saveContainer(sCMContainer);
    }

    public void setDefaultContainer(long l, boolean bl) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("setDefaultContainer");
        SCMDB.setDefaultContainer(l, bl);
    }

    public void deleteContainer(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("deleteContainer");
        logWriter.println("Delete container " + l);
        SCMDB.deleteContainer(l);
    }

    public SCMContainer[] getContainers(long l, boolean bl) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getContainers");
        return SCMDB.getContainers(l, bl);
    }

    public SCMContainer[] getContainersByHost(long l) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        this.checkAccess("getContainersByHost");
        SCMHost sCMHost = this.getHost(l);
        return SCMSynchronizer.getInstance().updateContainers(this, sCMHost.getHostName(), sCMHost.getPort());
    }

    public boolean isProjectOnHost(long l, long l2) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("isProjectOnHost");
        boolean bl = false;
        if (!this.getHost(l).getVersion().equals("5.10")) {
            bl = SCMDB.isProjectOnHost(l, l2);
        }
        return bl;
    }

    public boolean isProjectOnZone(long l, long l2, long l3) throws RemoteException, SMSecurityException, SMDatabaseException {
        return SCMDB.isProjectOnZone(l, l2, l3);
    }

    public SCMContainer[] getContainersByPool(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getContainersByPool");
        try {
            SCMHost sCMHost = this.getHost(this.getResourcePool(l).getHostID());
            this.syncUpContainers(sCMHost);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace((PrintWriter)logWriter);
        }
        return SCMDB.getContainersByPool(l);
    }

    private SCMContainer[] syncUpContainers(SCMHost sCMHost) throws SMAPIException {
        return SCMSynchronizer.getInstance().updateContainers(this, sCMHost.getHostName(), sCMHost.getPort());
    }

    public SCMContainer[] getContainersByZone(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        try {
            SCMHost sCMHost = this.getHost(this.getZoneByID(l).getHostID());
            this.syncUpContainers(sCMHost);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace((PrintWriter)logWriter);
        }
        return SCMDB.getContainersByZone(l);
    }

    public SCMContainer getContainer(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getContainer");
        return SCMDB.getContainer(l);
    }

    public void activateContainer(long l) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException, SCMAPIException {
        String string;
        this.checkAccess("activateContainer");
        SMRowStatusRequest sMRowStatusRequest = new SMRowStatusRequest(this.rawDataRequest);
        SCMContainer sCMContainer = this.getContainer(l);
        boolean bl = this.is10Module(sCMContainer.getHostName(), sCMContainer.getPort());
        SCMHost sCMHost = this.getHost(sCMContainer.getHostID());
        if (!sCMHost.getVersion().equals("5.10") && this.isProjectOnHost(sCMContainer.getHostID(), sCMContainer.getProjectID())) {
            logWriter.println("Container activation error:  duplication on host");
            throw new SCMAPIException("activate.container.duplication");
        }
        if (sCMHost.getVersion().equals("5.10") && this.isProjectOnZone(sCMContainer.getHostID(), sCMContainer.getZoneID(), sCMContainer.getProjectID())) {
            logWriter.println("Container activation error:  duplication on zone");
            throw new SCMAPIException("activate.container.duplication");
        }
        SCMProject sCMProject = this.getProject(sCMContainer.getProjectID());
        SCMResourcePool sCMResourcePool = this.getResourcePool(sCMContainer.getResourceID());
        logWriter.println("Container activation: " + sCMContainer.getContainerName() + " on host " + sCMContainer.getHostName());
        if (sCMResourcePool == null) {
            throw new SCMAPIException("resourcepool.invalid");
        }
        if (!sCMHost.getVersion().equals("5.10")) {
            if (sCMResourcePool.getAvailableCPU() < (float)sCMContainer.getCPUShares()) {
                throw new SCMAPIException("activate.container.no.cpu");
            }
        } else {
            logWriter.println("Zone CPUShares : " + this.getZoneByID(sCMContainer.getZoneID()).getUnusedCPUShares());
            if (this.getZoneByID(sCMContainer.getZoneID()).getUnusedCPUShares() < sCMContainer.getCPUShares()) {
                throw new SCMAPIException("activate.container.no.cpu");
            }
        }
        String string2 = "snmp://" + sCMContainer.getHostName() + ":" + sCMContainer.getPort() + "/mod/" + "scm-container/Containers/ContTable/ContEntry";
        String string3 = Long.toString(sCMContainer.getProjectID());
        String string4 = Long.toString(sCMContainer.getContainerID());
        String string5 = sCMContainer.getContainerName();
        String string6 = sCMProject.getProjectName();
        String string7 = sCMContainer.getResourceName();
        String string8 = Long.toString(sCMContainer.getCPUShares());
        String string9 = sCMProject.getOtherUsers();
        String string10 = sCMProject.getOtherGroups();
        String string11 = sCMProject.getMatchExpression();
        String string12 = sCMContainer.getZoneName();
        String string13 = "";
        if (sCMContainer.getMemory() != 0) {
            string13 = Integer.toString(sCMContainer.getMemory());
        }
        String string14 = "";
        if (sCMContainer.getMaxSHMemory() != 0L) {
            string14 = Long.toString(sCMContainer.getMaxSHMemory());
        }
        String string15 = string = bl ? string3 : string12 + "," + string3;
        if (string == null || string5 == null || string4 == null || string6 == null || string7 == null || string8 == null) {
            throw new SCMAPIException("Incorrect parameters");
        }
        Vector<String> vector = new Vector<String>();
        Vector<StString> vector2 = new Vector<StString>();
        vector2.addElement(new StString(string4));
        vector.addElement("contID");
        vector2.addElement(new StString(string5));
        vector.addElement("contName");
        vector2.addElement(new StString(string6));
        vector.addElement("projectName");
        vector2.addElement(new StString(string7));
        vector.addElement("poolName");
        vector2.addElement(new StString(string8));
        vector.addElement("cpuRes");
        vector2.addElement(new StString(string13));
        vector.addElement("memCap");
        if (sCMHost.getVersion().equals("5.10")) {
            vector2.addElement(new StString(string14));
            vector.addElement("maxSHMMemory");
        }
        if (string9 != null && string9.trim().length() > 0) {
            vector2.addElement(new StString(string9));
            vector.addElement("users");
        }
        if (string10 != null && string10.trim().length() > 0) {
            vector2.addElement(new StString(string10));
            vector.addElement("groups");
        }
        if (string11 != null && string11.trim().length() > 0) {
            vector2.addElement(new StString(string11));
            vector.addElement("matchexpr");
        }
        if (bl) {
            vector2.addElement(new StString(string12));
            vector.addElement("zoneName");
        }
        int n = vector.size();
        Object[] objectArray = new String[n];
        Object[] objectArray2 = new StString[n];
        vector.copyInto(objectArray);
        vector2.copyInto(objectArray2);
        logWriter.println("Activate container " + string5);
        logWriter.println("URL: " + string2);
        int n2 = 0;
        while (n2 < objectArray.length) {
            logWriter.println((String)objectArray[n2] + ":" + objectArray2[n2]);
            ++n2;
        }
        try {
            boolean bl2 = sMRowStatusRequest.createAndGo(string2, string, "rowstatus", (String[])objectArray, (StObject[])objectArray2);
            if (!bl2) {
                logWriter.println("Failed to activate container " + sCMContainer.getName() + ", return value is not OK ");
                throw new SCMAPIException("activate.container.duplication");
            }
        }
        catch (SMAPIException sMAPIException) {
            String string16 = sMAPIException.getMessage();
            if (sMAPIException.getReasonCode() == 1) {
                if (!this.rawDataRequest.isInServerContext(sCMContainer.getHostName(), sCMContainer.getPort())) {
                    logWriter.println("Failed to activate container " + sCMContainer.getName() + ", target host is in remote server context");
                    throw new SCMAPIException("activate.container.remoteServer", (Throwable)sMAPIException);
                }
                logWriter.println("Failed to activate container " + sCMContainer.getName() + ", security error");
                throw new SCMAPIException("activate.container.noaccess", (Throwable)sMAPIException);
            }
            if (sMAPIException.getReasonCode() == 4) {
                logWriter.println("Failed to activate container:" + sCMContainer.getName() + " " + sMAPIException.getMessage());
                throw new SCMAPIException("activate.container.timeout", (Throwable)sMAPIException);
            }
            logWriter.println("Failed to activate container:" + sCMContainer.getName() + " " + sMAPIException.getMessage());
            if (string16.indexOf("SNMP request returned error status 12 (inconsistent value)") != -1) {
                String string17 = sCMProject.getType();
                String string18 = "activate.container.appBased.inconsistentvalue";
                if (string17.equals("U")) {
                    string18 = "activate.container.userBased.inconsistentvalue";
                } else if (string17.equals("G")) {
                    string18 = "activate.container.groupBased.inconsistentvalue";
                }
                throw new SCMAPIException(string18, (Throwable)sMAPIException);
            }
            throw new SCMAPIException("activate.container.fail", (Throwable)sMAPIException);
        }
        sCMContainer.setStatus(true);
        logWriter.println("Container Activated successfully");
        this.saveContainerInDB(sCMContainer);
    }

    public void deactivateContainer(long l) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException, SCMAPIException {
        SMRowStatusRequest sMRowStatusRequest = new SMRowStatusRequest(this.rawDataRequest);
        SCMContainer sCMContainer = this.getContainer(l);
        String string = "snmp://" + sCMContainer.getHostName() + ":" + sCMContainer.getPort() + "/mod/" + "scm-container/Containers/ContTable/ContEntry";
        boolean bl = this.is10Module(sCMContainer.getHostName(), sCMContainer.getPort());
        String string2 = Long.toString(sCMContainer.getProjectID());
        String string3 = bl ? string2 : sCMContainer.getZoneName() + "," + string2;
        logWriter.println("Deactivate container: " + l);
        logWriter.println("URL: " + string);
        try {
            sMRowStatusRequest.destroy(string, string3, "rowstatus");
        }
        catch (SMAPIException sMAPIException) {
            String string4 = sMAPIException.getMessage();
            if (sMAPIException.getReasonCode() == 1) {
                if (!this.rawDataRequest.isInServerContext(sCMContainer.getHostName(), sCMContainer.getPort())) {
                    logWriter.println("Failed to deactivate container " + sCMContainer.getName() + ", target host is in remote context");
                    throw new SCMAPIException("deactivate.container.remoteServer", (Throwable)sMAPIException);
                }
                logWriter.println("Failed to deactivate container " + sCMContainer.getName() + ", security error");
                throw new SCMAPIException("deactivate.container.noaccess", (Throwable)sMAPIException);
            }
            if (sMAPIException.getReasonCode() == 4) {
                logWriter.println("Failed to deactivate container " + sCMContainer.getName() + ", " + sMAPIException.getMessage());
                throw new SCMAPIException("deactivate.container.timeout", (Throwable)sMAPIException);
            }
            logWriter.println("Failed to deactivate container " + sCMContainer.getName() + ", " + sMAPIException.getMessage());
            if (string4.indexOf("SNMP request returned error status 12 (inconsistent value)") != -1) {
                SCMHost sCMHost = this.getHost(sCMContainer.getHostID());
                if (sCMHost.getVersion().equals("5.8")) {
                    throw new SCMAPIException("deactivate.container.processInside", (Throwable)sMAPIException);
                }
                throw new SCMAPIException("deactivate.container.inconsistentvalue", (Throwable)sMAPIException);
            }
            throw new SCMAPIException("deactivate.container.fail", (Throwable)sMAPIException);
        }
        sCMContainer.setStatus(false);
        this.saveContainerInDB(sCMContainer);
    }

    public long saveResourcePool(SCMResourcePool sCMResourcePool) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        String string;
        String string2;
        this.checkAccess("saveResourcePool");
        logWriter.println("Save Resource Pool: " + sCMResourcePool.getResourcePoolName());
        SCMHost sCMHost = this.getHost(sCMResourcePool.getHostID());
        long l = 0L;
        if (sCMResourcePool.getResourcePoolID() == 0L) {
            string2 = sCMHost.getHostName();
            string = sCMResourcePool.getResourcePoolName();
            if (SCMResourcePoolManager.getResourcePoolID(string, string2) > 0L) {
                throw new SCMAPIException("resourcepool.save.duplicate.name");
            }
        } else {
            string2 = this.getResourcePool(sCMResourcePool.getResourcePoolID());
            if (string2 == null) {
                throw new SCMAPIException("resourcepool.invalid");
            }
            l = string2.getMinCPU();
        }
        if (this.getAvailableCPUForNewPool(sCMResourcePool.getHostID()) + l < sCMResourcePool.getMinCPU()) {
            throw new SCMAPIException("resourcepool.save.no.cpu");
        }
        try {
            this.saveResourcePool(sCMResourcePool, false);
            return this.saveResourcePool(sCMResourcePool, true);
        }
        catch (SMAPIException sMAPIException) {
            string = sMAPIException.getMessage();
            if (sMAPIException.getReasonCode() == 1) {
                if (!this.rawDataRequest.isInServerContext(sCMHost.getHostName(), sCMHost.getPort())) {
                    throw new SCMAPIException("resourcepool.save.remoteServer", (Throwable)sMAPIException);
                }
                throw new SCMAPIException("resourcepool.save.noaccess", (Throwable)sMAPIException);
            }
            if (sMAPIException.getReasonCode() == 4) {
                throw new SCMAPIException("resourcepool.save.timeout", (Throwable)sMAPIException);
            }
            if (string.indexOf("SNMP request returned error status 12 (inconsistent value)") != -1) {
                throw new SCMAPIException("resourcepool.save.no.cpu", (Throwable)sMAPIException);
            }
            throw new SCMAPIException("resourcepool.save.fail", (Throwable)sMAPIException);
        }
    }

    public long saveResourcePool(SCMResourcePool sCMResourcePool, boolean bl) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        this.checkAccess("saveResourcePool");
        if (bl) {
            logWriter.println("Save Resource Pool (DB): " + sCMResourcePool.getResourcePoolName());
            return SCMResourcePoolManager.persistResourcePool(sCMResourcePool);
        }
        logWriter.println("Save Resource Pool (Agent): " + sCMResourcePool.getResourcePoolName());
        this.saveResPoolInAgent(sCMResourcePool);
        return sCMResourcePool.getResourcePoolID();
    }

    public void deleteResourcePool(long l) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        this.checkAccess("deleteResourcePool");
        logWriter.println("Save Resource Pool: " + l);
        this.deleteResourcePool(l, false);
    }

    public void deleteResourcePool(long l, boolean bl) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        this.checkAccess("deleteResourcePool");
        logWriter.println("Delete Resource Pool: " + l);
        SCMResourcePool sCMResourcePool = null;
        try {
            sCMResourcePool = this.getResourcePool(l);
        }
        catch (SMNoSuchObjectException sMNoSuchObjectException) {
            logWriter.println("The resource pool: " + l + " is not resolvable in the database");
            return;
        }
        this.deleteResourcePool(sCMResourcePool, bl);
    }

    public void deleteResourcePool(SCMResourcePool sCMResourcePool, boolean bl) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        if (sCMResourcePool == null) {
            return;
        }
        long l = sCMResourcePool.getResourcePoolID();
        if (l == 0L) {
            return;
        }
        SCMContainer[] sCMContainerArray = this.getContainersByPool(l);
        long l2 = sCMResourcePool.getHostID();
        if (sCMContainerArray != null && sCMContainerArray.length > 0) {
            if (!bl) {
                logWriter.println("Cannot delete the resource pool: " + sCMResourcePool.getResourcePoolName());
                throw new SCMAPIException("resourcePool.delete.referred");
            }
            SCMResourcePool sCMResourcePool2 = this.getDefaultResourcePool(l2);
            long l3 = sCMResourcePool2.getResourcePoolID();
            String string = sCMResourcePool2.getResourcePoolName();
            int n = 0;
            while (n < sCMContainerArray.length) {
                sCMContainerArray[n].setResourceID(l3);
                sCMContainerArray[n].setResourceName(string);
                this.saveContainerInDB(sCMContainerArray[n]);
                ++n;
            }
        }
        if (!bl) {
            try {
                this.deleteResPoolInAgent(sCMResourcePool);
            }
            catch (SMAPIException sMAPIException) {
                if (sMAPIException.getReasonCode() == 1) {
                    SCMHost sCMHost = this.getHost(sCMResourcePool.getHostID());
                    if (!this.rawDataRequest.isInServerContext(sCMHost.getHostName(), sCMHost.getPort())) {
                        throw new SCMAPIException("resourcePool.delete.remoteServer", (Throwable)sMAPIException);
                    }
                    throw new SCMAPIException("resourcePool.delete.noaccess");
                }
                if (sMAPIException.getReasonCode() == 4) {
                    throw new SCMAPIException("resourcePool.delete.timeout", (Throwable)sMAPIException);
                }
                throw sMAPIException;
            }
        }
        SCMResourcePoolManager.deleteResource(l);
    }

    public SCMResourcePool getResourcePool(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        return this.fetchCurrentCPUSize4Pool(SCMResourcePoolManager.getResourcePool(l));
    }

    public SCMResourcePool getDefaultResourcePool(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getDefaultResourcePool");
        return this.fetchCurrentCPUSize4Pool(SCMResourcePoolManager.getDefaultResourcePool(l));
    }

    public SCMResourcePool[] getResourcePools(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getResourcePools");
        logWriter.println("Get resourlcepool by host : " + l);
        SCMResourcePool[] sCMResourcePoolArray = SCMResourcePoolManager.getResourcePools(l);
        int n = 0;
        while (n < sCMResourcePoolArray.length) {
            this.fetchCurrentCPUSize4Pool(sCMResourcePoolArray[n]);
            ++n;
        }
        return sCMResourcePoolArray;
    }

    public String[] getMinAvailableResources(long[] lArray) throws RemoteException, SMSecurityException, SMDatabaseException, SCMAPIException {
        this.checkAccess("getMinAvailableResources");
        if (lArray == null || lArray.length == 0) {
            return null;
        }
        SCMResourcePool[] sCMResourcePoolArray = SCMResourcePoolManager.getResourcePools(lArray);
        if (sCMResourcePoolArray == null || sCMResourcePoolArray.length == 0) {
            throw new SCMAPIException("resourcepool.invalid");
        }
        float f = sCMResourcePoolArray[0].getAvailableCPU();
        float f2 = sCMResourcePoolArray[0].getAvailableMemory();
        int n = 1;
        while (n < lArray.length) {
            sCMResourcePoolArray[n] = this.getResourcePool(lArray[n]);
            if (f > sCMResourcePoolArray[n].getAvailableCPU()) {
                f = sCMResourcePoolArray[n].getAvailableCPU();
            }
            if (f2 > sCMResourcePoolArray[n].getAvailableMemory()) {
                f2 = sCMResourcePoolArray[n].getAvailableMemory();
            }
            ++n;
        }
        String[] stringArray = new String[]{Float.toString(f), Float.toString(f2)};
        return stringArray;
    }

    public SCMReportResult[] runPerformanceReport(int n, SCMTreeNode[] sCMTreeNodeArray, Vector vector, String string, int n2, Date date, Date date2) throws RemoteException, SMAPIException, SCMAPIException {
        this.checkAccess("runPerformanceReport");
        if (this.reportController != null) {
            SCMHostTree[] sCMHostTreeArray;
            SCMReportResult[] sCMReportResultArray = null;
            if (sCMTreeNodeArray == null || sCMTreeNodeArray.length == 0) {
                String string2 = "The target list is empty.";
                logWriter.println(string2);
                throw new SCMAPIException(3, string2);
            }
            if (n2 == 101) {
                n2 = 0;
                sCMHostTreeArray = this.getDatesForMonth();
                date = (Date)sCMHostTreeArray.elementAt(0);
                date2 = (Date)sCMHostTreeArray.elementAt(1);
            }
            switch (n) {
                case 1: {
                    logWriter.println("BY FOLDER");
                    if (sCMTreeNodeArray.length != 1) break;
                    logWriter.println("Only 1 folder:" + sCMTreeNodeArray[0].getID());
                    int n3 = n;
                    if (sCMTreeNodeArray[0] instanceof SCMContainerTree) {
                        n3 = 3;
                    }
                    if (sCMTreeNodeArray[0] instanceof SCMHostTree) {
                        n3 = 2;
                    }
                    SCMTreeNode[] sCMTreeNodeArray2 = null;
                    try {
                        sCMTreeNodeArray2 = this.getChildNodes(sCMTreeNodeArray[0]);
                    }
                    catch (Exception exception) {
                        String string3 = "Database exception: getChildNodes";
                        logWriter.println(string3);
                        throw new SCMAPIException(1, string3);
                    }
                    if (sCMTreeNodeArray2 == null || sCMTreeNodeArray2.length == 0) {
                        String string4 = "The result is empty.";
                        logWriter.println(string4);
                        throw new SCMAPIException(3, string4);
                    }
                    if (sCMTreeNodeArray2[0].isFolder()) {
                        n = 1;
                    }
                    sCMReportResultArray = this.runPerformanceReport(n3, sCMTreeNodeArray2, vector, string, n2, date, date2);
                    break;
                }
                case 2: {
                    logWriter.println("BY HOST");
                    if (sCMTreeNodeArray.length == 1) {
                        logWriter.println("only 1 host:" + sCMTreeNodeArray[0].getID());
                        sCMHostTreeArray = null;
                        try {
                            sCMHostTreeArray = this.getContainers(sCMTreeNodeArray[0].getID(), true);
                        }
                        catch (Exception exception) {
                            String string5 = "Database exception: getContainers";
                            logWriter.println(string5);
                            throw new SCMAPIException(1, string5);
                        }
                        if (sCMHostTreeArray == null || sCMHostTreeArray.length == 0) {
                            String string6 = "The result is empty.";
                            logWriter.println(string6);
                            throw new SCMAPIException(3, string6);
                        }
                        Vector<String> vector2 = new Vector<String>();
                        int n4 = 0;
                        while (n4 < sCMHostTreeArray.length) {
                            String string7 = sCMHostTreeArray[n4].getContainerMasterName();
                            if (!vector2.contains(string7)) {
                                vector2.add(string7);
                            }
                            ++n4;
                        }
                        int n5 = vector2.size();
                        String[] stringArray = new String[n5];
                        stringArray = vector2.toArray(stringArray);
                        sCMReportResultArray = this.reportController.runPerformanceReportByServiceElement(null, stringArray, sCMTreeNodeArray[0], null, vector, string, n2, date, date2);
                        break;
                    }
                    logWriter.println("more than 1 host");
                    sCMHostTreeArray = new SCMHostTree[sCMTreeNodeArray.length];
                    int n6 = 0;
                    while (n6 < sCMTreeNodeArray.length) {
                        sCMHostTreeArray[n6] = (SCMHostTree)sCMTreeNodeArray[n6];
                        ++n6;
                    }
                    sCMReportResultArray = this.reportController.runPerformanceReportByHost(sCMHostTreeArray, null, null, null, vector, string, n2, date, date2);
                    break;
                }
                case 3: {
                    logWriter.println("BY SERVICE ELEMENT");
                    if (sCMTreeNodeArray.length == 1) {
                        logWriter.println("only 1 service element:" + sCMTreeNodeArray[0].getID());
                        sCMHostTreeArray = null;
                        try {
                            sCMHostTreeArray = this.getContainers(sCMTreeNodeArray[0].getID(), true);
                        }
                        catch (Exception exception) {
                            String string8 = "Database exception: getContainers";
                            logWriter.println(string8);
                            throw new SCMAPIException(1, string8);
                        }
                        if (sCMHostTreeArray == null || sCMHostTreeArray.length == 0) {
                            String string9 = "The result is empty.";
                            logWriter.println(string9);
                            throw new SCMAPIException(3, string9);
                        }
                        Vector<String> vector3 = new Vector<String>();
                        int n7 = 0;
                        while (n7 < sCMHostTreeArray.length) {
                            String string10 = sCMHostTreeArray[n7].getHostName();
                            if (!vector3.contains(string10)) {
                                vector3.add(string10);
                            }
                            ++n7;
                        }
                        int n8 = vector3.size();
                        String[] stringArray = new String[n8];
                        stringArray = vector3.toArray(stringArray);
                        sCMReportResultArray = this.reportController.runPerformanceReportByHost(null, stringArray, sCMTreeNodeArray[0], null, vector, string, n2, date, date2);
                        break;
                    }
                    sCMReportResultArray = this.reportController.runPerformanceReportByServiceElement(sCMTreeNodeArray, null, null, null, vector, string, n2, date, date2);
                    break;
                }
                default: {
                    sCMHostTreeArray = "Invalid request type.";
                    throw new SCMAPIException(5, (String)sCMHostTreeArray);
                }
            }
            return sCMReportResultArray;
        }
        String string11 = "Report service not available.";
        throw new SCMAPIException(2, string11);
    }

    public SCMReportResult[] runPerformanceReport(int n, String[] stringArray, SCMTreeNode sCMTreeNode, Vector vector, String string, int n2, Date date, Date date2) throws RemoteException, SMAPIException, SCMAPIException {
        this.checkAccess("runPerformanceReport");
        if (this.reportController != null) {
            Vector<String> vector2;
            SCMReportResult[] sCMReportResultArray = null;
            if (stringArray == null || stringArray.length == 0) {
                String string2 = "The target list is empty.";
                logWriter.println(string2);
                throw new SCMAPIException(3, string2);
            }
            if (n2 == 101) {
                n2 = 0;
                vector2 = this.getDatesForMonth();
                date = (Date)vector2.elementAt(0);
                date2 = (Date)vector2.elementAt(1);
            }
            switch (n) {
                case 2: {
                    sCMReportResultArray = this.reportController.runPerformanceReportByHost(null, stringArray, sCMTreeNode, null, vector, string, n2, date, date2);
                    break;
                }
                case 3: {
                    sCMReportResultArray = this.reportController.runPerformanceReportByServiceElement(null, stringArray, sCMTreeNode, null, vector, string, n2, date, date2);
                    break;
                }
                case 4: {
                    String[] stringArray2;
                    logWriter.println("BY RESOURCE POOL");
                    vector2 = new Vector<String>();
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        String string3;
                        stringArray2 = null;
                        try {
                            long l = new Long(stringArray[n3]);
                            stringArray2 = this.getContainersByPool(l);
                        }
                        catch (NumberFormatException numberFormatException) {
                            string3 = "Invalid pool id:" + stringArray[n3];
                            logWriter.println(string3);
                            throw new SMAPIException(1, string3);
                        }
                        catch (Exception exception) {
                            String string4 = "Database exception: getContainersByPool";
                            logWriter.println(string4);
                            throw new SMAPIException(1, string4);
                        }
                        if (stringArray2 != null) {
                            int n4 = 0;
                            while (n4 < stringArray2.length) {
                                string3 = stringArray2[n4].getContainerMasterName();
                                if (!vector2.contains(string3)) {
                                    vector2.add(string3);
                                }
                                ++n4;
                            }
                        }
                        ++n3;
                    }
                    if (vector2.size() == 0) {
                        stringArray2 = "The result is empty.";
                        logWriter.println((String)stringArray2);
                        throw new SCMAPIException(3, (String)stringArray2);
                    }
                    stringArray2 = new String[vector2.size()];
                    stringArray2 = vector2.toArray(stringArray2);
                    sCMReportResultArray = this.reportController.runPerformanceReportByServiceElement(null, stringArray2, sCMTreeNode, null, vector, string, n2, date, date2);
                    break;
                }
                case 5: {
                    long l;
                    String[] stringArray3;
                    logWriter.println("BY ZONE");
                    Vector<String> vector3 = new Vector<String>();
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        String string5;
                        stringArray3 = null;
                        try {
                            l = new Long(stringArray[n5]);
                            stringArray3 = this.getContainersByZone(l);
                        }
                        catch (NumberFormatException numberFormatException) {
                            string5 = "Invalid zone id:" + stringArray[n5];
                            logWriter.println(string5);
                            throw new SMAPIException(1, string5);
                        }
                        catch (Exception exception) {
                            String string6 = "Database exception: getContainersByZone";
                            logWriter.println(string6);
                            throw new SMAPIException(1, string6);
                        }
                        if (stringArray3 != null) {
                            int n6 = 0;
                            while (n6 < stringArray3.length) {
                                string5 = stringArray3[n6].getContainerMasterName();
                                if (!vector3.contains(string5)) {
                                    vector3.add(string5);
                                }
                                ++n6;
                            }
                        }
                        ++n5;
                    }
                    if (vector3.size() == 0) {
                        stringArray3 = "The result is empty.";
                        logWriter.println((String)stringArray3);
                        throw new SCMAPIException(3, (String)stringArray3);
                    }
                    stringArray3 = new String[vector3.size()];
                    stringArray3 = vector3.toArray(stringArray3);
                    l = new Long(stringArray[0]);
                    SCMZone sCMZone = this.getZoneByID(l);
                    String string7 = sCMZone.getZoneName();
                    sCMReportResultArray = this.reportController.runPerformanceReportByServiceElement(null, stringArray3, sCMTreeNode, string7, vector, string, n2, date, date2);
                    break;
                }
                default: {
                    String string8 = "Invalid request type.";
                    throw new SCMAPIException(5, string8);
                }
            }
            return sCMReportResultArray;
        }
        String string9 = "Report service not available.";
        throw new SCMAPIException(2, string9);
    }

    public SCMReportResult[] runPerformanceReport(int n, String[] stringArray, SCMTreeNode sCMTreeNode, String string, Vector vector, String string2, int n2, Date date, Date date2) throws RemoteException, SMAPIException, SCMAPIException {
        this.checkAccess("runPerformanceReport");
        if (this.reportController != null) {
            Object object;
            SCMReportResult[] sCMReportResultArray = null;
            if (stringArray == null || stringArray.length == 0) {
                String string3 = "The target list is empty.";
                logWriter.println(string3);
                throw new SCMAPIException(3, string3);
            }
            if (n2 == 101) {
                n2 = 0;
                object = this.getDatesForMonth();
                date = (Date)((Vector)object).elementAt(0);
                date2 = (Date)((Vector)object).elementAt(1);
            }
            switch (n) {
                case 2: {
                    sCMReportResultArray = this.reportController.runPerformanceReportByHost(null, stringArray, sCMTreeNode, string, vector, string2, n2, date, date2);
                    break;
                }
                case 3: {
                    sCMReportResultArray = this.reportController.runPerformanceReportByServiceElement(null, stringArray, sCMTreeNode, string, vector, string2, n2, date, date2);
                    break;
                }
                default: {
                    object = "Invalid request type.";
                    throw new SCMAPIException(5, (String)object);
                }
            }
            return sCMReportResultArray;
        }
        String string4 = "Report service not available.";
        throw new SCMAPIException(2, string4);
    }

    public SCMReportResult[] runAccountingReport(int n, SCMTreeNode[] sCMTreeNodeArray, Vector vector, String string, int n2, Date date, Date date2) throws RemoteException, SMAPIException, SCMAPIException {
        this.checkAccess("runAccountingReport");
        return null;
    }

    public SCMReportResult[] runAccountingReport(int n, String[] stringArray, SCMTreeNode sCMTreeNode, Vector vector, String string, int n2, Date date, Date date2) throws RemoteException, SMAPIException, SCMAPIException {
        this.checkAccess("runAccountingReport");
        return null;
    }

    public boolean isReportingAvailable() {
        return this.reportController != null;
    }

    public void addEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
    }

    public void removeEventListener(SMDBRemoteChangeListener sMDBRemoteChangeListener) throws RemoteException {
    }

    SCMContainer[] getContainersInDB(long l, boolean bl) throws SMSecurityException, SMDatabaseException {
        if (bl) {
            SCMContainer[] sCMContainerArray = SCMDB.getContainersByHost(l);
            if (sCMContainerArray == null || sCMContainerArray.length == 0) {
                return sCMContainerArray;
            }
            Vector<SCMContainer> vector = new Vector<SCMContainer>(sCMContainerArray.length);
            int n = 0;
            while (n < sCMContainerArray.length) {
                if (sCMContainerArray[n].getStatus()) {
                    vector.addElement(sCMContainerArray[n]);
                }
                ++n;
            }
            SCMContainer[] sCMContainerArray2 = new SCMContainer[vector.size()];
            sCMContainerArray2 = vector.toArray(sCMContainerArray2);
            return sCMContainerArray2;
        }
        return SCMDB.getContainersByHost(l);
    }

    public SCMZone[] getZonesByPool(long l) throws SMAPIException, RemoteException, SMSecurityException, SMDatabaseException {
        try {
            SCMResourcePool sCMResourcePool = this.getResourcePool(l);
            SCMHost sCMHost = this.getHost(sCMResourcePool.getHostID());
            SCMSynchronizer.getInstance().updateZones(this, sCMHost.getHostName(), sCMHost.getPort());
        }
        catch (Exception exception) {}
        return SCMZoneManager.getZonesByPool(l);
    }

    public SCMZone[] getZonesByHost(long l) throws SMAPIException, RemoteException, SMSecurityException, SMDatabaseException {
        return this.getZonesByHost(l, true);
    }

    public SCMZone[] getZonesByHost(long l, boolean bl) throws SMAPIException, RemoteException, SMSecurityException, SMDatabaseException {
        block2: {
            if (!bl) break block2;
            try {
                SCMHost sCMHost = this.getHost(l);
                SCMSynchronizer.getInstance().updateZones(this, sCMHost.getHostName(), sCMHost.getPort());
            }
            catch (Exception exception) {}
        }
        return SCMZoneManager.getZonesByHost(l);
    }

    public void bootZone(long l) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        logWriter.println("Boot Zone : " + l);
        try {
            SCMZone sCMZone = this.getZoneByID(l);
            sCMZone.setState(SCMZone.BOOT);
            this.updateZoneInAgent(sCMZone, true);
            SCMZoneManager.persistZone(sCMZone);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace((PrintWriter)logWriter);
            throw sMAPIException;
        }
    }

    public void shutdownZone(long l) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        logWriter.println("Shutdown zone: " + l);
        try {
            SCMZone sCMZone = this.getZoneByID(l);
            sCMZone.setState(SCMZone.HALT);
            this.updateZoneInAgent(sCMZone, true);
            SCMZoneManager.persistZone(sCMZone);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace((PrintWriter)logWriter);
            throw sMAPIException;
        }
    }

    public long createZone(SCMZone sCMZone, SCMSysIDInfo sCMSysIDInfo) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        logWriter.println("Create Zone: " + sCMZone.getZoneName());
        try {
            this.setSysIDInfoInAgent(sCMZone, sCMSysIDInfo);
            this.createZoneInAgent(sCMZone);
            sCMZone.setState(SCMZone.INSTALLING);
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace((PrintWriter)logWriter);
            throw sMAPIException;
        }
        return SCMZoneManager.persistZone(sCMZone);
    }

    public SCMZone getZoneByID(long l) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        return SCMZoneManager.getZoneByID(l);
    }

    public void deleteZone(long l, boolean bl) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        logWriter.println("Delete zone: " + l);
        if (!bl) {
            SCMZone sCMZone = this.getZoneByID(l);
            this.deleteZoneFromAgent(sCMZone);
            SCMZoneManager.deleteZone(l);
        } else {
            SCMZoneManager.deleteZone(l);
        }
    }

    public long saveZone(SCMZone sCMZone, boolean bl) throws RemoteException, SMSecurityException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException, SMDatabaseException, SMAPIException {
        logWriter.println("Save Zone: " + sCMZone.getZoneName());
        if (!bl) {
            if (sCMZone.getID() == 0L) {
                this.createZoneInAgent(sCMZone);
            } else {
                this.updateZoneInAgent(sCMZone, false);
            }
        }
        return SCMZoneManager.persistZone(sCMZone);
    }

    public long saveZone(SCMZone sCMZone) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException, SMNoSuchObjectException, SMDuplicateException, SMStaleDataException {
        this.checkAccess("saveZone");
        return this.saveZone(sCMZone, false);
    }

    public void deleteZone(long l) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        this.deleteZone(l, false);
    }

    private void saveResPoolInAgent(SCMResourcePool sCMResourcePool) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        logWriter.println("SaveResPoolInAgent : " + sCMResourcePool.getResourcePoolName());
        SMRowStatusRequest sMRowStatusRequest = new SMRowStatusRequest(this.rawDataRequest);
        SCMHost sCMHost = this.getHost(sCMResourcePool.getHostID());
        String string = sCMResourcePool.getResourcePoolName();
        String string2 = "snmp://" + sCMHost.getHostName() + ":" + sCMHost.getPort() + "/mod/scm-container/Pools/PoolTable/PoolEntry/";
        String[] stringArray = SCMResourcePoolManager.AGENT_RESOURCE_POOL_MIB_COLUMNS;
        StObject[] stObjectArray = new StObject[]{new StString(sCMResourcePool.getSchedulerClass()), new StString("" + sCMResourcePool.getMinCPU()), new StString("" + sCMResourcePool.getMaxCPU()), new StString("" + sCMResourcePool.getMaxCPUShares()), new StString(sCMResourcePool.getObjectives())};
        this.validateData(stringArray, stObjectArray);
        if (sCMResourcePool.getResourcePoolID() == 0L) {
            if (!sMRowStatusRequest.createAndGo(string2, string, "rowstatus", stringArray, stObjectArray)) {
                logWriter.println("Resource Pool: " + string + " already exists");
            }
        } else {
            String[] stringArray2 = new String[stringArray.length];
            StString[][] stStringArray = new StString[stringArray2.length][1];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = SMRawDataRequest.buildShadowURL((String)(string2 + SCMResourcePoolManager.AGENT_RESOURCE_POOL_MIB_COLUMNS[n]), null, (String)string);
                stStringArray[n][0] = stObjectArray[n];
                logWriter.println("Update Agent URL: " + stringArray2[n] + " Value: " + stStringArray[n][0]);
                ++n;
            }
            this.rawDataRequest.setURLValue(stringArray2, (StObject[][])stStringArray);
        }
    }

    private void validateData(String[] stringArray, StObject[] stObjectArray) throws SMAPIException {
        if (stringArray.length != stObjectArray.length) {
            throw new SMAPIException("Number of fields does not match with strObj, fileds(" + stringArray.length + ")=" + Arrays.asList(stringArray) + "and respective values(" + stObjectArray.length + ")=" + Arrays.asList(stObjectArray));
        }
    }

    private void deleteResPoolInAgent(SCMResourcePool sCMResourcePool) throws RemoteException, SMSecurityException, SMDatabaseException, SMAPIException {
        SCMHost sCMHost = this.getHost(sCMResourcePool.getHostID());
        String string = "snmp://" + sCMHost.getHostName() + ":" + sCMHost.getPort() + "/mod/scm-container/Pools/PoolTable/PoolEntry/";
        logWriter.println("Deleting Resource pool:" + sCMResourcePool.getResourcePoolName());
        try {
            new SMRowStatusRequest(this.rawDataRequest).destroy(string, sCMResourcePool.getResourcePoolName(), "rowstatus");
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace((PrintWriter)logWriter);
            throw sMAPIException;
        }
    }

    private void updateContainerInAgent(SCMContainer sCMContainer) throws SMAPIException, RemoteException {
        logWriter.println("Update Container: " + sCMContainer.getContainerName() + " on host: " + sCMContainer.getHostName());
        boolean bl = this.is10Module(sCMContainer.getHostName(), sCMContainer.getPort());
        SCMHost sCMHost = this.getHost(sCMContainer.getHostID());
        String string = Long.toString(sCMContainer.getProjectID());
        String string2 = bl ? string : sCMContainer.getZoneName() + "," + string;
        String string3 = sCMContainer.getResourceName();
        String string4 = Long.toString(sCMContainer.getCPUShares());
        String string5 = "0";
        if (sCMContainer.getMemory() != 0) {
            string5 = Integer.toString(sCMContainer.getMemory());
        }
        String string6 = "0";
        if (sCMContainer.getMaxSHMemory() != 0L) {
            string6 = Long.toString(sCMContainer.getMaxSHMemory());
        }
        if (string2 == null || string3 == null || string4 == null) {
            throw new SCMAPIException("incorrect parameters");
        }
        int n = sCMHost.getVersion().equals("5.10") ? 4 : 3;
        String[] stringArray = new String[n];
        StObject[][] stObjectArray = new StObject[n][1];
        String string7 = "snmp://" + sCMContainer.getHostName() + ":" + sCMContainer.getPort() + "/mod/" + "scm-container/Containers/ContTable/ContEntry";
        int n2 = 0;
        stringArray[n2] = string7 + "/" + "poolName" + "#" + string2;
        stObjectArray[n2][0] = new StString(string3);
        stringArray[++n2] = string7 + "/" + "cpuRes" + "#" + string2;
        stObjectArray[n2][0] = new StString(string4);
        stringArray[++n2] = string7 + "/" + "memCap" + "#" + string2;
        stObjectArray[n2][0] = new StString(string5);
        if (sCMHost.getVersion().equals("5.10")) {
            stringArray[++n2] = string7 + "/" + "maxSHMMemory" + "#" + string2;
            stObjectArray[n2][0] = new StString(string6);
        }
        logWriter.println(" Container update parameters");
        n2 = 0;
        while (n2 < n) {
            logWriter.println("Url: " + stringArray[n2] + " Value:" + stObjectArray[n2][0]);
            ++n2;
        }
        try {
            this.rawDataRequest.setURLValue(stringArray, stObjectArray);
            logWriter.println("Container updated successfully");
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace((PrintWriter)logWriter);
            throw sMAPIException;
        }
    }

    private void createZoneInAgent(SCMZone sCMZone) throws SMSecurityException, SMAPIException, SCMAPIException, IllegalArgumentException {
        Object object;
        logWriter.println("Create zone : " + sCMZone.getZoneName());
        if (sCMZone.getID() != 0L) {
            throw new IllegalArgumentException("invalid.newZoneId");
        }
        sCMZone.setState(SCMZone.BOOT);
        SMRowStatusRequest sMRowStatusRequest = new SMRowStatusRequest(this.rawDataRequest);
        long l = sCMZone.getPoolID();
        SCMResourcePool sCMResourcePool = null;
        int n = 161;
        try {
            sCMResourcePool = this.getResourcePool(l);
            object = this.getHost(sCMResourcePool.getHostID());
            if (!object.getVersion().equals("5.10")) {
                throw new IllegalArgumentException("newZone.invalid.hostVersion");
            }
            n = object.getPort();
        }
        catch (Exception exception) {
            throw new SCMAPIException("resourcepool.invalid", (Throwable)exception);
        }
        if (sCMResourcePool == null) {
            throw new SCMAPIException("resourcepool.invalid");
        }
        if (sCMResourcePool.getAvailableCPU() < (float)sCMZone.getCPUShare()) {
            throw new SCMAPIException("create.zone.no.cpu");
        }
        object = "snmp://" + sCMResourcePool.getHostName() + ":" + n + "/mod/" + "scm-container/Zones/ZoneTable/ZoneEntry";
        String[] stringArray = SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS;
        StString[] stStringArray = new StString[]{new StString(sCMZone.getZoneName()), new StString(sCMZone.getZonePath()), new StString(sCMZone.getNetworkInterface()), new StString(sCMZone.getZoneIP()), new StString(sCMZone.getZoneHostName()), new StString("" + sCMZone.getCPUShare()), new StString("" + sCMZone.getMaxCPUShares()), new StString(sCMZone.getState()), new StString(sCMResourcePool.getResourcePoolName()), new StString(Boolean.toString(sCMZone.getIPQSInfo().isIPQSEnabled())), new StString("" + (long)sCMZone.getIPQSInfo().getMaxInputBandWidth()), new StString("" + (long)sCMZone.getIPQSInfo().getMaxOutputBandWidth()), new StString(Boolean.toString(sCMZone.isAutoboot())), new StString(sCMZone.getAdditionalAttributes())};
        int n2 = 0;
        while (n2 < stringArray.length) {
            logWriter.println(stringArray[n2] + ":" + stStringArray[n2]);
            ++n2;
        }
        try {
            this.validateData(stringArray, (StObject[])stStringArray);
            boolean bl = sMRowStatusRequest.createAndGo((String)object, sCMZone.getZoneName(), "rowstatus", stringArray, (StObject[])stStringArray);
            if (!bl) {
                logWriter.println("Failed to create zone  " + sCMZone.getZoneName() + ", return value is not OK ");
                throw new SCMAPIException("create.zone.duplication");
            }
            logWriter.println("successfully created zone " + sCMZone.getZoneName() + " at agent " + sCMResourcePool.getHostName());
        }
        catch (SMAPIException sMAPIException) {
            sMAPIException.printStackTrace((PrintWriter)logWriter);
            throw sMAPIException;
        }
    }

    private void setSysIDInfoInAgent(SCMZone sCMZone, SCMSysIDInfo sCMSysIDInfo) throws SMSecurityException, SMAPIException, SCMAPIException, IllegalArgumentException {
        if (sCMZone.getID() != 0L) {
            throw new IllegalArgumentException("invalid.newZoneId");
        }
        if (sCMSysIDInfo != null) {
            Object object;
            Object object2;
            SMRowStatusRequest sMRowStatusRequest = new SMRowStatusRequest(this.rawDataRequest);
            long l = sCMZone.getPoolID();
            SCMResourcePool sCMResourcePool = null;
            int n = 161;
            try {
                sCMResourcePool = this.getResourcePool(l);
                object2 = this.getHost(sCMResourcePool.getHostID());
                n = object2.getPort();
            }
            catch (Exception exception) {
                throw new SCMAPIException("resourcepool.invalid", (Throwable)exception);
            }
            object2 = "snmp://" + sCMResourcePool.getHostName() + ":" + n + "/mod/" + "scm-container/SysID/SysidTable/SysidEntry";
            String string = sCMZone.getZoneName();
            String string2 = sCMZone.getZoneHostName();
            String string3 = sCMSysIDInfo.getLocale();
            String string4 = sCMSysIDInfo.getRootPasswd();
            try {
                logWriter.println("Encrypting root password...");
                object = new SCMEncrypt();
                string4 = ((SCMEncrypt)object).encrypt(string4);
                logWriter.println("Encrypted root password : " + string4);
            }
            catch (Exception exception) {
                exception.printStackTrace((PrintWriter)logWriter);
                throw new SCMAPIException("Zone's root password encryption failed");
            }
            if (string4 == null) {
                throw new SCMAPIException("Zone's root password encryption failed");
            }
            object = sCMSysIDInfo.getTerminal();
            String string5 = sCMSysIDInfo.getNameService();
            String string6 = sCMSysIDInfo.getTimeZone();
            Vector<String> vector = new Vector<String>();
            Vector<StString> vector2 = new Vector<StString>();
            vector2.addElement(new StString(string));
            vector.addElement("zoneName");
            vector2.addElement(new StString(string2));
            vector.addElement("hostName");
            vector2.addElement(new StString(string3));
            vector.addElement("locale");
            vector2.addElement(new StString(string4));
            vector.addElement("rootPasswd");
            vector2.addElement(new StString((String)object));
            vector.addElement("termType");
            vector2.addElement(new StString(string5));
            vector.addElement("nameService");
            vector2.addElement(new StString(string6));
            vector.addElement("timeZone");
            int n2 = vector.size();
            Object[] objectArray = new String[n2];
            Object[] objectArray2 = new StString[n2];
            vector.copyInto(objectArray);
            vector2.copyInto(objectArray2);
            logWriter.println("Create sysinfo for zone:" + string);
            logWriter.println("URL: " + (String)object2);
            int n3 = 0;
            while (n3 < objectArray.length) {
                logWriter.println((String)objectArray[n3] + ":" + objectArray2[n3]);
                ++n3;
            }
            try {
                boolean bl = sMRowStatusRequest.createAndGo((String)object2, string, "rowstatus", (String[])objectArray, (StObject[])objectArray2);
                if (!bl) {
                    logWriter.println("Failed to sysinfo " + string + ", return value is not OK ");
                    throw new SCMAPIException("create.zone.fail");
                }
            }
            catch (SMAPIException sMAPIException) {
                sMAPIException.printStackTrace((PrintWriter)logWriter);
                throw sMAPIException;
            }
            logWriter.println("Success: setSysIDInfoInAgent ");
        }
    }

    public void deleteZoneFromAgent(SCMZone sCMZone) throws RemoteException, SMDatabaseException, SMSecurityException, SMAPIException, SCMAPIException {
        Object object;
        SMRowStatusRequest sMRowStatusRequest = new SMRowStatusRequest(this.rawDataRequest);
        String string = sCMZone.getZoneName();
        long l = sCMZone.getPoolID();
        SCMResourcePool sCMResourcePool = null;
        int n = 161;
        try {
            sCMResourcePool = this.getResourcePool(l);
            object = this.getHost(sCMResourcePool.getHostID());
            n = object.getPort();
        }
        catch (Exception exception) {
            throw new SCMAPIException("resourcepool.invalid", (Throwable)exception);
        }
        if (string == null) {
            throw new SCMAPIException("incorrect parameters");
        }
        object = "snmp://" + sCMResourcePool.getHostName() + ":" + n + "/mod/" + "scm-container/Zones/ZoneTable/ZoneEntry";
        logWriter.println("Deleting a zone from agent zone table, the url is " + (String)object);
        sMRowStatusRequest.destroy((String)object, string, "rowstatus");
    }

    private void updateZoneInAgent(SCMZone sCMZone, boolean bl) throws SMAPIException {
        logWriter.println("Zone modification: " + sCMZone.getZoneName());
        String string = sCMZone.getZoneName();
        long l = sCMZone.getPoolID();
        SCMResourcePool sCMResourcePool = null;
        int n = 161;
        try {
            sCMResourcePool = this.getResourcePool(l);
            SCMHost sCMHost = this.getHost(sCMResourcePool.getHostID());
            n = sCMHost.getPort();
        }
        catch (Exception exception) {
            throw new SCMAPIException("resourcepool.invalid", (Throwable)exception);
        }
        if (string == null) {
            throw new SCMAPIException("incorrect parameters");
        }
        int n2 = 5;
        if (bl) {
            n2 = 1;
        }
        String[] stringArray = new String[n2];
        StObject[][] stObjectArray = new StObject[n2][1];
        String string2 = "snmp://" + sCMResourcePool.getHostName() + ":" + n + "/mod/" + "scm-container/Zones/ZoneTable/ZoneEntry";
        if (bl) {
            int n3 = 0;
            stringArray[n3] = string2 + "/" + SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS[7] + "#" + string;
            stObjectArray[n3][0] = new StString(sCMZone.getState());
        } else {
            int n4 = 0;
            stringArray[n4] = string2 + "/" + SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS[8] + "#" + string;
            stObjectArray[n4][0] = new StString(sCMResourcePool.getResourcePoolName());
            stringArray[++n4] = string2 + "/" + SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS[5] + "#" + string;
            stObjectArray[n4][0] = new StString(Long.toString(sCMZone.getCPUShare()));
            stringArray[++n4] = string2 + "/" + SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS[6] + "#" + string;
            stObjectArray[n4][0] = new StString(Long.toString(sCMZone.getMaxCPUShares()));
            stringArray[++n4] = string2 + "/" + SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS[10] + "#" + string;
            stObjectArray[n4][0] = new StString(Long.toString((long)sCMZone.getIPQSInfo().getMaxInputBandWidth()));
            stringArray[++n4] = string2 + "/" + SCMZoneManager.SYNC_AGENT_ZONE_MIB_COLUMNS[11] + "#" + string;
            stObjectArray[n4][0] = new StString(Long.toString((long)sCMZone.getIPQSInfo().getMaxOutputBandWidth()));
        }
        this.rawDataRequest.setURLValue(stringArray, stObjectArray);
    }

    public boolean is10Module(String string, int n) {
        return false;
    }

    private Vector getDatesForMonth() {
        Date date = null;
        Date date2 = null;
        int n = 30;
        Vector<Date> vector = new Vector<Date>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        date2 = calendar.getTime();
        calendar.add(5, -(n - 1));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        date = calendar.getTime();
        vector.add(date);
        vector.add(date2);
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    public SCMMoveProcessesResult moveProcesses(SCMContainer var1_1, SCMContainer var2_2, Set var3_3) throws RemoteException {
        try {
            this.checkAccess("moveProcesses");
            SCMServiceImpl.logWriter.println("Move processes");
            var4_4 = new HashMap<Long, Boolean>();
            var5_6 = new HashMap<Long, SMAPIException>();
            var6_7 = new String[SCMServiceConstants.MOVE_PROCESS_FIELDS.length];
            var6_7[0] = "snmp://" + var1_1.getHostName() + ":" + var1_1.getPort() + "/mod/" + "scm-container/Action" + "/" + SCMServiceConstants.MOVE_PROCESS_FIELDS[0] + "#0";
            var7_8 = var3_3.iterator();
            block4: while (var7_8.hasNext()) {
                var8_9 = (Long)var7_8.next();
                try {
                    var9_10 = new StString[SCMServiceConstants.MOVE_PROCESS_FIELDS.length][1];
                    var9_10[0][0] = new StString(var8_9 + ":" + var2_2.getProjectName() + ":" + var2_2.getZoneName());
                    SCMServiceImpl.logWriter.println("SNMP URL: " + var6_7[0] + " - " + var8_9 + ":" + var2_2.getProjectName() + ":" + var2_2.getZoneName());
                    this.rawDataRequest.setURLValue(var6_7, (StObject[][])var9_10);
                    var4_4.put(var8_9, Boolean.TRUE);
                    continue;
                }
                catch (SMAPIException var9_11) {
                    var9_11.printStackTrace((PrintWriter)SCMServiceImpl.logWriter);
                    var5_6.put(var8_9, var9_11);
                    if (var9_11.getReasonCode() != 4 && var9_11.getReasonCode() != 1) continue;
                    ** while (var7_8.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    var5_6.put(var8_9, var9_11);
                    continue;
lbl29:
                    // 1 sources

                }
            }
            var8_9 = new SCMMoveProcessesResult(var1_1, var2_2, var4_4, var5_6, null);
            SCMServiceImpl.logWriter.println("Result of Move Processes was:" + var8_9);
            return var8_9;
        }
        catch (SMSecurityException var4_5) {
            var4_5.printStackTrace((PrintWriter)SCMServiceImpl.logWriter);
            return new SCMMoveProcessesResult(var1_1, var2_2, Collections.EMPTY_MAP, Collections.EMPTY_MAP, (Exception)var4_5);
        }
    }

    public SCMReportResult[] runPerformanceReport(SCMTreeNode sCMTreeNode, Vector vector, String string, int n, Date date, Date date2, int n2, int n3, int n4) throws SMAPIException, RemoteException, SCMAPIException {
        this.checkAccess("runPerformanceReport");
        if (!this.isReportingAvailable()) {
            return null;
        }
        if (n == 101) {
            n = 0;
            Vector vector2 = this.getDatesForMonth();
            date = (Date)vector2.elementAt(0);
            date2 = (Date)vector2.elementAt(1);
        }
        return this.reportDispatcher.runPerformanceReport(sCMTreeNode, vector, string, n, date, date2, n2, n3, n4);
    }

    public SCMReportResult[] runPerformanceReport(SCMContainer sCMContainer, Vector vector, String string, int n, Date date, Date date2) throws SMAPIException, RemoteException, SCMAPIException {
        this.checkAccess("runPerformanceReport");
        if (!this.isReportingAvailable()) {
            return null;
        }
        return null;
    }

    public long getAvailableCPUForNewPool(long l) throws RemoteException, SMSecurityException, SMDatabaseException {
        this.checkAccess("getAvailableCPUForNewPool");
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        try {
            SCMHost sCMHost = this.getHost(l);
            l3 = sCMHost.getProcessors();
            SCMResourcePool[] sCMResourcePoolArray = SCMResourcePoolManager.getResourcePools(l);
            int n = 0;
            while (n < sCMResourcePoolArray.length) {
                l4 += sCMResourcePoolArray[n].getMinCPU();
                ++n;
            }
            l2 = l3 - l4;
        }
        catch (Exception exception) {
            exception.printStackTrace((PrintWriter)logWriter);
            throw new SMDatabaseException("error while getting available CPUs");
        }
        return l2;
    }

    private final SCMResourcePool fetchCurrentCPUSize4Pool(SCMResourcePool sCMResourcePool) throws RemoteException {
        if (sCMResourcePool != null) {
            try {
                SCMHost sCMHost = this.getHost(sCMResourcePool.getHostID());
                String string = "snmp://" + sCMHost.getHostName() + ":" + sCMHost.getPort() + "/mod/scm-container/Pools/PoolTable/PoolEntry/cpus#" + sCMResourcePool.getResourcePoolName();
                String string2 = this.retriveDataFromURL(string);
                long l = 0L;
                try {
                    l = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    l = 0L;
                }
                sCMResourcePool.setCurrentCPU(l);
            }
            catch (SMAPIException sMAPIException) {
                throw new RemoteException("error retriving current  cpu data of resource pool " + sCMResourcePool.getResourcePoolName() + " on host " + sCMResourcePool.getHostName(), sMAPIException);
            }
        }
        return sCMResourcePool;
    }

    private final String retriveDataFromURL(String string) throws SCMAPIException, SMAPIException {
        String[] stringArray = new String[]{string};
        StObject[][] stObjectArray = this.rawDataRequest.getURLValue(stringArray);
        if (stObjectArray == null || stObjectArray.length < 1) {
            throw new SMAPIException("Invalid return values for the url request:" + string);
        }
        Vector[] vectorArray = SCMSynchronizer.decryptData(stObjectArray, empty, string);
        String string2 = vectorArray[0].get(0).toString();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SCMAlarmRecord[] getAlarms() throws RemoteException, SMAPIException, SMDatabaseException {
        this.checkAccess("getAlarms");
        SCMServiceImpl sCMServiceImpl = this;
        synchronized (sCMServiceImpl) {
            if (this.scmHierarchy == null) {
                this.scmHierarchy = new SCMHierarchyData(this, this.rawDataRequest, this.dbobj);
            }
        }
        return this.scmHierarchy.getAlarms();
    }

    public SCMHostInfo getSCMHostInfo(long l) throws SMAPIException, RemoteException, SMDatabaseException {
        SCMHost sCMHost = this.getHost(l);
        String string = "snmp://" + sCMHost.getHostName() + ":" + sCMHost.getPort();
        String string2 = this.retriveDataFromURL(string + NETWORK_INTF_URL);
        String string3 = this.retriveDataFromURL(string + TERMINAL_TYPES_URL);
        String string4 = this.retriveDataFromURL(string + TIMEZONES__URL);
        String string5 = this.retriveDataFromURL(string + LOCALE_URL);
        return new SCMHostInfo(SCMServiceImpl.tokenize(string2, ',', false), SCMServiceImpl.tokenize(string3, ',', false), SCMServiceImpl.tokenize(string4, ',', false), SCMServiceImpl.tokenize(string5, ',', false));
    }

    private static final String[] tokenize(String string, char c, boolean bl) {
        String string2;
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = string;
        int n = 0;
        int n2 = string3.indexOf(c);
        while (n2 >= 0) {
            if (n2 != 0 && string3.charAt(n2 - 1) == ESCAPE_FORWARD_SLASH_CHAR) {
                string3 = string3.substring(0, n2 - 1) + string3.substring(n2);
                n2 = string3.indexOf(c, n2);
                continue;
            }
            string2 = string3.substring(n, n2);
            n = n2 + 1;
            n2 = string3.indexOf(c, n);
            if (!bl && string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        string2 = string3.substring(n);
        if (string3.length() > 0 && (bl || string2.length() > 0)) {
            arrayList.add(string2);
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    static {
        scmDomain = null;
        EMPTY_STRING_ARRAY = new String[0];
        ESCAPE_FORWARD_SLASH_CHAR = "\\".charAt(0);
        empty = new String[]{""};
        try {
            scService = MSSecurity.getInstance();
            controller = SCMServiceController.getInstance();
            logWriter = controller.getLogWriter();
        }
        catch (SMSecurityException sMSecurityException) {
            logWriter.println("Security service is not available.\nExiting ...");
            System.exit(1);
        }
    }
}

