/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.common.MSSecurity;
import com.sun.symon.base.mgmtservice.framework.MSBaseServiceInterface;
import com.sun.symon.base.mgmtservice.framework.MSServiceLocator;
import com.sun.symon.base.mgmtservice.framework.MSServiceProvider;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceConstants;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceImpl;
import com.sun.symon.base.mgmtservice.scm.manager.SCMTrapHandler;
import com.sun.symon.base.server.common.ScSecurityCredential;

public class SCMServiceController
implements MSServiceLocator,
MSServiceProvider,
SCMServiceConstants {
    private String serviceName = null;
    private MSLogPrintWriter logWriter;
    private MSLogPrintWriter errorWriter;
    private static SCMServiceController controller;
    private static SMRawDataRequest rawDataRequest;

    public static SCMServiceController getInstance() {
        return controller;
    }

    public SCMServiceController(String string) {
        this.serviceName = string;
        controller = this;
        try {
            this.errorWriter = this.logWriter = MSLogPrintWriter.getChannel((String)"scmlog");
        }
        catch (Exception exception) {
            try {
                this.errorWriter = this.logWriter = MSLogPrintWriter.createChannel((String)"scmlog");
            }
            catch (Exception exception2) {
                System.out.println("CANNOT CREATE SCMLOG: " + exception2.getMessage());
                this.logWriter = MSLogPrintWriter.getInfoWriter();
                this.errorWriter = MSLogPrintWriter.getErrorWriter();
            }
        }
        ScSecurityCredential scSecurityCredential = null;
        try {
            scSecurityCredential = MSSecurity.getMasterUser();
            rawDataRequest = new SMRawDataRequest(scSecurityCredential);
            rawDataRequest.setGUIMode(false);
            this.logWriter.println("RawDataRequest: " + rawDataRequest);
            this.logWriter.println("createSCMHiddenDomain");
        }
        catch (Exception exception) {
            this.logWriter.println("Error in creating SMRawDataRequest");
        }
        SCMTrapHandler sCMTrapHandler = SCMTrapHandler.getInstance();
    }

    public MSLogPrintWriter getLogWriter() {
        return this.logWriter;
    }

    public MSLogPrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public MSServiceProvider register() {
        return this;
    }

    public MSBaseServiceInterface getService(ScSecurityCredential scSecurityCredential, String string) throws Exception {
        return new SCMServiceImpl(scSecurityCredential, string);
    }
}

