/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager;

import com.sun.symon.base.client.scm.manager.SCMHostTree;
import com.sun.symon.base.client.scm.manager.SCMResourcePool;
import com.sun.symon.base.client.scm.manager.SCMResourcePoolTree;
import com.sun.symon.base.client.scm.manager.SCMZoneTree;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.mgmtservice.common.MSDB;
import com.sun.symon.base.mgmtservice.scm.manager.SCMDB;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public final class SCMResourcePoolManager
extends SCMDB {
    private static final SCMResourcePool[] EMPTY_RESOURCE_POOL_ARRAY = new SCMResourcePool[0];
    static final String DEFAULT_RESOURCE_POOL_NAME = "pool_default";
    static final String AGENT_RESOURCE_POOL_MIB_COLUMN_NAME = "poolName";
    static final String AGENT_RESOURCE_POOL_MIB_URL = "/mod/scm-container/Pools/PoolTable/PoolEntry/";
    static final String[] AGENT_RESOURCE_POOL_MIB_COLUMNS = new String[]{"schedClass", "mincpus", "maxcpus", "maxCPUShares", "objectives"};
    static final String AGENT_RESOURCE_POOL_CURRENT_CPU_URL = "/mod/scm-container/Pools/PoolTable/PoolEntry/cpus#";
    static final String[] SYNC_AGENT_RESOURCE_POOL_MIB_COLUMNS = new String[]{"poolName", AGENT_RESOURCE_POOL_MIB_COLUMNS[0], AGENT_RESOURCE_POOL_MIB_COLUMNS[1], AGENT_RESOURCE_POOL_MIB_COLUMNS[2], AGENT_RESOURCE_POOL_MIB_COLUMNS[3], AGENT_RESOURCE_POOL_MIB_COLUMNS[4], "default"};
    private static final String SP_GET_HOST_RESOURCEPOOLS = "{call sp_get_resource_pools(?, ?)}";
    private static final int SP_GET_HOST_RESOURCEPOOLS_HOST_ID = 1;
    private static final String SP_GET_HOST_DEFAULT_RESOURCEPOOL = "{call sp_get_default_resource_pool(?, ?)}";
    private static final int SP_GET_HOST_DEFAULT_RESOURCEPOOL_HOST_ID = 1;
    private static final int SP_GET_HOST_DEFAULT_RESOURCEPOOL_CSR = 2;
    private static final String SP_GET_RESOURCEPOOL = "{call sp_get_resource_pool(?, ?)}";
    private static final int SP_GET_RESOURCEPOOL_ID = 1;
    private static final int SP_GET_RESOURCEPOOL_CSR = 2;
    private static final String SP_GET_RESOURCEPOOLS = "{call sp_get_resource_pools_info(?, ?)}";
    private static final int SP_GET_RESOURCEPOOLS_ID = 1;
    private static final int SP_GET_RESOURCEPOOLS_CSR = 2;
    private static final String SP_GET_RESOURCEID = "{call sp_get_poolid_by_names(?, ?, ?)}";
    private static final int SP_GET_RESOURCEID_POOLNAME = 1;
    private static final int SP_GET_RESOURCEID_HOSTNAME = 2;
    private static final int SP_GET_RESOURCEID_ID = 3;
    static final String SP_SAVE_RESOURCE = "{call sp_save_scm_resource_pool(" + SCMDB.createParamString(11) + ")}";
    static final int P_SAVE_RESOURCE_ID = 1;
    static final int P_SAVE_RESOURCE_NAME = 2;
    static final int P_SAVE_RESOURCE_DESC = 3;
    static final int P_SAVE_RESOURCE_SCHED_CLASS = 4;
    static final int P_SAVE_RESOURCE_MIN_CPU = 5;
    static final int P_SAVE_RESOURCE_MAX_CPU = 6;
    static final int P_SAVE_RESOURCE_MEMSET = 7;
    static final int P_SAVE_RESOURCE_HOST_ID = 8;
    static final int P_SAVE_RESOURCE_IS_DEFAULT = 9;
    static final int P_SAVE_RESOURCE_OBJECTIVE = 10;
    static final int P_SAVE_RESOURCE_MAX_CPU_SHARES = 11;
    static final int SP_DELETE_RESOURCE_ID = 1;
    static final String SP_DELETE_RESOURCE = "{call sp_delete_resource_pool(" + SCMDB.createParamString(1) + ")}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long persistResourcePool(SCMResourcePool sCMResourcePool) throws SMDatabaseException {
        long l2 = sCMResourcePool.getResourcePoolID();
        String string = sCMResourcePool.getResourcePoolName();
        String string2 = sCMResourcePool.getResourcePoolDescription();
        String string3 = "" + sCMResourcePool.getSchedulerClass();
        long l3 = sCMResourcePool.getMinCPU();
        long l4 = sCMResourcePool.getMaxCPU();
        long l5 = sCMResourcePool.getMemory();
        long l6 = sCMResourcePool.getHostID();
        String string4 = sCMResourcePool.isDefault() ? "1" : "0";
        String string5 = sCMResourcePool.getObjectives();
        long l7 = sCMResourcePool.getMaxCPUShares();
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        long l = 0L;
        try {
            try {
                callableStatement = connection.prepareCall(SP_SAVE_RESOURCE);
                callableStatement.registerOutParameter(1, 2);
                if (l2 == 0L) {
                    callableStatement.setNull(1, 2);
                } else {
                    callableStatement.setLong(1, l2);
                }
                callableStatement.setString(2, string);
                callableStatement.setString(3, string2);
                callableStatement.setString(4, string3);
                callableStatement.setLong(5, l3);
                callableStatement.setLong(6, l4);
                callableStatement.setLong(7, l5);
                callableStatement.setLong(8, l6);
                callableStatement.setString(9, string4);
                callableStatement.setLong(11, l7);
                callableStatement.setString(10, string5);
                callableStatement.execute();
                l = callableStatement.getLong(1);
                connection.commit();
            }
            catch (SQLException sQLException) {
                SCMDB.logWriter.println("saveResource: Exception: " + sQLException);
                sQLException.printStackTrace(SCMDB.logWriter);
                l = -1L;
                Object var24_16 = null;
                SCMDB.closeCall(callableStatement);
                MSDB.closeConnection((Connection)connection);
                return l;
            }
            Object var24_15 = null;
        }
        catch (Throwable throwable) {
            Object var24_17 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static void deleteResource(long l) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            try {
                callableStatement = connection.prepareCall(SP_DELETE_RESOURCE);
                callableStatement.setLong(1, l);
                callableStatement.execute();
                connection.commit();
            }
            catch (SQLException sQLException) {
                MSDB.rollback((Connection)connection);
                SCMDB.logWriter.println("deleteResource: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
    }

    public static SCMResourcePool[] getResourcePools(long[] lArray) throws SMDatabaseException {
        Object[] objectArray;
        Vector<SCMResourcePool> vector = new Vector<SCMResourcePool>();
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(SP_GET_RESOURCEPOOLS);
            callableStatement.registerOutParameter(2, -10);
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)callableStatement;
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"SCM.TYPE_POOLIDS", (Connection)connection);
            ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)lArray);
            oracleCallableStatement.setARRAY(1, aRRAY);
            oracleCallableStatement.execute();
            ResultSet resultSet = (ResultSet)callableStatement.getObject(2);
            while (resultSet.next()) {
                vector.addElement(SCMResourcePoolManager.createResourcePool(resultSet));
            }
            connection.commit();
            Object[] objectArray2 = new SCMResourcePool[vector.size()];
            vector.copyInto(objectArray2);
            objectArray = objectArray2;
            Object var11_11 = null;
        }
        catch (SQLException sQLException) {
            try {
                SCMDB.logWriter.println("getResourcePools: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                SCMDB.closeCall(callableStatement);
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return objectArray;
    }

    public static long getResourcePoolID(String string, String string2) throws SMDatabaseException {
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        long l = -1L;
        try {
            try {
                callableStatement = connection.prepareCall(SP_GET_RESOURCEID);
                callableStatement.setString(1, string);
                callableStatement.setString(2, string2);
                callableStatement.registerOutParameter(3, 2);
                callableStatement.execute();
                l = callableStatement.getLong(3);
            }
            catch (SQLException sQLException) {
                SCMDB.logWriter.println("getResourceID: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return l;
    }

    public static SCMResourcePool[] getResourcePools(long l) throws SMDatabaseException {
        SCMResourcePool[] sCMResourcePoolArray;
        Vector<SCMResourcePool[]> vector = new Vector<SCMResourcePool[]>();
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall(SP_GET_HOST_RESOURCEPOOLS);
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            ResultSet resultSet = (ResultSet)callableStatement.getObject(2);
            while (resultSet.next()) {
                sCMResourcePoolArray = SCMResourcePoolManager.createResourcePool(resultSet);
                vector.addElement(sCMResourcePoolArray);
            }
            sCMResourcePoolArray = vector.toArray(EMPTY_RESOURCE_POOL_ARRAY);
            Object var8_7 = null;
        }
        catch (SQLException sQLException) {
            try {
                SCMDB.logWriter.println("getResourcePools: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                SCMDB.closeCall(callableStatement);
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sCMResourcePoolArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SCMResourcePool getDefaultResourcePool(long l) throws SMDatabaseException {
        SCMResourcePool sCMResourcePool;
        CallableStatement callableStatement;
        Connection connection;
        block5: {
            connection = MSDB.getConnection();
            callableStatement = null;
            callableStatement = connection.prepareCall(SP_GET_HOST_DEFAULT_RESOURCEPOOL);
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            ResultSet resultSet = (ResultSet)callableStatement.getObject(2);
            if (!resultSet.next()) throw new SQLException("In consistant Database - Default Resource Pool is not present for the host ID: " + l);
            sCMResourcePool = SCMResourcePoolManager.createResourcePool(resultSet);
            if (!sCMResourcePool.isDefault()) break block5;
            SCMResourcePool sCMResourcePool2 = sCMResourcePool;
            Object var8_7 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            return sCMResourcePool2;
        }
        try {
            try {
                throw new SQLException("Either SQL Procedure is fetching non-default pool or some thing is wrong in setting the isDefault() values of Resource Pool Object, read pool name:" + sCMResourcePool.getResourcePoolName());
            }
            catch (SQLException sQLException) {
                SCMDB.logWriter.println("getDefaultResourcePool: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SCMDB.closeCall(callableStatement);
            MSDB.closeConnection((Connection)connection);
            throw throwable;
        }
    }

    public static SCMResourcePool getResourcePool(long l) throws SMDatabaseException {
        SCMResourcePool sCMResourcePool;
        Connection connection = MSDB.getConnection();
        CallableStatement callableStatement = null;
        try {
            SCMResourcePool sCMResourcePool2 = null;
            callableStatement = connection.prepareCall(SP_GET_RESOURCEPOOL);
            callableStatement.registerOutParameter(2, -10);
            callableStatement.setLong(1, l);
            callableStatement.execute();
            ResultSet resultSet = (ResultSet)callableStatement.getObject(2);
            while (resultSet.next()) {
                sCMResourcePool2 = SCMResourcePoolManager.createResourcePool(resultSet);
            }
            sCMResourcePool = sCMResourcePool2;
            Object var8_7 = null;
        }
        catch (SQLException sQLException) {
            try {
                SCMDB.logWriter.println("getResourcePool: Exception: " + sQLException);
                throw SCMDB.getSMDatabaseException(sQLException);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                SCMDB.closeCall(callableStatement);
                MSDB.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        SCMDB.closeCall(callableStatement);
        MSDB.closeConnection((Connection)connection);
        return sCMResourcePool;
    }

    static void getAllResourcePools(Connection connection, SCMHostTree sCMHostTree) throws SQLException {
        if (connection == null || sCMHostTree == null) {
            return;
        }
        CallableStatement callableStatement = connection.prepareCall(SP_GET_HOST_RESOURCEPOOLS);
        callableStatement.registerOutParameter(2, -10);
        callableStatement.setLong(1, sCMHostTree.getHostID());
        callableStatement.execute();
        ResultSet resultSet = (ResultSet)callableStatement.getObject(2);
        while (resultSet.next()) {
            long l = resultSet.getLong("resource_pool_id");
            String string = resultSet.getString("resource_pool_name");
            long l2 = l + 20000L;
            boolean bl = false;
            if (resultSet.getString("is_default").equals("1")) {
                bl = true;
            }
            SCMResourcePoolTree sCMResourcePoolTree = new SCMResourcePoolTree(l2, sCMHostTree, string, sCMHostTree.getPort(), sCMHostTree.getHostID(), l);
            sCMResourcePoolTree.setIsDefault(bl);
            String string2 = sCMHostTree.getVersion();
            sCMResourcePoolTree.setVersion(string2);
            if (!SCMDB.isSolaris10(string2)) continue;
            sCMResourcePoolTree.setIsFolder(true);
            SCMResourcePoolManager.getAllZoneNode(connection, sCMResourcePoolTree);
        }
        resultSet.close();
        SCMDB.closeCallableStmt(callableStatement);
    }

    private static void getAllZoneNode(Connection connection, SCMResourcePoolTree sCMResourcePoolTree) throws SQLException {
        if (connection == null || sCMResourcePoolTree == null) {
            return;
        }
        CallableStatement callableStatement = connection.prepareCall("{call sp_get_zones_by_poolid(?, ?)}");
        callableStatement.registerOutParameter(2, -10);
        callableStatement.setLong(1, sCMResourcePoolTree.getResourcePoolID());
        callableStatement.execute();
        ResultSet resultSet = (ResultSet)callableStatement.getObject(2);
        while (resultSet.next()) {
            String string;
            long l = resultSet.getLong("zone_id");
            String string2 = string = resultSet.getString("zone_name");
            long l2 = l + 40000L;
            SCMZoneTree sCMZoneTree = new SCMZoneTree(l2, (SCMHostTree)sCMResourcePoolTree, string, sCMResourcePoolTree.getPort(), sCMResourcePoolTree.getHostID(), sCMResourcePoolTree.getResourcePoolID(), l);
        }
        resultSet.close();
        SCMDB.closeCallableStmt(callableStatement);
    }

    private static final SCMResourcePool createResourcePool(ResultSet resultSet) throws SQLException {
        long l = resultSet.getLong("resource_pool_id");
        String string = resultSet.getString("resource_pool_name");
        String string2 = resultSet.getString("description");
        String string3 = resultSet.getString("sched_class");
        int n = new Float(resultSet.getFloat("mincpu")).intValue();
        int n2 = new Float(resultSet.getFloat("maxcpu")).intValue();
        float f = resultSet.getFloat("avail_cpu");
        int n3 = new Float(resultSet.getFloat("memory")).intValue();
        int n4 = new Float(resultSet.getFloat("avail_mem")).intValue();
        String string4 = resultSet.getString("host_name");
        long l2 = resultSet.getLong("host_id");
        String string5 = resultSet.getString("objectives");
        long l3 = resultSet.getLong("maxcpushares");
        int n5 = 0;
        boolean bl = false;
        if (resultSet.getString("is_default").equals("1")) {
            bl = true;
        }
        return new SCMResourcePool(l, string, string2, string3, (long)n, (long)n2, l3, string5, (long)n3, bl, l2, string4, (long)n5, f, (float)n4);
    }
}

