/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.mgmtservice.scm.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmIteratorSync;
import com.sun.symon.base.client.alarm.SMAlarmObjectData;
import com.sun.symon.base.client.alarm.SMAlarmObjectRequest;
import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.client.scm.manager.SCMAlarmRecord;
import com.sun.symon.base.client.scm.manager.SCMContainer;
import com.sun.symon.base.client.scm.manager.SCMContainerTree;
import com.sun.symon.base.client.scm.manager.SCMHostTree;
import com.sun.symon.base.client.scm.manager.SCMProject;
import com.sun.symon.base.client.scm.manager.SCMResourcePoolTree;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.topology.SMTopologyEntityInfo;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.mgmtservice.common.MSLogPrintWriter;
import com.sun.symon.base.mgmtservice.scm.manager.SCMDB;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceController;
import com.sun.symon.base.mgmtservice.scm.manager.SCMServiceImpl;
import com.sun.symon.base.utility.UcURL;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SCMHierarchyData {
    static final int STATUS_INIT = 7;
    static final String OPEN_STATE = "O";
    static final String CLOSE_STATE = "C";
    static final String SCM_MODULE_PATTERN = "/mod/scm-container/Containers/ContTable/ContEntry";
    static final String TOPOLOGYVIEW_PATTERN = "entityViewTable/entityViewEntry/entityStatus";
    static final String SCM_ZONE_PATTERN = "/mod/scm-container/Zones/ZoneTable/ZoneEntry/zoneState";
    static final String INDEX_CHAR = "#";
    private static MSLogPrintWriter logWriter;
    private SMRawDataRequest rawDataRequest;
    private SMTopologyRequest topoRequest;
    private SCMServiceImpl service;
    private SCMDB scmDB;
    private SMAlarmObjectRequest alarmRequest = null;
    private SMUserDomainData scmDomain = null;
    private String scmDomainName = null;

    public SCMHierarchyData(SCMServiceImpl sCMServiceImpl, SMRawDataRequest sMRawDataRequest, SCMDB sCMDB) {
        SCMServiceController sCMServiceController = SCMServiceController.getInstance();
        logWriter = sCMServiceController.getLogWriter();
        this.rawDataRequest = sMRawDataRequest;
        this.topoRequest = new SMTopologyRequest(sMRawDataRequest);
        this.scmDB = sCMDB;
        this.service = sCMServiceImpl;
        try {
            this.scmDomain = sCMServiceImpl.getSCMDomain();
            this.scmDomainName = this.scmDomain.getCompleteDomainName();
        }
        catch (Exception exception) {
            logWriter.println("Exception occurs when trying to get alarms: " + exception.getMessage());
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
    }

    public void cleanup() {
        block2: {
            if (this.alarmRequest == null) break block2;
            try {
                this.alarmRequest.closeSyncConnection();
                this.alarmRequest.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    public SCMHostTree getHostTree() throws SMDatabaseException {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        SCMHostTree sCMHostTree = SCMDB.getHostTree();
        Vector vector = null;
        try {
            vector = this.getDimensionAlarms(hashtable);
        }
        catch (Exception exception) {
            logWriter.println((Throwable)exception);
            return sCMHostTree;
        }
        this.processAlarms(vector, hashtable, hashtable3, hashtable2);
        this.propagateHostAlarms(sCMHostTree, hashtable3, hashtable2);
        return sCMHostTree;
    }

    public SCMContainerTree getContainerTree() throws SMDatabaseException {
        SCMContainerTree sCMContainerTree = SCMDB.getContainerTree();
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Vector vector = null;
        try {
            vector = this.getDimensionAlarms(hashtable);
        }
        catch (Exception exception) {
            return sCMContainerTree;
        }
        Hashtable hashtable3 = new Hashtable();
        this.processAlarms(vector, hashtable, hashtable2, hashtable3);
        this.propagateContainerAlarms(sCMContainerTree, hashtable2, hashtable3);
        return sCMContainerTree;
    }

    private synchronized Vector getDimensionAlarms(Hashtable hashtable) {
        String string = null;
        String string2 = "{O}";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = "{A} {N}";
        SMAlarmIteratorSync sMAlarmIteratorSync = null;
        Vector vector = new Vector();
        try {
            Object object;
            if (this.scmDomain == null) {
                this.scmDomain = this.service.getSCMDomain();
            }
            if (this.scmDomain == null) {
                logWriter.println("no SCM domain, no SCM entity");
                return vector;
            }
            SMTopologyEntityInfo[] sMTopologyEntityInfoArray = this.topoRequest.getTopologyEntitiesInfo(this.scmDomain.getDomainRootUrl());
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < sMTopologyEntityInfoArray.length) {
                if (n > 0) {
                    stringBuffer.append(" ");
                }
                object = new UcURL(sMTopologyEntityInfoArray[n].getTargetUrl());
                String string9 = "snmp://" + object.getHost() + ":" + object.getPort() + SCM_MODULE_PATTERN;
                stringBuffer.append("{" + string9 + "}");
                string9 = "snmp://" + object.getHost() + ":" + object.getPort() + SCM_ZONE_PATTERN;
                stringBuffer.append(" {" + string9 + "}");
                if (hashtable != null) {
                    String string10 = sMTopologyEntityInfoArray[n].getParentUrl() + "/" + TOPOLOGYVIEW_PATTERN;
                    string9 = SMRawDataRequest.buildShadowURL((String)string10, null, (String)(sMTopologyEntityInfoArray[n].getEntity() + "/"));
                    stringBuffer.append(" {" + string9 + "}");
                    String string11 = object.getHost() + ":" + object.getPort();
                    hashtable.put(sMTopologyEntityInfoArray[n].getEntity(), string11);
                }
                ++n;
            }
            string6 = stringBuffer.toString();
            if (this.alarmRequest != null) {
                try {
                    sMAlarmIteratorSync = this.alarmRequest.getAlarms("1", string, string6, string7, string2, string8, string3, string5, string4);
                }
                catch (Exception exception) {
                    try {
                        this.alarmRequest.closeSyncConnection();
                        this.alarmRequest.closeConnection();
                    }
                    catch (Throwable throwable) {
                        logWriter.println(throwable);
                    }
                    this.alarmRequest = null;
                }
            }
            if (this.alarmRequest == null) {
                this.alarmRequest = new SMAlarmObjectRequest(this.rawDataRequest, null);
                sMAlarmIteratorSync = this.alarmRequest.getAlarms("1", string, string6, string7, string2, string8, string3, string5, string4);
            }
            object = sMAlarmIteratorSync.getData();
            while (((Vector)object).size() > 0) {
                vector.addAll(object);
                sMAlarmIteratorSync = sMAlarmIteratorSync.getNextAlarms();
                object = sMAlarmIteratorSync.getData();
            }
        }
        catch (SMAPIException sMAPIException) {
            logWriter.println(sMAPIException.getMessage());
        }
        return vector;
    }

    private void processAlarms(Vector vector, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        Vector vector2 = vector;
        SMAlarmObjectData sMAlarmObjectData = null;
        int n = this.scmDomainName.length();
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string;
            int n3;
            String string2;
            sMAlarmObjectData = (SMAlarmObjectData)vector2.elementAt(n2);
            if (hashtable2 != null && TOPOLOGYVIEW_PATTERN.indexOf(sMAlarmObjectData.getManagedObject()) >= 0) {
                string2 = sMAlarmObjectData.getPropertyInstance();
                if (string2 != null && string2.length() != 0) {
                    n3 = string2.length();
                    if (string2.charAt(n3 - 1) == '/') {
                        string2 = string2.substring(0, n3 - 1);
                    }
                    if ((string = (String)hashtable.get(string2)) != null) {
                        String string3 = sMAlarmObjectData.getAlarmShortText();
                        int n4 = string3.indexOf(this.scmDomainName);
                        if (n4 != -1) {
                            string3 = string3.substring(n);
                            sMAlarmObjectData.setAlarmShortText(string3);
                        }
                        hashtable2.put(string, sMAlarmObjectData);
                    }
                }
            } else {
                string2 = sMAlarmObjectData.getPropertyInstance();
                n3 = string2.length();
                if (string2 != null && n3 > 0 && string2.charAt(n3 - 1) == '/') {
                    string2 = string2.substring(0, n3 - 1);
                }
                string = sMAlarmObjectData.getIp() + ":" + sMAlarmObjectData.getAgentPort() + ":" + string2;
                hashtable3.put(string, sMAlarmObjectData);
            }
            ++n2;
        }
    }

    private SMAlarmObjectData propagateHostAlarms(SCMHostTree sCMHostTree, Hashtable hashtable, Hashtable hashtable2) {
        SMAlarmObjectData sMAlarmObjectData = null;
        if (sCMHostTree == null) {
            return sMAlarmObjectData;
        }
        Vector vector = sCMHostTree.getChildren();
        if (sCMHostTree.isFolder()) {
            if (vector == null || vector.size() == 0) {
                return sMAlarmObjectData;
            }
            int n = 0;
            while (n < vector.size()) {
                SCMHostTree sCMHostTree2 = (SCMHostTree)vector.elementAt(n);
                SMAlarmObjectData sMAlarmObjectData2 = this.propagateHostAlarms(sCMHostTree2, hashtable, hashtable2);
                if (sMAlarmObjectData2 != null) {
                    sMAlarmObjectData = this.getStatusData(sMAlarmObjectData2, sMAlarmObjectData, true);
                }
                ++n;
            }
            if (sMAlarmObjectData != null) {
                sCMHostTree.setAlarmStatus(sMAlarmObjectData);
            }
            return sMAlarmObjectData;
        }
        String string = null;
        String string2 = null;
        try {
            string = this.service.getHost(sCMHostTree.getHostID()).getHostName();
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {
            string2 = string;
            logWriter.println("unable to get host ip, use host name: " + string2);
        }
        String string3 = string2 + ":" + sCMHostTree.getPort();
        SMAlarmObjectData sMAlarmObjectData3 = (SMAlarmObjectData)hashtable.get(string3);
        if (sMAlarmObjectData3 != null) {
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    SCMResourcePoolTree sCMResourcePoolTree = (SCMResourcePoolTree)vector.elementAt(n);
                    sCMResourcePoolTree.setAlarmStatus(sMAlarmObjectData3);
                    ++n;
                }
            }
            sCMHostTree.setAlarmStatus(sMAlarmObjectData3);
            return sMAlarmObjectData3;
        }
        if (vector == null || vector.size() == 0) {
            return sMAlarmObjectData;
        }
        SCMContainer[] sCMContainerArray = null;
        int n = 0;
        while (n < vector.size()) {
            block20: {
                SMAlarmObjectData sMAlarmObjectData4 = null;
                SCMResourcePoolTree sCMResourcePoolTree = (SCMResourcePoolTree)vector.elementAt(n);
                try {
                    sCMContainerArray = SCMDB.getContainers(sCMResourcePoolTree.getID(), true);
                }
                catch (Exception exception) {
                    break block20;
                }
                if (sCMContainerArray != null) {
                    int n2 = 0;
                    while (n2 < sCMContainerArray.length) {
                        String string4 = string3 + ":" + sCMContainerArray[n2].getZoneName() + "," + sCMContainerArray[n2].getProjectID();
                        SMAlarmObjectData sMAlarmObjectData5 = (SMAlarmObjectData)hashtable2.get(string4);
                        if (sMAlarmObjectData5 != null) {
                            sMAlarmObjectData4 = this.getStatusData(sMAlarmObjectData5, sMAlarmObjectData4, false);
                        }
                        ++n2;
                    }
                    if (sMAlarmObjectData4 != null) {
                        sCMResourcePoolTree.setAlarmStatus(sMAlarmObjectData4);
                        sMAlarmObjectData = this.getStatusData(sMAlarmObjectData4, sMAlarmObjectData, false);
                    }
                }
            }
            ++n;
        }
        if (sMAlarmObjectData != null) {
            sCMHostTree.setAlarmStatus(sMAlarmObjectData);
        }
        return sMAlarmObjectData;
    }

    private SMAlarmObjectData propagateContainerAlarms(SCMContainerTree sCMContainerTree, Hashtable hashtable, Hashtable hashtable2) {
        SMAlarmObjectData sMAlarmObjectData = null;
        if (sCMContainerTree == null) {
            return sMAlarmObjectData;
        }
        Vector vector = sCMContainerTree.getChildren();
        if (sCMContainerTree.isFolder()) {
            if (vector == null || vector.size() == 0) {
                return sMAlarmObjectData;
            }
            int n = 0;
            while (n < vector.size()) {
                SCMContainerTree sCMContainerTree2 = (SCMContainerTree)vector.elementAt(n);
                SMAlarmObjectData sMAlarmObjectData2 = this.propagateContainerAlarms(sCMContainerTree2, hashtable, hashtable2);
                if (sMAlarmObjectData2 != null) {
                    sMAlarmObjectData = this.getStatusData(sMAlarmObjectData2, sMAlarmObjectData, false);
                }
                ++n;
            }
            if (sMAlarmObjectData != null) {
                sCMContainerTree.setAlarmStatus(sMAlarmObjectData);
            }
            return sMAlarmObjectData;
        }
        SCMContainer[] sCMContainerArray = null;
        try {
            sCMContainerArray = this.service.getContainers(sCMContainerTree.getID(), true);
        }
        catch (Exception exception) {
            logWriter.println("propagateContainerAlarms: Error in getting activate containers from DB");
            return null;
        }
        if (sCMContainerArray == null || sCMContainerArray.length == 0) {
            return sMAlarmObjectData;
        }
        int n = 0;
        while (n < sCMContainerArray.length) {
            String string = null;
            try {
                string = InetAddress.getByName(sCMContainerArray[n].getHostName()).getHostAddress();
            }
            catch (Exception exception) {
                string = sCMContainerArray[n].getHostName();
            }
            String string2 = string + ":" + sCMContainerArray[n].getPort();
            SMAlarmObjectData sMAlarmObjectData3 = (SMAlarmObjectData)hashtable.get(string2);
            if (sMAlarmObjectData3 != null) {
                sCMContainerTree.setAlarmStatus(sMAlarmObjectData3);
                return sMAlarmObjectData3;
            }
            String string3 = string + ":" + sCMContainerArray[n].getPort() + ":" + sCMContainerArray[n].getZoneName() + "," + sCMContainerArray[n].getProjectID();
            SMAlarmObjectData sMAlarmObjectData4 = (SMAlarmObjectData)hashtable2.get(string3);
            if (sMAlarmObjectData4 != null) {
                sMAlarmObjectData = this.getStatusData(sMAlarmObjectData4, sMAlarmObjectData, false);
            }
            ++n;
        }
        if (sMAlarmObjectData != null) {
            sCMContainerTree.setAlarmStatus(sMAlarmObjectData);
        }
        return sMAlarmObjectData;
    }

    private SMAlarmObjectData getStatusData(SMAlarmObjectData sMAlarmObjectData, SMAlarmObjectData sMAlarmObjectData2, boolean bl) {
        if (sMAlarmObjectData2 == null) {
            return sMAlarmObjectData;
        }
        int n = SMAlarmStatusRequest.getStatusIndex((String)sMAlarmObjectData.getSeverity());
        int n2 = SMAlarmStatusRequest.getStatusIndex((String)sMAlarmObjectData2.getSeverity());
        if (n == 0) {
            return sMAlarmObjectData2;
        }
        if (n < n2 || n2 == 0) {
            return sMAlarmObjectData;
        }
        if (n > n2) {
            return sMAlarmObjectData2;
        }
        if (bl) {
            boolean bl2;
            boolean bl3 = TOPOLOGYVIEW_PATTERN.indexOf(sMAlarmObjectData2.getManagedObject()) >= 0;
            boolean bl4 = bl2 = TOPOLOGYVIEW_PATTERN.indexOf(sMAlarmObjectData.getManagedObject()) >= 0;
            if (bl3 && !bl2) {
                return sMAlarmObjectData2;
            }
            if (bl2 && !bl3) {
                return sMAlarmObjectData;
            }
        }
        if (sMAlarmObjectData.getUpdateTimestamp() < sMAlarmObjectData2.getUpdateTimestamp()) {
            return sMAlarmObjectData;
        }
        return sMAlarmObjectData2;
    }

    public SCMAlarmRecord[] getAlarms() throws SMDatabaseException {
        String string;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Vector vector = null;
        try {
            vector = this.getDimensionAlarms(hashtable);
        }
        catch (Exception exception) {
            return null;
        }
        this.processAlarms(vector, hashtable, hashtable3, hashtable2);
        SCMAlarmRecord[] sCMAlarmRecordArray = new SCMAlarmRecord[hashtable3.size() + hashtable2.size()];
        int n = 0;
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            sCMAlarmRecordArray[n] = new SCMAlarmRecord();
            String string2 = "";
            try {
                string2 = string2 + this.getAlarmSource(string);
            }
            catch (Exception exception) {
                logWriter.println("Could not get the alarm source correctly ");
                exception.printStackTrace();
            }
            sCMAlarmRecordArray[n].setAlarmSource(string2);
            SMAlarmObjectData sMAlarmObjectData = (SMAlarmObjectData)hashtable2.get(string);
            String string3 = sMAlarmObjectData.getSeverity();
            sCMAlarmRecordArray[n].setAlarmSeverity(string3);
            sCMAlarmRecordArray[n].setAlarmMessage(sMAlarmObjectData.getAlarmShortText());
            sCMAlarmRecordArray[n].setAlarmAckStatus(sMAlarmObjectData.isAcked());
            sCMAlarmRecordArray[n].setAlarmStartTime(sMAlarmObjectData.getOpenTimestamp() * 1000L);
            ++n;
        }
        enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            sCMAlarmRecordArray[n] = new SCMAlarmRecord(string, (SMAlarmObjectData)hashtable3.get(string));
            ++n;
        }
        return sCMAlarmRecordArray;
    }

    public String getAlarmSource(String string) {
        String string2 = ":";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string3 = null;
        try {
            string3 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            logWriter.println("COuld not get the host ip address");
        }
        String string4 = null;
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            logWriter.println("Could not get the host port ");
        }
        String string5 = null;
        try {
            string5 = stringTokenizer.nextToken();
        }
        catch (Exception exception) {
            logWriter.println("Could not get the zoneProject token ");
        }
        String string6 = null;
        String string7 = null;
        long l = 0L;
        if (string5 != null) {
            stringTokenizer = new StringTokenizer(string5, ",");
            string6 = stringTokenizer.nextToken();
            string7 = stringTokenizer.nextToken();
        }
        try {
            l = Long.parseLong(string7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        InetAddress inetAddress = null;
        try {
            if (string3 != null) {
                inetAddress = InetAddress.getByName(string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string8 = null;
        try {
            string8 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            logWriter.println("Could not get the hostname ");
        }
        SCMProject sCMProject = null;
        try {
            if (string7 != null) {
                sCMProject = this.service.getProject(l);
            }
        }
        catch (Exception exception) {
            logWriter.println("Could not initialize the project ");
        }
        String string9 = null;
        String string10 = null;
        String string11 = null;
        SCMContainer[] sCMContainerArray = null;
        if (sCMProject != null) {
            string10 = sCMProject.getProjectName();
            try {
                sCMContainerArray = this.service.getContainersByHost(this.service.getHostID(string8));
            }
            catch (Exception exception) {
                logWriter.println("Could not get the container array for this host : " + string8);
            }
            if (sCMContainerArray != null) {
                int n = 0;
                while (n < sCMContainerArray.length) {
                    String string12 = sCMContainerArray[n].getProjectName();
                    if (string12.equals(string10)) {
                        string9 = sCMContainerArray[n].getContainerName();
                        string11 = sCMContainerArray[n].getResourceName();
                        break;
                    }
                    ++n;
                }
            }
        }
        String string13 = "";
        if (string8 != null) {
            string13 = string13 + string8;
        }
        if (string11 != null) {
            string13 = string13 + string2 + string11;
        }
        if (string6 != null) {
            string13 = string13 + string2 + string6;
        }
        if (string10 != null) {
            string13 = string13 + string2 + string10;
        }
        return string13;
    }
}

