/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.uno.Any;
import com.sun.star.wizards.ui.event.DataAware;
import java.lang.reflect.Field;

public class DataAwareFields {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class array$S;

    public static DataAware.Value getFieldValueFor(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            Class<?> clazz = field.getType();
            Class<?> clazz2 = object2.getClass();
            if (clazz.equals(Boolean.TYPE)) {
                return new BooleanFieldValue(field, clazz2);
            }
            if (clazz.equals(Integer.TYPE)) {
                return new IntFieldValue(field, clazz2);
            }
            if (clazz.equals(Double.TYPE)) {
                return new DoubleFieldValue(field, clazz2);
            }
            if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = DataAwareFields.class$("java.lang.String")) : class$java$lang$String) && clazz2.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = DataAwareFields.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new ConvertedStringValue(field, clazz2);
            }
            return new SimpleFieldValue(field);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            return null;
        }
    }

    private static double toDouble(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.valueOf((String)object);
        }
        if (object instanceof short[]) {
            return ((short[])object).length == 0 ? 0.0 : (double)((short[])object)[0];
        }
        throw new IllegalArgumentException("Can't convert value to double." + object.getClass().getName());
    }

    private static boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        if (object instanceof String) {
            return ((String)object).equals(TRUE);
        }
        if (object instanceof short[]) {
            return ((short[])object).length != 0 && ((short[])object)[0] != 0;
        }
        throw new IllegalArgumentException("Can't convert value to boolean." + object.getClass().getName());
    }

    private static int toInt(boolean bl) {
        return bl ? 1 : 0;
    }

    private static short[] toShortArray(double d) {
        return new short[]{(short)d};
    }

    private static Number toNumber(double d, Class clazz) {
        if (clazz.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = DataAwareFields.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)d);
        }
        if (clazz.equals(class$java$lang$Short == null ? (class$java$lang$Short = DataAwareFields.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)d);
        }
        if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = DataAwareFields.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(d);
        }
        throw new IllegalArgumentException("Cannot convert to the given Number type.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SimpleFieldValue
    extends FieldValue {
        public SimpleFieldValue(Field field) {
            super(field);
        }

        public Object get(Object object) {
            try {
                if (object == null) {
                    if (this.field.getType().equals(class$java$lang$String == null ? (class$java$lang$String = DataAwareFields.class$("java.lang.String")) : class$java$lang$String)) {
                        return "";
                    }
                    if (this.field.getType().equals(class$java$lang$Short == null ? (class$java$lang$Short = DataAwareFields.class$("java.lang.Short")) : class$java$lang$Short)) {
                        return new Short(0);
                    }
                    if (this.field.getType().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = DataAwareFields.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        return new Integer(0);
                    }
                    if (this.field.getType().equals(array$S == null ? (array$S = DataAwareFields.class$("[S")) : array$S)) {
                        return new short[0];
                    }
                    return null;
                }
                return this.field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        public void set(Object object, Object object2) {
            try {
                this.field.set(object2, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private static class ConvertedStringValue
    extends FieldValue {
        private Class convertTo;

        public ConvertedStringValue(Field field, Class clazz) {
            super(field);
            this.convertTo = clazz;
        }

        public Object get(Object object) {
            try {
                String string = (String)this.field.get(object);
                if (this.convertTo.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataAwareFields.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return string != null && !string.equals("") && string.equals(DataAwareFields.TRUE) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (this.convertTo.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = DataAwareFields.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    if (string == null || string.equals("")) {
                        return Any.VOID;
                    }
                    return new Integer(string);
                }
                if (this.convertTo.equals(class$java$lang$Double == null ? (class$java$lang$Double = DataAwareFields.class$("java.lang.Double")) : class$java$lang$Double)) {
                    if (string == null || string.equals("")) {
                        return Any.VOID;
                    }
                    return new Double(string);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        public void set(Object object, Object object2) {
            try {
                this.field.set(object2, object == null || object.equals(Any.VOID) ? "" : object.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private static class DoubleFieldValue
    extends FieldValue {
        private Class convertTo;

        public DoubleFieldValue(Field field, Class clazz) {
            super(field);
            this.convertTo = clazz;
        }

        public Object get(Object object) {
            try {
                double d = this.field.getDouble(object);
                if (this.convertTo.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataAwareFields.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return d != 0.0 ? Boolean.TRUE : Boolean.FALSE;
                }
                if ((class$java$lang$Number == null ? (class$java$lang$Number = DataAwareFields.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(d, this.convertTo);
                }
                if (this.convertTo.equals(class$java$lang$String == null ? (class$java$lang$String = DataAwareFields.class$("java.lang.String")) : class$java$lang$String)) {
                    return String.valueOf(d);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(d);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        public void set(Object object, Object object2) {
            try {
                this.field.setDouble(object2, DataAwareFields.toDouble(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private static class IntFieldValue
    extends FieldValue {
        private Class convertTo;

        public IntFieldValue(Field field, Class clazz) {
            super(field);
            this.convertTo = clazz;
        }

        public Object get(Object object) {
            try {
                int n = this.field.getInt(object);
                if (this.convertTo.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataAwareFields.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return n != 0 ? Boolean.TRUE : Boolean.FALSE;
                }
                if ((class$java$lang$Number == null ? (class$java$lang$Number = DataAwareFields.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(n, this.convertTo);
                }
                if (this.convertTo.equals(class$java$lang$String == null ? (class$java$lang$String = DataAwareFields.class$("java.lang.String")) : class$java$lang$String)) {
                    return String.valueOf(n);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(n);
                }
                throw new IllegalArgumentException("Cannot convert int value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        public void set(Object object, Object object2) {
            try {
                this.field.setInt(object2, (int)DataAwareFields.toDouble(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private static class BooleanFieldValue
    extends FieldValue {
        private Class convertTo;

        public BooleanFieldValue(Field field, Class clazz) {
            super(field);
            this.convertTo = clazz;
        }

        public Object get(Object object) {
            try {
                boolean bl = this.field.getBoolean(object);
                if (this.convertTo.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataAwareFields.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    return bl ? Boolean.TRUE : Boolean.FALSE;
                }
                if ((class$java$lang$Number == null ? (class$java$lang$Number = DataAwareFields.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.convertTo)) {
                    return DataAwareFields.toNumber(bl ? 1.0 : 0.0, this.convertTo);
                }
                if (this.convertTo.equals(class$java$lang$String == null ? (class$java$lang$String = DataAwareFields.class$("java.lang.String")) : class$java$lang$String)) {
                    return String.valueOf(bl);
                }
                if (this.convertTo.isArray()) {
                    return DataAwareFields.toShortArray(DataAwareFields.toInt(bl));
                }
                throw new IllegalArgumentException("Cannot convert boolean value to given type (" + this.convertTo.getName() + ").");
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                return null;
            }
        }

        public void set(Object object, Object object2) {
            try {
                this.field.setBoolean(object2, DataAwareFields.toBoolean(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private static abstract class FieldValue
    implements DataAware.Value {
        Field field;

        public FieldValue(Field field) {
            this.field = field;
        }

        public boolean isAssignable(Class clazz) {
            return this.field.getDeclaringClass().isAssignableFrom(clazz);
        }
    }
}

