/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.conversionAlgorithm;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParaStyle
extends Style
implements Cloneable {
    public static final int MARGIN_LEFT = 0;
    public static final int MARGIN_RIGHT = 1;
    public static final int MARGIN_TOP = 2;
    public static final int MARGIN_BOTTOM = 3;
    public static final int TEXT_INDENT = 4;
    public static final int LINE_HEIGHT = 5;
    public static final int TEXT_ALIGN = 6;
    protected static final int NR_PROPERTIES = 7;
    protected boolean[] isSet = new boolean[7];
    protected int[] value = new int[7];
    protected String[] attrName = new String[]{"fo:margin-left", "fo:margin-right", "fo:margin-top", "fo:margin-bottom", "fo:text-indent", "fo:line-height", "fo:text-align"};
    protected Class[] algor = new Class[]{class$org$openoffice$xmerge$converter$xml$horizSize == null ? (class$org$openoffice$xmerge$converter$xml$horizSize = ParaStyle.class$("org.openoffice.xmerge.converter.xml.horizSize")) : class$org$openoffice$xmerge$converter$xml$horizSize, class$org$openoffice$xmerge$converter$xml$horizSize == null ? (class$org$openoffice$xmerge$converter$xml$horizSize = ParaStyle.class$("org.openoffice.xmerge.converter.xml.horizSize")) : class$org$openoffice$xmerge$converter$xml$horizSize, class$org$openoffice$xmerge$converter$xml$horizSize == null ? (class$org$openoffice$xmerge$converter$xml$horizSize = ParaStyle.class$("org.openoffice.xmerge.converter.xml.horizSize")) : class$org$openoffice$xmerge$converter$xml$horizSize, class$org$openoffice$xmerge$converter$xml$horizSize == null ? (class$org$openoffice$xmerge$converter$xml$horizSize = ParaStyle.class$("org.openoffice.xmerge.converter.xml.horizSize")) : class$org$openoffice$xmerge$converter$xml$horizSize, class$org$openoffice$xmerge$converter$xml$horizSize == null ? (class$org$openoffice$xmerge$converter$xml$horizSize = ParaStyle.class$("org.openoffice.xmerge.converter.xml.horizSize")) : class$org$openoffice$xmerge$converter$xml$horizSize, class$org$openoffice$xmerge$converter$xml$lineHeight == null ? (class$org$openoffice$xmerge$converter$xml$lineHeight = ParaStyle.class$("org.openoffice.xmerge.converter.xml.lineHeight")) : class$org$openoffice$xmerge$converter$xml$lineHeight, class$org$openoffice$xmerge$converter$xml$alignment == null ? (class$org$openoffice$xmerge$converter$xml$alignment = ParaStyle.class$("org.openoffice.xmerge.converter.xml.alignment")) : class$org$openoffice$xmerge$converter$xml$alignment};
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_JUST = 3;
    public static final int ALIGN_LEFT = 4;
    public static final int LH_PCT = 0x40000000;
    public static final int LH_ATLEAST = 0x20000000;
    public static final int LH_VALUEMASK = 0xFFFFFF;
    private static String[] ignored = new String[]{"style:font-name", "fo:font-size", "fo:font-weight", "fo:color", "fo:language", "fo:country", "style:font-name-asian", "style:font-size-asian", "style:language-asian", "style:country-asian", "style:font-name-complex", "style:font-size-complex", "style:language-complex", "style:country-complex", "style:text-autospace", "style:punctuation-wrap", "style:line-break", "fo:keep-with-next", "fo:font-style", "text:number-lines", "text:line-number"};
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$horizSize;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$lineHeight;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$alignment;

    public ParaStyle(Node node, StyleCatalog styleCatalog) {
        super(node, styleCatalog);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                NamedNodeMap namedNodeMap;
                Node node2 = nodeList.item(n2);
                String string = node2.getNodeName();
                if (string.equals("style:properties") && (namedNodeMap = node2.getAttributes()) != null) {
                    int n3 = namedNodeMap.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        Node node3 = namedNodeMap.item(n4);
                        this.setAttribute(node3.getNodeName(), node3.getNodeValue());
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public ParaStyle(String string, String string2, String string3, String[] stringArray, String[] stringArray2, StyleCatalog styleCatalog) {
        super(string, string2, string3, styleCatalog);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.setAttribute(stringArray[n], stringArray2[n]);
                ++n;
            }
        }
    }

    public ParaStyle(String string, String string2, String string3, int[] nArray, String[] stringArray, StyleCatalog styleCatalog) {
        super(string, string2, string3, styleCatalog);
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                this.setAttribute(nArray[n], stringArray[n]);
                ++n;
            }
        }
    }

    private boolean isIgnored(String string) {
        int n = 0;
        while (n < ignored.length) {
            if (ignored[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setAttribute(String string, String string2) {
        int n = 0;
        while (n < 7) {
            if (string.equals(this.attrName[n])) {
                this.setAttribute(n, string2);
                return;
            }
            ++n;
        }
        if (!this.isIgnored(string)) {
            Debug.log(1, "ParaStyle Unhandled: " + string + "=" + string2);
        }
    }

    public boolean isAttributeSet(int n) {
        return this.isSet[n];
    }

    public int getAttribute(int n) {
        if (this.isSet[n]) {
            return this.value[n];
        }
        return 0;
    }

    public void setAttribute(int n, String string) {
        this.isSet[n] = true;
        try {
            this.value[n] = ((conversionAlgorithm)this.algor[n].newInstance()).I(string);
        }
        catch (Exception exception) {
            Debug.log(2, "Instantiation error", exception);
        }
    }

    public Style getResolved() {
        ParaStyle paraStyle = null;
        try {
            paraStyle = (ParaStyle)this.clone();
        }
        catch (Exception exception) {
            Debug.log(2, "Can't clone", exception);
        }
        ParaStyle paraStyle2 = null;
        if (this.sc != null) {
            if (this.parent != null) {
                paraStyle2 = (ParaStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (paraStyle2 == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    paraStyle2 = (ParaStyle)paraStyle2.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                paraStyle2 = (ParaStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (paraStyle2 != null) {
            paraStyle2 = (ParaStyle)paraStyle2.getResolved();
            int n = 0;
            while (n < 7) {
                if (!this.isSet[n] && paraStyle2.isSet[n]) {
                    paraStyle.isSet[n] = true;
                    paraStyle.value[n] = paraStyle2.value[n];
                }
                ++n;
            }
        }
        return paraStyle;
    }

    private static String toCSV(String string) {
        if (string != null) {
            return "\"" + string + "\",";
        }
        return "\"\",";
    }

    private static String toLastCSV(String string) {
        if (string != null) {
            return "\"" + string + "\"";
        }
        return "\"\"";
    }

    public static void dumpHdr() {
        System.out.println(ParaStyle.toCSV("Name") + ParaStyle.toCSV("Family") + ParaStyle.toCSV("parent") + ParaStyle.toCSV("left mgn") + ParaStyle.toCSV("right mgn") + ParaStyle.toCSV("top mgn") + ParaStyle.toCSV("bottom mgn") + ParaStyle.toCSV("txt indent") + ParaStyle.toCSV("line height") + ParaStyle.toLastCSV("txt align"));
    }

    public void dumpCSV() {
        String string = "";
        int n = 0;
        while (n <= 6) {
            string = this.isSet[n] ? string + ParaStyle.toCSV("" + this.value[n]) : string + ParaStyle.toCSV(null);
            ++n;
        }
        System.out.println(ParaStyle.toCSV(this.name) + ParaStyle.toCSV(this.family) + ParaStyle.toCSV(this.parent) + string + ParaStyle.toLastCSV(null));
    }

    public Node createNode(Document document, String string) {
        Element element = document.createElement(string);
        this.writeAttributes(element);
        return element;
    }

    public boolean isSubset(Style style) {
        if (!super.isSubset(style)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(style.getClass())) {
            return false;
        }
        ParaStyle paraStyle = (ParaStyle)style;
        int n = 0;
        while (n < 7) {
            int n2;
            if (paraStyle.isSet[n] && (n < 6 ? (n2 = this.value[n] > paraStyle.value[n] ? this.value[n] - paraStyle.value[n] : paraStyle.value[n] - this.value[n]) > 32 : (n != 6 || this.value[n] != 0 || paraStyle.value[n] != 4) && this.value[n] != paraStyle.value[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void writeAttributes(Element element) {
        int n = 0;
        while (n <= 4) {
            if (this.isSet[n]) {
                double d = (double)this.value[n] / 100.0;
                String string = new Double(d).toString() + "mm";
                element.setAttribute(this.attrName[n], string);
            }
            ++n;
        }
        if (this.isSet[5]) {
            String string;
            if ((this.value[5] & 0x40000000) != 0) {
                string = new Integer(this.value[5] & 0xFFFFFF).toString() + "%";
            } else {
                double d = (double)(this.value[5] & 0xFFFFFF) / 100.0;
                string = new Double(d).toString() + "mm";
            }
            element.setAttribute(this.attrName[5], string);
        }
        if (this.isSet[6]) {
            String string;
            switch (this.value[6]) {
                case 1: {
                    string = "end";
                    break;
                }
                case 2: {
                    string = "center";
                    break;
                }
                case 3: {
                    string = "justify";
                    break;
                }
                case 4: {
                    string = "left";
                    break;
                }
                default: {
                    string = "unknown";
                }
            }
            element.setAttribute(this.attrName[6], string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

