/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.converter.palm.Record;

public final class PalmDB {
    public static final short PDB_HEADER_ATTR_BACKUP = 8;
    public static final int NAME_LENGTH = 32;
    private Record[] records;
    private byte[] bName = null;
    private String sName = null;
    private int creatorID = 0;
    private int typeID = 0;
    private int version = 0;
    private short attribute = 0;

    public PalmDB(int n, int n2, int n3, short s) {
        this.records = new Record[0];
        this.setAttributes(n, n2, n3, s);
    }

    public PalmDB(String string, int n, int n2, int n3, short s, Record[] recordArray) throws UnsupportedEncodingException {
        this(string.getBytes("8859_1"), n, n2, n3, s, recordArray);
    }

    public PalmDB(byte[] byArray, int n, int n2, int n3, short s, Record[] recordArray) throws UnsupportedEncodingException {
        this.store(byArray);
        this.records = new Record[recordArray.length];
        System.arraycopy(recordArray, 0, this.records, 0, recordArray.length);
        this.setAttributes(n, n2, n3, s);
    }

    public void setAttributes(int n, int n2, int n3, short s) {
        this.creatorID = n;
        this.typeID = n2;
        this.version = n3;
        this.attribute = s;
    }

    private void store(byte[] byArray) throws UnsupportedEncodingException {
        this.bName = new byte[32];
        int n = 31;
        int n2 = byArray.length < n ? byArray.length : n;
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] == 0) break;
            this.bName[n3] = byArray[n3];
            ++n3;
        }
        this.sName = new String(this.bName, 0, n3, "8859_1");
    }

    public int getCreatorID() {
        return this.creatorID;
    }

    public int getTypeID() {
        return this.typeID;
    }

    public short getAttribute() {
        return this.attribute;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRecordCount() {
        return this.records.length;
    }

    public Record getRecord(int n) {
        return this.records[n];
    }

    public Record[] getRecords() {
        return this.records;
    }

    public String getPDBNameString() {
        return this.sName;
    }

    public byte[] getPDBNameBytes() {
        return this.bName;
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(this.bName);
        dataOutputStream.writeShort(this.records.length);
        int n = 0;
        while (n < this.records.length) {
            this.records[n].write(dataOutputStream);
            ++n;
        }
    }

    public void read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[32];
        dataInputStream.readFully(byArray);
        this.store(byArray);
        int n = dataInputStream.readUnsignedShort();
        this.records = new Record[n];
        int n2 = 0;
        while (n2 < n) {
            this.records[n2] = new Record();
            this.records[n2].read(dataInputStream);
            ++n2;
        }
    }

    public boolean equals(Object object) {
        boolean bl;
        block7: {
            bl = false;
            if (object instanceof PalmDB) {
                PalmDB palmDB = (PalmDB)object;
                if (this.sName.equals(palmDB.sName) && this.bName.length == palmDB.bName.length) {
                    int n = 0;
                    while (n < this.bName.length) {
                        if (this.bName[n] == palmDB.bName[n]) {
                            ++n;
                            continue;
                        }
                        break block7;
                    }
                    if (this.records.length == palmDB.records.length) {
                        int n2 = 0;
                        while (n2 < this.records.length) {
                            if (this.records[n2].equals(palmDB.records[n2])) {
                                ++n2;
                                continue;
                            }
                            break block7;
                        }
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }
}

