/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BordersImpl;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.WriterTableCellsImpl;
import com.sun.star.helper.writer.WriterTableRowsImpl;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XWriterTableCells;
import com.sun.star.helper.writer.XWriterTableRow;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;

public class WriterTableRowImpl
extends HelperInterfaceAdaptor
implements XWriterTableRow,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Row";
    protected XTextTable xTable;
    protected XTableRows xRows;
    protected int index = -1;
    static /* synthetic */ Class class$com$sun$star$table$XCellRange;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    public WriterTableRowImpl(WriterTableRowsImpl writerTableRowsImpl, XTextTable xTextTable, XTableRows xTableRows, int n) throws BasicErrorException {
        super(__serviceName, writerTableRowsImpl);
        this.xTable = xTextTable;
        this.xRows = xTableRows;
        this.index = --n;
        if (this.xRows == null || this.xTable == null || this.index < 0 || this.index >= this.xRows.getCount()) {
            DebugHelper.exception(51, "Cannot construct cells object with these parameters.");
        }
    }

    public XWriterTableCells Cells() throws BasicErrorException {
        return new WriterTableCellsImpl(this, (TableImpl)this.getParent().getParent(), null);
    }

    public void Select() throws BasicErrorException {
        StringBuffer stringBuffer = new StringBuffer("A");
        stringBuffer.append(this.index + 1);
        XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = WriterTableRowImpl.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)this.xTable);
        int n = this.xTable.getColumns().getCount();
        stringBuffer = stringBuffer.append(":").append(TableImpl.getStringForNumber(n)).append(this.index + 1);
        XCellRange xCellRange2 = xCellRange.getCellRangeByName(stringBuffer.toString());
        XModel xModel = this.getXModel();
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = WriterTableRowImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)xModel.getCurrentController());
        try {
            xSelectionSupplier.select((Object)xCellRange2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    public void setAllowBreakAcrossPages(Object object) throws BasicErrorException {
        int n = 1;
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.warning((Exception)((Object)illegalArgumentException));
        }
        if (n == 9999999) {
            DebugHelper.writeInfo("'AllowBreakAcrossPages' set to wdUndefined is ignored");
        } else {
            try {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableRowImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.xRows.getByIndex(this.index));
                xPropertySet.setPropertyValue("IsSplitAllowed", (Object)(n != 0 ? 1 : 0));
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    public Object getAllowBreakAcrossPages() throws BasicErrorException {
        boolean bl = false;
        try {
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableRowImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.xRows.getByIndex(this.index));
            Object object = xPropertySet.getPropertyValue("IsSplitAllowed");
            bl = NumericalHelper.toBoolean(object);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return bl;
    }

    public void Delete() throws BasicErrorException {
        ((WriterTableRowsImpl)this.getParent()).delete(this.index, 1);
    }

    public XBorders Borders() throws BasicErrorException {
        XCell[][] xCellArray = new XCell[this.xTable.getColumns().getCount()][1];
        int n = 0;
        while (n < xCellArray.length) {
            StringBuffer stringBuffer = new StringBuffer(TableImpl.getStringForNumber(n));
            stringBuffer.append(this.index + 1);
            xCellArray[n][0] = this.xTable.getCellByName(stringBuffer.toString());
            if (xCellArray[n][0] == null) {
                DebugHelper.exception(51, "Cannot get a cell from table.");
            }
            ++n;
        }
        return new BordersImpl((TableImpl)this.getParent().getParent(), xCellArray);
    }

    public int Index() throws BasicErrorException {
        return this.getRowIndex();
    }

    protected int getRowIndex() {
        return this.index + 1;
    }

    public Object getUnoObject() throws BasicErrorException {
        Object object = null;
        try {
            object = this.xRows.getByIndex(this.index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

