/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetImplementation;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BordersImpl;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.WriterTableCellImpl;
import com.sun.star.helper.writer.WriterTableColumnImpl;
import com.sun.star.helper.writer.WriterTableColumnsImpl;
import com.sun.star.helper.writer.WriterTableRowImpl;
import com.sun.star.helper.writer.WriterTableRowsImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XWriterTableCell;
import com.sun.star.helper.writer.XWriterTableCells;
import com.sun.star.helper.writer.XWriterTableColumns;
import com.sun.star.helper.writer.XWriterTableRows;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTableCursor;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.util.Arrays;

public class WriterTableCellsImpl
extends HelperInterfaceAdaptor
implements XWriterTableCells,
XPropertySet,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Cells";
    private static final int ROW_PARENT = 0;
    private static final int COLUMN_PARENT = 1;
    private static final int RANGE_PARENT = 2;
    private static final int ROW = 1;
    private static final int COLUMN = 0;
    private final int PARENT_TYPE;
    private XTextTable xTable;
    private TableImpl aWriterTable;
    private int[] iFirstCellIndex;
    private int[] iLastCellIndex;
    private PropertySetImplementation propSet;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$table$XCellRange;

    public WriterTableCellsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, TableImpl tableImpl, int n, int n2) throws BasicErrorException {
        this(helperInterfaceAdaptor, tableImpl);
        StringBuffer stringBuffer = new StringBuffer("A1:");
        stringBuffer.append(TableImpl.getStringForNumber(n)).append(n2 + 1);
        try {
            this.setPropertySet();
            this.setCellIndicesForRange(helperInterfaceAdaptor, stringBuffer.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    public WriterTableCellsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, TableImpl tableImpl, String string) throws BasicErrorException {
        this(helperInterfaceAdaptor, tableImpl);
        try {
            this.setPropertySet();
            this.setCellIndicesForRange(helperInterfaceAdaptor, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    private WriterTableCellsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, TableImpl tableImpl) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        if (tableImpl == null) {
            DebugHelper.exception(51, "Cannot construct cells object with these parameters.");
        }
        this.xTable = tableImpl.getWrappedTable();
        if (this.xTable == null) {
            DebugHelper.exception(51, "Cannot construct cells object with these parameters.");
        }
        this.aWriterTable = tableImpl;
        this.iFirstCellIndex = new int[2];
        this.iLastCellIndex = new int[2];
        int n = -1;
        n = helperInterfaceAdaptor instanceof WriterTableRowImpl ? 0 : (helperInterfaceAdaptor instanceof WriterTableColumnImpl ? 1 : 2);
        this.PARENT_TYPE = n;
    }

    public XWriterTableCell Item(Object object) throws IndexOutOfBoundsException, BasicErrorException {
        int n = 0;
        if (object != null) {
            try {
                n = WriterUtilities.getIntFromObject(object) - 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
            }
        }
        if (n < 0 && n >= this.getCellCount()) {
            throw new IndexOutOfBoundsException("Cannot construct an object with this index.");
        }
        XWriterTableCell xWriterTableCell = this.getTableCell(n);
        return xWriterTableCell;
    }

    public void SetWidth(Object object, Object object2) throws BasicErrorException {
        this.setWidth(object);
    }

    public Object getWidth() throws BasicErrorException {
        Integer n = null;
        WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)this.aWriterTable.Columns().Item(new Integer(this.iFirstCellIndex[0] + 1));
        n = (Integer)writerTableColumnImpl.getWidth();
        if (n == null) {
            DebugHelper.exception(51, "Width");
        }
        return n;
    }

    public void setWidth(Object object) throws BasicErrorException {
        if (this.xTable.getRows().getCount() != this.iLastCellIndex[1] - this.iFirstCellIndex[1] + 1) {
            DebugHelper.writeInfo("Cannot support setCellWidth for incomplete columns.");
            DebugHelper.exception(425, "");
        }
        Object var2_2 = null;
        int n = this.iLastCellIndex[0] - this.iFirstCellIndex[0] + 1;
        int n2 = 1;
        while (n2 <= n) {
            WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)this.aWriterTable.Columns().Item(new Integer(n2));
            writerTableColumnImpl.setWidth(object);
            ++n2;
        }
    }

    public void Merge() throws BasicErrorException {
        StringBuffer stringBuffer = new StringBuffer(TableImpl.getStringForNumber(this.iFirstCellIndex[0]));
        stringBuffer.append(this.iFirstCellIndex[1] + 1);
        StringBuffer stringBuffer2 = new StringBuffer(TableImpl.getStringForNumber(this.iLastCellIndex[0]));
        stringBuffer2.append(this.iLastCellIndex[1] + 1);
        XTextTableCursor xTextTableCursor = this.xTable.createCursorByCellName(stringBuffer.toString());
        xTextTableCursor.gotoCellByName(stringBuffer2.toString(), true);
        xTextTableCursor.mergeRange();
        this.iLastCellIndex[1] = this.iFirstCellIndex[1];
        this.iLastCellIndex[0] = this.iFirstCellIndex[0];
    }

    public Object getHeightRule() throws BasicErrorException {
        int n = 2;
        int n2 = this.iFirstCellIndex[1];
        XPropertySet xPropertySet = null;
        try {
            Object object = this.xTable.getRows().getByIndex(n2);
            xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableCellsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
            Object object2 = xPropertySet.getPropertyValue("IsAutoHeight");
            boolean bl = AnyConverter.toBoolean((Object)object2);
            n = bl ? 0 : 2;
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        return new Integer(n);
    }

    public void setHeightRule(Object object) throws BasicErrorException {
        try {
            int n = NumericalHelper.toInt(object);
            if (n == 1) {
                DebugHelper.exception(73, "This value is not supported in StarOffice.");
            }
            boolean bl = n == 0;
            int n2 = this.iFirstCellIndex[1];
            XPropertySet xPropertySet = null;
            Object object2 = this.xTable.getRows().getByIndex(n2);
            xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableCellsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object2);
            xPropertySet.setPropertyValue("IsAutoHeight", (Object)bl);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.exception((Exception)((Object)propertyVetoException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
    }

    public int Count() throws BasicErrorException {
        return this.getCellCount();
    }

    public XBorders Borders() throws BasicErrorException {
        int n = this.iLastCellIndex[1] - this.iFirstCellIndex[1] + 1;
        int n2 = this.iLastCellIndex[0] - this.iFirstCellIndex[0] + 1;
        XCell[][] xCellArray = new XCell[n2][n];
        try {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    xCellArray[n4][n3] = this.xTable.getCellByName(this.getCellNameByIndex(n3 * n2 + n4));
                    if (xCellArray[n4][n3] == null) {
                        DebugHelper.exception(51, "Cannot get a cell from table.");
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        return new BordersImpl(this.aWriterTable, xCellArray);
    }

    protected XWriterTableCell getTableCell(int n) throws BasicErrorException {
        WriterTableCellImpl writerTableCellImpl = null;
        try {
            String string = this.getCellNameByIndex(n);
            writerTableCellImpl = new WriterTableCellImpl(this.aWriterTable, string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        return writerTableCellImpl;
    }

    protected XWriterTableRows getRows() throws BasicErrorException {
        return new WriterTableRowsImpl(this.aWriterTable, this.xTable, this.iFirstCellIndex[1], this.iLastCellIndex[1]);
    }

    protected XWriterTableColumns getColumns() throws BasicErrorException {
        return new WriterTableColumnsImpl(this.aWriterTable, this.xTable, this.iFirstCellIndex[0], this.iLastCellIndex[0]);
    }

    private String getCellNameByIndex(int n) throws IndexOutOfBoundsException {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.PARENT_TYPE) {
            case 1: {
                if (n >= 0 && n <= this.iLastCellIndex[1]) {
                    stringBuffer.append(TableImpl.getStringForNumber(this.iFirstCellIndex[0]));
                    stringBuffer.append(n + 1);
                    break;
                }
                throw new IndexOutOfBoundsException("Cannot get a cell with this index.");
            }
            case 0: {
                if (n >= 0 && n <= this.iLastCellIndex[0]) {
                    stringBuffer.append(TableImpl.getStringForNumber(n));
                    stringBuffer.append(this.iFirstCellIndex[1] + 1);
                    break;
                }
                throw new IndexOutOfBoundsException("Cannot get a cell with this index.");
            }
            case 2: {
                if (n >= 0 && n < this.getCellCount()) {
                    int n2 = this.iLastCellIndex[0] - this.iFirstCellIndex[0] + 1;
                    int n3 = n % n2;
                    int n4 = n / n2;
                    stringBuffer.append(TableImpl.getStringForNumber(this.iFirstCellIndex[0] + n3));
                    stringBuffer.append(this.iFirstCellIndex[1] + 1 + n4);
                    break;
                }
                throw new IndexOutOfBoundsException("Cannot get a cell with this index.");
            }
            default: {
                throw new IndexOutOfBoundsException("Cannot get a cell with this index.");
            }
        }
        return stringBuffer.toString();
    }

    private int getCellCount() {
        int n = (this.iLastCellIndex[0] - this.iFirstCellIndex[0] + 1) * (this.iLastCellIndex[1] - this.iFirstCellIndex[1] + 1);
        return n;
    }

    private void setCellIndicesForRange(Object object, String string) throws IllegalArgumentException, BasicErrorException {
        int n;
        int n2;
        int[] nArray;
        int[] nArray2;
        block12: {
            block11: {
                nArray2 = new int[]{0, 0};
                nArray = new int[]{0, 0};
                n2 = this.aWriterTable.Rows().Count() - 1;
                n = this.aWriterTable.Columns().Count() - 1;
                if (string != null) break block11;
                switch (this.PARENT_TYPE) {
                    case 0: {
                        WriterTableRowImpl writerTableRowImpl = (WriterTableRowImpl)object;
                        nArray2[0] = writerTableRowImpl.getRowIndex() - 1;
                        nArray2[1] = nArray2[0];
                        nArray[0] = 0;
                        nArray[1] = this.aWriterTable.Columns().Count() - 1;
                        break block12;
                    }
                    case 1: {
                        WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)object;
                        nArray[0] = writerTableColumnImpl.getColumnIndex() - 1;
                        nArray[1] = nArray[0];
                        nArray2[0] = 0;
                        nArray2[1] = this.aWriterTable.Rows().Count() - 1;
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot construct cells object with these parameters.");
                    }
                }
            }
            String[] stringArray = TableImpl.getStartEndCellFromRange(string);
            if (stringArray[0].equals("") || stringArray[1].equals("")) {
                throw new IllegalArgumentException("Cannot construct cells object with these parameters.");
            }
            nArray[0] = TableImpl.getNumberForString(stringArray[0]) - 1;
            nArray[1] = TableImpl.getNumberForString(stringArray[1]) - 1;
            nArray2[0] = new Integer(stringArray[0].substring(1, 2)) - 1;
            nArray2[1] = new Integer(stringArray[1].substring(1, 2)) - 1;
            if (this.PARENT_TYPE == 0) {
                WriterTableRowImpl writerTableRowImpl = (WriterTableRowImpl)object;
                nArray2[0] = writerTableRowImpl.getRowIndex();
                nArray2[1] = nArray2[0];
            } else if (this.PARENT_TYPE == 1) {
                WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)object;
                nArray[0] = writerTableColumnImpl.getColumnIndex();
                nArray[1] = nArray[0];
            } else if (this.PARENT_TYPE != 2) {
                throw new IllegalArgumentException("Cannot construct cells object with these parameters.");
            }
        }
        Arrays.sort(nArray);
        Arrays.sort(nArray2);
        if (nArray[0] < 0 || nArray[1] > n || nArray2[0] < 0 || nArray2[1] > n2) {
            throw new IllegalArgumentException("Cannot construct cells object with these parameters.");
        }
        this.iFirstCellIndex[0] = nArray[0];
        this.iFirstCellIndex[1] = nArray2[0];
        this.iLastCellIndex[0] = nArray[1];
        this.iLastCellIndex[1] = nArray2[1];
    }

    private void setPropertySet() throws IllegalArgumentException {
        Property[] propertyArray = new Property[]{new Property("Width", -1, Type.LONG, 0), new Property("HeightRule", -1, Type.LONG, 0)};
        this.propSet = new PropertySetImplementation(propertyArray, this);
    }

    public void addPropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.propSet.addPropertyChangeListener(string, xPropertyChangeListener);
    }

    public void addVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.propSet.addVetoableChangeListener(string, xVetoableChangeListener);
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.propSet.getPropertySetInfo();
    }

    public Object getPropertyValue(String string) throws UnknownPropertyException, WrappedTargetException {
        return this.propSet.getPropertyValue(string);
    }

    public void removePropertyChangeListener(String string, XPropertyChangeListener xPropertyChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.propSet.removePropertyChangeListener(string, xPropertyChangeListener);
    }

    public void removeVetoableChangeListener(String string, XVetoableChangeListener xVetoableChangeListener) throws UnknownPropertyException, WrappedTargetException {
        this.propSet.removeVetoableChangeListener(string, xVetoableChangeListener);
    }

    public void setPropertyValue(String string, Object object) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.propSet.setPropertyValue(string, object);
    }

    public Object getUnoObject() throws BasicErrorException {
        XCellRange xCellRange = null;
        try {
            XCellRange xCellRange2 = (XCellRange)OptionalParamUtility.getObject(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = WriterTableCellsImpl.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange, this.xTable);
            xCellRange = xCellRange2.getCellRangeByPosition(this.iFirstCellIndex[1], this.iFirstCellIndex[0], this.iLastCellIndex[1], this.iLastCellIndex[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        return xCellRange;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

