/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.Filename;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.WriterTemplateFilename;
import com.sun.star.helper.writer.DocumentsImpl;
import com.sun.star.helper.writer.OptionsImpl;
import com.sun.star.helper.writer.TemplateImpl;
import com.sun.star.helper.writer.WriterImpl;
import com.sun.star.helper.writer.XTemplate;
import com.sun.star.helper.writer.XTemplates;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import java.util.ArrayList;

public class TemplatesImpl
extends HelperInterfaceAdaptor
implements XTemplates {
    private ArrayList m_aListOfTemplate = new ArrayList();
    private String m_sDefaultTemplatePath = "";

    public TemplatesImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) throws BasicErrorException {
        super("com.sun.star.helper.writer.TemplatesImpl", helperInterfaceAdaptor);
        DocumentsImpl documentsImpl = null;
        if (this.getParentAdaptor() instanceof DocumentsImpl) {
            documentsImpl = (DocumentsImpl)this.getParentAdaptor();
        } else {
            DebugHelper.exception(51, "wrong parent");
        }
        WriterImpl writerImpl = (WriterImpl)documentsImpl.getParent();
        OptionsImpl optionsImpl = new OptionsImpl(writerImpl);
        this.m_sDefaultTemplatePath = optionsImpl.DefaultFilePath(2);
        this.Add();
    }

    public int Count() throws BasicErrorException {
        return this.m_aListOfTemplate.size();
    }

    public TemplateImpl Add() throws BasicErrorException {
        return this.Add("", "normal", 0);
    }

    public TemplateImpl Add(String string, String string2, int n) throws BasicErrorException {
        Object object;
        if (string.length() == 0) {
            string = this.m_sDefaultTemplatePath;
        }
        String string3 = string + Filename.getGlobalFileSeparator() + string2;
        String string4 = Filename.getSuffix(string2);
        if (string4.length() == 0) {
            object = new WriterTemplateFilename(string2, string);
            ((Filename)object).clearCurrentExtension();
            if (((Filename)object).checkExistanceForRead()) {
                string3 = ((Filename)object).getAbsoluteFilename();
            }
        }
        if ((object = this.getNamedTemplate(string3)) != null) {
            return object;
        }
        object = new TemplateImpl(this.getParentAdaptor(), string, string2, n);
        this.m_aListOfTemplate.add(object);
        return object;
    }

    private TemplateImpl getNamedTemplate(String string) throws BasicErrorException {
        String string2 = Filename.getPathFromName(string);
        String string3 = Filename.getBasename(string);
        int n = 0;
        while (n < this.Count()) {
            TemplateImpl templateImpl = (TemplateImpl)this.m_aListOfTemplate.get(n);
            if (templateImpl.getFullName().equals(string)) {
                return templateImpl;
            }
            ++n;
        }
        return null;
    }

    public XTemplate Item(Object object) throws BasicErrorException {
        XTemplate xTemplate = null;
        if (AnyConverter.isString((Object)object)) {
            String string = "";
            try {
                string = AnyConverter.toString((Object)object);
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
            xTemplate = this.getItemByName(string);
        } else {
            try {
                int n = NumericalHelper.toInt(object);
                xTemplate = this.getItemByIndex(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(964, object.getClass().getName());
            }
        }
        if (xTemplate == null) {
            DebugHelper.exception(5, "");
        }
        return xTemplate;
    }

    private XTemplate getItemByName(String string) throws BasicErrorException {
        XTemplate xTemplate = null;
        String string2 = Filename.getPathFromName(string);
        String string3 = Filename.getBasename(string);
        String string4 = string2 + Filename.getGlobalFileSeparator() + string3;
        String string5 = Filename.getSuffix(string3);
        if (string5.length() == 0) {
            WriterTemplateFilename writerTemplateFilename = new WriterTemplateFilename(string3, string2);
            writerTemplateFilename.clearCurrentExtension();
            if (writerTemplateFilename.checkExistanceForRead()) {
                string4 = writerTemplateFilename.getAbsoluteFilename();
            }
        }
        int n = 0;
        while (n < this.m_aListOfTemplate.size()) {
            xTemplate = (XTemplate)this.m_aListOfTemplate.get(n);
            if (xTemplate.getFullName().equals(string4)) {
                return xTemplate;
            }
            ++n;
        }
        return xTemplate;
    }

    private XTemplate getItemByIndex(int n) throws BasicErrorException {
        XTemplate xTemplate = null;
        int n2 = n - 1;
        if (n2 < this.m_aListOfTemplate.size()) {
            xTemplate = (XTemplate)this.m_aListOfTemplate.get(n2);
        }
        return xTemplate;
    }

    public static XTemplates create(DocumentsImpl documentsImpl) throws BasicErrorException {
        if (documentsImpl == null) {
            DebugHelper.exception((Exception)((Object)new IllegalArgumentException("Documents must given.")));
        }
        TemplatesImpl templatesImpl = new TemplatesImpl(documentsImpl);
        return templatesImpl;
    }
}

