/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BordersImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.TablesImpl;
import com.sun.star.helper.writer.WriterTableCellImpl;
import com.sun.star.helper.writer.WriterTableColumnsImpl;
import com.sun.star.helper.writer.WriterTableRowsImpl;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XTable;
import com.sun.star.helper.writer.XWriterTableCell;
import com.sun.star.helper.writer.XWriterTableColumns;
import com.sun.star.helper.writer.XWriterTableRows;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XCell;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;

public class TableImpl
extends HelperInterfaceAdaptor
implements XTable,
XUnoAccess {
    protected static final int CORRECT_VALUE = 56;
    protected XTextTable xTable;
    protected String sTableName;
    static /* synthetic */ Class class$com$sun$star$text$XTextViewCursorSupplier;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    public TableImpl(TablesImpl tablesImpl, XTextTable xTextTable, String string) throws IllegalArgumentException {
        super(tablesImpl);
        if (xTextTable == null || string == null) {
            throw new IllegalArgumentException("Cannot construct a table with the given parameters.");
        }
        this.xTable = xTextTable;
        this.sTableName = string;
    }

    public XWriterTableCell Cell(int n, int n2) throws IndexOutOfBoundsException, BasicErrorException {
        WriterTableCellImpl writerTableCellImpl = this.getCellAtPos(TableImpl.getStringForNumber(n2 - 1) + n);
        return writerTableCellImpl;
    }

    public XWriterTableRows Rows() throws BasicErrorException {
        return new WriterTableRowsImpl(this, this.xTable);
    }

    public XWriterTableColumns Columns() throws BasicErrorException {
        return new WriterTableColumnsImpl(this, this.xTable);
    }

    public XRange Range() throws BasicErrorException {
        XTextRange xTextRange = this.xTable.getAnchor();
        RangeImpl rangeImpl = new RangeImpl((HelperInterfaceAdaptor)this, xTextRange);
        return rangeImpl;
    }

    public void Delete() throws BasicErrorException {
        TablesImpl tablesImpl = (TablesImpl)this.getParent();
        tablesImpl.deleteTableByName(this.getName());
    }

    public XBorders Borders() throws BasicErrorException {
        return new BordersImpl(this);
    }

    public void Select() throws BasicErrorException {
        XController xController = this.getXModel().getCurrentController();
        XTextViewCursorSupplier xTextViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextViewCursorSupplier == null ? (class$com$sun$star$text$XTextViewCursorSupplier = TableImpl.class$("com.sun.star.text.XTextViewCursorSupplier")) : class$com$sun$star$text$XTextViewCursorSupplier), (Object)xController);
        XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = TableImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)xController);
        try {
            xSelectionSupplier.select((Object)this.xTable);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        XTextViewCursor xTextViewCursor = xTextViewCursorSupplier.getViewCursor();
        xTextViewCursor.gotoEnd(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public XRange ConvertToText(Object object, Object object2) throws BasicErrorException {
        String string = "\t";
        if (!AnyConverter.isVoid((Object)object) && !AnyConverter.isString((Object)object)) {
            int n = NumericalHelper.toInt(object, -1);
            if (n != -1) {
                switch (n) {
                    case 2: {
                        string = "";
                        break;
                    }
                    case 0: {
                        string = "\n";
                        if (!NumericalHelper.toBoolean(object2, false)) break;
                        DebugHelper.exception(73, "NestedTables");
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            string = NumericalHelper.toString(object, string);
        }
        this.Select();
        PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
        propertyValueArray[0].Name = "Delimiter";
        propertyValueArray[0].Value = string;
        DispatchCommand.execute(".uno:ConvertTableToText", this.getXModel().getCurrentController().getFrame(), propertyValueArray);
        return null;
    }

    protected void setAlignment(int n) throws BasicErrorException {
        Throwable throwable = null;
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = TableImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xTable);
            xPropertySet.setPropertyValue("HoriOrient", (Object)new Short((short)n));
        }
        catch (PropertyVetoException propertyVetoException) {
            throwable = propertyVetoException;
        }
        catch (UnknownPropertyException unknownPropertyException) {
            throwable = unknownPropertyException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throwable = illegalArgumentException;
        }
        catch (WrappedTargetException wrappedTargetException) {
            throwable = wrappedTargetException;
        }
        if (throwable != null) {
            DebugHelper.exception((Exception)throwable);
        }
    }

    protected int getAlignment() throws BasicErrorException {
        int n = -1;
        Throwable throwable = null;
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = TableImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xTable);
            Object object = xPropertySet.getPropertyValue("HoriOrient");
            n = NumericalHelper.toInt(object);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            throwable = unknownPropertyException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throwable = illegalArgumentException;
        }
        catch (WrappedTargetException wrappedTargetException) {
            throwable = wrappedTargetException;
        }
        if (throwable != null) {
            DebugHelper.exception((Exception)throwable);
        }
        return n;
    }

    private WriterTableCellImpl getCellAtPos(String string) throws BasicErrorException {
        return new WriterTableCellImpl(this, string);
    }

    protected static String getStringForNumber(int n) {
        String string = null;
        int n2 = 0;
        int n3 = 0;
        if (n <= 26) {
            string = new String(new char[]{(char)(n + 65)});
        } else {
            n2 = n / 26;
            n3 = n % 26;
            if (n3 == 0) {
                n3 = n / n2;
                --n2;
            }
            string = new String(new char[]{(char)(n2 + 65), (char)(n3 + 65)});
        }
        return string;
    }

    protected static int getNumberForString(String string) {
        int n = 0;
        if (string != null && string.length() != 0) {
            int n2 = Character.getNumericValue(string.charAt(0)) + 56;
            n = n2 - 65;
        }
        return n;
    }

    protected static String[] getStartEndCellFromRange(String string) {
        String[] stringArray = null;
        if (string != null && string.length() != 0) {
            int n = string.indexOf(58);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                stringArray = new String[]{string2, string3};
            } else {
                stringArray = new String[]{string, string};
            }
        } else {
            stringArray = new String[]{"", ""};
        }
        return stringArray;
    }

    protected XTextTable getWrappedTable() {
        return this.xTable;
    }

    protected String getName() {
        return this.sTableName;
    }

    protected void deleteContent() {
        String[] stringArray = this.xTable.getCellNames();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                XCell xCell = this.xTable.getCellByName(stringArray[n]);
                if (xCell != null) {
                    xCell.setFormula("");
                } else {
                    DebugHelper.warning(new Exception("Cannot get cell from table."));
                }
                ++n;
            }
        } else {
            DebugHelper.warning(new Exception("Cannot get cell names from table."));
        }
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xTable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

