/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.CollectionHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.StyleImpl;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XStyle;
import com.sun.star.helper.writer.XStyles;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.util.ArrayList;

public class StylesImpl
extends HelperInterfaceAdaptor
implements XStyles,
XUnoAccess {
    private static final String STYLE_TYPE_NAME_PARAGRAPH = "ParagraphStyles";
    private static final String STYLE_TYPE_NAME_CHARACTER = "CharacterStyles";
    private static final String STYLE_TYPE_NAME_TABLE = "ParagraphStyles";
    private static final int STYLE_TYPE_COUNT = 2;
    private static final String[] STYLE_TYPE_NAMES = new String[]{"ParagraphStyles", "CharacterStyles", "ParagraphStyles"};
    private static final String[] STYLE_TYPE_PROPERTY = new String[]{"ParaStyleName", "CharStyleName", "ParaStyleName"};
    private static final String[] STYLE_TYPE_SERVICES = new String[]{"com.sun.star.style.ParagraphStyle", "com.sun.star.style.CharacterStyle", "com.sun.star.style.CellStyle"};
    private static XStyleFamiliesSupplier m_xStyleFamiliesSupplier;
    private StylesHelperCache itemStyles = new StylesHelperCache();
    static /* synthetic */ Class class$com$sun$star$style$XStyleFamiliesSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XNameContainer;
    static /* synthetic */ Class class$com$sun$star$container$XIndexAccess;
    static /* synthetic */ Class class$com$sun$star$uno$XInterface;
    static /* synthetic */ Class class$com$sun$star$style$XStyle;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$helper$writer$XStyle;

    public StylesImpl(DocumentImpl documentImpl) {
        super(documentImpl);
        m_xStyleFamiliesSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$style$XStyleFamiliesSupplier == null ? (class$com$sun$star$style$XStyleFamiliesSupplier = StylesImpl.class$("com.sun.star.style.XStyleFamiliesSupplier")) : class$com$sun$star$style$XStyleFamiliesSupplier), (Object)this.getXModel());
    }

    public static int detectStyleType(Object object) throws BasicErrorException {
        int n = HelperUtilities.supportsService(object, STYLE_TYPE_SERVICES);
        if (n == -1) {
            if (HelperUtilities.supportsService(object, "com.sun.star.style.CharacterProperties") && HelperUtilities.supportsService(object, "com.sun.star.style.Style")) {
                return 2;
            }
            DebugHelper.exception(51, "Invalid style object " + object);
        }
        return n + 1;
    }

    private static XNameContainer getStyleType(String string) {
        try {
            Object object = m_xStyleFamiliesSupplier.getStyleFamilies().getByName(string);
            return (XNameContainer)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameContainer == null ? (class$com$sun$star$container$XNameContainer = StylesImpl.class$("com.sun.star.container.XNameContainer")) : class$com$sun$star$container$XNameContainer), (Object)object);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.warning(exception);
            return null;
        }
    }

    private com.sun.star.style.XStyle getRawStyle(String string) throws BasicErrorException {
        Object[] objectArray;
        int n;
        if (string == null || string.length() == 0) {
            DebugHelper.exception(51, "Unknown style: " + string);
        }
        if ((n = this.getStyleOrCount(string, objectArray = new com.sun.star.style.XStyle[1])) != -1) {
            DebugHelper.exception(51, "Unknown style: " + string);
        }
        return objectArray[0];
    }

    public int Count() throws BasicErrorException {
        return this.getStyleOrCount(null, null);
    }

    public void getStyles(ArrayList arrayList) throws BasicErrorException {
        Object[] objectArray = new Object[]{arrayList};
        this.getStyleOrCount(null, objectArray);
    }

    private int getStyleOrCount(String string, Object[] objectArray) throws BasicErrorException {
        int n = 0;
        ArrayList arrayList = null;
        if (string == null && objectArray != null && objectArray.length > 0 && objectArray[0] instanceof ArrayList) {
            arrayList = (ArrayList)objectArray[0];
        }
        int n2 = 0;
        while (n2 < 2) {
            XNameContainer xNameContainer = StylesImpl.getStyleType(STYLE_TYPE_NAMES[n2]);
            if (xNameContainer != null) {
                Object object;
                if (string == null) {
                    try {
                        object = (XIndexAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XIndexAccess == null ? StylesImpl.class$("com.sun.star.container.XIndexAccess") : class$com$sun$star$container$XIndexAccess), (Object)xNameContainer);
                        int n3 = object.getCount();
                        n += n3;
                        if (arrayList != null) {
                            int n4 = 0;
                            while (n4 < n3) {
                                Object object2 = object.getByIndex(n4);
                                if (object2 instanceof Any) {
                                    object2 = AnyConverter.toObject((Class)(class$com$sun$star$uno$XInterface == null ? StylesImpl.class$("com.sun.star.uno.XInterface") : class$com$sun$star$uno$XInterface), (Object)object2);
                                }
                                arrayList.add(object2);
                                ++n4;
                            }
                        }
                    }
                    catch (com.sun.star.uno.Exception exception) {
                        DebugHelper.exception(exception);
                    }
                    catch (Exception exception) {
                        DebugHelper.exception(51, exception.getMessage());
                    }
                } else if (xNameContainer.hasByName(string)) {
                    try {
                        object = xNameContainer.getByName(string);
                        if (object instanceof Any) {
                            object = AnyConverter.toObject((Class)(class$com$sun$star$style$XStyle == null ? (class$com$sun$star$style$XStyle = StylesImpl.class$("com.sun.star.style.XStyle")) : class$com$sun$star$style$XStyle), (Object)object);
                        }
                        if (object == null) {
                            DebugHelper.exception(51, "bad style");
                        }
                        objectArray[0] = object;
                        return -1;
                    }
                    catch (com.sun.star.uno.Exception exception) {
                        DebugHelper.exception(exception);
                    }
                    catch (Exception exception) {
                        DebugHelper.exception(51, exception.getMessage());
                    }
                }
            }
            ++n2;
        }
        return n;
    }

    public XStyle Item(Object object) throws BasicErrorException {
        StyleImpl styleImpl;
        block3: {
            this.itemStyles.updateCache();
            styleImpl = null;
            if (object == null || AnyConverter.isVoid((Object)object)) break block3;
            try {
                if (AnyConverter.isString((Object)object)) {
                    String string = null;
                    string = AnyConverter.toString((Object)object);
                    styleImpl = this.getStyleByName(string);
                    break block3;
                }
                int n = (int)OptionalParamUtility.getAnyNumber("Index", object, 1L, true);
                styleImpl = this.getStyleByIndex(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        }
        return styleImpl;
    }

    public XStyle Add(Object object, Object object2) throws BasicErrorException {
        String string = null;
        StyleImpl styleImpl = null;
        if (object != null && !AnyConverter.isVoid((Object)object) && AnyConverter.isString((Object)object)) {
            try {
                string = AnyConverter.toString((Object)object);
                int n = -1;
                if (object2 == null || AnyConverter.isVoid((Object)object2)) {
                    n = 1;
                } else if (object2 instanceof Number) {
                    Number number = (Number)object2;
                    n = number.intValue();
                }
                if (n >= 1) {
                    styleImpl = this.createStyle(string, n);
                }
            }
            catch (com.sun.star.uno.Exception exception) {
                HelperUtilities.exception(exception);
            }
        }
        if (styleImpl == null) {
            DebugHelper.exception(5, "Invalid style name: " + object + " or type " + object2);
        }
        return styleImpl;
    }

    private StyleImpl createStyle(String string, int n) throws BasicErrorException {
        XNameContainer xNameContainer;
        int n2 = n - 1;
        if (string.length() == 0) {
            DebugHelper.exception(5, "Invalid style name " + string);
        }
        if (n2 < 0 || n2 >= STYLE_TYPE_NAMES.length) {
            DebugHelper.exception(5, "Invalid style type " + n);
        }
        if ((xNameContainer = StylesImpl.getStyleType(STYLE_TYPE_NAMES[n2])).hasByName(string)) {
            DebugHelper.exception(10, string);
        }
        StyleImpl styleImpl = null;
        try {
            XMultiServiceFactory xMultiServiceFactory = ((DocumentImpl)this.getParent()).getXMultiServiceFactory();
            Object object = xMultiServiceFactory.createInstance(STYLE_TYPE_SERVICES[n2]);
            styleImpl = this.addStyle(object);
            styleImpl.setType(n);
            xNameContainer.insertByName(string, object);
            styleImpl.setNameLocal(string);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return styleImpl;
    }

    StyleImpl getStyleByName(String string) throws BasicErrorException {
        this.itemStyles.updateCache();
        if (string.length() == 0) {
            DebugHelper.exception(51, "Range/Selection has multiple assigned styles");
        }
        com.sun.star.style.XStyle xStyle = this.getRawStyle(string);
        return (StyleImpl)this.itemStyles.getOrCreateHelper(xStyle);
    }

    private StyleImpl getStyleByIndex(int n) throws BasicErrorException {
        this.itemStyles.updateCache();
        return (StyleImpl)this.itemStyles.item(n - 1);
    }

    private XStyle getStyle(Object object) throws BasicErrorException {
        return (StyleImpl)this.itemStyles.getOrCreateHelper(object);
    }

    private StyleImpl addStyle(Object object) throws BasicErrorException {
        return (StyleImpl)this.itemStyles.addImplementationObject(object);
    }

    protected static String getHelperStyleName(XDocument xDocument, HelperInterfaceAdaptor helperInterfaceAdaptor) throws BasicErrorException {
        String string;
        XTextRange xTextRange = helperInterfaceAdaptor.getXTextRange();
        String string2 = null;
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = StylesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextRange);
        Property[] propertyArray = xPropertySet.getPropertySetInfo().getProperties();
        int n = 0;
        while (n < propertyArray.length) {
            System.out.println("Aha: " + propertyArray[n]);
            System.out.println("ok.");
            ++n;
        }
        try {
            string = HelperUtilities.getStringProperty(xTextRange, "CharStyleName");
            if (string != null && string.length() > 0) {
                string2 = string;
            }
        }
        catch (Exception exception) {
            DebugHelper.writeInfo(exception.getMessage());
        }
        try {
            string = HelperUtilities.getStringProperty(xTextRange, "ParaStyleName");
            if (string != null && string.length() > 0) {
                string2 = string;
            }
        }
        catch (Exception exception) {
            DebugHelper.writeInfo(exception.getMessage());
        }
        if (string2 == null) {
            DebugHelper.exception(51, "HelperStyleName");
        }
        return string2;
    }

    private static void setHelperStyleName(HelperInterfaceAdaptor helperInterfaceAdaptor, int n, String string) throws BasicErrorException {
        DebugHelper.writeInfo("typeId " + n);
        DebugHelper.writeInfo("styleName " + string);
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = StylesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)helperInterfaceAdaptor.getXTextRange());
        n = StylesImpl.getTypeIdFromList(string) + 1;
        try {
            xPropertySet.setPropertyValue(STYLE_TYPE_PROPERTY[n - 1], (Object)string);
        }
        catch (Exception exception) {
            DebugHelper.exception(51, "Invalid target for style " + helperInterfaceAdaptor + " : " + string);
        }
    }

    protected static void setHelperStyleAny(XDocument xDocument, HelperInterfaceAdaptor helperInterfaceAdaptor, Object object) throws BasicErrorException {
        XStyle xStyle = null;
        String string = null;
        if (object instanceof Any) {
            try {
                if (AnyConverter.isString((Object)object)) {
                    string = AnyConverter.toString((Object)object);
                } else if (AnyConverter.isObject((Object)object)) {
                    xStyle = (XStyle)AnyConverter.toObject((Class)(class$com$sun$star$helper$writer$XStyle == null ? (class$com$sun$star$helper$writer$XStyle = StylesImpl.class$("com.sun.star.helper.writer.XStyle")) : class$com$sun$star$helper$writer$XStyle), (Object)object);
                    string = xStyle.getNameLocal();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            try {
                int n = NumericalHelper.toInt(object);
                switch (n) {
                    case -1: {
                        string = "Standard";
                        break;
                    }
                    case -2: {
                        string = "Heading 1";
                        break;
                    }
                    case -3: {
                        string = "Heading 2";
                        break;
                    }
                    case -4: {
                        string = "Heading 3";
                        break;
                    }
                    case -5: {
                        string = "Heading 4";
                        break;
                    }
                    case -6: {
                        string = "Heading 5";
                        break;
                    }
                    case -7: {
                        string = "Heading 6";
                        break;
                    }
                    case -8: {
                        string = "Heading 7";
                        break;
                    }
                    case -9: {
                        string = "Heading 8";
                        break;
                    }
                    case -10: {
                        string = "Heading 9";
                        break;
                    }
                    default: {
                        DebugHelper.writeInfo("WdBuildinStyle(" + n + ") not handled yet. 'Standard' is used.");
                        string = "Standard";
                        break;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        }
        if (xStyle == null) {
            xStyle = xDocument.getStyles().Item(string);
        }
        if (xStyle == null) {
            DebugHelper.writeInfo("Can't find or convert the given style.");
            DebugHelper.exception(14, "");
        }
        StylesImpl.setHelperStyleName(helperInterfaceAdaptor, xStyle.getType(), string);
    }

    private static int getTypeIdFromList(String string) throws BasicErrorException {
        if (string == null) {
            return -1;
        }
        int n = 0;
        while (n < 2) {
            XNameContainer xNameContainer = StylesImpl.getStyleType(STYLE_TYPE_NAMES[n]);
            if (xNameContainer != null && xNameContainer.hasByName(string)) {
                try {
                    Object object = xNameContainer.getByName(string);
                    object = AnyConverter.toObject((Class)(class$com$sun$star$style$XStyle == null ? (class$com$sun$star$style$XStyle = StylesImpl.class$("com.sun.star.style.XStyle")) : class$com$sun$star$style$XStyle), (Object)object);
                    return n;
                }
                catch (com.sun.star.uno.Exception exception) {
                    DebugHelper.exception(exception);
                }
            }
            ++n;
        }
        return -1;
    }

    public Object getUnoObject() throws BasicErrorException {
        return m_xStyleFamiliesSupplier;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class StylesHelperCache
    extends CollectionHelper {
        StylesHelperCache() {
            super(1);
        }

        public void fetchImplementationObjects(ArrayList arrayList) throws BasicErrorException {
            Object[] objectArray = new Object[]{arrayList};
            StylesImpl.this.getStyleOrCount(null, objectArray);
        }

        public boolean isValidImplementationObject(Object object) {
            return HelperUtilities.supportsService(object, "com.sun.star.style.Style");
        }

        public HelperInterfaceAdaptor createHelper(Object object) throws BasicErrorException {
            if (!this.isValidImplementationObject(object)) {
                return null;
            }
            StyleImpl styleImpl = new StyleImpl((DocumentImpl)StylesImpl.this.getParent(), (XInterface)object);
            return styleImpl;
        }
    }
}

