/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;
import java.util.Hashtable;
import java.util.Vector;

public class RangeSortDescriptorHelper {
    public static final String EXCLUDE_HEADER = "ExcludeHeader";
    public static final String FIELD_NUMBER = "FieldNumber";
    public static final String SORT_FIELD_TYPE = "SortFieldType";
    public static final String SORT_ORDER = "SortOrder";
    public static final String FIELD_NUMBER2 = "FieldNumber2";
    public static final String SORT_FIELD_TYPE2 = "SortFieldType2";
    public static final String SORT_ORDER2 = "SortOrder2";
    public static final String FIELD_NUMBER3 = "FieldNumber3";
    public static final String SORT_FIELD_TYPE3 = "SortFieldType3";
    public static final String SORT_ORDER3 = "SortOrder3";
    public static final String SORT_COULMN = "SortColumn";
    public static final String SEPARATOR = "Separator";
    public static final String CASE_SENSITIVE = "CaseSensitive";
    public static final String BIDI_SORT = "BidiSort";
    public static final String IGNORE_THE = "IgnoreThe";
    public static final String IGNORE_KASHIDA = "IgnoreKashida";
    public static final String IGNORE_DIACRITICS = "IgnoreDiacritics";
    public static final String IGNORE_HE = "IgnoreHe";
    public static final String LANGUAGE_ID = "LanguageID";
    private static Vector m_ResultSortDescriptor = new Vector();

    private RangeSortDescriptorHelper() {
    }

    public static PropertyValue[] completeSortDescriptorProperties(PropertyValue[] propertyValueArray, Hashtable hashtable) throws BasicErrorException {
        int n;
        int n2 = 0;
        while (n2 < propertyValueArray.length) {
            m_ResultSortDescriptor.add(propertyValueArray[n2]);
            ++n2;
        }
        if (NumericalHelper.toBoolean(hashtable.get(EXCLUDE_HEADER), false)) {
            DebugHelper.exception(73, EXCLUDE_HEADER);
        }
        if (NumericalHelper.toBoolean(hashtable.get(SORT_COULMN), false)) {
            DebugHelper.exception(73, SORT_COULMN);
        }
        if (hashtable.get(SEPARATOR) != null) {
            n = NumericalHelper.toInt(hashtable.get(SEPARATOR), 1);
            char c = ',';
            switch (n) {
                case 1: {
                    c = ',';
                    break;
                }
                case 2: {
                    c = ';';
                    break;
                }
                case 0: {
                    c = '\t';
                    break;
                }
                default: {
                    try {
                        c = NumericalHelper.toChar(hashtable.get(SEPARATOR));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        DebugHelper.exception((Exception)((Object)illegalArgumentException));
                    }
                }
            }
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "Delimiter";
            propertyValue.Value = new Character(c);
            m_ResultSortDescriptor.add(propertyValue);
        }
        if (hashtable.get(CASE_SENSITIVE) != null) {
            n = NumericalHelper.toBoolean(hashtable.get(CASE_SENSITIVE), false) ? 1 : 0;
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "IsCaseSensitive";
            propertyValue.Value = n != 0 ? Boolean.TRUE : Boolean.FALSE;
            m_ResultSortDescriptor.add(propertyValue);
        }
        if (hashtable.get(LANGUAGE_ID) != null) {
            DebugHelper.exception(73, LANGUAGE_ID);
        }
        if (hashtable.get(FIELD_NUMBER) != null || hashtable.get(SORT_FIELD_TYPE) != null || hashtable.get(SORT_ORDER) != null) {
            RangeSortDescriptorHelper.handleFieldNumber(hashtable.get(FIELD_NUMBER), hashtable.get(SORT_FIELD_TYPE), hashtable.get(SORT_ORDER), 0);
        }
        if (hashtable.get(FIELD_NUMBER2) != null || hashtable.get(SORT_FIELD_TYPE2) != null || hashtable.get(SORT_ORDER2) != null) {
            RangeSortDescriptorHelper.handleFieldNumber(hashtable.get(FIELD_NUMBER2), hashtable.get(SORT_FIELD_TYPE2), hashtable.get(SORT_ORDER2), 1);
        }
        if (hashtable.get(FIELD_NUMBER3) != null || hashtable.get(SORT_FIELD_TYPE3) != null || hashtable.get(SORT_ORDER3) != null) {
            RangeSortDescriptorHelper.handleFieldNumber(hashtable.get(FIELD_NUMBER3), hashtable.get(SORT_FIELD_TYPE3), hashtable.get(SORT_ORDER3), 2);
        }
        PropertyValue[] propertyValueArray2 = new PropertyValue[m_ResultSortDescriptor.size()];
        propertyValueArray2 = m_ResultSortDescriptor.toArray(propertyValueArray2);
        int n3 = 0;
        while (n3 < propertyValueArray2.length) {
            propertyValueArray2[n3].Handle = -1;
            DebugHelper.writeDebug("Prop: " + propertyValueArray2[n3].Name + "  " + propertyValueArray2[n3].Value.toString() + "  " + propertyValueArray2[n3].Handle);
            ++n3;
        }
        return propertyValueArray2;
    }

    private static void handleFieldNumber(Object object, Object object2, Object object3, int n) throws BasicErrorException {
        if (object == null) {
            DebugHelper.exception(969, "");
        }
        int n2 = NumericalHelper.toInt(object, 0);
        int n3 = NumericalHelper.toInt(object2, 0);
        boolean bl = false;
        switch (n3) {
            case 0: {
                bl = false;
                break;
            }
            case 1: 
            case 2: {
                bl = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                DebugHelper.exception(73, SORT_FIELD_TYPE + (n + 1));
                break;
            }
            default: {
                DebugHelper.exception(14, SORT_FIELD_TYPE + (n + 1));
            }
        }
        boolean bl2 = false;
        int n4 = NumericalHelper.toInt(object3, 0);
        switch (n3) {
            case 0: {
                bl2 = true;
                break;
            }
            case 1: {
                bl2 = false;
                break;
            }
            default: {
                DebugHelper.exception(14, SORT_ORDER + (n + 1));
            }
        }
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "SortRowOrColumnNo" + n;
        propertyValue.Value = new Integer(n2);
        PropertyValue propertyValue2 = new PropertyValue();
        propertyValue2.Name = "IsSortNumeric" + n;
        propertyValue2.Value = bl ? Boolean.TRUE : Boolean.FALSE;
        PropertyValue propertyValue3 = new PropertyValue();
        propertyValue3.Name = "IsSortAscending" + n;
        propertyValue3.Value = bl2 ? Boolean.TRUE : Boolean.FALSE;
        m_ResultSortDescriptor.add(propertyValue);
        m_ResultSortDescriptor.add(propertyValue2);
        m_ResultSortDescriptor.add(propertyValue3);
    }
}

