/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.LocaleUtilities;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.OptionsImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.SelectionImpl;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XTable;
import com.sun.star.helper.writer.XTables;
import com.sun.star.helper.writer.XWindow;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.linguistic2.XDictionary;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.uno.UnoRuntime;

public class RangeHelper {
    public static final int RANGES_EQUAL = 0;
    public static final int RANGES_INSIDE = 3;
    public static final int FIRST_RANGE_BEFORE = 2;
    public static final int SECOND_RANGE_BEFORE = -2;
    public static final int FIRST_RANGE_HALF_BEFORE = 1;
    public static final int SECOND_RANGE_HALF_BEFORE = -1;
    public static final int UNKNOWN = 256;
    static /* synthetic */ Class class$com$sun$star$text$XTextRangeCompare;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$linguistic2$XDictionary;

    private RangeHelper() {
    }

    public static int getPosition(XText xText, XTextRange xTextRange) {
        int n;
        block4: {
            n = -1;
            if (xText == null || xTextRange == null) break block4;
            n = 0;
            XTextCursor xTextCursor = xText.createTextCursor();
            xTextCursor.collapseToStart();
            XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = RangeHelper.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)xText);
            try {
                short s = xTextRangeCompare.compareRegionStarts(xTextCursor.getStart(), xTextRange);
                boolean bl = true;
                while (s != 0 && bl) {
                    bl = xTextCursor.goRight((short)1, false);
                    s = xTextRangeCompare.compareRegionStarts(xTextCursor.getStart(), xTextRange);
                    ++n;
                }
                if (!bl && s != 0) {
                    n = -1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
                n = -1;
            }
        }
        return n;
    }

    public static int getTableAdjustment(XTables xTables) throws BasicErrorException {
        int n = 0;
        int n2 = 1;
        while (n2 <= xTables.Count()) {
            try {
                XTable xTable = (XTable)xTables.Item(new Integer(n2));
                int n3 = xTable.Columns().Count();
                int n4 = xTable.Rows().Count();
                n += n4 * (n3 + 1) + 1;
            }
            catch (NullPointerException nullPointerException) {
                DebugHelper.warning(new com.sun.star.uno.Exception(nullPointerException.getMessage()));
            }
            ++n2;
        }
        return n;
    }

    public static XTextRange getRangeByPosition(XText xText, int n) {
        XTextRange xTextRange = null;
        if (xText != null) {
            int n2 = 0;
            XTextCursor xTextCursor = xText.createTextCursor();
            xTextCursor.collapseToStart();
            boolean bl = true;
            while (xTextRange == null && bl) {
                if (n == n2) {
                    xTextRange = xTextCursor.getStart();
                    continue;
                }
                bl = xTextCursor.goRight((short)1, false);
                ++n2;
            }
        }
        return xTextRange;
    }

    public static XTextRangeCompare getRangeComparator(XDocument xDocument) throws BasicErrorException {
        XTextRangeCompare xTextRangeCompare = null;
        if (xDocument != null && xDocument instanceof DocumentImpl) {
            DocumentImpl documentImpl = (DocumentImpl)xDocument;
            xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = RangeHelper.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)documentImpl.getXTextRange());
        } else {
            DebugHelper.exception(5, "Got a wrong XDocument implementation");
        }
        return xTextRangeCompare;
    }

    public static int compareStartAndEnd(XTextCursor xTextCursor, XDocument xDocument) throws BasicErrorException {
        XTextRangeCompare xTextRangeCompare = RangeHelper.getRangeComparator(xDocument);
        try {
            return xTextRangeCompare.compareRegionStarts(xTextCursor.getStart(), xTextCursor.getEnd());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            return 0;
        }
    }

    public static void collapseLeftOrRight(boolean bl, XTextCursor xTextCursor, XDocument xDocument) throws BasicErrorException {
        int n = RangeHelper.compareStartAndEnd(xTextCursor, xDocument);
        if (bl) {
            n = -n;
        }
        if (n > 0) {
            xTextCursor.collapseToStart();
        } else if (n < 0) {
            xTextCursor.collapseToEnd();
        }
    }

    public static boolean forceStartPrecedesEnd(XTextCursor xTextCursor, XDocument xDocument) throws BasicErrorException {
        if (RangeHelper.compareStartAndEnd(xTextCursor, xDocument) < 0) {
            RangeHelper.swapDirection(xTextCursor);
            return true;
        }
        return false;
    }

    public static void swapDirection(XTextCursor xTextCursor) throws BasicErrorException {
        XTextRange xTextRange = xTextCursor.getStart();
        xTextCursor.collapseToEnd();
        xTextCursor.gotoRange(xTextRange, true);
    }

    public static boolean areRangesEqual(XTextRange xTextRange, XTextRange xTextRange2) {
        return RangeHelper.compareRangesPosition(xTextRange, xTextRange2) == 0;
    }

    public static int compareRangesPosition(XTextRange xTextRange, XTextRange xTextRange2) {
        int n;
        block3: {
            XTextRangeCompare xTextRangeCompare;
            n = 256;
            if (xTextRange == null || xTextRange2 == null || (xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = RangeHelper.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)xTextRange.getText())) == null) break block3;
            try {
                short s = xTextRangeCompare.compareRegionStarts(xTextRange, xTextRange2);
                short s2 = xTextRangeCompare.compareRegionEnds(xTextRange, xTextRange2);
                n = s + s2;
                if (n == 0 && s != 0) {
                    n = 3;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        }
        return n;
    }

    public static boolean doubleUp(StringBuffer stringBuffer, char c) {
        char[] cArray = new char[]{c};
        String string = new String(cArray);
        int n = stringBuffer.indexOf(string);
        if (n >= 0 && n < stringBuffer.length() - 1 && stringBuffer.charAt(n + 1) != c) {
            stringBuffer.insert(n, c);
            return true;
        }
        return false;
    }

    public static void insertControlCharacter(XTextRange xTextRange, XText xText, short s, boolean bl) throws BasicErrorException {
        try {
            xText.insertControlCharacter(xTextRange, s, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
    }

    public static void insertString(XTextRange xTextRange, XText xText, String string, boolean bl) throws BasicErrorException {
        int n = 0;
        int n2 = 0;
        try {
            while ((n2 = string.indexOf(10, n)) >= 0) {
                xTextRange = xTextRange.getEnd();
                if (n < n2 - 1) {
                    xText.insertString(xTextRange, string.substring(n, n2 - 1), bl);
                    xTextRange = xTextRange.getEnd();
                }
                xText.insertControlCharacter(xTextRange, (short)0, bl);
                n = n2 + 1;
            }
            if (n < string.length()) {
                xTextRange = xTextRange.getEnd();
                String string2 = string.substring(n);
                xText.insertString(xTextRange, string2, bl);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public static int getTextUnit(Object object, int n) throws BasicErrorException {
        try {
            if (NumericalHelper.isNumerical(object)) {
                return NumericalHelper.toInt(object);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public static int getNextExtent(int n) {
        n = n < 0 ? 1 : (n < 4 ? ++n : (n == 4 ? 8 : 6));
        return n;
    }

    public static XTextCursor initCursor(XTextRange xTextRange, XText xText) {
        XTextCursor xTextCursor;
        block7: {
            xTextCursor = null;
            boolean bl = false;
            try {
                xTextCursor = xText.createTextCursorByRange(xTextRange);
                bl = true;
            }
            catch (Throwable throwable) {
                DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
            }
            if (!bl) {
                try {
                    XText xText2 = xTextRange.getText();
                    xTextCursor = xText2.createTextCursor();
                    bl = true;
                }
                catch (Throwable throwable) {
                    DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
                }
            }
            if (bl) break block7;
            try {
                xTextCursor = xText.createTextCursor();
                bl = true;
            }
            catch (Throwable throwable) {
                DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
            }
        }
        return xTextCursor;
    }

    public static RangeImpl syncModelCursorToView(RangeImpl rangeImpl, DocumentImpl documentImpl, XTextViewCursor xTextViewCursor) {
        block3: {
            try {
                if (rangeImpl == null) {
                    rangeImpl = new RangeImpl((HelperInterfaceAdaptor)documentImpl, (XTextRange)xTextViewCursor);
                    break block3;
                }
                rangeImpl.setXTextRange((XTextRange)xTextViewCursor);
            }
            catch (Exception exception) {
                DebugHelper.writeInfo("syncModelCursorToView: Exception : " + exception.toString());
            }
        }
        return rangeImpl;
    }

    public static void syncModelCursorToView(SelectionImpl selectionImpl) throws BasicErrorException {
        DocumentImpl documentImpl = (DocumentImpl)((XWindow)selectionImpl.getParent()).getDocument();
        selectionImpl.setRangeImpl(RangeHelper.syncModelCursorToView(selectionImpl.getRangeImpl(), documentImpl, selectionImpl.getTextViewCursor()));
    }

    public static void syncViewCursorToModel(XTextViewCursor xTextViewCursor, RangeImpl rangeImpl) {
        try {
            RangeHelper.setXTextRange(xTextViewCursor, rangeImpl.getXTextRange());
        }
        catch (Exception exception) {
            DebugHelper.writeInfo("syncViewCursorToModel: Exception : " + exception.toString());
        }
    }

    public static void setXTextRange(XTextViewCursor xTextViewCursor, XTextRange xTextRange, XTextRange xTextRange2) {
        xTextViewCursor.gotoRange(xTextRange, false);
        xTextViewCursor.gotoRange(xTextRange2, true);
    }

    public static void setXTextRange(XTextViewCursor xTextViewCursor, XTextRange xTextRange) {
        xTextViewCursor.gotoRange(xTextRange.getStart(), false);
        xTextViewCursor.gotoRange(xTextRange.getEnd(), true);
    }

    public static short getRotationFromOrientation(int n) throws NoSupportException {
        short s = 0;
        switch (n) {
            case 0: {
                s = 0;
                break;
            }
            case 3: {
                s = 2700;
                break;
            }
            case 2: {
                s = 900;
                break;
            }
            default: {
                throw new NoSupportException("Unsopported Orientation");
            }
        }
        return s;
    }

    public static int getOrientationFromRotation(short s) {
        int n = 0;
        if (450 <= s && s <= 1350) {
            n = 2;
        } else if (1350 < s && s <= 3050) {
            n = 3;
        }
        return n;
    }

    public static boolean InRangesR2InR1(XTextRange xTextRange, XTextRange xTextRange2) {
        block3: {
            XTextRangeCompare xTextRangeCompare;
            if (xTextRange == null || xTextRange2 == null || (xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = RangeHelper.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)xTextRange.getText())) == null) break block3;
            try {
                if (xTextRangeCompare.compareRegionStarts(xTextRange, xTextRange2) >= 0 && xTextRangeCompare.compareRegionEnds(xTextRange, xTextRange2) <= 0) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        }
        return false;
    }

    public static Locale getAdjacentLocale(XTextRange xTextRange) {
        Locale locale = null;
        XPropertySet xPropertySet = null;
        try {
            xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = RangeHelper.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xTextRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.writeDebugWarning((Exception)((Object)illegalArgumentException));
        }
        int n = 0;
        while (!RangeHelper.checkLocale(locale)) {
            switch (n) {
                case 0: {
                    try {
                        if (xPropertySet == null) break;
                        locale = (Locale)xPropertySet.getPropertyValue("CharLocale");
                    }
                    catch (UnknownPropertyException unknownPropertyException) {
                        DebugHelper.writeDebugWarning((Exception)((Object)unknownPropertyException));
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        DebugHelper.writeDebugWarning((Exception)((Object)wrappedTargetException));
                    }
                    break;
                }
                case 1: {
                    if (xTextRange == null || xPropertySet == null) break;
                    java.util.Locale locale2 = xTextRange.getStart();
                    XTextCursor xTextCursor = locale2.getText().createTextCursorByRange((XTextRange)locale2);
                    xTextCursor.goLeft((short)1, true);
                    try {
                        xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? RangeHelper.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet, xTextCursor);
                        locale = (Locale)xPropertySet.getPropertyValue("CharLocale");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        DebugHelper.writeDebugWarning((Exception)((Object)illegalArgumentException));
                    }
                    catch (UnknownPropertyException unknownPropertyException) {
                        DebugHelper.writeDebugWarning((Exception)((Object)unknownPropertyException));
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        DebugHelper.writeDebugWarning((Exception)((Object)wrappedTargetException));
                    }
                    break;
                }
                case 2: {
                    if (xTextRange == null || xPropertySet == null) break;
                    java.util.Locale locale2 = xTextRange.getEnd();
                    XTextCursor xTextCursor = locale2.getText().createTextCursorByRange((XTextRange)locale2);
                    xTextCursor.goRight((short)1, true);
                    try {
                        xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? RangeHelper.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet, xTextCursor);
                        locale = (Locale)xPropertySet.getPropertyValue("CharLocale");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        DebugHelper.writeDebugWarning((Exception)((Object)illegalArgumentException));
                    }
                    catch (UnknownPropertyException unknownPropertyException) {
                        DebugHelper.writeDebugWarning((Exception)((Object)unknownPropertyException));
                    }
                    catch (WrappedTargetException wrappedTargetException) {
                        DebugHelper.writeDebugWarning((Exception)((Object)wrappedTargetException));
                    }
                    break;
                }
                case 3: {
                    java.util.Locale locale2 = LocaleUtilities.getCurrentLocale();
                    locale = new Locale();
                    locale.Country = locale2.getCountry();
                    locale.Language = locale2.getLanguage();
                    locale.Variant = locale2.getVariant();
                    break;
                }
                default: {
                    locale = new Locale();
                    locale.Country = "US";
                    locale.Language = "en";
                }
            }
            ++n;
        }
        return locale;
    }

    private static boolean checkLocale(Locale locale) {
        boolean bl = false;
        if (locale != null && locale.Country != null && locale.Country.length() != 0 && locale.Language != null && locale.Language.length() != 0) {
            bl = true;
        }
        return bl;
    }

    public static void enableDictionaries(OptionsImpl optionsImpl, Object[] objectArray, boolean bl) throws BasicErrorException {
        try {
            XDictionary[] xDictionaryArray = optionsImpl.getDictionaries();
            int n = 0;
            while (n < xDictionaryArray.length) {
                boolean bl2 = false;
                if (xDictionaryArray[n].getName().equals("standard")) {
                    bl2 = bl;
                }
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] instanceof String) {
                        bl2 |= ((String)objectArray[n2]).equalsIgnoreCase(xDictionaryArray[n].getName());
                    } else {
                        XDictionary xDictionary = (XDictionary)OptionalParamUtility.getObject(class$com$sun$star$linguistic2$XDictionary == null ? RangeHelper.class$("com.sun.star.linguistic2.XDictionary") : class$com$sun$star$linguistic2$XDictionary, objectArray[n2]);
                        bl2 |= xDictionary.getName().equalsIgnoreCase(xDictionaryArray[n].getName());
                    }
                    ++n2;
                }
                xDictionaryArray[n].setActive(bl2);
                ++n;
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

