/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.drawing.XShape;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.writer.ShapeImpl;
import com.sun.star.helper.writer.XPictureFormat;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;

public class PictureFormatImpl
extends HelperInterfaceAdaptor
implements XPictureFormat {
    protected static final String __serviceName = "com.sun.star.helper.writer.PictureFormat";
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;

    public PictureFormatImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
    }

    public void IncrementBrightness(double d) throws BasicErrorException {
        double d2 = this.getBrightness();
        if ((d2 += d) < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        this.setBrightness(d2);
    }

    public void IncrementContrast(double d) throws BasicErrorException {
        double d2 = this.getContrast();
        if ((d2 += d) < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        this.setContrast(d2);
    }

    private void checkParameterRangeInDouble(double d, double d2, double d3) throws BasicErrorException {
        if (d < d2) {
            DebugHelper.exception((Exception)((Object)new IllegalArgumentException("Parameter out of range, value is too small.")));
        }
        if (d > d3) {
            DebugHelper.exception((Exception)((Object)new IllegalArgumentException("Parameter out of range, value is too high.")));
        }
    }

    public void setBrightness(double d) throws BasicErrorException {
        this.checkParameterRangeInDouble(d, 0.0, 1.0);
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = PictureFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            double d2 = d * 200.0 - 100.0;
            propertySetHelper.setPropertyValue("AdjustLuminance", new Short((short)d2));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getBrightness() throws BasicErrorException {
        double d = 0.5;
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = PictureFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            int n = propertySetHelper.getPropertyValueAsInteger("AdjustLuminance", 0);
            double d2 = n;
            d = (d2 + 100.0) / 200.0;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return d;
    }

    public void setContrast(double d) throws BasicErrorException {
        this.checkParameterRangeInDouble(d, 0.0, 1.0);
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = PictureFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            double d2 = d * 200.0 - 100.0;
            propertySetHelper.setPropertyValue("AdjustContrast", new Short((short)d2));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getContrast() throws BasicErrorException {
        double d = 0.5;
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = PictureFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            int n = propertySetHelper.getPropertyValueAsInteger("AdjustContrast", 0);
            double d2 = n;
            d = (d2 + 100.0) / 200.0;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return d;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

