/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BordersImpl;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.DropCapImpl;
import com.sun.star.helper.writer.ParagraphFormatImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.StyleImpl;
import com.sun.star.helper.writer.StylesImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XDropCap;
import com.sun.star.helper.writer.XParagraph;
import com.sun.star.helper.writer.XParagraphFormat;
import com.sun.star.helper.writer.XRange;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.ParagraphAdjust;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;

public class ParagraphImpl
extends HelperInterfaceAdaptor
implements XParagraph,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Paragraph";
    XTextRange xParagraphRange = null;
    private int paraIndex;
    private static final int HALF_INCH_IN_SO_FORMAT = 1270;
    RangeImpl cacheRange;
    static /* synthetic */ Class class$com$sun$star$text$XParagraphCursor;
    static /* synthetic */ Class class$com$sun$star$container$XEnumerationAccess;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$java$lang$Integer;

    public ParagraphImpl(DocumentImpl documentImpl, XTextRange xTextRange, int n) {
        super(__serviceName, documentImpl);
        this.xParagraphRange = xTextRange;
        this.paraIndex = n;
    }

    private void initRange() throws BasicErrorException {
        if (this.cacheRange == null) {
            this.cacheRange = new RangeImpl((HelperInterfaceAdaptor)this, this.xParagraphRange, true);
        }
    }

    private void syncRange() throws BasicErrorException {
        this.initRange();
        this.cacheRange.StartOf(new Integer(4), Boolean.FALSE);
        this.cacheRange.EndOf(new Integer(4), Boolean.TRUE);
    }

    public XTextRange getXTextRange() {
        try {
            this.syncRange();
        }
        catch (BasicErrorException basicErrorException) {
            DebugHelper.warning((Exception)((Object)basicErrorException));
        }
        return this.xParagraphRange;
    }

    public void Indent() throws BasicErrorException {
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.xParagraphRange);
        int n = propertySetHelper.getPropertyValueAsInteger("ParaLeftMargin", 0);
        int n2 = n / 1270;
        propertySetHelper.setPropertyValue("ParaLeftMargin", new Integer(1270 * ++n2));
    }

    public XParagraph Next(Object object) throws BasicErrorException {
        int n = (int)OptionalParamUtility.getAnyNumber("Count", object, 1L, false);
        return ((XDocument)this.getParent()).getParagraphs().Item(this.paraIndex + n);
    }

    public XParagraph Previous(Object object) throws BasicErrorException {
        int n = (int)OptionalParamUtility.getAnyNumber("Count", object, 1L, false);
        return ((XDocument)this.getParent()).getParagraphs().Item(this.paraIndex - n);
    }

    public XRange Range() throws BasicErrorException {
        this.syncRange();
        XRange xRange = this.cacheRange.Duplicate();
        return xRange;
    }

    public XDropCap DropCap() throws BasicErrorException {
        return new DropCapImpl(this, this.xParagraphRange);
    }

    public XParagraphFormat Format() throws BasicErrorException {
        return new ParagraphFormatImpl(this);
    }

    public Object getStyle() throws BasicErrorException {
        String string = StylesImpl.getHelperStyleName((XDocument)this.getParent(), this);
        StyleImpl styleImpl = ((StylesImpl)((XDocument)this.getParent()).getStyles()).getStyleByName(string);
        styleImpl.setRange(this.xParagraphRange);
        return styleImpl;
    }

    public void setStyle(Object object) throws BasicErrorException {
        if (object instanceof StyleImpl) {
            ((StyleImpl)object).setRange(this.xParagraphRange);
        }
        StylesImpl.setHelperStyleAny((XDocument)this.getParent(), this, object);
    }

    public void Space15() throws BasicErrorException {
        this.Format().setLineSpacingRule(1);
    }

    public void Space2() throws BasicErrorException {
        this.Format().setLineSpacingRule(2);
    }

    public void setLineSpacing(float f) throws BasicErrorException {
        this.Format().setLineSpacing(f);
    }

    public float getLineSpacing() throws BasicErrorException {
        return this.Format().getLineSpacing();
    }

    public void setKeepTogether(boolean bl) throws BasicErrorException {
        this.Format().setKeepTogether(bl);
    }

    public boolean getKeepTogether() throws BasicErrorException {
        return this.Format().getKeepTogether();
    }

    public XBorders Borders() throws BasicErrorException {
        try {
            XParagraphCursor xParagraphCursor = (XParagraphCursor)OptionalParamUtility.getObject(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = ParagraphImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor, this.xParagraphRange);
            return new BordersImpl(this, xParagraphCursor);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
            return null;
        }
    }

    public void setHyphenation(boolean bl) throws BasicErrorException {
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.xParagraphRange);
        propertySetHelper.setPropertyValue("ParaIsHyphenation", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getHyphenation() throws BasicErrorException {
        boolean bl = false;
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.xParagraphRange);
        bl = propertySetHelper.getPropertyValueAsBoolean("ParaIsHyphenation", false);
        return bl;
    }

    public float getSpaceBefore() throws BasicErrorException {
        return this.getSpace("ParaTopMargin");
    }

    public float getSpaceAfter() throws BasicErrorException {
        return this.getSpace("ParaBottomMargin");
    }

    public void setSpaceBefore(float f) throws BasicErrorException {
        this.setSpace(f, "ParaTopMargin");
    }

    public void setSpaceAfter(float f) throws BasicErrorException {
        this.setSpace(f, "ParaBottomMargin");
    }

    private float getSpace(String string) throws BasicErrorException {
        int n = 9999999;
        try {
            Object object;
            XServiceInfo xServiceInfo;
            XParagraphCursor xParagraphCursor = (XParagraphCursor)OptionalParamUtility.getObject(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = ParagraphImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor, this.xParagraphRange);
            XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = ParagraphImpl.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess, xParagraphCursor);
            XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
            int n2 = -1;
            if (xEnumeration.hasMoreElements() && !(xServiceInfo = (XServiceInfo)OptionalParamUtility.getObject(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = ParagraphImpl.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, object = xEnumeration.nextElement())).supportsService("com.sun.star.text.TextTable")) {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ParagraphImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xServiceInfo);
                Integer n3 = (Integer)OptionalParamUtility.getObject(class$java$lang$Integer == null ? (class$java$lang$Integer = ParagraphImpl.class$("java.lang.Integer")) : class$java$lang$Integer, WriterUtilities.getProperty(xPropertySet, string));
                n2 = n3;
                n = (int)WriterUtilities.hundredthsMillimeterToPoints(n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (NoSuchElementException noSuchElementException) {
            DebugHelper.exception((Exception)((Object)noSuchElementException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        return n;
    }

    private void setSpace(float f, String string) throws BasicErrorException {
        try {
            Object object;
            XServiceInfo xServiceInfo;
            XParagraphCursor xParagraphCursor;
            XEnumerationAccess xEnumerationAccess;
            XEnumeration xEnumeration;
            if (f < 0.0f || f > 1584.0f) {
                DebugHelper.exception(9, "The measurement must be between 0pt and 1584");
            }
            if ((xEnumeration = (xEnumerationAccess = (XEnumerationAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = ParagraphImpl.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess, xParagraphCursor = (XParagraphCursor)OptionalParamUtility.getObject(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = ParagraphImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor, this.xParagraphRange))).createEnumeration()).hasMoreElements() && !(xServiceInfo = (XServiceInfo)OptionalParamUtility.getObject(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = ParagraphImpl.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, object = xEnumeration.nextElement())).supportsService("com.sun.star.text.TextTable")) {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ParagraphImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xServiceInfo);
                xPropertySet.setPropertyValue(string, (Object)new Integer(WriterUtilities.pointsToHundredthsMillimeter(f)));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.exception((Exception)((Object)propertyVetoException));
        }
        catch (NoSuchElementException noSuchElementException) {
            DebugHelper.exception((Exception)((Object)noSuchElementException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
    }

    public void setAlignment(int n) throws BasicErrorException {
        ParagraphAdjust paragraphAdjust = ParagraphFormatImpl.getStarOfficeAlignment(n);
        try {
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ParagraphImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.xParagraphRange);
            xPropertySet.setPropertyValue("ParaAdjust", (Object)paragraphAdjust);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.exception((Exception)((Object)propertyVetoException));
        }
    }

    public int getAlignment() throws BasicErrorException {
        int n = 0;
        try {
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ParagraphImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.xParagraphRange);
            Object object = xPropertySet.getPropertyValue("ParaAdjust");
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        return ParagraphFormatImpl.getMSWordAlignment(n);
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xParagraphRange;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

