/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.awt.Size;

public class PaperFormat {
    private static final int A3_WIDTH = 29700;
    private static final int A3_HEIGHT = 42000;
    private static final Size a_3 = new Size(29700, 42000);
    private static final int A4_WIDTH = 21000;
    private static final int A4_HEIGHT = 29700;
    private static final Size a_4 = new Size(21000, 29700);
    private static final int A5_WIDTH = 14800;
    private static final int A5_HEIGHT = 21000;
    private static final Size a_5 = new Size(14800, 21000);
    private static final int B4ISO_WIDTH = 25000;
    private static final int B4ISO_HEIGHT = 35300;
    private static final Size b_4_iso = new Size(25000, 35300);
    private static final int B5ISO_WIDTH = 17600;
    private static final int B5ISO_HEIGHT = 25000;
    private static final Size b_5_iso = new Size(17600, 25000);
    private static final int B6ISO_WIDTH = 12500;
    private static final int B6ISO_HEIGHT = 17600;
    private static final Size b_6_iso = new Size(12500, 17600);
    private static final int B4JIS_WIDTH = 25700;
    private static final int B4JIS_HEIGHT = 36400;
    private static final Size b_4_jis = new Size(25700, 36400);
    private static final int B5JIS_WIDTH = 18200;
    private static final int B5JIS_HEIGHT = 25700;
    private static final Size b_5_jis = new Size(18200, 25700);
    private static final int B6JIS_WIDTH = 12800;
    private static final int B6JIS_HEIGHT = 18200;
    private static final Size b_6_jis = new Size(12800, 18200);
    private static final int TABLOID_WIDTH = 27960;
    private static final int TABLOID_HEIGHT = 43130;
    private static final Size tabloid = new Size(27960, 43130);
    private static final int LETTER_WIDTH = 21590;
    private static final int LETTER_HEIGHT = 27940;
    private static final Size letter = new Size(21590, 27940);
    private static final int LEGAL_WIDTH = 21590;
    private static final int LEGAL_HEIGHT = 35570;
    private static final Size legal = new Size(21590, 35570);
    private static final int D1_WIDTH = 11000;
    private static final int D1_HEIGHT = 22000;
    private static final Size dl = new Size(11000, 22000);
    private static final int ENV_MONARCH_WIDTH = 98400;
    private static final int ENV_MONARCH_HEIGHT = 19050;
    private static final Size envMonarch = new Size(98400, 19050);
    private static final int ENV9_WIDTH = 98400;
    private static final int ENV9_HEIGHT = 22540;
    private static final Size env9 = new Size(98400, 22540);
    private static final int ENV10_WIDTH = 10480;
    private static final int ENV10_HEIGHT = 24130;
    private static final Size env10 = new Size(10480, 24130);
    private static final int ENV11_WIDTH = 11430;
    private static final int ENV11_HEIGHT = 26350;
    private static final Size env11 = new Size(11430, 26350);
    private static final int ENV12_WIDTH = 11430;
    private static final int ENV12_HEIGHT = 26350;
    private static final Size env12 = new Size(11430, 26350);
    private static final int C65_WIDTH = 11430;
    private static final int C65_HEIGHT = 22700;
    private static final Size c_65 = new Size(11430, 22700);
    private static final int C4_WIDTH = 22900;
    private static final int C4_HEIGHT = 32400;
    private static final Size c_4 = new Size(22900, 32400);
    private static final int C5_WIDTH = 16200;
    private static final int C5_HEIGHT = 22900;
    private static final Size c_5 = new Size(16200, 22900);
    private static final int C6_WIDTH = 11400;
    private static final int C6_HEIGHT = 16200;
    private static final Size c_6 = new Size(11400, 16200);
    private static final int SIZE_11X17_WIDTH = 11000;
    private static final int SIZE_11X17_HEIGHT = 17000;
    private static final Size size11x17 = new Size(11000, 17000);
    private static final int SIZE_10X14_WIDTH = 10000;
    private static final int SIZE_10X14_HEIGHT = 14000;
    private static final Size size10x14 = new Size(10000, 14000);
    private static final int MAX_DEVIATION = 4;

    public static Size getSizeForFormat(int n) {
        Size size = null;
        switch (n) {
            case 2: 
            case 20: {
                size = letter;
                break;
            }
            case 4: {
                size = legal;
                break;
            }
            case 7: 
            case 8: {
                size = a_4;
                break;
            }
            case 25: {
                size = env10;
                break;
            }
            case 0: {
                size = size10x14;
                break;
            }
            case 1: {
                size = size11x17;
                break;
            }
            case 6: {
                size = a_3;
                break;
            }
            case 9: {
                size = a_5;
                break;
            }
            case 10: {
                size = b_4_iso;
                break;
            }
            case 11: {
                size = b_5_iso;
                break;
            }
            case 23: {
                size = tabloid;
                break;
            }
            case 39: {
                size = envMonarch;
                break;
            }
            case 37: {
                size = dl;
                break;
            }
            case 24: {
                size = env9;
                break;
            }
            case 26: {
                size = env11;
                break;
            }
            case 27: {
                size = env12;
                break;
            }
            case 33: {
                size = c_4;
                break;
            }
            case 34: {
                size = c_5;
                break;
            }
            case 35: {
                size = c_6;
                break;
            }
            case 36: {
                size = c_65;
                break;
            }
            case 41: {
                size = letter;
                break;
            }
            default: {
                size = null;
            }
        }
        return size;
    }

    public static int getFormatForSize(Size size) {
        int n = 41;
        if (Math.abs(size.Height - PaperFormat.letter.Height) < 4 && Math.abs(size.Width - PaperFormat.letter.Width) < 4) {
            n = 2;
        } else if (Math.abs(size.Height - PaperFormat.legal.Height) < 4 && Math.abs(size.Width - PaperFormat.legal.Width) < 4) {
            n = 4;
        } else if (Math.abs(size.Height - PaperFormat.a_4.Height) < 4 && Math.abs(size.Width - PaperFormat.a_4.Width) < 4) {
            n = 7;
        } else if (Math.abs(size.Height - PaperFormat.env10.Height) < 4 && Math.abs(size.Width - PaperFormat.env10.Width) < 4) {
            n = 25;
        } else if (Math.abs(size.Height - PaperFormat.size10x14.Height) < 4 && Math.abs(size.Width - PaperFormat.size10x14.Width) < 4) {
            n = 0;
        } else if (Math.abs(size.Height - PaperFormat.size11x17.Height) < 4 && Math.abs(size.Width - PaperFormat.size11x17.Width) < 4) {
            n = 1;
        } else if (Math.abs(size.Height - PaperFormat.a_3.Height) < 4 && Math.abs(size.Width - PaperFormat.a_3.Width) < 4) {
            n = 6;
        } else if (Math.abs(size.Height - PaperFormat.a_5.Height) < 4 && Math.abs(size.Width - PaperFormat.a_5.Width) < 4) {
            n = 9;
        } else if (Math.abs(size.Height - PaperFormat.tabloid.Height) < 4 && Math.abs(size.Width - PaperFormat.tabloid.Width) < 4) {
            n = 23;
        } else if (Math.abs(size.Height - PaperFormat.envMonarch.Height) < 4 && Math.abs(size.Width - PaperFormat.envMonarch.Width) < 4) {
            n = 39;
        } else if (Math.abs(size.Height - PaperFormat.dl.Height) < 4 && Math.abs(size.Width - PaperFormat.dl.Width) < 4) {
            n = 37;
        } else if (Math.abs(size.Height - PaperFormat.env9.Height) < 4 && Math.abs(size.Width - PaperFormat.env9.Width) < 4) {
            n = 24;
        } else if (Math.abs(size.Height - PaperFormat.env11.Height) < 4 && Math.abs(size.Width - PaperFormat.env11.Width) < 4) {
            n = 26;
        } else if (Math.abs(size.Height - PaperFormat.env12.Height) < 4 && Math.abs(size.Width - PaperFormat.env12.Width) < 4) {
            n = 27;
        } else if (Math.abs(size.Height - PaperFormat.c_4.Height) < 4 && Math.abs(size.Width - PaperFormat.c_4.Width) < 4) {
            n = 33;
        } else if (Math.abs(size.Height - PaperFormat.c_5.Height) < 4 && Math.abs(size.Width - PaperFormat.c_5.Width) < 4) {
            n = 34;
        } else if (Math.abs(size.Height - PaperFormat.c_6.Height) < 4 && Math.abs(size.Width - PaperFormat.c_6.Width) < 4) {
            n = 35;
        } else if (Math.abs(size.Height - PaperFormat.c_65.Height) < 4 && Math.abs(size.Width - PaperFormat.c_65.Width) < 4) {
            n = 36;
        } else if (Math.abs(size.Height - PaperFormat.b_4_iso.Height) < 4 && Math.abs(size.Width - PaperFormat.b_4_iso.Width) < 4) {
            n = 10;
        } else if (Math.abs(size.Height - PaperFormat.b_5_iso.Height) < 4 && Math.abs(size.Width - PaperFormat.b_5_iso.Width) < 4) {
            n = 11;
        }
        return n;
    }
}

