/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.CalcFilename;
import com.sun.star.helper.common.DataSourceHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.DocumentUtilities;
import com.sun.star.helper.common.Filename;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.WriterFilename;
import com.sun.star.helper.writer.MailMergeDataFieldsImpl;
import com.sun.star.helper.writer.MailMergeImpl;
import com.sun.star.helper.writer.MailMergeParameter;
import com.sun.star.helper.writer.XMailMergeDataFields;
import com.sun.star.helper.writer.XMailMergeDataSource;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.sdbc.XStatement;
import com.sun.star.sdbcx.XTablesSupplier;
import com.sun.star.uno.Exception;
import java.io.File;

public class MailMergeDataSourceImpl
extends HelperInterfaceAdaptor
implements XMailMergeDataSource {
    protected static final String __serviceName = "com.sun.star.helper.writer.MailMergeDataSource";
    private DataSourceHelper dataSource;
    private String sFileName = null;
    public static final int UNDEFINED_DATA_SOURCE = -1;
    public static final int DOCUMENT_DATA_SOURCE = 0;
    public static final int TABLE_DATA_SOURCE = 1;
    public static final int DATABASE_DATA_SOURCE = 2;
    public static final int TEXT_DATA_SOURCE = 3;
    public static final int APPENDIX_LENGTH = 3;
    protected static final String[] DATA_SOURCE_PREFIX = new String[]{"sdbc:calc", "sdbc:calc", "sdbc:text", "sdbc:odbc"};
    private MailMergeParameter mailMergeParam;
    private int iDataSourceType;
    private String[] databaseProps;
    static /* synthetic */ Class class$com$sun$star$sdbc$XRow;
    static /* synthetic */ Class class$com$sun$star$sdbcx$XTablesSupplier;

    public MailMergeDataSourceImpl(MailMergeImpl mailMergeImpl) {
        super(__serviceName, mailMergeImpl);
        this.mailMergeParam = null;
        this.databaseProps = null;
        this.iDataSourceType = -1;
    }

    public MailMergeDataSourceImpl(MailMergeImpl mailMergeImpl, MailMergeParameter mailMergeParameter) throws BasicErrorException {
        super(__serviceName, mailMergeImpl);
        this.mailMergeParam = mailMergeParameter;
        this.createDataSource();
        this.openDataSource();
    }

    public XMailMergeDataFields DataFields() throws BasicErrorException {
        return new MailMergeDataFieldsImpl(this);
    }

    public String Name() throws BasicErrorException {
        if (this.mailMergeParam == null || this.mailMergeParam.getName() == null) {
            return "";
        }
        return this.mailMergeParam.getName();
    }

    public void setFirstRecord(int n) throws BasicErrorException {
        DebugHelper.exception(51, "not yet implemented");
    }

    public int getFirstRecord() throws BasicErrorException {
        return 1;
    }

    public int getLastRecord() throws BasicErrorException {
        int n = 1;
        try {
            XResultSet xResultSet = this.executeQuery("select count(*) from $table;");
            xResultSet.next();
            XRow xRow = (XRow)OptionalParamUtility.getObject(class$com$sun$star$sdbc$XRow == null ? (class$com$sun$star$sdbc$XRow = MailMergeDataSourceImpl.class$("com.sun.star.sdbc.XRow")) : class$com$sun$star$sdbc$XRow, xResultSet);
            n = xRow.getInt(1);
        }
        catch (SQLException sQLException) {
            DebugHelper.exception((Exception)((Object)sQLException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public void setLastRecord(int n) throws BasicErrorException {
        DebugHelper.exception(51, "not yet implemented");
    }

    public void Close() throws BasicErrorException {
        this.mailMergeParam = null;
        this.dataSource = null;
    }

    public String[] getDatabaseProperties() {
        return this.databaseProps;
    }

    private int getCommandType() {
        int n = 2;
        if (this.iDataSourceType == 1 || this.iDataSourceType == 0) {
            n = 0;
        }
        return n;
    }

    protected XResultSet executeQuery(String string) throws BasicErrorException {
        XResultSet xResultSet = null;
        try {
            XConnection xConnection = this.dataSource.getConnection();
            String string2 = this.getTableName();
            string = string.replaceAll("\\$table", string2);
            XStatement xStatement = xConnection.createStatement();
            xResultSet = xStatement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            DebugHelper.exception((Exception)((Object)sQLException));
        }
        return xResultSet;
    }

    private void createDataSource() throws BasicErrorException {
        String string;
        String string2 = this.mailMergeParam.getName();
        int n = string2.lastIndexOf(46);
        this.iDataSourceType = 2;
        if (n != -1 && n != string2.length() - 1 && (string = string2.substring(n + 1)).length() == 3) {
            if (string.equalsIgnoreCase("doc") || string.equalsIgnoreCase("odt") || string.equalsIgnoreCase("sxw")) {
                this.iDataSourceType = 0;
            } else if (string.equalsIgnoreCase("xls") || string.equalsIgnoreCase("ods") || string.equalsIgnoreCase("sxc")) {
                this.iDataSourceType = 1;
            } else if (string.equalsIgnoreCase("csv") || string.equalsIgnoreCase("txt")) {
                this.iDataSourceType = 3;
            } else {
                DebugHelper.warning(new Exception("Cannot determine the data source type for file type " + string + "; try to open as text file"));
                this.iDataSourceType = 3;
            }
        }
        switch (this.iDataSourceType) {
            case 2: {
                this.createODBCDataSource();
                break;
            }
            case 0: {
                this.createDocumentDataSource();
                break;
            }
            case 1: {
                this.createTableDataSource();
                break;
            }
            default: {
                this.createTextDataSource();
            }
        }
    }

    private void createDocumentDataSource() throws BasicErrorException {
        String string = this.mailMergeParam.getName();
        WriterFilename writerFilename = new WriterFilename(string);
        if (!writerFilename.checkExistanceForRead()) {
            DebugHelper.exception(53, string);
        }
        XModel xModel = DocumentUtilities.openDocument(string, true, null);
        DispatchCommand.execute(".uno:SelectAll", xModel.getCurrentController().getFrame());
        DispatchCommand.execute(".uno:SelectAll", xModel.getCurrentController().getFrame());
        DispatchCommand.execute(".uno:Copy", xModel.getCurrentController().getFrame());
        DocumentUtilities.closeDocument(xModel, 0, 1);
        XModel xModel2 = null;
        xModel2 = DocumentUtilities.openDocument("private:factory/scalc", false, null);
        DispatchCommand.execute(".uno:Paste", xModel2.getCurrentController().getFrame());
        try {
            this.sFileName = Filename.getUniqueFileName("TempDataSource", CalcFilename.getCalcFileSuffix());
            DocumentUtilities.saveDocumentAs(xModel2, HelperUtilities.getURLForFileName(this.sFileName));
        }
        catch (IOException iOException) {
            DebugHelper.exception((Exception)((Object)iOException));
        }
        DocumentUtilities.closeDocument(xModel2, 0, 1);
        this.dataSource = new DataSourceHelper();
        this.dataSource.registerSpreadSheetDB(this.mailMergeParam.getName(), HelperUtilities.getURLForFileName(this.sFileName), DATA_SOURCE_PREFIX[0], null);
    }

    private void createTableDataSource() throws BasicErrorException {
        this.dataSource = new DataSourceHelper();
        this.sFileName = this.getSystemFileName(this.mailMergeParam.getName());
        this.dataSource.registerSpreadSheetDB(this.mailMergeParam.getName(), HelperUtilities.getURLForFileName(this.sFileName), DATA_SOURCE_PREFIX[1], this.mailMergeParam.getPasswordDocument());
    }

    private void createODBCDataSource() throws BasicErrorException {
        DebugHelper.exception(51, "not yet implemented");
    }

    private void createTextDataSource() throws BasicErrorException {
        DebugHelper.exception(51, "not yet implemented");
    }

    private void openDataSource() throws BasicErrorException {
        Object object;
        XConnection xConnection = null;
        MailMergeImpl mailMergeImpl = null;
        try {
            mailMergeImpl = (MailMergeImpl)this.getParent();
        }
        catch (ClassCastException classCastException) {
            DebugHelper.writeInfo(classCastException.getMessage());
        }
        try {
            xConnection = this.dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            DebugHelper.exception((Exception)((Object)sQLException));
        }
        if (mailMergeImpl == null) {
            DebugHelper.exception(51, "parent is null");
        }
        if (mailMergeImpl.getSuppressBlankLines()) {
            object = (MailMergeDataFieldsImpl)this.DataFields();
            StringBuffer stringBuffer = new StringBuffer(((MailMergeDataFieldsImpl)object).getFieldNameFromIndex(1));
            int n = 2;
            while (n <= ((MailMergeDataFieldsImpl)object).Count()) {
                stringBuffer.append(",").append(((MailMergeDataFieldsImpl)object).getFieldNameFromIndex(n));
                ++n;
            }
            XResultSet xResultSet = this.executeQuery("select * from $table group by " + stringBuffer);
            mailMergeImpl.setMailMergeProperty("ResultSet", xResultSet);
        } else {
            mailMergeImpl.setMailMergeProperty("ActiveConnection", xConnection);
        }
        mailMergeImpl.setMailMergeProperty("DataSourceName", this.Name());
        mailMergeImpl.setMailMergeProperty("CommandType", new Integer(this.getCommandType()));
        object = this.getTableName();
        DebugHelper.writeDebug("Command: " + (String)object);
        if (this.iDataSourceType != 0 && this.iDataSourceType != 1) {
            object = this.mailMergeParam.getConnection();
        }
        mailMergeImpl.setMailMergeProperty("Command", object);
        this.databaseProps = new String[]{this.Name(), object};
    }

    private String getSystemFileName(String string) throws BasicErrorException {
        String string2 = null;
        File file = new File(string);
        if (file.exists()) {
            string2 = file.getAbsolutePath();
        } else {
            string2 = System.getProperty("user.dir") + Filename.getGlobalFileSeparator() + string;
            file = new File(string2);
            if (!file.exists()) {
                int n = string.lastIndexOf(46);
                string2 = n != -1 ? string.substring(0, n) : string;
                string2 = string2 + CalcFilename.getCalcFileSuffix();
                file = new File(string2);
                if (!file.exists() && !(file = new File(string2 = System.getProperty("user.dir") + Filename.getGlobalFileSeparator() + string2)).exists()) {
                    DebugHelper.exception(53, string);
                }
            }
        }
        return string2;
    }

    private String getTableName() throws BasicErrorException {
        String string;
        block4: {
            string = null;
            try {
                XConnection xConnection = this.dataSource.getConnection();
                XTablesSupplier xTablesSupplier = (XTablesSupplier)OptionalParamUtility.getObject(class$com$sun$star$sdbcx$XTablesSupplier == null ? (class$com$sun$star$sdbcx$XTablesSupplier = MailMergeDataSourceImpl.class$("com.sun.star.sdbcx.XTablesSupplier")) : class$com$sun$star$sdbcx$XTablesSupplier, xConnection);
                XNameAccess xNameAccess = xTablesSupplier.getTables();
                String[] stringArray = xNameAccess.getElementNames();
                if (stringArray != null && stringArray.length != 0) {
                    string = stringArray.length == 1 ? stringArray[0] : this.mailMergeParam.getConnection();
                    if (string != null) break block4;
                    DebugHelper.exception(51, "cannot get table from data source.");
                    break block4;
                }
                DebugHelper.exception(51, "cannot get table from data source.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
            catch (SQLException sQLException) {
                DebugHelper.exception((Exception)((Object)sQLException));
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

