/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.PresetPropertiesForListTemplates;
import com.sun.star.helper.writer.ListLevelsImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XListLevel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;
import java.util.regex.PatternSyntaxException;

public class ListLevelImpl
extends HelperInterfaceAdaptor
implements XListLevel {
    private static final String __ServiceName = "com.sun.star.helper.writer.ListLevel";
    private int iListLevel;
    private PresetPropertiesForListTemplates pplt;

    public ListLevelImpl(ListLevelsImpl listLevelsImpl, int n, PresetPropertiesForListTemplates presetPropertiesForListTemplates) throws BasicErrorException {
        super(__ServiceName, listLevelsImpl);
        if (n < 1 || n > presetPropertiesForListTemplates.getTemplatesCount()) {
            DebugHelper.exception(51, "Level");
        }
        this.iListLevel = n - 1;
        this.pplt = presetPropertiesForListTemplates;
    }

    public void setNumberStyle(int n) throws BasicErrorException {
        int n2 = 0;
        switch (n) {
            case 3: {
                n2 = 9;
                break;
            }
            case 4: {
                n2 = 10;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 0: {
                n2 = 4;
                break;
            }
            case 255: {
                n2 = 5;
                break;
            }
            case 14: {
                n2 = 13;
                break;
            }
            case 18: {
                n2 = 14;
                break;
            }
            case 6: {
                n2 = 31;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 4;
                break;
            }
            default: {
                DebugHelper.exception(73, "number style conversion");
            }
        }
        this.pplt.setPropertyValueWithNameAndLevel(new Short((short)n2), this.iListLevel, 0);
    }

    public int getNumberStyle() throws BasicErrorException {
        Object object = this.pplt.getPropertyValueWithNameAndLevel(this.iListLevel, 0);
        int n = 0;
        try {
            int n2 = NumericalHelper.toInt(object);
            switch (n2) {
                case 0: {
                    n = 3;
                    break;
                }
                case 1: {
                    n = 4;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 0;
                    break;
                }
                case 5: {
                    n = 255;
                    break;
                }
                case 13: {
                    n = 14;
                    break;
                }
                case 14: {
                    n = 18;
                    break;
                }
                case 31: {
                    n = 6;
                    break;
                }
                default: {
                    DebugHelper.exception(73, "number style conversion");
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public void setNumberPosition(double d) throws BasicErrorException {
        int n = WriterUtilities.pointsToHundredthsMillimeter(d);
        this.pplt.setPosition(n, this.iListLevel, 0);
    }

    public double getNumberPosition() throws BasicErrorException {
        int n = this.pplt.getPosition(this.iListLevel, 0);
        return Math.round(WriterUtilities.hundredthsMillimeterToPoints(n));
    }

    public void setTabPosition(double d) throws BasicErrorException {
        int n = WriterUtilities.pointsToHundredthsMillimeter(d);
        this.pplt.setPosition(n, this.iListLevel, 2);
    }

    public double getTabPosition() throws BasicErrorException {
        int n = this.pplt.getPosition(this.iListLevel, 2);
        return Math.round(WriterUtilities.hundredthsMillimeterToPoints(n));
    }

    public void setTextPosition(double d) throws BasicErrorException {
        int n = WriterUtilities.pointsToHundredthsMillimeter(d);
        this.pplt.setPosition(n, this.iListLevel, 1);
    }

    public double getTextPosition() throws BasicErrorException {
        int n = this.pplt.getPosition(this.iListLevel, 1);
        return Math.round(WriterUtilities.hundredthsMillimeterToPoints(n));
    }

    public void setTrailingCharacter(int n) throws BasicErrorException {
        this.pplt.setPosition(n, this.iListLevel, 3);
    }

    public int getTrailingCharacter() throws BasicErrorException {
        return this.pplt.getPosition(this.iListLevel, 3);
    }

    public String getNumberFormat() throws BasicErrorException {
        StringBuffer stringBuffer = new StringBuffer();
        Short s = (Short)this.pplt.getPropertyValueWithNameAndLevel(this.iListLevel, 3);
        if (this.iListLevel + 1 != s.intValue()) {
            stringBuffer.append(s);
        }
        stringBuffer.append(this.pplt.getPropertyValueWithNameAndLevel(this.iListLevel, 2));
        stringBuffer.append("%").append(this.iListLevel + 1);
        stringBuffer.append(this.pplt.getPropertyValueWithNameAndLevel(this.iListLevel, 1));
        return stringBuffer.toString();
    }

    public void setNumberFormat(String string) throws BasicErrorException {
        String string2 = "%[1-9]";
        String[] stringArray = null;
        try {
            stringArray = string.split(string2, 3);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            DebugHelper.exception(51, patternSyntaxException.getMessage());
        }
        String string3 = null;
        String string4 = null;
        short s = -1;
        int n = -1;
        int n2 = stringArray.length;
        switch (n2) {
            case 1: {
                DebugHelper.exception(73, "");
                break;
            }
            case 2: {
                int n3 = stringArray[0].length();
                string3 = n3 == 0 ? null : stringArray[0];
                string4 = stringArray[1];
                n = (short)(string.charAt(n3 + 1) - 48);
                if (n == this.iListLevel + 1) break;
                DebugHelper.exception(73, "");
                break;
            }
            case 3: {
                if (stringArray[0].length() != 0) {
                    DebugHelper.exception(73, "");
                    break;
                }
                int n4 = 0;
                int n5 = stringArray[1].length() + 2;
                string3 = n5 == 2 ? null : stringArray[1];
                string4 = stringArray[2].length() == 0 ? null : stringArray[2];
                n = (short)(string.charAt(n5 + 1) - 48);
                s = (short)(string.charAt(n4 + 1) - 48);
                if (n == this.iListLevel + 1) break;
                DebugHelper.exception(73, "");
                break;
            }
            default: {
                DebugHelper.exception(73, "");
            }
        }
        if (string3 != null) {
            this.pplt.setPropertyValueWithNameAndLevel(string3, this.iListLevel, 2);
        }
        if (string4 != null) {
            this.pplt.setPropertyValueWithNameAndLevel(string4, this.iListLevel, 1);
        }
        if (s != -1) {
            this.pplt.setPropertyValueWithNameAndLevel(new Short(s), this.iListLevel, 3);
        }
    }

    public int getStartAt() throws BasicErrorException {
        Object object = this.pplt.getPropertyValueWithNameAndLevel(this.iListLevel, 6);
        int n = 0;
        try {
            n = NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public void setStartAt(int n) throws BasicErrorException {
        this.pplt.setPropertyValueWithNameAndLevel(new Short((short)n), this.iListLevel, 6);
    }
}

