/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.common.DebugHelper;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.BorderLine;

public class LineDefinitionHelper {
    public static final int MSOFFICE = 0;
    public static final int SOFFICE = 1;
    public static final int LINEWIDTH025PT = 25;
    public static final int LINEWIDTH050PT = 50;
    public static final int LINEWIDTH075PT = 75;
    public static final int LINEWIDTH100PT = 100;
    public static final int LINEWIDTH150PT = 150;
    public static final int LINEWIDTH225PT = 225;
    public static final int LINEWIDTH300PT = 300;
    public static final int LINEWIDTH450PT = 450;
    public static final int LINEWIDTH600PT = 600;
    protected static final int[][] LINE_WIDTH_DEPENDENCE = new int[][]{{2, 25}, {4, 50}, {6, 75}, {8, 100}, {12, 150}, {18, 225}, {24, 300}, {36, 450}, {48, 600}};
    public static final short NONE = 0;
    public static final boolean BORDER_INLINE = true;
    public static final boolean BORDER_OUTLINE = false;
    public static final short THIN_LINE = (short)LINE_WIDTH_DEPENDENCE[0][1];
    public static final short THICK_LINE = (short)LINE_WIDTH_DEPENDENCE[LINE_WIDTH_DEPENDENCE.length - 1][1];
    public static final short THIN_GAP = 150;
    public static final short MEDIUM_GAP = 300;
    public static final short THICK_GAP = 450;
    public static final short BINARY_THIN_INNER_LINE = 1;
    public static final short BINARY_THICK_INNER_LINE = 2;
    public static final short BINARY_THIN_OUTER_LINE = 4;
    public static final short BINARY_THICK_OUTER_LINE = 8;
    public static final short BINARY_SMALL_GAP = 16;
    public static final short BINARY_MEDIUM_GAP = 32;
    public static final short BINARY_LARGE_GAP = 64;
    public static final short THIN_THICK_SMALL_GAP = 25;
    public static final short THICK_THIN_SMALL_GAP = 22;
    public static final short THIN_THICK_MEDIUM_GAP = 41;
    public static final short THICK_THIN_MEDIUM_GAP = 38;
    public static final short THIN_THICK_LARGE_GAP = 73;
    public static final short THICK_THIN_LARGE_GAP = 70;

    public static int getLineStyleFromBorderLine(BorderLine borderLine) {
        short s = borderLine.InnerLineWidth;
        short s2 = borderLine.OuterLineWidth;
        short s3 = borderLine.LineDistance;
        int n = 0;
        if (s2 != 0) {
            if (s == 0) {
                n = 1;
            } else {
                int n2 = s >= THICK_LINE ? 2 : 1;
                int n3 = s2 >= THICK_LINE ? 8 : 4;
                int n4 = 32;
                if (s3 >= 450) {
                    n4 = 64;
                } else if (s3 < 300) {
                    n4 = 16;
                }
                int n5 = n2 | n3 | n4;
                switch (n5) {
                    case 22: {
                        n = 10;
                        break;
                    }
                    case 38: {
                        n = 13;
                        break;
                    }
                    case 70: {
                        n = 16;
                        break;
                    }
                    case 25: {
                        n = 9;
                        break;
                    }
                    case 41: {
                        n = 12;
                        break;
                    }
                    case 73: {
                        n = 15;
                        break;
                    }
                    default: {
                        n = 7;
                    }
                }
            }
        }
        return n;
    }

    public static BorderLine getBorderLineFromLineStyle(int n, int n2) throws BasicErrorException {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        switch (n) {
            case 0: {
                n3 = 0;
                n4 = 0;
                n5 = 0;
                break;
            }
            case 1: {
                n3 = 0;
                n4 = THIN_LINE;
                n5 = 0;
                break;
            }
            case 7: {
                n3 = THIN_LINE;
                n4 = THIN_LINE;
                n5 = 150;
                break;
            }
            case 9: {
                n3 = THIN_LINE;
                n4 = THICK_LINE;
                n5 = 150;
                break;
            }
            case 10: {
                n3 = THICK_LINE;
                n4 = THIN_LINE;
                n5 = 150;
                break;
            }
            case 12: {
                n3 = THIN_LINE;
                n4 = THICK_LINE;
                n5 = 300;
                break;
            }
            case 13: {
                n3 = THICK_LINE;
                n4 = THIN_LINE;
                n5 = 300;
                break;
            }
            case 15: {
                n3 = THIN_LINE;
                n4 = THICK_LINE;
                n5 = 450;
                break;
            }
            case 16: {
                n3 = THICK_LINE;
                n4 = THIN_LINE;
                n5 = 450;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl = true;
                break;
            }
            default: {
                DebugHelper.exception(969, "This line style is invalid.");
            }
        }
        if (bl) {
            DebugHelper.exception(51, "The desired line style is not supported.");
        }
        BorderLine borderLine = new BorderLine();
        borderLine.Color = n2;
        borderLine.InnerLineWidth = (short)n3;
        borderLine.OuterLineWidth = (short)n4;
        borderLine.LineDistance = (short)n5;
        return borderLine;
    }

    public static int getLineWidthFromBorder(BorderLine borderLine) {
        int n = 0;
        if (borderLine.InnerLineWidth != 0) {
            n = 9999999;
        } else {
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            while (n2 != 0 && n3 < LINE_WIDTH_DEPENDENCE.length) {
                int n4 = Math.abs(borderLine.OuterLineWidth - LINE_WIDTH_DEPENDENCE[n3][1]);
                if (n2 > n4) {
                    n2 = n4;
                    n = LINE_WIDTH_DEPENDENCE[n3][0];
                }
                ++n3;
            }
        }
        return n;
    }

    public static BorderLine getBorderLineFromLineWidth(int n, BorderLine borderLine) throws BasicErrorException {
        int n2 = -1;
        boolean bl = false;
        if (n == 9999999) {
            borderLine.OuterLineWidth = THIN_LINE;
            bl = true;
        } else {
            int n3 = 0;
            while (!bl && n3 < LINE_WIDTH_DEPENDENCE.length) {
                if (n == LINE_WIDTH_DEPENDENCE[n3][0]) {
                    bl = true;
                    borderLine.OuterLineWidth = (short)LINE_WIDTH_DEPENDENCE[n3][1];
                }
                ++n3;
            }
        }
        if (!bl) {
            DebugHelper.exception(969, "Illegal line width.");
        }
        return borderLine;
    }
}

