/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.awt.FontSlant;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.calc.CalcHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.MSO2SOIntMapping;
import com.sun.star.helper.common.UNOUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.ColorTableHelper;
import com.sun.star.helper.writer.StyleImpl;
import com.sun.star.helper.writer.XFont;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;

public class FontImpl
extends HelperInterfaceAdaptor
implements XFont,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Font";
    private static final int[][] arrayUnderlineMapping = new int[][]{{0, 0}, {1, 1}, {2, 1}, {3, 2}, {4, 3}, {6, 14}, {7, 5}, {9, 7}, {10, 8}, {11, 10}, {20, 13}, {23, 14}, {25, 16}, {26, 17}, {27, 18}, {39, 6}, {43, 11}, {55, 15}};
    public static final MSO2SOIntMapping UnderlineMapping = new MSO2SOIntMapping(arrayUnderlineMapping);
    static /* synthetic */ Class class$com$sun$star$awt$FontSlant;

    public FontImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
    }

    public void setFontProperties(XFont xFont) throws BasicErrorException {
        if (xFont instanceof FontImpl) {
            HelperUtilities.copyPropertiesByPrefix("Char", ((FontImpl)xFont).getFontObject(), this.getFontObject());
        }
    }

    protected Object getFontObject() throws BasicErrorException {
        HelperInterfaceAdaptor helperInterfaceAdaptor = this.getParentAdaptor();
        if (helperInterfaceAdaptor instanceof StyleImpl) {
            XUnoAccess xUnoAccess = (XUnoAccess)((Object)helperInterfaceAdaptor);
            return xUnoAccess.getUnoObject();
        }
        return helperInterfaceAdaptor.getXTextRange();
    }

    protected int getBgColor() throws BasicErrorException {
        return (int)HelperUtilities.getLongProperty(this.getFontObject(), "CharBackColor");
    }

    protected void setBgColor(int n) throws BasicErrorException {
        HelperUtilities.setLongProperty(this.getFontObject(), "CharBackColor", n);
    }

    public int getBold() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharWeight");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        float f = HelperUtilities.getFloatValue(object, false, 0.0f);
        return f > 100.0f ? -1 : 0;
    }

    public void setBold(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getBold());
        }
        HelperUtilities.setFloatProperty(this.getFontObject(), "CharWeight", n == -1 ? 150.0f : 100.0f);
    }

    public int getColor() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharColor");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        int n = HelperUtilities.getIntegerValue(object, false, -1);
        if (n == -1) {
            return 9999999;
        }
        n = CalcHelper.swapFirstAndThirdByte(n);
        return n;
    }

    public void setColor(int n) throws BasicErrorException {
        HelperUtilities.setIntegerProperty(this.getFontObject(), "CharColor", CalcHelper.swapFirstAndThirdByte(n));
    }

    public void setAllCaps(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getAllCaps());
        }
        try {
            HelperUtilities.setShortProperty(this.getFontObject(), "CharCaseMap", n == -1 ? (short)1 : 0);
        }
        catch (Exception exception) {
            DebugHelper.writeInfo(exception.getMessage());
        }
    }

    public int getAllCaps() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharCaseMap");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        short s = 0;
        try {
            s = AnyConverter.toShort((Object)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.writeInfo(illegalArgumentException.getMessage());
        }
        return s == 1 ? -1 : 0;
    }

    public void setSmallCaps(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getSmallCaps());
        }
        try {
            HelperUtilities.setShortProperty(this.getFontObject(), "CharCaseMap", n == -1 ? (short)4 : 0);
        }
        catch (Exception exception) {
            DebugHelper.writeInfo(exception.getMessage());
        }
    }

    public int getSmallCaps() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharCaseMap");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        short s = 0;
        try {
            s = AnyConverter.toShort((Object)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.writeInfo(illegalArgumentException.getMessage());
        }
        return s == 4 ? -1 : 0;
    }

    public void setHidden(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getHidden());
        }
        try {
            HelperUtilities.setBooleanProperty(this.getFontObject(), "CharHidden", n == -1);
        }
        catch (Exception exception) {
            DebugHelper.writeInfo(exception.getMessage());
        }
    }

    public int getHidden() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharHidden");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        boolean bl = false;
        try {
            bl = AnyConverter.toBoolean((Object)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.writeInfo(illegalArgumentException.getMessage());
        }
        return bl ? -1 : 0;
    }

    public void setOutline(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getOutline());
        }
        try {
            HelperUtilities.setBooleanProperty(this.getFontObject(), "CharContoured", n == -1);
        }
        catch (Exception exception) {
            DebugHelper.writeInfo(exception.getMessage());
        }
    }

    public int getOutline() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharContoured");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        boolean bl = false;
        try {
            bl = AnyConverter.toBoolean((Object)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.writeInfo(illegalArgumentException.getMessage());
        }
        return bl ? -1 : 0;
    }

    public void setAnimation(int n) throws BasicErrorException {
        switch (n) {
            case 0: {
                try {
                    HelperUtilities.setBooleanProperty(this.getFontObject(), "CharFlash", Boolean.FALSE);
                }
                catch (Exception exception) {
                    DebugHelper.writeInfo(exception.getMessage());
                }
                break;
            }
            default: {
                if (n != 2) {
                    DebugHelper.writeInfo("WdAnimation type is unsupported and defaulted to wdAnimationBlinkingBackground");
                }
                try {
                    HelperUtilities.setBooleanProperty(this.getFontObject(), "CharFlash", Boolean.TRUE);
                }
                catch (Exception exception) {
                    DebugHelper.writeInfo(exception.getMessage());
                }
                break;
            }
        }
    }

    public int getAnimation() throws BasicErrorException {
        boolean bl = false;
        try {
            bl = HelperUtilities.getBooleanProperty(this.getFontObject(), "CharFlash");
        }
        catch (Exception exception) {
            DebugHelper.writeInfo(exception.getMessage());
        }
        return bl ? 2 : 0;
    }

    public void setColorIndex(int n) throws BasicErrorException {
        try {
            int n2 = ColorTableHelper.getColorForIndex(n);
            this.setColor(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception(5, "");
        }
    }

    public int getColorIndex() throws BasicErrorException {
        int n = this.getColor();
        int n2 = ColorTableHelper.getIndexFromColor(n);
        return n2;
    }

    private short getStrikeThroughType(short s) {
        switch (s) {
            case 1: 
            case 5: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: {
                return 2;
            }
        }
        return 0;
    }

    public int getDoubleStrikeThrough() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharStrikeout");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        short s = this.getStrikeThroughType(HelperUtilities.getShortValue(object, false, (short)3));
        if (s == 3) {
            return 9999999;
        }
        return s == 2 ? -1 : 0;
    }

    public void setDoubleStrikeThrough(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getStrikeThrough());
        }
        HelperUtilities.setShortProperty(this.getFontObject(), "CharStrikeout", n == -1 ? (short)2 : 0);
    }

    public int getItalic() throws BasicErrorException {
        int n = 0;
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharPosture");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        try {
            FontSlant fontSlant = (FontSlant)AnyConverter.toObject((Class)(class$com$sun$star$awt$FontSlant == null ? (class$com$sun$star$awt$FontSlant = FontImpl.class$("com.sun.star.awt.FontSlant")) : class$com$sun$star$awt$FontSlant), (Object)object);
            n = FontSlant.NONE.equals(fontSlant) ? 0 : -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public void setItalic(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getItalic());
        }
        HelperUtilities.setShortProperty(this.getFontObject(), "CharPosture", (short)(n == -1 ? 2 : 0));
    }

    public int getKerning() throws BasicErrorException {
        UNOUtility.printPropertyNames(this.getFontObject(), DebugHelper.getPrintStream());
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharKerning");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 0;
        }
        return HelperUtilities.getShortValue(object, false, (short)0);
    }

    public void setKerning(int n) throws BasicErrorException {
        HelperUtilities.setShortProperty(this.getFontObject(), "CharKerning", (short)n);
        if (n >= 0) {
            HelperUtilities.setBooleanProperty(this.getFontObject(), "CharAutoKerning", true);
        }
    }

    public String getName() throws BasicErrorException {
        return HelperUtilities.getStringProperty(this.getFontObject(), "CharFontName");
    }

    public void setName(String string) throws BasicErrorException {
        HelperUtilities.setStringProperty(this.getFontObject(), "CharFontName", string);
    }

    public int getPosition() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharEscapement");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 0;
        }
        short s = HelperUtilities.getShortValue(object, false, (short)0);
        int n = this.getSize();
        return n * s / 100;
    }

    public void setPosition(int n) throws BasicErrorException {
        int n2 = this.getSize();
        HelperUtilities.setShortProperty(this.getFontObject(), "CharEscapement", (short)(n * 100 / n2));
    }

    public int getShadow() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharShadowed");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 0;
        }
        return HelperUtilities.getBooleanValue(object, false, false) ? -1 : 0;
    }

    public void setShadow(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getShadow());
        }
        HelperUtilities.setBooleanProperty(this.getFontObject(), "CharShadowed", n == -1);
    }

    public int getSize() throws BasicErrorException {
        return (int)HelperUtilities.getFloatProperty(this.getFontObject(), "CharHeight");
    }

    public void setSize(int n) throws BasicErrorException {
        int n2 = this.getPosition();
        HelperUtilities.setFloatProperty(this.getFontObject(), "CharHeight", n);
        if (n2 != 0) {
            this.setPosition(n2);
        }
        this.getKerning();
    }

    public int getStrikeThrough() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharStrikeout");
        if (HelperUtilities.isPropertyVoid(object)) {
            return 9999999;
        }
        short s = this.getStrikeThroughType(HelperUtilities.getShortValue(object, false, (short)0));
        if (s == 3) {
            return 9999999;
        }
        return s == 1 ? -1 : 0;
    }

    public void setStrikeThrough(int n) throws BasicErrorException {
        if (n == 9999998) {
            n = HelperUtilities.getToggleValue(this.getStrikeThrough());
        }
        HelperUtilities.setShortProperty(this.getFontObject(), "CharStrikeout", n == -1 ? (short)1 : 0);
    }

    public int getUnderline() throws BasicErrorException {
        short s = HelperUtilities.getShortProperty(this.getFontObject(), "CharUnderline");
        return UnderlineMapping.getMSOFromSO(s);
    }

    public void setUnderline(int n) throws BasicErrorException {
        short s = (short)UnderlineMapping.getSOFromMSO(n);
        HelperUtilities.setShortProperty(this.getFontObject(), "CharUnderline", s);
    }

    public int getUnderlineColor() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharUnderlineColor");
        int n = HelperUtilities.getIntegerValue(object, false, 0);
        if (n == -1) {
            return 9999999;
        }
        return n;
    }

    public void setUnderlineColor(int n) throws BasicErrorException {
        if (n == 9999999) {
            n = -1;
        }
        HelperUtilities.setIntegerProperty(this.getFontObject(), "CharUnderlineColor", n);
        if (n >= 0) {
            HelperUtilities.setBooleanProperty(this.getFontObject(), "CharUnderlineHasColor", true);
        }
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.getFontObject();
    }

    public boolean getSuperscript() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharEscapement");
        if (HelperUtilities.isPropertyVoid(object)) {
            DebugHelper.writeInfo("Can't get CharEscapement from Font object.");
            return false;
        }
        short s = HelperUtilities.getShortValue(object, false, (short)0);
        return s != 0;
    }

    public void setSuperscript(boolean bl) throws BasicErrorException {
        short s = 0;
        int n = 0;
        if (bl) {
            s = 30;
            n = 80;
        }
        HelperUtilities.setShortProperty(this.getFontObject(), "CharEscapement", s);
        HelperUtilities.setByteProperty(this.getFontObject(), "CharEscapementHeight", n);
    }

    public boolean getSubscript() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharEscapement");
        if (HelperUtilities.isPropertyVoid(object)) {
            DebugHelper.writeInfo("Can't get CharEscapement from Font object.");
            return false;
        }
        short s = HelperUtilities.getShortValue(object, false, (short)0);
        return s != 0;
    }

    public void setSubscript(boolean bl) throws BasicErrorException {
        short s = 0;
        int n = 0;
        if (bl) {
            s = -30;
            n = 80;
        }
        HelperUtilities.setShortProperty(this.getFontObject(), "CharEscapement", s);
        HelperUtilities.setByteProperty(this.getFontObject(), "CharEscapementHeight", n);
    }

    public boolean getEmboss() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharRelief");
        if (HelperUtilities.isPropertyVoid(object)) {
            DebugHelper.writeInfo("Can't get CharRelief from Font object.");
            return false;
        }
        short s = HelperUtilities.getShortValue(object, false, (short)0);
        return s == 1;
    }

    public void setEmboss(boolean bl) throws BasicErrorException {
        short s = 0;
        if (bl) {
            s = 1;
        }
        HelperUtilities.setShortProperty(this.getFontObject(), "CharRelief", s);
    }

    public boolean getEngrave() throws BasicErrorException {
        Object object = HelperUtilities.getProperty(this.getFontObject(), "CharRelief");
        if (HelperUtilities.isPropertyVoid(object)) {
            DebugHelper.writeInfo("Can't get CharRelief from Font object.");
            return false;
        }
        short s = HelperUtilities.getShortValue(object, false, (short)0);
        return s == 2;
    }

    public void setEngrave(boolean bl) throws BasicErrorException {
        short s = 0;
        if (bl) {
            s = 2;
        }
        HelperUtilities.setShortProperty(this.getFontObject(), "CharRelief", s);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Props {
        public static final String PROP_Bold = "CharWeight";
        public static final String PROP_Color = "CharColor";
        public static final String PROP_Italic = "CharPosture";
        public static final String PROP_Kerning = "CharKerning";
        public static final String PROP_Name = "CharFontName";
        public static final String PROP_Position = "CharEscapement";
        public static final String PROP_Shadow = "CharShadowed";
        public static final String PROP_Size = "CharHeight";
        public static final String PROP_StrikeThrough = "CharStrikeout";
        public static final String PROP_Underline = "CharUnderline";
        public static final String PROP_UnderlineColor = "CharUnderlineColor";
        public static final String PROP_CaseMap = "CharCaseMap";
        public static final String PROP_Hidden = "CharHidden";
        public static final String PROP_Outline = "CharContoured";
        public static final String PROP_Animation = "CharFlash";
        public static final String PROP_ENABLE_Kerning = "CharAutoKerning";
        public static final String PROP_ENABLE_UnderlineColor = "CharUnderlineHasColor";
    }
}

