/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.writer.ParagraphImpl;
import com.sun.star.helper.writer.XDropCap;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.DropCapFormat;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;

public class DropCapImpl
extends HelperInterfaceAdaptor
implements XDropCap {
    private XTextRange xParagraphRange;
    private static final DropCapFormat emptyFormat = new DropCapFormat();
    private DropCapFormat actualFormat;

    public DropCapImpl(ParagraphImpl paragraphImpl, XTextRange xTextRange) {
        super(paragraphImpl);
        this.xParagraphRange = xTextRange;
        this.actualFormat = new DropCapFormat();
        this.actualFormat.Count = 1;
        this.actualFormat.Distance = 0;
        this.actualFormat.Lines = (byte)3;
    }

    public void Enable() throws BasicErrorException {
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.xParagraphRange);
        propertySetHelper.setPropertyValue("DropCapFormat", this.actualFormat);
    }

    public void Clear() throws BasicErrorException {
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.xParagraphRange);
        propertySetHelper.setPropertyValue("DropCapFormat", emptyFormat);
    }

    public String getFontName() throws BasicErrorException {
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.getTextCursor());
        String string = propertySetHelper.getPropertyValueAsString("CharFontName", null);
        if (string == null) {
            DebugHelper.exception(51, "CharFontName");
        }
        return string;
    }

    public void setFontName(String string) throws BasicErrorException {
        if (string == null) {
            DebugHelper.exception(14, "CharFontName");
        }
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.getTextCursor());
        propertySetHelper.setPropertyValue("CharFontName", string);
    }

    public int getPosition() throws BasicErrorException {
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.xParagraphRange);
        DropCapFormat dropCapFormat = (DropCapFormat)propertySetHelper.getPropertyValueAsObject("DropCapFormat");
        int n = 0;
        n = dropCapFormat.Count == 0 || dropCapFormat.Lines == 0 ? 0 : 1;
        return n;
    }

    public void setPosition(int n) throws BasicErrorException {
        switch (n) {
            case 2: {
                DebugHelper.exception(73, "DropPosition");
                break;
            }
            case 0: {
                this.Clear();
                break;
            }
            case 1: {
                this.Enable();
                break;
            }
            default: {
                DebugHelper.exception(14, "DropPosition");
            }
        }
    }

    private XTextCursor getTextCursor() {
        XTextCursor xTextCursor = null;
        XTextRange xTextRange = this.xParagraphRange.getStart();
        xTextCursor = this.xParagraphRange.getText().createTextCursorByRange(xTextRange);
        xTextCursor.goRight((short)1, true);
        return xTextCursor;
    }

    static {
        DropCapImpl.emptyFormat.Count = 0;
        DropCapImpl.emptyFormat.Distance = 0;
        DropCapImpl.emptyFormat.Lines = 0;
    }
}

