/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.lang.IndexOutOfBoundsException;

public class ColorTableHelper {
    private static final int COLOR_INDEX = 0;
    private static final int COLOR = 1;
    private static final int REMOVE_HIGH_BITS = 255;
    private static final int BIT_COUNT = 3;
    private static final int BIT_SHIFT = 8;
    protected static final int[][] COLOR_DEPENDENCE = new int[][]{{0, -16777216}, {1, 0}, {2, 0xFF0000}, {3, 0xFFFF00}, {4, 65280}, {5, 0xFF00FF}, {6, 255}, {7, 65535}, {8, 0xFFFFFF}, {9, 0x800000}, {10, 0x808000}, {11, 32768}, {12, 0x800080}, {13, 128}, {14, 32896}, {15, 0x808080}, {16, 0xC0C0C0}, {0, -16777216}, {-1, 0}};

    public static int getColorForIndex(int n) throws IndexOutOfBoundsException {
        if (n < -1 || n > COLOR_DEPENDENCE.length) {
            throw new IndexOutOfBoundsException("This is not a valid ColorIndex.");
        }
        return COLOR_DEPENDENCE[n][1];
    }

    public static int getIndexFromColor(int n) {
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        while (n3 != 0 && n4 < COLOR_DEPENDENCE.length) {
            int n5 = ColorTableHelper.getRGBDependentDelta(n, COLOR_DEPENDENCE[n4][1]);
            if (n3 > n5) {
                n3 = n5;
                n2 = COLOR_DEPENDENCE[n4][0];
            }
            ++n4;
        }
        if (n2 == 0 || n2 == -1) {
            n2 = 1;
        }
        return n2;
    }

    private static int getRGBDependentDelta(int n, int n2) {
        int n3 = 0;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        int n4 = 0;
        while (n4 < 3) {
            nArray[n4] = n & 0xFF;
            n >>>= 8;
            nArray2[n4] = n2 & 0xFF;
            n2 >>>= 8;
            n3 += Math.abs(nArray[n4] - nArray2[n4]);
            ++n4;
        }
        return n3;
    }
}

