/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.container.XNamed;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BookmarkImpl;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.XBookmark;
import com.sun.star.helper.writer.XBookmarks;
import com.sun.star.helper.writer.XRange;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class BookmarksImpl
extends HelperInterfaceAdaptor
implements XBookmarks,
XUnoAccess {
    private XBookmarksSupplier xBookmarksSupplier = null;
    private XTextRangeCompare xDocumentTextCompare = null;
    private XTextRange parentRange = null;
    private XText xText = null;
    private XTextDocument xTextDoc = null;
    private HelperInterfaceAdaptor parent = null;
    static /* synthetic */ Class class$com$sun$star$text$XBookmarksSupplier;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$text$XTextRangeCompare;
    static /* synthetic */ Class class$com$sun$star$text$XTextContent;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;

    public BookmarksImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) throws BasicErrorException {
        super("com.sun.star.helper.writer.BookmarksImpl", helperInterfaceAdaptor);
        this.parent = helperInterfaceAdaptor;
        if (!(this.parent instanceof DocumentImpl) && !(this.parent instanceof RangeImpl)) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("Bookmarks only work for Document- and RangeImpl")));
        }
        XModel xModel = this.getXModel();
        this.xBookmarksSupplier = (XBookmarksSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XBookmarksSupplier == null ? (class$com$sun$star$text$XBookmarksSupplier = BookmarksImpl.class$("com.sun.star.text.XBookmarksSupplier")) : class$com$sun$star$text$XBookmarksSupplier), (Object)xModel);
        if (this.xBookmarksSupplier == null) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("couldn't gain BookmarksSupplier")));
        }
        this.xTextDoc = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = BookmarksImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)xModel);
        if (this.xTextDoc == null) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("works only in textdocuments")));
        }
        this.xText = this.xTextDoc.getText();
        this.xDocumentTextCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = BookmarksImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)this.xTextDoc.getText());
        if (this.xDocumentTextCompare == null) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("couldn't get XTextRangeCompare")));
        }
        this.renameAllBookmarksToLowercase();
        this.parentRange = this.parent instanceof RangeImpl ? ((RangeImpl)this.parent).getXTextRange() : ((DocumentImpl)this.parent).getXTextRange();
    }

    public XBookmark Add(String string, XRange xRange) throws BasicErrorException {
        XTextRange xTextRange = null;
        try {
            xTextRange = ((RangeImpl)xRange).getXTextRange();
        }
        catch (Exception exception) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("only RangeImpl is allowed as second parameter")));
        }
        if (this.xBookmarksSupplier.getBookmarks().hasByName(string)) {
            this.removeBookmarkByName(string);
        }
        this.addBookmarkByName(string.toLowerCase(), xTextRange);
        return new BookmarkImpl(this, this.xBookmarksSupplier, string);
    }

    public int Count() throws BasicErrorException {
        boolean bl = false;
        if (this.parent instanceof RangeImpl) {
            return this.CountInParagraph();
        }
        return this.xBookmarksSupplier.getBookmarks().getElementNames().length;
    }

    public boolean Exists(String string) throws BasicErrorException {
        String string2 = string.toLowerCase();
        boolean bl = this.xBookmarksSupplier.getBookmarks().hasByName(string2);
        if (this.parent instanceof RangeImpl) {
            bl = this.isInRange(string2);
        }
        return bl;
    }

    public XBookmark Item(Object object) throws BasicErrorException {
        XBookmark xBookmark = null;
        if (AnyConverter.isVoid((Object)object) || !this.isInteger(object) && !AnyConverter.isString((Object)object)) {
            DebugHelper.exception(964, object.getClass().getName());
        }
        if (this.isInteger(object)) {
            int n = 0;
            try {
                n = AnyConverter.toInt((Object)object);
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
            xBookmark = this.getItemByIndex(n);
        }
        if (AnyConverter.isString((Object)object)) {
            String string = "";
            try {
                string = AnyConverter.toString((Object)object);
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
            xBookmark = this.getItemByName(string);
        }
        return xBookmark;
    }

    public int getDefaultSorting() throws BasicErrorException {
        return 0;
    }

    public boolean getShowHidden() throws BasicErrorException {
        return true;
    }

    public void setDefaultSorting(int n) throws BasicErrorException {
        if (n != 0 && n != 1) {
            DebugHelper.exception(9, "");
        }
    }

    public void setShowHidden(boolean bl) throws BasicErrorException {
        if (!bl) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("SO can't hide Bookmarks")));
        }
    }

    private XBookmark getItemByIndex(int n) throws BasicErrorException {
        Object[] objectArray = this.xBookmarksSupplier.getBookmarks().getElementNames();
        if (this.parent instanceof RangeImpl) {
            objectArray = this.createSubset();
        }
        if (n > objectArray.length || n < 1) {
            DebugHelper.exception(9, "");
        }
        return new BookmarkImpl(this, this.xBookmarksSupplier, (String)objectArray[n - 1]);
    }

    private XBookmark getItemByName(String string) throws BasicErrorException {
        Object[] objectArray = this.xBookmarksSupplier.getBookmarks().getElementNames();
        if (this.parent instanceof RangeImpl) {
            objectArray = this.createSubset();
        }
        if (!this.hasByName(objectArray, string.toLowerCase())) {
            DebugHelper.exception(9, "");
        }
        return new BookmarkImpl(this, this.xBookmarksSupplier, string);
    }

    private boolean hasByName(Object[] objectArray, String string) {
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private Object[] createSubset() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.xBookmarksSupplier.getBookmarks().getElementNames();
        int n = 0;
        while (n < stringArray.length) {
            if (this.isInRange(stringArray[n])) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private int CountInParagraph() {
        String[] stringArray = this.xBookmarksSupplier.getBookmarks().getElementNames();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.isInRange(stringArray[n2])) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private boolean isInRange(String string) {
        boolean bl = false;
        try {
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = BookmarksImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent), (Object)this.xBookmarksSupplier.getBookmarks().getByName(string));
            XTextRange xTextRange = xTextContent.getAnchor();
            short s = this.xDocumentTextCompare.compareRegionStarts(xTextRange, this.parentRange);
            short s2 = this.xDocumentTextCompare.compareRegionEnds(xTextRange, this.parentRange);
            if (s < 1 || s2 > -1) {
                bl = true;
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.warning(exception);
        }
        return bl;
    }

    private void removeBookmarkByName(String string) throws BasicErrorException {
        try {
            Object object = this.xBookmarksSupplier.getBookmarks().getByName(string);
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = BookmarksImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent), (Object)object);
            this.xText.removeTextContent(xTextContent);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    private void addBookmarkByName(String string, XTextRange xTextRange) throws BasicErrorException {
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = BookmarksImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)this.xTextDoc);
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.text.Bookmark");
            XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = BookmarksImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)object);
            XTextContent xTextContent = (XTextContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = BookmarksImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent), (Object)object);
            xNamed.setName(string);
            this.xText.insertTextContent(xTextRange, xTextContent, false);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    private void renameAllBookmarksToLowercase() throws BasicErrorException {
        try {
            String[] stringArray = this.xBookmarksSupplier.getBookmarks().getElementNames();
            int n = 0;
            while (n < stringArray.length) {
                Object object;
                String string = stringArray[n].toLowerCase();
                XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? BookmarksImpl.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed), (Object)(object = this.xBookmarksSupplier.getBookmarks().getByName(stringArray[n])));
                String string2 = xNamed.getName();
                if (!string2.equals(string)) {
                    xNamed.setName(string);
                }
                ++n;
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        catch (Exception exception) {
            DebugHelper.exception(new com.sun.star.uno.Exception("This should not happen " + exception));
        }
    }

    private boolean isInteger(Object object) {
        boolean bl = AnyConverter.isByte((Object)object) || AnyConverter.isInt((Object)object) || AnyConverter.isShort((Object)object);
        return bl;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xBookmarksSupplier;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

